/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.ast.visitor;

import java.util.Objects;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;

public abstract class BaseVisitor
extends ClassCodeVisitorSupport {
    public static final String GCONTRACTS_ENABLED_VAR = "$GCONTRACTS_ENABLED";
    protected final SourceUnit sourceUnit;

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public BaseVisitor(SourceUnit sourceUnit, ReaderSource source) {
        this.sourceUnit = sourceUnit;
    }

    public static BooleanExpression asConditionExecution(AnnotationNode annotation) {
        ClassNode conditionClass = annotation.getMember("value").getType();
        ConstructorCallExpression createInstance = GeneralUtils.ctorX((ClassNode)conditionClass, (Expression)GeneralUtils.args((Expression[])new Expression[]{VariableExpression.THIS_EXPRESSION, VariableExpression.THIS_EXPRESSION}));
        MethodCallExpression doCall = GeneralUtils.callX((Expression)createInstance, (String)"doCall");
        doCall.setMethodTarget((MethodNode)conditionClass.getMethods("doCall").get(0));
        BooleanExpression asBoolean = GeneralUtils.boolX((Expression)doCall);
        asBoolean.setSourcePosition((ASTNode)annotation);
        return asBoolean;
    }

    protected static ClosureExpression getOriginalCondition(AnnotationNode annotation) {
        Expression value = annotation.getMember("value");
        if (value instanceof ClosureExpression) {
            return (ClosureExpression)value;
        }
        return null;
    }

    protected static Expression getReplacedCondition(AnnotationNode annotation) {
        Expression value = annotation.getMember("value");
        if (!(value instanceof ClosureExpression)) {
            return value;
        }
        return null;
    }

    protected static void replaceCondition(AnnotationNode node, Expression expr) {
        node.setMember("value", Objects.requireNonNull(expr));
    }
}

