/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.codegen.descriptors.FileClassDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.impl.IrClassImpl;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/FileClassLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend"})
public final class FileClassLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        ArrayList<IrDeclaration> classes2 = new ArrayList<IrDeclaration>();
        ArrayList<IrDeclaration> fileClassMembers = new ArrayList<IrDeclaration>();
        Iterable $receiver$iv = irFile.getDeclarations();
        for (Object element$iv : $receiver$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            if (it instanceof IrClass) {
                classes2.add(it);
                continue;
            }
            fileClassMembers.add(it);
        }
        if (fileClassMembers.isEmpty()) {
            return;
        }
        FileClassDescriptor fileClassDescriptor = this.context.getSpecialDescriptorsFactory().createFileClassDescriptor(irFile.getFileEntry(), irFile.getPackageFragmentDescriptor());
        IrClassImpl irFileClass = new IrClassImpl(0, irFile.getFileEntry().getMaxOffset(), IrDeclarationOrigin.DEFINED.INSTANCE, fileClassDescriptor, (List<? extends IrDeclaration>)fileClassMembers);
        classes2.add(irFileClass);
        irFile.getDeclarations().clear();
        irFile.getDeclarations().addAll((Collection<IrDeclaration>)classes2);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public FileClassLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }
}

