/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FacadePartWithSourceFile;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.RootContext;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityUtilsKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.codeFragmentUtil.CodeFragmentUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

public class JvmCodegenUtil {
    private JvmCodegenUtil() {
    }

    public static boolean isNonDefaultInterfaceMember(@NotNull CallableMemberDescriptor descriptor2) {
        if (!JvmCodegenUtil.isJvmInterface(descriptor2.getContainingDeclaration())) {
            return false;
        }
        if (descriptor2 instanceof JavaCallableMemberDescriptor) {
            return descriptor2.getModality() == Modality.ABSTRACT;
        }
        return !org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt.hasJvmDefaultAnnotation(descriptor2);
    }

    public static boolean isJvmInterface(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor2).getKind();
            return kind == ClassKind.INTERFACE || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isJvmInterface(KotlinType type2) {
        return JvmCodegenUtil.isJvmInterface(type2.getConstructor().getDeclarationDescriptor());
    }

    public static boolean isConst(@NotNull CalculatedClosure closure) {
        return closure.getCaptureThis() == null && closure.getCaptureReceiverType() == null && closure.getCaptureVariables().isEmpty() && !closure.isSuspend();
    }

    private static boolean isCallInsideSameClassAsFieldRepresentingProperty(@NotNull PropertyDescriptor descriptor2, @NotNull CodegenContext context) {
        boolean isFakeOverride = descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean isDelegate = descriptor2.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration().getOriginal();
        if (JvmAbi.isPropertyWithBackingFieldInOuterClass(descriptor2)) {
            containingDeclaration = containingDeclaration.getContainingDeclaration();
        }
        return !isFakeOverride && !isDelegate && (context.hasThisDescriptor() && containingDeclaration == context.getThisDescriptor() || context.getParentContext() instanceof FacadePartWithSourceFile && JvmCodegenUtil.isWithinSameFile(((FacadePartWithSourceFile)((Object)context.getParentContext())).getSourceFile(), descriptor2)) && context.getContextKind() != OwnerKind.DEFAULT_IMPLS;
    }

    private static boolean isWithinSameFile(@Nullable KtFile callerFile, @NotNull CallableMemberDescriptor descriptor2) {
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration().getOriginal();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            PsiElement calleeElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            PsiFile calleeFile = calleeElement != null ? calleeElement.getContainingFile() : null;
            return callerFile != null && callerFile != SourceFile.NO_SOURCE_FILE && calleeFile == callerFile;
        }
        return false;
    }

    public static boolean isCallInsideSameModuleAsDeclared(@NotNull CallableMemberDescriptor declarationDescriptor, @NotNull CodegenContext context, @Nullable File outDirectory) {
        if (context instanceof RootContext) {
            return true;
        }
        Object contextDescriptor = context.getContextDescriptor();
        CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(declarationDescriptor);
        if (directMember instanceof DeserializedCallableMemberDescriptor) {
            return ModuleVisibilityUtilsKt.isContainedByCompiledPartOfOurModule(directMember, outDirectory);
        }
        return DescriptorUtils.areInSameModule(directMember, contextDescriptor);
    }

    public static boolean hasAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        return CollectionsKt.any(DescriptorUtils.getAllDescriptors(classDescriptor.getDefaultType().getMemberScope()), descriptor2 -> descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getModality() == Modality.ABSTRACT);
    }

    public static boolean isConstOrHasJvmFieldAnnotation(@NotNull PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.isConst() || AnnotationUtilKt.hasJvmFieldAnnotation(propertyDescriptor);
    }

    public static boolean couldUseDirectAccessToProperty(@NotNull PropertyDescriptor property, boolean forGetter, boolean isDelegated, @NotNull MethodContext contextBeforeInline, boolean shouldInlineConstVals) {
        PropertyAccessorDescriptor accessor;
        if (shouldInlineConstVals && property.isConst()) {
            return true;
        }
        if (KotlinTypeMapper.isAccessor(property)) {
            return false;
        }
        CodegenContext context = contextBeforeInline.getFirstCrossInlineOrNonInlineContext();
        if (context.isInlineMethodContext() || context.getEnclosingClass() != null && context.getEnclosingClass().isInline()) {
            return false;
        }
        if (!JvmCodegenUtil.isCallInsideSameClassAsFieldRepresentingProperty(property, context)) {
            DeclarationDescriptor propertyOwner = property.getContainingDeclaration();
            boolean isAnnotationValue = propertyOwner instanceof ClassDescriptor ? ((ClassDescriptor)propertyOwner).getKind() == ClassKind.ANNOTATION_CLASS : false;
            if (isAnnotationValue || !JvmCodegenUtil.isDebuggerContext(context)) {
                return false;
            }
            for (PropertyAccessorDescriptor accessorDescriptor : property.getAccessors()) {
                if (accessorDescriptor.isDefault() || forGetter != accessorDescriptor instanceof PropertyGetterDescriptor) continue;
                return false;
            }
            if (!property.getOverriddenDescriptors().isEmpty()) {
                return false;
            }
        }
        if (isDelegated || property.getExtensionReceiverParameter() != null) {
            return false;
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = forGetter ? property.getGetter() : property.getSetter();
        if (accessor == null) {
            return true;
        }
        if (DescriptorPsiUtilsKt.hasBody(accessor)) {
            return false;
        }
        return Visibilities.isPrivate(property.getVisibility()) || accessor.getModality() == Modality.FINAL;
    }

    private static boolean isDebuggerContext(@NotNull CodegenContext context) {
        KtFile file2 = DescriptorToSourceUtils.getContainingFile(context.getContextDescriptor());
        return file2 != null && CodeFragmentUtilKt.getSuppressDiagnosticsInDebugMode(file2);
    }

    @Nullable
    public static ClassDescriptor getDispatchReceiverParameterForConstructorCall(@NotNull ConstructorDescriptor descriptor2, @Nullable CalculatedClosure closure) {
        ClassDescriptor expectedThisClass;
        if (closure != null) {
            return closure.getCaptureThis();
        }
        ReceiverParameterDescriptor dispatchReceiver = descriptor2.getDispatchReceiverParameter();
        if (dispatchReceiver != null && !(expectedThisClass = (ClassDescriptor)dispatchReceiver.getContainingDeclaration()).getKind().isSingleton()) {
            return expectedThisClass;
        }
        return null;
    }

    @NotNull
    public static CallableMemberDescriptor getDirectMember(@NotNull CallableMemberDescriptor descriptor2) {
        return DescriptorUtils.getDirectMember(descriptor2);
    }

    public static boolean isArgumentWhichWillBeInlined(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor descriptor2) {
        PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        return InlineUtil.canBeInlineArgument(declaration) && InlineUtil.isInlinedArgument((KtFunction)declaration, bindingContext, false);
    }

    @NotNull
    public static String getModuleName(ModuleDescriptor module2) {
        return StringsKt.removeSurrounding(module2.getName().asString(), (CharSequence)"<", (CharSequence)">");
    }

    @NotNull
    public static String getMappingFileName(@NotNull String moduleName) {
        return "META-INF/" + moduleName + "." + "kotlin_module";
    }

    public static boolean isInlinedJavaConstProperty(VariableDescriptor descriptor2) {
        return descriptor2 instanceof JavaPropertyDescriptor && descriptor2.isConst();
    }

    @Nullable
    public static KotlinType getPropertyDelegateType(@NotNull VariableDescriptorWithAccessors descriptor2, @NotNull BindingContext bindingContext) {
        Call call2;
        VariableAccessorDescriptor getter2 = descriptor2.getGetter();
        if (getter2 != null && (call2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_CALL, getter2)) != null) {
            assert (call2.getExplicitReceiver() != null) : "No explicit receiver for call:" + call2;
            return ((ReceiverValue)call2.getExplicitReceiver()).getType();
        }
        return null;
    }

    public static boolean isDelegatedLocalVariable(@NotNull DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor2).isDelegated();
    }

    @Nullable
    public static ReceiverValue getBoundCallableReferenceReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
        ReceiverValue receiver;
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (descriptor2.getExtensionReceiverParameter() == null && descriptor2.getDispatchReceiverParameter() == null) {
            return null;
        }
        ReceiverValue dispatchReceiver = resolvedCall2.getDispatchReceiver();
        ReceiverValue extensionReceiver = resolvedCall2.getExtensionReceiver();
        assert (dispatchReceiver == null || extensionReceiver == null) : "Cannot generate reference with both receivers: " + descriptor2;
        ReceiverValue receiverValue = receiver = dispatchReceiver != null ? dispatchReceiver : extensionReceiver;
        if (receiver instanceof TransientReceiver) {
            return null;
        }
        return receiver;
    }

    public static boolean isCompanionObjectInInterfaceNotIntrinsic(@NotNull DeclarationDescriptor companionObject) {
        return DescriptorUtils.isCompanionObject(companionObject) && JvmCodegenUtil.isJvmInterface(companionObject.getContainingDeclaration()) && !JvmAbi.isMappedIntrinsicCompanionObject((ClassDescriptor)companionObject);
    }

    public static boolean hasBackingField(@NotNull PropertyDescriptor descriptor2, @NotNull OwnerKind kind, @NotNull BindingContext bindingContext) {
        return !JvmCodegenUtil.isJvmInterface(descriptor2.getContainingDeclaration()) && kind != OwnerKind.DEFAULT_IMPLS && !Boolean.FALSE.equals(bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2));
    }
}

