/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileTypeFileViewProviders;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.FileViewProviderFactory;
import com.intellij.psi.LanguageFileViewProviders;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileManagerImpl
implements FileManager {
    private static final Key<Boolean> IN_COMA = Key.create("IN_COMA");
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.file.impl.FileManagerImpl");
    private final Key<FileViewProvider> myPsiHardRefKey = Key.create("HARD_REFERENCE_TO_PSI");
    private final PsiManagerImpl myManager;
    private final FileIndexFacade myFileIndex;
    private final AtomicReference<ConcurrentMap<VirtualFile, PsiDirectory>> myVFileToPsiDirMap = new AtomicReference();
    private final AtomicReference<ConcurrentMap<VirtualFile, FileViewProvider>> myVFileToViewProviderMap = new AtomicReference();
    private final ThreadLocal<Map<VirtualFile, FileViewProvider>> myTempProviders = ThreadLocal.withInitial(() -> new HashMap());
    private boolean myDisposed;
    private final FileDocumentManager myFileDocumentManager;
    private final MessageBusConnection myConnection;
    private static final VirtualFile NULL = new LightVirtualFile();
    private boolean myProcessingFileTypesChange;

    public FileManagerImpl(PsiManagerImpl manager, FileDocumentManager fileDocumentManager, FileIndexFacade fileIndex) {
        this.myManager = manager;
        this.myFileIndex = fileIndex;
        this.myConnection = manager.getProject().getMessageBus().connect();
        this.myFileDocumentManager = fileDocumentManager;
        Disposer.register(manager.getProject(), this);
        LowMemoryWatcher.register(this::processQueue, this);
        this.myConnection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FileManagerImpl.this.processFileTypesChanged();
            }

            public void exitDumbMode() {
                FileManagerImpl.this.processFileTypesChanged();
            }
        });
    }

    public void processQueue() {
        ConcurrentMap<VirtualFile, FileViewProvider> map2 = this.myVFileToViewProviderMap.get();
        if (map2 != null) {
            map2.remove(NULL);
        }
    }

    @NotNull
    public ConcurrentMap<VirtualFile, FileViewProvider> getVFileToViewProviderMap() {
        ConcurrentMap<VirtualFile, FileViewProvider> map2 = this.myVFileToViewProviderMap.get();
        if (map2 == null) {
            map2 = ConcurrencyUtil.cacheOrGet(this.myVFileToViewProviderMap, ContainerUtil.createConcurrentWeakValueMap());
        }
        ConcurrentMap<VirtualFile, FileViewProvider> concurrentMap = map2;
        if (concurrentMap == null) {
            FileManagerImpl.$$$reportNull$$$0(0);
        }
        return concurrentMap;
    }

    @NotNull
    private ConcurrentMap<VirtualFile, PsiDirectory> getVFileToPsiDirMap() {
        ConcurrentMap<VirtualFile, PsiDirectory> map2 = this.myVFileToPsiDirMap.get();
        if (map2 == null) {
            map2 = ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, ContainerUtil.createConcurrentSoftValueMap());
        }
        ConcurrentMap<VirtualFile, PsiDirectory> concurrentMap = map2;
        if (concurrentMap == null) {
            FileManagerImpl.$$$reportNull$$$0(1);
        }
        return concurrentMap;
    }

    public static void clearPsiCaches(@NotNull FileViewProvider provider) {
        if (provider == null) {
            FileManagerImpl.$$$reportNull$$$0(2);
        }
        ((AbstractFileViewProvider)provider).getCachedPsiFiles().forEach(PsiFile::clearCaches);
    }

    public void forceReload(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(3);
        }
        LanguageSubstitutors.cancelReparsing(vFile);
        FileViewProvider viewProvider = this.findCachedViewProvider(vFile);
        if (viewProvider == null) {
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile dir = vFile.getParent();
        PsiDirectory parentDir = dir == null ? null : this.getCachedDirectory(dir);
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        if (parentDir == null) {
            event.setPropertyName("propUnloadedPsi");
            this.myManager.beforePropertyChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.propertyChanged(event);
        } else {
            event.setParent(parentDir);
            this.myManager.beforeChildrenChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.childrenChanged(event);
        }
    }

    public void firePropertyChangedForUnloadedPsi() {
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        event.setPropertyName("propUnloadedPsi");
        this.myManager.beforePropertyChange(event);
        this.myManager.propertyChanged(event);
    }

    @Override
    public void dispose() {
        this.myConnection.disconnect();
        this.clearViewProviders();
        this.myDisposed = true;
    }

    private void clearViewProviders() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        DebugUtil.performPsiModification("clearViewProviders", () -> {
            ConcurrentMap<VirtualFile, FileViewProvider> map2 = this.myVFileToViewProviderMap.get();
            if (map2 != null) {
                for (FileViewProvider provider : map2.values()) {
                    this.markInvalidated(provider);
                }
            }
            this.myVFileToViewProviderMap.set(null);
        });
    }

    @Override
    public void cleanupForNextTest() {
        ApplicationManager.getApplication().runWriteAction(this::clearViewProviders);
        this.myVFileToPsiDirMap.set(null);
        ((PsiModificationTrackerImpl)this.myManager.getModificationTracker()).incCounter();
    }

    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(4);
        }
        assert (!file2.isDirectory());
        FileViewProvider viewProvider = this.findCachedViewProvider(file2);
        if (viewProvider != null) {
            FileViewProvider fileViewProvider = viewProvider;
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(5);
            }
            return fileViewProvider;
        }
        if (file2 instanceof VirtualFileWindow) {
            throw new IllegalStateException("File " + file2 + " is invalid");
        }
        Map<VirtualFile, FileViewProvider> tempMap = this.myTempProviders.get();
        if (tempMap.containsKey(file2)) {
            FileViewProvider fileViewProvider = Objects.requireNonNull(tempMap.get(file2), "Recursive file view provider creation");
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(6);
            }
            return fileViewProvider;
        }
        viewProvider = this.createFileViewProvider(file2, true);
        if (file2 instanceof LightVirtualFile) {
            FileViewProvider fileViewProvider = file2.putUserDataIfAbsent(this.myPsiHardRefKey, viewProvider);
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(7);
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = ConcurrencyUtil.cacheOrGet(this.getVFileToViewProviderMap(), file2, viewProvider);
        if (fileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(8);
        }
        return fileViewProvider;
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file2) {
        FileViewProvider viewProvider;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(9);
        }
        if ((viewProvider = this.getRawCachedViewProvider(file2)) instanceof AbstractFileViewProvider && viewProvider.getUserData(IN_COMA) != null) {
            Map<VirtualFile, FileViewProvider> tempMap = this.myTempProviders.get();
            if (tempMap.containsKey(file2)) {
                return tempMap.get(file2);
            }
            if (!this.evaluateValidity((AbstractFileViewProvider)viewProvider)) {
                return null;
            }
        }
        return viewProvider;
    }

    @Nullable
    private FileViewProvider getRawCachedViewProvider(@NotNull VirtualFile file2) {
        ConcurrentMap<VirtualFile, FileViewProvider> map2;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(10);
        }
        FileViewProvider viewProvider = (map2 = this.myVFileToViewProviderMap.get()) == null ? null : (FileViewProvider)map2.get(file2);
        return viewProvider == null ? file2.getUserData(this.myPsiHardRefKey) : viewProvider;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile2, @Nullable FileViewProvider fileViewProvider) {
        FileViewProvider prev;
        if (virtualFile2 == null) {
            FileManagerImpl.$$$reportNull$$$0(11);
        }
        if ((prev = this.getRawCachedViewProvider(virtualFile2)) == fileViewProvider) {
            return;
        }
        if (prev != null) {
            DebugUtil.performPsiModification(null, () -> this.markInvalidated(prev));
        }
        if (fileViewProvider == null) {
            this.getVFileToViewProviderMap().remove(virtualFile2);
        } else if (virtualFile2 instanceof LightVirtualFile) {
            virtualFile2.putUserData(this.myPsiHardRefKey, fileViewProvider);
        } else {
            this.getVFileToViewProviderMap().put(virtualFile2, fileViewProvider);
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, boolean eventSystemEnabled) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(12);
        }
        FileType fileType = file2.getFileType();
        Language language = LanguageUtil.getLanguageForPsi(this.myManager.getProject(), file2);
        FileViewProviderFactory factory2 = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(fileType) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        SingleRootFileViewProvider viewProvider = factory2 == null ? null : factory2.createFileViewProvider(file2, language, this.myManager, eventSystemEnabled);
        SingleRootFileViewProvider singleRootFileViewProvider = viewProvider == null ? new SingleRootFileViewProvider((PsiManager)this.myManager, file2, eventSystemEnabled, fileType) : viewProvider;
        if (singleRootFileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(13);
        }
        return singleRootFileViewProvider;
    }

    @Deprecated
    public void markInitialized() {
    }

    @Deprecated
    public boolean isInitialized() {
        return true;
    }

    void processFileTypesChanged() {
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        DebugUtil.performPsiModification(null, () -> {
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
                    event.setPropertyName("propFileTypes");
                    this.myManager.beforePropertyChange(event);
                    this.possiblyInvalidatePhysicalPsi();
                    this.myManager.propertyChanged(event);
                });
            }
            finally {
                this.myProcessingFileTypesChange = false;
            }
        });
    }

    void possiblyInvalidatePhysicalPsi() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.removeInvalidDirs(true);
        for (FileViewProvider provider : this.getVFileToViewProviderMap().values()) {
            FileManagerImpl.markPossiblyInvalidated(provider);
        }
    }

    void dispatchPendingEvents() {
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        this.myConnection.deliverImmediately();
    }

    public void checkConsistency() {
        for (Object file2 : new ArrayList(this.getVFileToViewProviderMap().keySet())) {
            this.findCachedViewProvider((VirtualFile)file2);
        }
        HashMap<VirtualFile, FileViewProvider> fileToViewProvider = new HashMap<VirtualFile, FileViewProvider>(this.getVFileToViewProviderMap());
        this.myVFileToViewProviderMap.set(null);
        for (Map.Entry entry : fileToViewProvider.entrySet()) {
            FileViewProvider fileViewProvider = (FileViewProvider)entry.getValue();
            VirtualFile vFile = (VirtualFile)entry.getKey();
            LOG.assertTrue(vFile.isValid());
            PsiFile psiFile1 = this.findFile(vFile);
            if (psiFile1 == null || fileViewProvider == null || !fileViewProvider.isPhysical()) continue;
            PsiFile psi = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
            assert (psi != null) : fileViewProvider + "; " + fileViewProvider.getBaseLanguage() + "; " + psiFile1;
            assert (psiFile1.getClass().equals(psi.getClass())) : psiFile1 + "; " + psi + "; " + psiFile1.getClass() + "; " + psi.getClass();
        }
        HashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new HashMap<VirtualFile, PsiDirectory>(this.getVFileToPsiDirMap());
        this.myVFileToPsiDirMap.set(null);
        for (VirtualFile vFile : fileToPsiDirMap.keySet()) {
            LOG.assertTrue(vFile.isValid());
            PsiDirectory psiDir1 = this.findDirectory(vFile);
            LOG.assertTrue(psiDir1 != null);
            VirtualFile parent2 = vFile.getParent();
            if (parent2 == null) continue;
            LOG.assertTrue(this.getVFileToPsiDirMap().get(parent2) != null);
        }
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(14);
        }
        if (vFile.isDirectory()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("Invalid file: " + vFile);
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LOG.assertTrue(vFile.isValid(), "Invalid file");
        if (this.myDisposed) {
            LOG.error("Project is already disposed: " + this.myManager.getProject());
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(16);
        }
        if (this.myDisposed) {
            LOG.error("Access to psi files should not be performed after project disposal: " + this.myManager.getProject());
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!vFile.isValid()) {
            LOG.error("File is not valid:" + vFile);
            return null;
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile);
    }

    @Nullable
    private PsiDirectory findDirectoryImpl(@NotNull VirtualFile vFile) {
        PsiDirectory psiDir;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(17);
        }
        if ((psiDir = (PsiDirectory)this.getVFileToPsiDirMap().get(vFile)) != null) {
            return psiDir;
        }
        if (Registry.is("ide.hide.excluded.files") ? this.myFileIndex.isExcludedFile(vFile) : this.myFileIndex.isUnderIgnored(vFile)) {
            return null;
        }
        VirtualFile parent2 = vFile.getParent();
        if (parent2 != null) {
            this.findDirectoryImpl(parent2);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return ConcurrencyUtil.cacheOrGet(this.getVFileToPsiDirMap(), vFile, psiDir);
    }

    public PsiDirectory getCachedDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(18);
        }
        return (PsiDirectory)this.getVFileToPsiDirMap().get(vFile);
    }

    private void markInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(20);
        }
        viewProvider.putUserData(IN_COMA, null);
        ((AbstractFileViewProvider)viewProvider).markInvalidated();
        viewProvider.getVirtualFile().putUserData(this.myPsiHardRefKey, null);
    }

    public static void markPossiblyInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(21);
        }
        LOG.assertTrue(!(viewProvider instanceof FreeThreadedFileViewProvider));
        viewProvider.putUserData(IN_COMA, true);
        ((AbstractFileViewProvider)viewProvider).markPossiblyInvalidated();
        FileManagerImpl.clearPsiCaches(viewProvider);
    }

    @Nullable
    PsiFile getCachedPsiFileInner(@NotNull VirtualFile file2) {
        FileViewProvider fileViewProvider;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(22);
        }
        return (fileViewProvider = this.findCachedViewProvider(file2)) != null ? ((AbstractFileViewProvider)fileViewProvider).getCachedPsi(fileViewProvider.getBaseLanguage()) : null;
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files2 = new ArrayList<PsiFile>();
        for (VirtualFile file2 : new ArrayList(this.getVFileToViewProviderMap().keySet())) {
            FileViewProvider provider = this.findCachedViewProvider(file2);
            if (provider == null) continue;
            ContainerUtil.addIfNotNull(files2, ((AbstractFileViewProvider)provider).getCachedPsi(provider.getBaseLanguage()));
        }
        ArrayList<PsiFile> arrayList = files2;
        if (arrayList == null) {
            FileManagerImpl.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private void removeInvalidDirs(boolean useFind) {
        THashMap<VirtualFile, PsiDirectory> fileToPsiDirMap = new THashMap<VirtualFile, PsiDirectory>(this.getVFileToPsiDirMap());
        if (useFind) {
            this.myVFileToPsiDirMap.set(null);
        }
        Iterator iterator2 = fileToPsiDirMap.keySet().iterator();
        while (iterator2.hasNext()) {
            VirtualFile vFile = (VirtualFile)iterator2.next();
            if (!vFile.isValid()) {
                iterator2.remove();
                continue;
            }
            PsiDirectory psiDir = this.findDirectory(vFile);
            if (psiDir != null) continue;
            iterator2.remove();
        }
        this.myVFileToPsiDirMap.set(null);
        this.getVFileToPsiDirMap().putAll(fileToPsiDirMap);
    }

    static boolean areViewProvidersEquivalent(@NotNull FileViewProvider view1, @NotNull FileViewProvider view2) {
        if (view1 == null) {
            FileManagerImpl.$$$reportNull$$$0(24);
        }
        if (view2 == null) {
            FileManagerImpl.$$$reportNull$$$0(25);
        }
        if (view1.getClass() != view2.getClass() || view1.getFileType() != view2.getFileType()) {
            return false;
        }
        Language baseLanguage = view1.getBaseLanguage();
        if (baseLanguage != view2.getBaseLanguage()) {
            return false;
        }
        if (!view1.getLanguages().equals(view2.getLanguages())) {
            return false;
        }
        PsiFile psi1 = view1.getPsi(baseLanguage);
        PsiFile psi2 = view2.getPsi(baseLanguage);
        if (psi1 == null || psi2 == null) {
            return psi1 == psi2;
        }
        return psi1.getClass() == psi2.getClass();
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file2) {
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(27);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile vFile = file2.getVirtualFile();
        assert (vFile != null);
        Document document = this.myFileDocumentManager.getCachedDocument(vFile);
        if (document != null) {
            this.myFileDocumentManager.reloadFromDisk(document);
        } else {
            this.reloadPsiAfterTextChange(file2.getViewProvider(), vFile);
        }
    }

    void reloadPsiAfterTextChange(@NotNull FileViewProvider viewProvider, @NotNull VirtualFile vFile) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(28);
        }
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(29);
        }
        if (!FileManagerImpl.areViewProvidersEquivalent(viewProvider, this.createFileViewProvider(vFile, false))) {
            this.forceReload(vFile);
            return;
        }
        ((AbstractFileViewProvider)viewProvider).onContentReload();
    }

    public boolean evaluateValidity(@NotNull PsiFile file2) {
        AbstractFileViewProvider vp;
        if (file2 == null) {
            FileManagerImpl.$$$reportNull$$$0(30);
        }
        return this.evaluateValidity(vp = (AbstractFileViewProvider)file2.getViewProvider()) && vp.getCachedPsiFiles().contains(file2);
    }

    private boolean evaluateValidity(@NotNull AbstractFileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile file2 = viewProvider.getVirtualFile();
        if (this.getRawCachedViewProvider(file2) != viewProvider) {
            return false;
        }
        if (viewProvider.getUserData(IN_COMA) == null) {
            return true;
        }
        if (this.shouldResurrect(viewProvider, file2)) {
            viewProvider.putUserData(IN_COMA, null);
            LOG.assertTrue(this.getRawCachedViewProvider(file2) == viewProvider);
            for (PsiFile psiFile : viewProvider.getCachedPsiFiles()) {
                LOG.assertTrue(psiFile.isValid());
            }
            return true;
        }
        this.getVFileToViewProviderMap().remove(file2, viewProvider);
        file2.replace(this.myPsiHardRefKey, viewProvider, null);
        viewProvider.putUserData(IN_COMA, null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldResurrect(FileViewProvider viewProvider, VirtualFile file2) {
        if (!file2.isValid()) {
            return false;
        }
        Map<VirtualFile, FileViewProvider> tempProviders = this.myTempProviders.get();
        if (tempProviders.containsKey(file2)) {
            LOG.error(new StackOverflowPreventedException("isValid leads to endless recursion in " + viewProvider.getClass() + ": " + new ArrayList<Language>(viewProvider.getLanguages())));
        }
        tempProviders.put(file2, null);
        try {
            FileViewProvider recreated = this.createFileViewProvider(file2, true);
            tempProviders.put(file2, recreated);
            boolean bl = FileManagerImpl.areViewProvidersEquivalent(viewProvider, recreated) && ((AbstractFileViewProvider)viewProvider).getCachedPsiFiles().stream().noneMatch(f -> FileManagerImpl.hasInvalidOriginal(f));
            return bl;
        }
        finally {
            FileViewProvider temp = tempProviders.remove(file2);
            if (temp != null) {
                DebugUtil.performPsiModification("invalidate temp view provider", () -> ((AbstractFileViewProvider)temp).markInvalidated());
            }
        }
    }

    private static boolean hasInvalidOriginal(PsiFile file2) {
        PsiFile original = file2.getOriginalFile();
        return original != file2 && !original.isValid();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 20: 
            case 21: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view1";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view2";
                break;
            }
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileToPsiFileMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileToViewProviderMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileToPsiDirMap";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileViewProvider";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCachedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearPsiCaches";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forceReload";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findViewProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCachedViewProvider";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRawCachedViewProvider";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setViewProvider";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFileViewProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findDirectory";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findDirectoryImpl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDirectory";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeFilesAndDirsRecursively";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidated";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "markPossiblyInvalidated";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFileInner";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "areViewProvidersEquivalent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidations";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "reloadPsiAfterTextChange";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "evaluateValidity";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$markInvalidations$6";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeFilesAndDirsRecursively$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

