/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.TypeAliasExpansion;
import org.jetbrains.kotlin.resolve.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.DynamicType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J*\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010!\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\u0014\u0010\"\u001a\u00020#*\u00020#2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0014\u0010\"\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0014\u0010$\u001a\u00020\u0011*\u00020\u00112\u0006\u0010%\u001a\u00020\u000eH\u0002J\u0014\u0010&\u001a\u00020\u0011*\u00020\u00112\u0006\u0010%\u001a\u00020\u000eH\u0002J\u001c\u0010'\u001a\u00020\u0011*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0014\u0010(\u001a\u00020\n*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeAliasExpander;", "", "reportStrategy", "Lorg/jetbrains/kotlin/resolve/TypeAliasExpansionReportStrategy;", "shouldCheckBounds", "", "(Lorg/jetbrains/kotlin/resolve/TypeAliasExpansionReportStrategy;Z)V", "checkRepeatedAnnotations", "", "existingAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "newAnnotations", "checkTypeArgumentsSubstitution", "unsubstitutedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "substitutedType", "expand", "Lorg/jetbrains/kotlin/types/SimpleType;", "typeAliasExpansion", "Lorg/jetbrains/kotlin/resolve/TypeAliasExpansion;", "annotations", "expandNonArgumentTypeProjection", "Lorg/jetbrains/kotlin/types/TypeProjection;", "originalProjection", "recursionDepth", "", "expandRecursively", "isNullable", "withAbbreviatedType", "expandTypeProjection", "underlyingProjection", "typeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "expandWithoutAbbreviation", "combineAnnotations", "Lorg/jetbrains/kotlin/types/DynamicType;", "combineNullability", "fromType", "combineNullabilityAndAnnotations", "createAbbreviation", "createCombinedAnnotations", "Companion", "frontend"})
public final class TypeAliasExpander {
    private final TypeAliasExpansionReportStrategy reportStrategy;
    private final boolean shouldCheckBounds;
    @NotNull
    private static final TypeAliasExpander NON_REPORTING;
    public static final Companion Companion;

    @NotNull
    public final SimpleType expand(@NotNull TypeAliasExpansion typeAliasExpansion, @NotNull Annotations annotations2) {
        Intrinsics.checkParameterIsNotNull(typeAliasExpansion, "typeAliasExpansion");
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        return this.expandRecursively(typeAliasExpansion, annotations2, false, 0, true);
    }

    @NotNull
    public final SimpleType expandWithoutAbbreviation(@NotNull TypeAliasExpansion typeAliasExpansion, @NotNull Annotations annotations2) {
        Intrinsics.checkParameterIsNotNull(typeAliasExpansion, "typeAliasExpansion");
        Intrinsics.checkParameterIsNotNull(annotations2, "annotations");
        return this.expandRecursively(typeAliasExpansion, annotations2, false, 0, false);
    }

    private final SimpleType expandRecursively(TypeAliasExpansion typeAliasExpansion, Annotations annotations2, boolean isNullable2, int recursionDepth, boolean withAbbreviatedType) {
        SimpleType simpleType2;
        boolean bl;
        TypeProjectionImpl underlyingProjection = new TypeProjectionImpl(Variance.INVARIANT, typeAliasExpansion.getDescriptor().getUnderlyingType());
        TypeProjection expandedProjection = this.expandTypeProjection(underlyingProjection, typeAliasExpansion, null, recursionDepth);
        KotlinType kotlinType = expandedProjection.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "expandedProjection.type");
        SimpleType expandedType = TypeSubstitutionKt.asSimpleType(kotlinType);
        if (KotlinTypeKt.isError(expandedType)) {
            return expandedType;
        }
        boolean bl2 = bl = expandedProjection.getProjectionKind() == Variance.INVARIANT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Type alias expansion: result for " + typeAliasExpansion.getDescriptor() + " is " + (Object)((Object)expandedProjection.getProjectionKind()) + ", should be invariant";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.checkRepeatedAnnotations(expandedType.getAnnotations(), annotations2);
        SimpleType it = simpleType2 = this.combineAnnotations(expandedType, annotations2);
        SimpleType simpleType3 = TypeUtils.makeNullableIfNeeded(it, isNullable2);
        Intrinsics.checkExpressionValueIsNotNull(simpleType3, "expandedType.combineAnno\u2026fNeeded(it, isNullable) }");
        SimpleType expandedTypeWithExtraAnnotations = simpleType3;
        return withAbbreviatedType ? SpecialTypesKt.withAbbreviation(expandedTypeWithExtraAnnotations, this.createAbbreviation(typeAliasExpansion, annotations2, isNullable2)) : expandedTypeWithExtraAnnotations;
    }

    private final SimpleType createAbbreviation(@NotNull TypeAliasExpansion $receiver, Annotations annotations2, boolean isNullable2) {
        TypeConstructor typeConstructor2 = $receiver.getDescriptor().getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "descriptor.typeConstructor");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, typeConstructor2, $receiver.getArguments(), isNullable2, MemberScope.Empty.INSTANCE);
    }

    private final TypeProjection expandTypeProjection(TypeProjection underlyingProjection, TypeAliasExpansion typeAliasExpansion, TypeParameterDescriptor typeParameterDescriptor, int recursionDepth) {
        Variance variance;
        Object object;
        Variance substitutionVariance;
        Variance variance2;
        TypeAliasExpander typeAliasExpander;
        TypeAliasExpander.Companion.assertRecursionDepth(recursionDepth, typeAliasExpansion.getDescriptor());
        if (underlyingProjection.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            if (typeParameterDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            TypeProjection typeProjection = TypeUtils.makeStarProjection(typeParameterDescriptor2);
            Intrinsics.checkExpressionValueIsNotNull(typeProjection, "TypeUtils.makeStarProjec\u2026ypeParameterDescriptor!!)");
            return typeProjection;
        }
        KotlinType kotlinType = underlyingProjection.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "underlyingProjection.type");
        KotlinType underlyingType = kotlinType;
        TypeProjection typeProjection = typeAliasExpansion.getReplacement(underlyingType.getConstructor());
        if (typeProjection == null) {
            return this.expandNonArgumentTypeProjection(underlyingProjection, typeAliasExpansion, recursionDepth);
        }
        TypeProjection argument = typeProjection;
        if (argument.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor3 = typeParameterDescriptor;
            if (typeParameterDescriptor3 == null) {
                Intrinsics.throwNpe();
            }
            TypeProjection typeProjection2 = TypeUtils.makeStarProjection(typeParameterDescriptor3);
            Intrinsics.checkExpressionValueIsNotNull(typeProjection2, "TypeUtils.makeStarProjec\u2026ypeParameterDescriptor!!)");
            return typeProjection2;
        }
        UnwrappedType argumentType = argument.getType().unwrap();
        TypeAliasExpander $receiver = typeAliasExpander = this;
        Variance variance3 = argument.getProjectionKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)variance3, "argument.projectionKind");
        Variance argumentVariance = variance3;
        Variance variance4 = underlyingProjection.getProjectionKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)variance4, "underlyingProjection.projectionKind");
        Variance underlyingVariance = variance4;
        if (underlyingVariance == argumentVariance) {
            variance2 = argumentVariance;
        } else if (underlyingVariance == Variance.INVARIANT) {
            variance2 = argumentVariance;
        } else if (argumentVariance == Variance.INVARIANT) {
            variance2 = underlyingVariance;
        } else {
            $receiver.reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), typeParameterDescriptor, argumentType);
            variance2 = substitutionVariance = argumentVariance;
        }
        if ((object = typeParameterDescriptor) == null || (object = object.getVariance()) == null) {
            object = Variance.INVARIANT;
        }
        Intrinsics.checkExpressionValueIsNotNull(object, "typeParameterDescriptor?\u2026nce ?: Variance.INVARIANT");
        Object parameterVariance = object;
        if (parameterVariance == substitutionVariance) {
            variance = substitutionVariance;
        } else if (parameterVariance == Variance.INVARIANT) {
            variance = substitutionVariance;
        } else if (substitutionVariance == Variance.INVARIANT) {
            variance = Variance.INVARIANT;
        } else {
            $receiver.reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), typeParameterDescriptor, argumentType);
            variance = substitutionVariance;
        }
        Variance resultingVariance = variance;
        this.checkRepeatedAnnotations(underlyingType.getAnnotations(), argumentType.getAnnotations());
        UnwrappedType substitutedType = argumentType instanceof DynamicType ? (UnwrappedType)this.combineAnnotations((DynamicType)argumentType, underlyingType.getAnnotations()) : (UnwrappedType)this.combineNullabilityAndAnnotations(TypeSubstitutionKt.asSimpleType(argumentType), underlyingType);
        return new TypeProjectionImpl(resultingVariance, substitutedType);
    }

    private final DynamicType combineAnnotations(@NotNull DynamicType $receiver, Annotations newAnnotations) {
        return $receiver.replaceAnnotations(this.createCombinedAnnotations($receiver, newAnnotations));
    }

    private final SimpleType combineAnnotations(@NotNull SimpleType $receiver, Annotations newAnnotations) {
        return KotlinTypeKt.isError($receiver) ? $receiver : TypeSubstitutionKt.replace$default($receiver, null, this.createCombinedAnnotations($receiver, newAnnotations), 1, null);
    }

    private final Annotations createCombinedAnnotations(@NotNull KotlinType $receiver, Annotations newAnnotations) {
        if (KotlinTypeKt.isError($receiver)) {
            return $receiver.getAnnotations();
        }
        return AnnotationsKt.composeAnnotations(newAnnotations, $receiver.getAnnotations());
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRepeatedAnnotations(Annotations existingAnnotations, Annotations newAnnotations) {
        void destination$iv;
        void $receiver$iv;
        Iterable iterable = existingAnnotations;
        Collection collection = new HashSet();
        for (Object item$iv : $receiver$iv) {
            void it;
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)item$iv;
            void var11_8 = destination$iv;
            FqName fqName2 = it.getFqName();
            var11_8.add(fqName2);
        }
        HashSet existingAnnotationFqNames = (HashSet)destination$iv;
        for (AnnotationDescriptor annotation2 : newAnnotations) {
            if (!existingAnnotationFqNames.contains(annotation2.getFqName())) continue;
            this.reportStrategy.repeatedAnnotation(annotation2);
        }
    }

    private final SimpleType combineNullability(@NotNull SimpleType $receiver, KotlinType fromType) {
        SimpleType simpleType2 = TypeUtils.makeNullableIfNeeded($receiver, fromType.isMarkedNullable());
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "TypeUtils.makeNullableIf\u2026romType.isMarkedNullable)");
        return simpleType2;
    }

    private final SimpleType combineNullabilityAndAnnotations(@NotNull SimpleType $receiver, KotlinType fromType) {
        return this.combineAnnotations(this.combineNullability($receiver, fromType), fromType.getAnnotations());
    }

    /*
     * WARNING - void declaration
     */
    private final TypeProjection expandNonArgumentTypeProjection(TypeProjection originalProjection, TypeAliasExpansion typeAliasExpansion, int recursionDepth) {
        TypeProjection typeProjection;
        boolean bl;
        UnwrappedType originalType = originalProjection.getType().unwrap();
        if (DynamicTypesKt.isDynamic(originalType)) {
            return originalProjection;
        }
        SimpleType type2 = TypeSubstitutionKt.asSimpleType(originalType);
        if (KotlinTypeKt.isError(type2) || !TypeUtilsKt.requiresTypeAliasExpansion(type2)) {
            return originalProjection;
        }
        TypeConstructor typeConstructor2 = type2.getConstructor();
        ClassifierDescriptor typeDescriptor = typeConstructor2.getDeclarationDescriptor();
        boolean bl2 = bl = typeConstructor2.getParameters().size() == type2.getArguments().size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Unexpected malformed type: " + type2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ClassifierDescriptor classifierDescriptor = typeDescriptor;
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            typeProjection = originalProjection;
        } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            if (typeAliasExpansion.isRecursion((TypeAliasDescriptor)typeDescriptor)) {
                this.reportStrategy.recursiveTypeAlias((TypeAliasDescriptor)typeDescriptor);
                return new TypeProjectionImpl(Variance.INVARIANT, ErrorUtils.createErrorType("Recursive type alias: " + ((TypeAliasDescriptor)typeDescriptor).getName()));
            }
            Iterable iterable = $receiver$iv = (Iterable)type2.getArguments();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv) {
                void i;
                void typeAliasArgument;
                int n = index$iv$iv++;
                Collection collection = destination$iv$iv;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
                int n3 = n2;
                Collection collection2 = collection;
                TypeProjection typeProjection3 = this.expandTypeProjection((TypeProjection)typeAliasArgument, typeAliasExpansion, typeConstructor2.getParameters().get((int)i), recursionDepth + 1);
                collection2.add(typeProjection3);
            }
            List expandedArguments = (List)destination$iv$iv;
            TypeAliasExpansion nestedExpansion = TypeAliasExpansion.Companion.create(typeAliasExpansion, (TypeAliasDescriptor)typeDescriptor, expandedArguments);
            SimpleType nestedExpandedType = this.expandRecursively(nestedExpansion, type2.getAnnotations(), type2.isMarkedNullable(), recursionDepth + 1, false);
            SimpleType typeWithAbbreviation = DynamicTypesKt.isDynamic(nestedExpandedType) ? nestedExpandedType : SpecialTypesKt.withAbbreviation(nestedExpandedType, type2);
            typeProjection = new TypeProjectionImpl(originalProjection.getProjectionKind(), typeWithAbbreviation);
        } else {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable nestedExpandedType = $receiver$iv = (Iterable)type2.getArguments();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            int index$iv$iv = 0;
            for (Object item$iv$iv : $receiver$iv$iv) {
                void originalArgument;
                int n = index$iv$iv++;
                Collection collection = destination$iv$iv;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n4 = n;
                TypeProjection typeAliasArgument = (TypeProjection)item$iv$iv;
                int i = n4;
                Collection collection3 = collection;
                TypeProjection projection = this.expandTypeProjection((TypeProjection)originalArgument, typeAliasExpansion, typeConstructor2.getParameters().get(i), recursionDepth + 1);
                TypeProjection typeProjection4 = projection.isStarProjection() ? projection : (TypeProjection)new TypeProjectionImpl(projection.getProjectionKind(), TypeUtils.makeNullableIfNeeded(projection.getType(), originalArgument.getType().isMarkedNullable()));
                collection3.add(typeProjection4);
            }
            List substitutedArguments = (List)destination$iv$iv;
            SimpleType substitutedType = TypeSubstitutionKt.replace$default(type2, substitutedArguments, null, 2, null);
            this.checkTypeArgumentsSubstitution(type2, substitutedType);
            typeProjection = new TypeProjectionImpl(originalProjection.getProjectionKind(), substitutedType);
        }
        return typeProjection;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeArgumentsSubstitution(KotlinType unsubstitutedType, KotlinType substitutedType) {
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(substitutedType);
        Intrinsics.checkExpressionValueIsNotNull(typeSubstitutor2, "TypeSubstitutor.create(substitutedType)");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        Iterable $receiver$iv = substitutedType.getArguments();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void substitutedArgument;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            TypeProjection typeProjection = (TypeProjection)item$iv;
            int i = n2;
            if (substitutedArgument.isStarProjection()) continue;
            KotlinType kotlinType = substitutedArgument.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "substitutedArgument.type");
            if (TypeUtilsKt.containsTypeAliasParameters(kotlinType)) continue;
            TypeProjection unsubstitutedArgument = unsubstitutedType.getArguments().get(i);
            TypeParameterDescriptor typeParameter = unsubstitutedType.getConstructor().getParameters().get(i);
            if (!this.shouldCheckBounds) continue;
            DescriptorResolver.checkBoundsInTypeAlias(this.reportStrategy, unsubstitutedArgument.getType(), substitutedArgument.getType(), typeParameter, typeSubstitutor3);
        }
    }

    public TypeAliasExpander(@NotNull TypeAliasExpansionReportStrategy reportStrategy, boolean shouldCheckBounds) {
        Intrinsics.checkParameterIsNotNull(reportStrategy, "reportStrategy");
        this.reportStrategy = reportStrategy;
        this.shouldCheckBounds = shouldCheckBounds;
    }

    static {
        Companion = new Companion(null);
        NON_REPORTING = new TypeAliasExpander(TypeAliasExpansionReportStrategy.DO_NOTHING.INSTANCE, false);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/TypeAliasExpander$Companion;", "", "()V", "MAX_RECURSION_DEPTH", "", "NON_REPORTING", "Lorg/jetbrains/kotlin/resolve/TypeAliasExpander;", "getNON_REPORTING", "()Lorg/jetbrains/kotlin/resolve/TypeAliasExpander;", "assertRecursionDepth", "", "recursionDepth", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "frontend"})
    public static final class Companion {
        private final void assertRecursionDepth(int recursionDepth, TypeAliasDescriptor typeAliasDescriptor) {
            if (recursionDepth > 100) {
                throw (Throwable)((Object)new AssertionError((Object)("Too deep recursion while expanding type alias " + typeAliasDescriptor.getName())));
            }
        }

        @NotNull
        public final TypeAliasExpander getNON_REPORTING() {
            return NON_REPORTING;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

