/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBIterator<E>
implements Iterator<E> {
    private Object myCurrent = Do.INIT;
    private Object myNext = Do.INIT;
    private Op myFirstOp;
    private Op myLastOp = this.myFirstOp = new NextOp();
    private static final Function.Mono CURSOR_NEXT = new Function.Mono<JBIterator<?>>(){

        @Override
        public JBIterator<?> fun(JBIterator<?> iterator2) {
            return (JBIterator)((JBIterator)iterator2).addOp(false, iterator2.new CursorOp());
        }
    };

    @NotNull
    public static <E> JBIterator<E> from(@NotNull Iterator<E> it) {
        if (it == null) {
            JBIterator.$$$reportNull$$$0(2);
        }
        JBIterator<E> jBIterator = it instanceof JBIterator ? (JBIterator<E>)it : JBIterator.wrap(it);
        if (jBIterator == null) {
            JBIterator.$$$reportNull$$$0(3);
        }
        return jBIterator;
    }

    @NotNull
    static <E> JBIterator<E> wrap(final @NotNull Iterator<E> it) {
        if (it == null) {
            JBIterator.$$$reportNull$$$0(4);
        }
        JBIterator jBIterator = new JBIterator<E>(){

            @Override
            protected E nextImpl() {
                return it.hasNext() ? it.next() : this.stop();
            }
        };
        if (jBIterator == null) {
            JBIterator.$$$reportNull$$$0(5);
        }
        return jBIterator;
    }

    protected abstract E nextImpl();

    protected void currentChanged() {
    }

    @Nullable
    protected final E stop() {
        this.myNext = Do.STOP;
        return null;
    }

    @Nullable
    protected final E skip() {
        this.myNext = Do.SKIP;
        return null;
    }

    @Override
    public final boolean hasNext() {
        this.peekNext();
        return this.myNext != Do.STOP;
    }

    @Override
    public final E next() {
        this.advance();
        return this.current();
    }

    public final boolean advance() {
        this.myCurrent = Do.INIT;
        this.peekNext();
        if (this.myNext == Do.STOP) {
            return false;
        }
        this.myCurrent = this.myNext;
        this.myNext = Do.INIT;
        if (this.myFirstOp instanceof CursorOp) {
            ((CursorOp)this.myFirstOp).advance(this.myCurrent);
        }
        this.currentChanged();
        return true;
    }

    public final E current() {
        if (this.myCurrent == Do.INIT) {
            throw new NoSuchElementException();
        }
        return (E)this.myCurrent;
    }

    private void peekNext() {
        if (this.myNext != Do.INIT) {
            return;
        }
        Object o = Do.INIT;
        Op op2 = this.myFirstOp;
        while (op2 != null) {
            o = op2.apply(op2.impl == null ? this.nextImpl() : o);
            if (this.myNext == Do.STOP) {
                return;
            }
            if (this.myNext == Do.SKIP) {
                this.myNext = Do.INIT;
                o = this.myNext;
                if (op2.impl == null) {
                    Op op22 = this.myFirstOp;
                    while (op22.impl instanceof CountDown) {
                        ++((CountDown)op22.impl).cur;
                        op22 = op22.nextOp;
                    }
                }
                op2 = null;
            }
            op2 = op2 == null ? this.myFirstOp : op2.nextOp;
        }
        this.myNext = o;
    }

    @NotNull
    public final <T> JBIterator<T> map(@NotNull Function<? super E, T> function2) {
        if (function2 == null) {
            JBIterator.$$$reportNull$$$0(6);
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new TransformOp<E, T>(function2));
        if (jBIterator == null) {
            JBIterator.$$$reportNull$$$0(7);
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> filter(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterator.$$$reportNull$$$0(8);
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new FilterOp<E>(condition));
        if (jBIterator == null) {
            JBIterator.$$$reportNull$$$0(9);
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> take(int count2) {
        JBIterator jBIterator = (JBIterator)this.addOp(!(this.myLastOp instanceof NextOp), new WhileOp(new CountDown(count2)));
        if (jBIterator == null) {
            JBIterator.$$$reportNull$$$0(10);
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> takeWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterator.$$$reportNull$$$0(11);
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new WhileOp<E>(condition));
        if (jBIterator == null) {
            JBIterator.$$$reportNull$$$0(12);
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> skip(int count2) {
        JBIterator jBIterator = this.skipWhile(new CountDown(count2));
        if (jBIterator == null) {
            JBIterator.$$$reportNull$$$0(13);
        }
        return jBIterator;
    }

    @NotNull
    public final JBIterator<E> skipWhile(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterator.$$$reportNull$$$0(14);
        }
        JBIterator jBIterator = (JBIterator)this.addOp(true, new SkipOp<E>(condition));
        if (jBIterator == null) {
            JBIterator.$$$reportNull$$$0(15);
        }
        return jBIterator;
    }

    @NotNull
    private <T> T addOp(boolean last2, @NotNull Op op2) {
        if (op2 == null) {
            JBIterator.$$$reportNull$$$0(16);
        }
        if (op2.impl == null) {
            this.myFirstOp = this.myLastOp = op2;
        } else if (last2) {
            this.myLastOp = this.myLastOp.nextOp = op2;
        } else {
            op2.nextOp = this.myFirstOp;
            this.myFirstOp = op2;
        }
        JBIterator jBIterator = this;
        if (jBIterator == null) {
            JBIterator.$$$reportNull$$$0(17);
        }
        return (T)jBIterator;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        List<Op> ops = this.operationsImpl().toList();
        return "{cur=" + this.myCurrent + "; next=" + this.myNext + (ops.size() < 2 ? "" : "; ops=" + ops) + "}";
    }

    @NotNull
    private JBIterable<Op> operationsImpl() {
        JBIterable<Op> jBIterable = JBIterable.generate(this.myFirstOp, new Function<Op, Op>(){

            @Override
            public Op fun(Op op2) {
                return op2.nextOp;
            }
        });
        if (jBIterable == null) {
            JBIterator.$$$reportNull$$$0(20);
        }
        return jBIterable;
    }

    @NotNull
    static String toShortString(@NotNull Object o) {
        String name;
        int idx;
        if (o == null) {
            JBIterator.$$$reportNull$$$0(21);
        }
        if ((idx = (name = o.getClass().getName()).lastIndexOf(36)) > 0 && idx < name.length() && StringUtil.isJavaIdentifierStart(name.charAt(idx + 1))) {
            String string = name.substring(idx + 1);
            if (string == null) {
                JBIterator.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = name.substring(name.lastIndexOf(46) + 1);
        if (string == null) {
            JBIterator.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/JBIterator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "op";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/JBIterator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cursor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "take";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "takeWhile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "skip";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "skipWhile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addOp";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransformations";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "operationsImpl";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "toShortString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cursor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "takeWhile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "skipWhile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addOp";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "toShortString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CursorOp
    extends Op<Void> {
        boolean advanced;

        CursorOp() {
            super(null);
        }

        @Override
        Object apply(Object o) {
            JBIterator it = (JBIterator)o;
            this.advanced = this.nextOp != null;
            return (this.advanced ? it.advance() : it.hasNext()) ? it : JBIterator.this.stop();
        }

        void advance(Object o) {
            if (this.advanced || !(o instanceof JBIterator)) {
                return;
            }
            ((JBIterator)o).advance();
            this.advanced = true;
        }
    }

    private static class NextOp
    extends Op<Void> {
        NextOp() {
            super(null);
        }

        @Override
        Object apply(Object o) {
            return o;
        }
    }

    private class SkipOp<E>
    extends Op<Condition<? super E>> {
        boolean active;

        SkipOp(Condition<? super E> condition) {
            super(condition);
            this.active = true;
        }

        @Override
        Object apply(Object o) {
            if (this.active && ((Condition)this.impl).value(o)) {
                return JBIterator.this.skip();
            }
            this.active = false;
            return o;
        }
    }

    private class WhileOp<E>
    extends Op<Condition<? super E>> {
        WhileOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        Object apply(Object o) {
            return ((Condition)this.impl).value(o) ? o : JBIterator.this.stop();
        }
    }

    private class FilterOp<E>
    extends Op<Condition<? super E>> {
        FilterOp(Condition<? super E> condition) {
            super(condition);
        }

        @Override
        Object apply(Object o) {
            return ((Condition)this.impl).value(o) ? o : JBIterator.this.skip();
        }
    }

    private static class TransformOp<E, T>
    extends Op<Function<? super E, T>> {
        TransformOp(Function<? super E, T> function2) {
            super(function2);
        }

        @Override
        Object apply(Object o) {
            return ((Function)this.impl).fun(o);
        }
    }

    private static class CountDown<A>
    implements Condition<A> {
        int cur;

        public CountDown(int count2) {
            this.cur = count2;
        }

        @Override
        public boolean value(A a) {
            return this.cur > 0 && this.cur-- != 0;
        }
    }

    private static class Op<T> {
        final T impl;
        Op nextOp;

        public Op(T impl) {
            this.impl = impl;
        }

        Object apply(Object o) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return JBIterator.toShortString(this.impl == null ? this : this.impl);
        }
    }

    private static enum Do {
        INIT,
        STOP,
        SKIP;

    }
}

