/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryValue {
    private final Registry myRegistry;
    private final String myKey;
    @Nullable
    private final RegistryKeyDescriptor myKeyDescriptor;
    private final List<Object> myListeners;
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private Double myDoubleCachedValue;
    private Boolean myBooleanCachedValue;
    private static final Logger LOG = Logger.getInstance(RegistryValue.class);

    RegistryValue(@NotNull Registry registry, @NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) {
        if (registry == null) {
            RegistryValue.$$$reportNull$$$0(0);
        }
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(1);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRegistry = registry;
        this.myKey = key;
        this.myKeyDescriptor = keyDescriptor;
    }

    @NotNull
    public String asString() {
        String value = this.get(this.myKey, null, true);
        assert (value != null) : this.myKey;
        String string = value;
        if (string == null) {
            RegistryValue.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean asBoolean() {
        if (this.myBooleanCachedValue == null) {
            this.myBooleanCachedValue = Boolean.valueOf(this.get(this.myKey, "false", true));
        }
        return this.myBooleanCachedValue;
    }

    public int asInteger() {
        if (this.myIntCachedValue == null) {
            try {
                this.myIntCachedValue = Integer.valueOf(this.get(this.myKey, "0", true));
            }
            catch (NumberFormatException e) {
                String bundleValue = Registry.getInstance().getBundleValue(this.myKey, true);
                assert (bundleValue != null);
                this.myIntCachedValue = Integer.valueOf(bundleValue);
            }
        }
        return this.myIntCachedValue;
    }

    public double asDouble() {
        if (this.myDoubleCachedValue == null) {
            try {
                this.myDoubleCachedValue = Double.valueOf(this.get(this.myKey, "0.0", true));
            }
            catch (NumberFormatException e) {
                String bundleValue = Registry.getInstance().getBundleValue(this.myKey, true);
                assert (bundleValue != null);
                this.myDoubleCachedValue = Double.valueOf(bundleValue);
            }
        }
        return this.myDoubleCachedValue;
    }

    protected String get(@NotNull String key, String defaultValue, boolean isValue) throws MissingResourceException {
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(7);
        }
        if (isValue) {
            if (this.myStringCachedValue == null) {
                this.myStringCachedValue = this._get(key, defaultValue, true);
            }
            return this.myStringCachedValue;
        }
        return this._get(key, defaultValue, false);
    }

    private String _get(@NotNull String key, String defaultValue, boolean mustExistInBundle) throws MissingResourceException {
        String userValue;
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(8);
        }
        if ((userValue = this.myRegistry.getUserProperties().get(key)) != null) {
            return userValue;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        String bundleValue = Registry.getInstance().getBundleValue(key, mustExistInBundle);
        if (bundleValue != null) {
            return bundleValue;
        }
        return defaultValue;
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isChangedFromDefault";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "_get";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

