/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileContentUtilCore {
    public static void reparseFiles(VirtualFile ... files2) {
        if (files2 == null) {
            FileContentUtilCore.$$$reportNull$$$0(0);
        }
        FileContentUtilCore.reparseFiles(Arrays.asList(files2));
    }

    public static void reparseFiles(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            FileContentUtilCore.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (files2 == null) {
                FileContentUtilCore.$$$reportNull$$$0(3);
            }
            THashSet events = new THashSet();
            for (VirtualFile file2 : files2) {
                FileContentUtilCore.saveOrReload(file2, (Collection<? super VFilePropertyChangeEvent>)events);
            }
            BulkFileListener publisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            List eventList = Collections.unmodifiableList(new ArrayList(events));
            publisher.before(eventList);
            publisher.after(eventList);
        });
    }

    private static void saveOrReload(VirtualFile file2, @NotNull Collection<? super VFilePropertyChangeEvent> events) {
        Document document;
        if (events == null) {
            FileContentUtilCore.$$$reportNull$$$0(2);
        }
        if (file2 == null || file2.isDirectory() || !file2.isValid()) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.isFileModified(file2) && (document = documentManager.getDocument(file2)) != null) {
            documentManager.saveDocumentAsIs(document);
        }
        events.add(new VFilePropertyChangeEvent("FileContentUtilCore.saveOrReload", file2, "name", file2.getName(), file2.getName(), false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/FileContentUtilCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reparseFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "saveOrReload";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$reparseFiles$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

