/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.classes;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.light.LightReferenceListBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class KotlinLightReferenceListBuilder
extends LightReferenceListBuilder
implements PsiReferenceList {
    private final List<PsiJavaCodeReferenceElement> myRefs = new ArrayList<PsiJavaCodeReferenceElement>();
    private volatile PsiJavaCodeReferenceElement[] myCachedRefs;
    private volatile PsiClassType[] myCachedTypes;
    private final PsiReferenceList.Role myRole;
    private final PsiElementFactory myFactory;

    public KotlinLightReferenceListBuilder(PsiManager manager, PsiReferenceList.Role role) {
        this(manager, JavaLanguage.INSTANCE, role);
    }

    public KotlinLightReferenceListBuilder(PsiManager manager, Language language, PsiReferenceList.Role role) {
        super(manager, language, role);
        this.myRole = role;
        this.myFactory = JavaPsiFacade.getElementFactory(this.getProject());
    }

    @Override
    public void addReference(PsiClass aClass2) {
        this.addReference(aClass2.getQualifiedName());
    }

    @Override
    public void addReference(String qualifiedName) {
        PsiJavaCodeReferenceElement ref = this.myFactory.createReferenceElementByFQClassName(qualifiedName, this.getResolveScope());
        this.myRefs.add(ref);
    }

    @Override
    public void addReference(PsiClassType type2) {
        PsiJavaCodeReferenceElement ref = this.myFactory.createReferenceElementByType(type2);
        this.myRefs.add(ref);
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        PsiJavaCodeReferenceElement[] refs = this.myCachedRefs;
        if (refs == null) {
            refs = this.myRefs.toArray(PsiJavaCodeReferenceElement.EMPTY_ARRAY);
            this.myCachedRefs = refs;
        }
        return refs;
    }

    @Override
    @NotNull
    public PsiClassType[] getReferencedTypes() {
        PsiClassType[] types = this.myCachedTypes;
        if (types == null) {
            int size = this.myRefs.size();
            types = size == 0 ? PsiClassType.EMPTY_ARRAY : new PsiClassType[size];
            for (int i = 0; i < size; ++i) {
                types[i] = this.myFactory.createType(this.myRefs.get(i));
            }
            this.myCachedTypes = types;
        }
        return types;
    }

    @Override
    public PsiReferenceList.Role getRole() {
        return this.myRole;
    }
}

