/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForFacade;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForScript;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.cli.jvm.compiler.CliTraceHolder;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.components.FilesByFacadeFqNameIndexer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.ResolveSessionUtils;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u000bH\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010)\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/CliKotlinAsJavaSupport;", "Lorg/jetbrains/kotlin/asJava/KotlinAsJavaSupport;", "project", "Lcom/intellij/openapi/project/Project;", "traceHolder", "Lorg/jetbrains/kotlin/cli/jvm/compiler/CliTraceHolder;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/cli/jvm/compiler/CliTraceHolder;)V", "psiManager", "Lcom/intellij/psi/PsiManager;", "findClassOrObjectDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findClassOrObjectDeclarationsInPackage", "packageFqName", "findFacadeFilesInPackage", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "scope", "findFilesForFacade", "facadeFqName", "findFilesForPackage", "getFacadeClasses", "Lcom/intellij/psi/PsiClass;", "getFacadeClassesInPackage", "getFacadeNames", "", "getKotlinInternalClasses", "getLightClass", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "classOrObject", "getLightClassForScript", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClassForScript;", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "getScriptClasses", "scriptFqName", "getSubPackages", "fqn", "packageExists", "", "cli"})
public final class CliKotlinAsJavaSupport
extends KotlinAsJavaSupport {
    private final PsiManager psiManager;
    private final CliTraceHolder traceHolder;

    @Override
    @NotNull
    public Collection<PsiClass> getFacadeClassesInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope) {
        Object $receiver$iv$iv$iv;
        Object $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Object $receiver$iv = this.findFacadeFilesInPackage(packageFqName, scope);
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object $receiver$iv$iv$iv2 = destination$iv$iv;
            Object element$iv$iv = iterator2.next();
            KtFile it = (KtFile)element$iv$iv;
            FqName key$iv$iv = JvmFileClassUtilKt.getJavaFileFacadeFqName(it);
            Object value$iv$iv$iv = $receiver$iv$iv$iv2.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Object object = $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator3 = object.entrySet().iterator();
        while (iterator3.hasNext()) {
            KtLightClassForFacade ktLightClassForFacade;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry $facadeClassFqName_files;
            Map.Entry entry = $facadeClassFqName_files = (element$iv$iv = (element$iv$iv$iv = iterator3.next()));
            FqName facadeClassFqName = (FqName)entry.getKey();
            entry = $facadeClassFqName_files;
            List files2 = (List)entry.getValue();
            PsiManager psiManager = this.psiManager;
            Intrinsics.checkExpressionValueIsNotNull(psiManager, "psiManager");
            if (KtLightClassForFacade.Factory.createForFacade(psiManager, facadeClassFqName, scope, files2) == null) continue;
            KtLightClassForFacade it$iv$iv = ktLightClassForFacade;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<String> getFacadeNames(@NotNull FqName packageFqName, @NotNull GlobalSearchScope scope) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Iterable $receiver$iv = this.findFacadeFilesInPackage(packageFqName, scope);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KtFile ktFile = (KtFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)it).shortName().asString();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> findFacadeFilesInPackage(FqName packageFqName, GlobalSearchScope scope) {
        List list2;
        List list3;
        List list4;
        Collection collection = (Collection)this.traceHolder.getBindingContext().get(FilesByFacadeFqNameIndexer.FACADE_FILES_BY_PACKAGE_NAME, packageFqName);
        if (collection != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv = collection;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                KtFile it = (KtFile)element$iv$iv;
                if (!PsiSearchScopeUtil.isInScope(scope, (PsiElement)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list4 = (List)destination$iv$iv;
        } else {
            list4 = null;
        }
        if ((list3 = (list2 = list4)) == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @Override
    @NotNull
    public Collection<PsiClass> getFacadeClasses(@NotNull FqName facadeFqName, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull(facadeFqName, "facadeFqName");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        Collection<KtFile> filesForFacade = this.findFilesForFacade(facadeFqName, scope);
        if (filesForFacade.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PsiManager psiManager = this.psiManager;
        Intrinsics.checkExpressionValueIsNotNull(psiManager, "psiManager");
        return CollectionsKt.listOfNotNull(KtLightClassForFacade.Factory.createForFacade(psiManager, facadeFqName, scope, filesForFacade));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<PsiClass> getScriptClasses(@NotNull FqName scriptFqName, @NotNull GlobalSearchScope scope) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(scriptFqName, "scriptFqName");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        if (scriptFqName.isRoot()) {
            return CollectionsKt.emptyList();
        }
        FqName fqName2 = scriptFqName.parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "scriptFqName.parent()");
        Iterable iterable = $receiver$iv = (Iterable)this.findFilesForPackage(fqName2, scope);
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KtLightClassForScript ktLightClassForScript;
            KtLightClassForScript ktLightClassForScript2;
            KtScript ktScript;
            KtScript it;
            Object element$iv$iv = element$iv$iv$iv;
            KtFile file2 = (KtFile)element$iv$iv;
            KtScript ktScript2 = file2.getScript();
            if (ktScript2 != null && (ktScript2 = Intrinsics.areEqual((it = (ktScript = ktScript2)).getFqName(), scriptFqName) ? ktScript : null) != null) {
                it = ktScript = ktScript2;
                ktLightClassForScript2 = this.getLightClassForScript(it);
            } else {
                ktLightClassForScript2 = null;
            }
            if (ktLightClassForScript2 == null) continue;
            KtLightClassForScript it$iv$iv = ktLightClassForScript = ktLightClassForScript2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Collection<PsiClass> getKotlinInternalClasses(@NotNull FqName fqName2, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtFile> findFilesForFacade(@NotNull FqName facadeFqName, @NotNull GlobalSearchScope scope) {
        List list2;
        List list3;
        List list4;
        Intrinsics.checkParameterIsNotNull(facadeFqName, "facadeFqName");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        if (facadeFqName.isRoot()) {
            return CollectionsKt.emptyList();
        }
        Collection collection = (Collection)this.traceHolder.getBindingContext().get(FilesByFacadeFqNameIndexer.FACADE_FILES_BY_FQ_NAME, facadeFqName);
        if (collection != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                KtFile it = (KtFile)element$iv$iv;
                if (!PsiSearchScopeUtil.isInScope(scope, (PsiElement)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list4 = (List)destination$iv$iv;
        } else {
            list4 = null;
        }
        if ((list3 = (list2 = list4)) == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @Override
    @NotNull
    public Collection<KtClassOrObject> findClassOrObjectDeclarationsInPackage(@NotNull FqName packageFqName, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Intrinsics.checkParameterIsNotNull(searchScope, "searchScope");
        Collection<KtFile> files2 = this.findFilesForPackage(packageFqName, searchScope);
        SmartList<KtDeclaration> result2 = new SmartList<KtDeclaration>();
        for (KtFile file2 : files2) {
            for (KtDeclaration declaration : file2.getDeclarations()) {
                if (!(declaration instanceof KtClassOrObject)) continue;
                result2.add(declaration);
            }
        }
        return result2;
    }

    @Override
    public boolean packageExists(@NotNull FqName fqName2, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        return !this.traceHolder.getModule().getPackage(fqName2).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<FqName> getSubPackages(@NotNull FqName fqn, @NotNull GlobalSearchScope scope) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(fqn, "fqn");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        PackageViewDescriptor packageView = this.traceHolder.getModule().getPackage(fqn);
        Iterable iterable = packageView.getMemberScope().getContributedDescriptors(DescriptorKindFilter.PACKAGES, MemberScope.Companion.getALL_NAME_FILTER());
        void var5_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            FqName fqName2;
            Object element$iv$iv = element$iv$iv$iv;
            DeclarationDescriptor member = (DeclarationDescriptor)element$iv$iv;
            DeclarationDescriptor declarationDescriptor = member;
            if (!(declarationDescriptor instanceof PackageViewDescriptor)) {
                declarationDescriptor = null;
            }
            PackageViewDescriptor packageViewDescriptor = (PackageViewDescriptor)declarationDescriptor;
            FqName fqName3 = packageViewDescriptor != null ? packageViewDescriptor.getFqName() : null;
            if (fqName3 == null) continue;
            FqName it$iv$iv = fqName2 = fqName3;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public KtLightClass getLightClass(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull(classOrObject, "classOrObject");
        return KtLightClassForSourceDeclaration.Companion.create(classOrObject);
    }

    @Override
    @Nullable
    public KtLightClassForScript getLightClassForScript(@NotNull KtScript script) {
        Intrinsics.checkParameterIsNotNull(script, "script");
        return KtLightClassForScript.Companion.create(script);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtClassOrObject> findClassOrObjectDeclarations(@NotNull FqName fqName2, @NotNull GlobalSearchScope searchScope) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(searchScope, "searchScope");
        Collection<ClassDescriptor> collection = ResolveSessionUtils.getClassDescriptorsByFqName(this.traceHolder.getModule(), fqName2);
        Intrinsics.checkExpressionValueIsNotNull(collection, "ResolveSessionUtils.getC\u2026aceHolder.module, fqName)");
        Iterable iterable = $receiver$iv = (Iterable)collection;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtClassOrObject ktClassOrObject;
            ClassDescriptor it;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            ClassDescriptor classDescriptor2 = it = (ClassDescriptor)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "it");
            PsiElement element = DescriptorToSourceUtils.getSourceFromDescriptor(classDescriptor2);
            KtClassOrObject ktClassOrObject2 = element instanceof KtClassOrObject && PsiSearchScopeUtil.isInScope(searchScope, element) ? (KtClassOrObject)element : null;
            if (ktClassOrObject2 == null) continue;
            KtClassOrObject it$iv$iv = ktClassOrObject = ktClassOrObject2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtFile> findFilesForPackage(@NotNull FqName fqName2, @NotNull GlobalSearchScope searchScope) {
        List list2;
        List list3;
        List list4;
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        Intrinsics.checkParameterIsNotNull(searchScope, "searchScope");
        Collection collection = (Collection)this.traceHolder.getBindingContext().get(BindingContext.PACKAGE_TO_FILES, fqName2);
        if (collection != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)collection;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                KtFile it = (KtFile)element$iv$iv;
                if (!PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list4 = (List)destination$iv$iv;
        } else {
            list4 = null;
        }
        if ((list3 = (list2 = list4)) == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    public CliKotlinAsJavaSupport(@NotNull Project project, @NotNull CliTraceHolder traceHolder) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        Intrinsics.checkParameterIsNotNull(traceHolder, "traceHolder");
        this.traceHolder = traceHolder;
        this.psiManager = PsiManager.getInstance(project);
    }
}

