/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.context;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.FunctionReader;
import org.jetbrains.kotlin.js.inline.util.FunctionUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H$J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0018H$J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/js/inline/context/FunctionContext;", "", "functionReader", "Lorg/jetbrains/kotlin/js/inline/FunctionReader;", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "(Lorg/jetbrains/kotlin/js/inline/FunctionReader;Lorg/jetbrains/kotlin/js/config/JsConfig;)V", "getFunctionDefinition", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "call", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "getFunctionDefinitionImpl", "hasFunctionDefinition", "", "lookUpFunctionDirect", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "lookUpFunctionExternal", "lookUpFunctionIndirect", "lookUpStaticFunction", "functionName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "lookUpStaticFunctionByTag", "functionTag", "", "tryExtractCallableReference", "invocation", "js.translator"})
public abstract class FunctionContext {
    private final FunctionReader functionReader;
    private final JsConfig config;

    @Nullable
    protected abstract FunctionWithWrapper lookUpStaticFunction(@Nullable JsName var1);

    @Nullable
    protected abstract FunctionWithWrapper lookUpStaticFunctionByTag(@NotNull String var1);

    @NotNull
    public final FunctionWithWrapper getFunctionDefinition(@NotNull JsInvocation call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        FunctionWithWrapper functionWithWrapper = this.getFunctionDefinitionImpl(call2);
        if (functionWithWrapper == null) {
            Intrinsics.throwNpe();
        }
        return functionWithWrapper;
    }

    public final boolean hasFunctionDefinition(@NotNull JsInvocation call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        return this.getFunctionDefinitionImpl(call2) != null;
    }

    private final FunctionWithWrapper getFunctionDefinitionImpl(JsInvocation call2) {
        CallableDescriptor descriptor2 = MetadataProperties.getDescriptor(call2);
        if (descriptor2 != null) {
            FunctionWithWrapper functionWithWrapper;
            FunctionWithWrapper functionWithWrapper2 = this.lookUpFunctionDirect(descriptor2);
            if (functionWithWrapper2 == null) {
                functionWithWrapper2 = functionWithWrapper = this.lookUpFunctionIndirect(call2);
            }
            if (functionWithWrapper2 == null) {
                functionWithWrapper = this.lookUpFunctionExternal(descriptor2);
            }
            return functionWithWrapper;
        }
        return this.lookUpFunctionIndirect(call2);
    }

    private final FunctionWithWrapper lookUpFunctionIndirect(JsInvocation call2) {
        FunctionWithWrapper functionWithWrapper;
        JsExpression qualifier;
        JsExpression jsExpression;
        if (InvocationUtilsKt.isCallInvocation(call2)) {
            JsExpression jsExpression2 = call2.getQualifier();
            if (jsExpression2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsNameRef");
            }
            JsExpression jsExpression3 = ((JsNameRef)jsExpression2).getQualifier();
            if (jsExpression3 == null) {
                Intrinsics.throwNpe();
            }
            jsExpression = jsExpression3;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression3, "(call.qualifier as JsNameRef).qualifier!!");
        } else {
            JsExpression jsExpression4 = call2.getQualifier();
            jsExpression = jsExpression4;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression4, "call.qualifier");
        }
        JsExpression callQualifier = jsExpression;
        JsExpression jsExpression5 = qualifier = InvocationUtilsKt.getTransitiveStaticRef(callQualifier);
        if (jsExpression5 instanceof JsInvocation) {
            functionWithWrapper = this.tryExtractCallableReference((JsInvocation)qualifier);
            if (functionWithWrapper == null) {
                JsName jsName = InvocationUtilsKt.getSimpleName((JsInvocation)qualifier);
                if (jsName != null) {
                    FunctionWithWrapper functionWithWrapper2;
                    FunctionWithWrapper it;
                    JsName jsName2;
                    JsName simpleName = jsName2 = jsName;
                    FunctionWithWrapper functionWithWrapper3 = this.lookUpStaticFunction(simpleName);
                    functionWithWrapper = functionWithWrapper3 != null ? (FunctionUtilsKt.isFunctionCreator((it = (functionWithWrapper2 = functionWithWrapper3)).getFunction()) ? it : null) : null;
                } else {
                    functionWithWrapper = null;
                }
            }
        } else {
            functionWithWrapper = jsExpression5 instanceof JsNameRef ? this.lookUpStaticFunction(((JsNameRef)qualifier).getName()) : (jsExpression5 instanceof JsFunction ? new FunctionWithWrapper((JsFunction)qualifier, null) : null);
        }
        return functionWithWrapper;
    }

    private final FunctionWithWrapper lookUpFunctionDirect(CallableDescriptor descriptor2) {
        String string = Namer.getFunctionTag(descriptor2, this.config);
        Intrinsics.checkExpressionValueIsNotNull(string, "Namer.getFunctionTag(descriptor, config)");
        return this.lookUpStaticFunctionByTag(string);
    }

    private final FunctionWithWrapper lookUpFunctionExternal(CallableDescriptor descriptor2) {
        return this.functionReader.get(descriptor2);
    }

    private final FunctionWithWrapper tryExtractCallableReference(JsInvocation invocation) {
        JsExpression arg;
        if (MetadataProperties.isCallableReference(invocation) && (arg = invocation.getArguments().get(1)) instanceof JsFunction) {
            return new FunctionWithWrapper((JsFunction)arg, null);
        }
        return null;
    }

    public FunctionContext(@NotNull FunctionReader functionReader, @NotNull JsConfig config) {
        Intrinsics.checkParameterIsNotNull(functionReader, "functionReader");
        Intrinsics.checkParameterIsNotNull(config, "config");
        this.functionReader = functionReader;
        this.config = config;
    }
}

