/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionComparatorUtil {
    private static final Pattern WORDS_SPLITTER = Pattern.compile("\\d+|[^\\d]+");
    private static final VersionTokenType[] VALUES = VersionTokenType.values();
    public static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return VersionComparatorUtil.compare(s1, s2);
        }
    };
    public static final Function<String, Integer> DEFAULT_TOKEN_PRIORITY_PROVIDER = new Function<String, Integer>(){

        @Override
        public Integer fun(String s) {
            return VersionTokenType.lookup(s).getPriority();
        }
    };

    static List<String> splitVersionString(String ver) {
        StringTokenizer st = new StringTokenizer(ver.trim(), "()._-;:/, +~");
        ArrayList<String> result2 = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            Matcher matcher2 = WORDS_SPLITTER.matcher(st.nextToken());
            while (matcher2.find()) {
                result2.add(matcher2.group());
            }
        }
        return result2;
    }

    public static int compare(String ver1, String ver2) {
        return VersionComparatorUtil.compare(ver1, ver2, DEFAULT_TOKEN_PRIORITY_PROVIDER);
    }

    public static int compare(String ver1, String ver2, Function<? super String, Integer> tokenPriorityProvider) {
        if (ver1 == null) {
            return ver2 == null ? 0 : -1;
        }
        if (ver2 == null) {
            return 1;
        }
        ver1 = ver1.toLowerCase();
        ver2 = ver2.toLowerCase();
        List<String> s1 = VersionComparatorUtil.splitVersionString(ver1);
        List<String> s2 = VersionComparatorUtil.splitVersionString(ver2);
        VersionComparatorUtil.padWithNulls(s1, s2);
        for (int i = 0; i < s1.size(); ++i) {
            String e1 = s1.get(i);
            String e2 = s2.get(i);
            VersionTokenType t1 = VersionTokenType.lookup(e1);
            int res2 = VersionComparatorUtil.comparePriorities(e1, e2, tokenPriorityProvider);
            if (res2 != 0) {
                return res2;
            }
            if (t1 == VersionTokenType._WORD) {
                res2 = e1.compareTo(e2);
            } else if (t1 == VersionTokenType._DIGITS) {
                res2 = VersionComparatorUtil.compareNumbers(e1, e2);
            }
            if (res2 == 0) continue;
            return res2;
        }
        return 0;
    }

    public static int comparePriorities(String ver1, String ver2, Function<? super String, Integer> tokenPriorityProvider) {
        int priority1 = tokenPriorityProvider.fun(ver1);
        int priority2 = tokenPriorityProvider.fun(ver2);
        return Integer.signum(priority1 - priority2);
    }

    private static int compareNumbers(String n1, String n2) {
        int n2len;
        while (n1.length() > 0 && n2.length() > 0 && n1.charAt(0) == '0' && n2.charAt(0) == '0') {
            n1 = n1.substring(1);
            n2 = n2.substring(1);
        }
        if (n1.length() > 0 && n1.charAt(0) == '0') {
            return -1;
        }
        if (n2.length() > 0 && n2.charAt(0) == '0') {
            return 1;
        }
        int n1len = n1.length();
        if (n1len > (n2len = n2.length())) {
            return 1;
        }
        if (n2len > n1len) {
            return -1;
        }
        return n1.compareTo(n2);
    }

    private static void padWithNulls(Collection<String> s1, Collection<String> s2) {
        if (s1.size() != s2.size()) {
            while (s1.size() < s2.size()) {
                s1.add(null);
            }
            while (s1.size() > s2.size()) {
                s2.add(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VersionTokenType {
        SNAP(10),
        SNAPSHOT(10),
        M(20),
        EAP(25),
        PRE(25),
        PREVIEW(25),
        ALPHA(30),
        A(30),
        BETA(40),
        BETTA(40),
        B(40),
        RC(50),
        _WS(60),
        SP(70),
        REL(80),
        RELEASE(80),
        R(80),
        FINAL(80),
        _WORD(90),
        _DIGITS(100),
        BUNDLED(666);

        private final int myPriority;

        private VersionTokenType(int priority) {
            this.myPriority = priority;
        }

        @NotNull
        public static VersionTokenType lookup(String str) {
            if (str == null) {
                VersionTokenType versionTokenType = _WS;
                if (versionTokenType == null) {
                    VersionTokenType.$$$reportNull$$$0(0);
                }
                return versionTokenType;
            }
            if ((str = str.trim()).length() == 0) {
                VersionTokenType versionTokenType = _WS;
                if (versionTokenType == null) {
                    VersionTokenType.$$$reportNull$$$0(1);
                }
                return versionTokenType;
            }
            for (VersionTokenType token : VALUES) {
                String name = token.name();
                if (name.charAt(0) == '_' || !name.equalsIgnoreCase(str)) continue;
                VersionTokenType versionTokenType = token;
                if (versionTokenType == null) {
                    VersionTokenType.$$$reportNull$$$0(2);
                }
                return versionTokenType;
            }
            if (str.matches("0+")) {
                VersionTokenType versionTokenType = _WS;
                if (versionTokenType == null) {
                    VersionTokenType.$$$reportNull$$$0(3);
                }
                return versionTokenType;
            }
            if (str.matches("\\d+")) {
                VersionTokenType versionTokenType = _DIGITS;
                if (versionTokenType == null) {
                    VersionTokenType.$$$reportNull$$$0(4);
                }
                return versionTokenType;
            }
            VersionTokenType versionTokenType = _WORD;
            if (versionTokenType == null) {
                VersionTokenType.$$$reportNull$$$0(5);
            }
            return versionTokenType;
        }

        public int getPriority() {
            return this.myPriority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/VersionComparatorUtil$VersionTokenType", "lookup"));
        }
    }
}

