/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callResolverUtil;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopesKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutionKt;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0090\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a:\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u001a$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\"\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d\u001a&\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a&\u0010 \u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001a\u001a\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000b2\u0006\u0010(\u001a\u00020\u0013H\u0002\u001a\u000e\u0010)\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013\u001a\u0010\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010,\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0013\u001a\u000e\u0010-\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0013\u001a\u0016\u0010.\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010/\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00100\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00101\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00102\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00103\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00104\u001a\u00020\u00012\u0006\u0010$\u001a\u000205\u001a\u000e\u00106\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u00107\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013\u001a\u0016\u00108\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u0013\u001a\u001e\u0010:\u001a\u00020;2\u0006\u0010(\u001a\u00020\u00132\f\u0010<\u001a\b\u0012\u0004\u0012\u00020'0\u000bH\u0002\u001a\u0012\u0010=\u001a\u00020\u0001*\u00020\u001a2\u0006\u0010>\u001a\u00020?\u001a\u0014\u0010@\u001a\u00020\u0001*\u00020\u001a2\u0006\u0010>\u001a\u00020?H\u0002\u00a8\u0006A"}, d2={"arrayAssignmentToVarargInNamedFormInAnnotation", "", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "createResolutionCandidatesForConstructors", "", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ResolutionCandidate;", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "lexicalScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "typeWithConstructors", "Lorg/jetbrains/kotlin/types/KotlinType;", "useKnownTypeSubstitutor", "syntheticScopes", "Lorg/jetbrains/kotlin/resolve/scopes/SyntheticScopes;", "filterOutTypeParameters", "upperBounds", "candidateDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getEffectiveExpectedType", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "getEffectiveExpectedTypeForSingleArgument", "getErasedReceiverType", "receiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "descriptor", "getExpectedType", "getParameterArgumentsOfCallableType", "Lorg/jetbrains/kotlin/types/TypeProjection;", "type", "getReturnTypeForCallable", "getSuperCallExpression", "Lorg/jetbrains/kotlin/psi/KtSuperExpression;", "hasUnknownFunctionParameter", "hasUnknownReturnType", "isArrayOrArrayLiteral", "isBinaryRemOperator", "isConventionCall", "isInfixCall", "isInvokeCallOnExpressionWithBothReceivers", "isInvokeCallOnVariable", "isOrOverridesSynthesized", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isSuperOrDelegatingConstructorCall", "replaceReturnTypeByUnknown", "replaceReturnTypeForCallable", "given", "replaceTypeArguments", "Lorg/jetbrains/kotlin/types/SimpleType;", "newArguments", "hasInferredReturnType", "constraintSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "hasReturnTypeDependentOnUninferredParams", "frontend"})
public final class CallResolverUtilKt {
    public static final boolean hasUnknownFunctionParameter(@NotNull KotlinType type2) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull(type2, "type");
            boolean bl2 = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string = "type " + type2 + " is not a function or property";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable $this$any$iv = CallResolverUtilKt.getParameterArgumentsOfCallableType(type2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeProjection it = (TypeProjection)element$iv;
                    boolean bl5 = false;
                    KotlinType kotlinType2 = it.getType();
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "it.type");
                    if (!(TypeUtilsKt.contains(kotlinType2, hasUnknownFunctionParameter.2.1.INSTANCE) || ErrorUtils.containsUninferredParameter(it.getType()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasUnknownReturnType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        boolean bl = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return ErrorUtils.containsErrorType(CallResolverUtilKt.getReturnTypeForCallable(type2));
    }

    @NotNull
    public static final KotlinType replaceReturnTypeForCallable(@NotNull KotlinType type2, @NotNull KotlinType given) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(given, "given");
        boolean bl = ReflectionTypes.Companion.isCallableType(type2) || FunctionTypesKt.isSuspendFunctionType(type2);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "type " + type2 + " is not a function or property";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ArrayList<TypeProjectionImpl> newArguments2 = Lists.newArrayList();
        newArguments2.addAll((Collection)CallResolverUtilKt.getParameterArgumentsOfCallableType(type2));
        newArguments2.add(new TypeProjectionImpl(Variance.INVARIANT, given));
        ArrayList<TypeProjectionImpl> arrayList = newArguments2;
        Intrinsics.checkExpressionValueIsNotNull(arrayList, "newArguments");
        return CallResolverUtilKt.replaceTypeArguments(type2, (List<? extends TypeProjection>)arrayList);
    }

    @NotNull
    public static final KotlinType replaceReturnTypeByUnknown(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        SimpleType simpleType2 = TypeUtils.DONT_CARE;
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "DONT_CARE");
        return CallResolverUtilKt.replaceReturnTypeForCallable(type2, simpleType2);
    }

    private static final SimpleType replaceTypeArguments(KotlinType type2, List<? extends TypeProjection> newArguments2) {
        return KotlinTypeFactory.simpleType(type2.getAnnotations(), type2.getConstructor(), newArguments2, type2.isMarkedNullable());
    }

    private static final List<TypeProjection> getParameterArgumentsOfCallableType(KotlinType type2) {
        return CollectionsKt.dropLast(type2.getArguments(), 1);
    }

    @NotNull
    public static final KotlinType getReturnTypeForCallable(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        KotlinType kotlinType2 = CollectionsKt.last(type2.getArguments()).getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "type.arguments.last().type");
        return kotlinType2;
    }

    private static final boolean hasReturnTypeDependentOnUninferredParams(@NotNull CallableDescriptor $this$hasReturnTypeDependentOnUninferredParams, ConstraintSystem constraintSystem) {
        boolean bl;
        block4: {
            KotlinType kotlinType2 = $this$hasReturnTypeDependentOnUninferredParams.getReturnType();
            if (kotlinType2 == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "returnType ?: return false");
            KotlinType returnType2 = kotlinType2;
            List<TypeVariable> nestedTypeVariables = ConstraintSystemUtilsKt.getNestedTypeVariables(constraintSystem, returnType2);
            Iterable $this$any$iv = nestedTypeVariables;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeVariable it = (TypeVariable)element$iv;
                    boolean bl2 = false;
                    if (!(constraintSystem.getTypeBounds(it).getValue() == null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasInferredReturnType(@NotNull CallableDescriptor $this$hasInferredReturnType, @NotNull ConstraintSystem constraintSystem) {
        Intrinsics.checkParameterIsNotNull($this$hasInferredReturnType, "$this$hasInferredReturnType");
        Intrinsics.checkParameterIsNotNull(constraintSystem, "constraintSystem");
        if (CallResolverUtilKt.hasReturnTypeDependentOnUninferredParams($this$hasInferredReturnType, constraintSystem)) {
            return false;
        }
        return !constraintSystem.getStatus().hasOnlyErrorsDerivedFrom(ConstraintPositionKind.EXPECTED_TYPE_POSITION);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KotlinType> filterOutTypeParameters(List<? extends KotlinType> upperBounds, CallableDescriptor candidateDescriptor) {
        void $this$filterNotTo$iv$iv;
        if (upperBounds.size() < 2) {
            return upperBounds;
        }
        Iterable $this$filterNot$iv = upperBounds;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KotlinType it = (KotlinType)element$iv$iv;
            boolean bl = false;
            ClassifierDescriptor declarationDescriptor = it.getConstructor().getDeclarationDescriptor();
            if (declarationDescriptor instanceof TypeParameterDescriptor && Intrinsics.areEqual(((TypeParameterDescriptor)declarationDescriptor).getContainingDeclaration(), candidateDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List result2 = (List)destination$iv$iv;
        if (result2.isEmpty()) {
            return upperBounds;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KotlinType getErasedReceiverType(@NotNull ReceiverParameterDescriptor receiverParameterDescriptor, @NotNull CallableDescriptor descriptor2) {
        TypeConstructor typeConstructor2;
        Intrinsics.checkParameterIsNotNull(receiverParameterDescriptor, "receiverParameterDescriptor");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        KotlinType kotlinType2 = receiverParameterDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "receiverParameterDescriptor.type");
        KotlinType receiverType = kotlinType2;
        Iterator<TypeParameterDescriptor> iterator2 = descriptor2.getTypeParameters().iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameter;
            TypeParameterDescriptor typeParameterDescriptor = typeParameter = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
            if (!Intrinsics.areEqual(typeParameterDescriptor.getTypeConstructor(), receiverType.getConstructor())) continue;
            List<KotlinType> list2 = typeParameter.getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull(list2, "typeParameter.upperBounds");
            List<KotlinType> properUpperBounds = CallResolverUtilKt.filterOutTypeParameters(list2, descriptor2);
            Intrinsics.checkExpressionValueIsNotNull(TypeIntersector.intersectUpperBounds(typeParameter, properUpperBounds), "TypeIntersector.intersec\u2026meter, properUpperBounds)");
        }
        List list3 = ContainerUtil.newSmartList();
        Intrinsics.checkExpressionValueIsNotNull(list3, "ContainerUtil.newSmartList<TypeProjection>()");
        List fakeTypeArguments = list3;
        for (TypeProjection typeProjection : receiverType.getArguments()) {
            fakeTypeArguments.add(new TypeProjectionImpl(typeProjection.getProjectionKind(), TypeUtils.DONT_CARE));
        }
        if (receiverType.getConstructor() instanceof IntersectionTypeConstructor) {
            void $this$mapTo$iv$iv;
            Collection<KotlinType> collection = receiverType.getConstructor().getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection, "receiverType.constructor.supertypes");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void supertype;
                KotlinType kotlinType3 = (KotlinType)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv2 = supertype.getArguments();
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    TypeProjection typeProjection = (TypeProjection)item$iv$iv2;
                    Collection collection3 = destination$iv$iv2;
                    boolean bl2 = false;
                    TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(it.getProjectionKind(), TypeUtils.DONT_CARE);
                    collection3.add(typeProjectionImpl);
                }
                List fakeArguments = (List)destination$iv$iv2;
                void v5 = supertype;
                Intrinsics.checkExpressionValueIsNotNull(v5, "supertype");
                KotlinType kotlinType4 = TypeSubstitutionKt.replace$default((KotlinType)v5, fakeArguments, null, 2, null);
                collection2.add(kotlinType4);
            }
            List superTypesWithFakeArguments = (List)destination$iv$iv;
            typeConstructor2 = new IntersectionTypeConstructor(superTypesWithFakeArguments);
        } else {
            typeConstructor2 = receiverType.getConstructor();
        }
        TypeConstructor receiverTypeConstructor = typeConstructor2;
        Annotations annotations2 = receiverType.getAnnotations();
        boolean bl = receiverType.isMarkedNullable();
        MemberScope memberScope2 = ErrorUtils.createErrorScope("Error scope for erased receiver type", true);
        Intrinsics.checkExpressionValueIsNotNull(memberScope2, "ErrorUtils.createErrorSc\u2026/*throwExceptions=*/true)");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(annotations2, receiverTypeConstructor, fakeTypeArguments, bl, memberScope2);
    }

    public static final boolean isOrOverridesSynthesized(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return true;
        }
        if (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            boolean bl;
            block5: {
                Collection<? extends CallableMemberDescriptor> collection = descriptor2.getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(collection, "descriptor.overriddenDescriptors");
                Iterable $this$all$iv = collection;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        CallableMemberDescriptor p1 = (CallableMemberDescriptor)element$iv;
                        boolean bl2 = false;
                        if (CallResolverUtilKt.isOrOverridesSynthesized(p1)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    public static final boolean isBinaryRemOperator(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        KtElement ktElement = call2.getCallElement();
        if (!(ktElement instanceof KtBinaryExpression)) {
            ktElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktElement;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression callElement = ktBinaryExpression;
        IElementType iElementType = callElement.getOperationToken();
        Intrinsics.checkExpressionValueIsNotNull(iElementType, "callElement.operationToken");
        IElementType operator = iElementType;
        if (!(operator instanceof KtToken)) {
            return false;
        }
        Name name = OperatorConventions.getNameForOperationSymbol((KtToken)operator, true, true);
        if (name == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull(name, "OperatorConventions.getN\u2026ue, true) ?: return false");
        Name name2 = name;
        return ((ImmutableSet)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.keySet()).contains(name2);
    }

    public static final boolean isConventionCall(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        if (call2 instanceof CallTransformer.CallForImplicitInvoke) {
            return true;
        }
        KtElement ktElement = call2.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull(ktElement, "call.callElement");
        KtElement callElement = ktElement;
        if (callElement instanceof KtArrayAccessExpression || callElement instanceof KtDestructuringDeclarationEntry) {
            return true;
        }
        KtExpression ktExpression = call2.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression calleeExpression = ktOperationReferenceExpression;
        return calleeExpression.isConventionOperator();
    }

    public static final boolean isInfixCall(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        KtExpression ktExpression = call2.getCalleeExpression();
        if (!(ktExpression instanceof KtOperationReferenceExpression)) {
            ktExpression = null;
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = (KtOperationReferenceExpression)ktExpression;
        if (ktOperationReferenceExpression == null) {
            return false;
        }
        KtOperationReferenceExpression operationRefExpression = ktOperationReferenceExpression;
        PsiElement psiElement = operationRefExpression.getParent();
        if (!(psiElement instanceof KtBinaryExpression)) {
            psiElement = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        return binaryExpression.getOperationReference() == operationRefExpression && operationRefExpression.getOperationSignTokenType() == null;
    }

    public static final boolean isSuperOrDelegatingConstructorCall(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        KtExpression ktExpression = call2.getCalleeExpression();
        boolean bl = false;
        boolean bl2 = false;
        KtExpression it = ktExpression;
        boolean bl3 = false;
        return it instanceof KtConstructorCalleeExpression || it instanceof KtConstructorDelegationReferenceExpression;
    }

    public static final boolean isInvokeCallOnVariable(@NotNull Call call2) {
        ReceiverValue dispatchReceiver;
        Intrinsics.checkParameterIsNotNull(call2, "call");
        if (call2.getCallType() != Call.CallType.INVOKE) {
            return false;
        }
        ReceiverValue receiverValue = dispatchReceiver = call2.getDispatchReceiver();
        if (receiverValue == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver");
        }
        KtExpression expression2 = ((ExpressionReceiver)receiverValue).getExpression();
        return expression2 instanceof KtSimpleNameExpression;
    }

    public static final boolean isInvokeCallOnExpressionWithBothReceivers(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        if (call2.getCallType() != Call.CallType.INVOKE || CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            return false;
        }
        return call2.getExplicitReceiver() != null && call2.getDispatchReceiver() != null;
    }

    @Nullable
    public static final KtSuperExpression getSuperCallExpression(@NotNull Call call2) {
        Intrinsics.checkParameterIsNotNull(call2, "call");
        Receiver receiver = call2.getExplicitReceiver();
        if (!(receiver instanceof ExpressionReceiver)) {
            receiver = null;
        }
        ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiver;
        KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        if (!(ktExpression instanceof KtSuperExpression)) {
            ktExpression = null;
        }
        return (KtSuperExpression)ktExpression;
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(resolvedArgument, "resolvedArgument");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        List<ValueArgument> list2 = resolvedArgument.getArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, "resolvedArgument.arguments");
        ValueArgument argument = CollectionsKt.singleOrNull(list2);
        return argument != null ? CallResolverUtilKt.getEffectiveExpectedTypeForSingleArgument(parameterDescriptor, argument, languageVersionSettings, trace) : CallResolverUtilKt.getExpectedType(parameterDescriptor);
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedType(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument, @NotNull ResolutionContext<?> context2) {
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        LanguageVersionSettings languageVersionSettings = context2.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings, "context.languageVersionSettings");
        BindingTrace bindingTrace = context2.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        return CallResolverUtilKt.getEffectiveExpectedTypeForSingleArgument(parameterDescriptor, argument, languageVersionSettings, bindingTrace);
    }

    @NotNull
    public static final KotlinType getEffectiveExpectedTypeForSingleArgument(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        if (argument.getSpreadElement() != null) {
            KotlinType kotlinType2;
            if (parameterDescriptor.getVarargElementType() == null) {
                SimpleType simpleType2 = TypeUtils.DONT_CARE;
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "DONT_CARE");
                kotlinType2 = simpleType2;
            } else {
                KotlinType kotlinType3 = parameterDescriptor.getType();
                kotlinType2 = kotlinType3;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "parameterDescriptor.type");
            }
            return kotlinType2;
        }
        if (CallResolverUtilKt.arrayAssignmentToVarargInNamedFormInAnnotation(parameterDescriptor, argument, languageVersionSettings, trace)) {
            KotlinType kotlinType4 = parameterDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "parameterDescriptor.type");
            return kotlinType4;
        }
        return CallResolverUtilKt.getExpectedType(parameterDescriptor);
    }

    private static final KotlinType getExpectedType(ValueParameterDescriptor parameterDescriptor) {
        KotlinType kotlinType2 = parameterDescriptor.getVarargElementType();
        if (kotlinType2 == null) {
            KotlinType kotlinType3 = parameterDescriptor.getType();
            kotlinType2 = kotlinType3;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "parameterDescriptor.type");
        }
        return kotlinType2;
    }

    private static final boolean arrayAssignmentToVarargInNamedFormInAnnotation(ValueParameterDescriptor parameterDescriptor, ValueArgument argument, LanguageVersionSettings languageVersionSettings, BindingTrace trace) {
        if (!languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return false;
        }
        if (!DescriptorUtilsKt.isParameterOfAnnotation(parameterDescriptor)) {
            return false;
        }
        return argument.isNamed() && ArgumentsUtilsKt.isVararg(parameterDescriptor) && CallResolverUtilKt.isArrayOrArrayLiteral(argument, trace);
    }

    public static final boolean isArrayOrArrayLiteral(@NotNull ValueArgument argument, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        KtExpression ktExpression = argument.getArgumentExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression argumentExpression = ktExpression;
        if (argumentExpression instanceof KtCollectionLiteralExpression) {
            return true;
        }
        KotlinType kotlinType2 = trace.getType(argumentExpression);
        if (kotlinType2 == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "trace.getType(argumentExpression) ?: return false");
        KotlinType type2 = kotlinType2;
        return KotlinBuiltIns.isArrayOrPrimitiveArray(type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ResolutionCandidate<ConstructorDescriptor>> createResolutionCandidatesForConstructors(@NotNull LexicalScope lexicalScope, @NotNull Call call2, @NotNull KotlinType typeWithConstructors, boolean useKnownTypeSubstitutor, @NotNull SyntheticScopes syntheticScopes) {
        void $this$mapTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$firstOrNull$iv;
        Collection collection;
        TypeAliasDescriptor typeAliasDescriptor;
        Object object;
        TypeAliasDescriptor typeAliasDescriptor2;
        TypeSubstitutor knownSubstitutor;
        TypeSubstitutor typeSubstitutor2;
        Intrinsics.checkParameterIsNotNull(lexicalScope, "lexicalScope");
        Intrinsics.checkParameterIsNotNull(call2, "call");
        Intrinsics.checkParameterIsNotNull(typeWithConstructors, "typeWithConstructors");
        Intrinsics.checkParameterIsNotNull(syntheticScopes, "syntheticScopes");
        ClassifierDescriptor classifierDescriptor = typeWithConstructors.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor classWithConstructors = (ClassDescriptor)classifierDescriptor;
        UnwrappedType unwrappedType = typeWithConstructors.unwrap();
        if (useKnownTypeSubstitutor) {
            SimpleType simpleType2;
            UnwrappedType unwrappedType2 = unwrappedType;
            if (!(unwrappedType2 instanceof AbbreviatedType)) {
                unwrappedType2 = null;
            }
            typeSubstitutor2 = TypeSubstitutor.create((simpleType2 = (AbbreviatedType)unwrappedType2) != null && (simpleType2 = simpleType2.getAbbreviation()) != null ? (UnwrappedType)simpleType2 : unwrappedType);
        } else {
            typeSubstitutor2 = knownSubstitutor = null;
        }
        if (unwrappedType instanceof AbbreviatedType) {
            ClassifierDescriptor classifierDescriptor2 = ((AbbreviatedType)unwrappedType).getAbbreviation().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor2 instanceof TypeAliasDescriptor)) {
                classifierDescriptor2 = null;
            }
            typeAliasDescriptor2 = (TypeAliasDescriptor)classifierDescriptor2;
        } else {
            typeAliasDescriptor2 = null;
        }
        if ((object = (typeAliasDescriptor = typeAliasDescriptor2)) != null && (object = object.getConstructors()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                TypeAliasConstructorDescriptor typeAliasConstructorDescriptor;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Object receiver = element$iv$iv;
                boolean bl2 = false;
                if (((TypeAliasConstructorDescriptor)receiver).getWithDispatchReceiver() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                TypeAliasConstructorDescriptor it$iv$iv = typeAliasConstructorDescriptor;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            Collection collection2 = classWithConstructors.getConstructors();
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull(collection2, "classWithConstructors.constructors");
        }
        Collection constructors2 = collection;
        if (constructors2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ExplicitReceiverKind receiverKind = null;
        ReceiverValue dispatchReceiver = null;
        if (classWithConstructors.isInner()) {
            Object v12;
            block20: {
                Annotated annotated;
                DeclarationDescriptor declarationDescriptor = classWithConstructors.getContainingDeclaration();
                if (!(declarationDescriptor instanceof ClassDescriptor)) {
                    declarationDescriptor = null;
                }
                if ((annotated = (ClassDescriptor)declarationDescriptor) == null || (annotated = annotated.getDefaultType()) == null) {
                    return CollectionsKt.emptyList();
                }
                Intrinsics.checkExpressionValueIsNotNull(annotated, "(classWithConstructors.c\u2026ype ?: return emptyList()");
                Annotated outerClassType = annotated;
                Object object2 = knownSubstitutor;
                if (object2 == null || (object2 = ((TypeSubstitutor)object2).substitute((KotlinType)outerClassType, Variance.INVARIANT)) == null) {
                    object2 = (KotlinType)outerClassType;
                }
                Intrinsics.checkExpressionValueIsNotNull(object2, "knownSubstitutor?.substi\u2026ARIANT) ?: outerClassType");
                Object substitutedOuterClassType = object2;
                $this$firstOrNull$iv = ScopeUtilsKt.getImplicitReceiversHierarchy(lexicalScope);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ReceiverParameterDescriptor it = (ReceiverParameterDescriptor)element$iv;
                    boolean bl = false;
                    if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(it.getType(), (KotlinType)substitutedOuterClassType)) continue;
                    v12 = element$iv;
                    break block20;
                }
                v12 = null;
            }
            ReceiverParameterDescriptor receiverParameterDescriptor = v12;
            if (receiverParameterDescriptor == null) {
                return CollectionsKt.emptyList();
            }
            ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
            receiverKind = ExplicitReceiverKind.DISPATCH_RECEIVER;
            dispatchReceiver = receiver.getValue();
        } else {
            receiverKind = ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
            dispatchReceiver = null;
        }
        Iterable $this$flatMap$iv = constructors2;
        boolean $i$f$flatMap = false;
        $this$firstOrNull$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ConstructorDescriptor it = (ConstructorDescriptor)element$iv$iv;
            boolean bl = false;
            ConstructorDescriptor constructorDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull(constructorDescriptor, "it");
            Iterable list$iv$iv = SyntheticScopesKt.collectSyntheticConstructors(syntheticScopes, constructorDescriptor);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List syntheticConstructors = (List)destination$iv$iv;
        Iterable $this$map$iv = CollectionsKt.plus(constructors2, (Iterable)syntheticConstructors);
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConstructorDescriptor list$iv$iv = (ConstructorDescriptor)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            ResolutionCandidate<CallableDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, (CallableDescriptor)it, dispatchReceiver, receiverKind, knownSubstitutor);
            collection3.add(resolutionCandidate);
        }
        return (List)destination$iv$iv;
    }
}

