/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtil$getPsiMethodWrappers$;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KotlinLightTypeParameterListBuilder;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.asJava.elements.KtLightField;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightMethodImplKt;
import org.jetbrains.kotlin.asJava.elements.KtLightTypeParameter;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J,\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0016\u0010\u0015\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\n0\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010#\u001a\u00020$J\u0010\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010%\u001a\u00020&J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f2\u0006\u0010#\u001a\u00020$J\u000e\u0010(\u001a\u00020\f2\u0006\u0010%\u001a\u00020&J\u000e\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*J\u0010\u0010+\u001a\u0004\u0018\u00010!2\u0006\u0010,\u001a\u00020-J\u0012\u0010.\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u0012002\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/asJava/LightClassUtil;", "", "()V", "buildLightTypeParameterList", "Lcom/intellij/psi/PsiTypeParameterList;", "owner", "Lcom/intellij/psi/PsiTypeParameterListOwner;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canGenerateLightClass", "", "extractPropertyAccessors", "Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "ktDeclaration", "specialGetter", "Lcom/intellij/psi/PsiMethod;", "specialSetter", "findClass", "Lcom/intellij/psi/PsiClass;", "stub", "Lcom/intellij/psi/stubs/StubElement;", "predicate", "Lkotlin/Function1;", "Lcom/intellij/psi/impl/java/stubs/PsiClassStub;", "findFileFacade", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLightClassAccessorMethod", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "getLightClassAccessorMethods", "", "getLightClassBackingField", "Lcom/intellij/psi/PsiField;", "getLightClassMethod", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getLightClassMethods", "getLightClassPropertyMethods", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getLightFieldForCompanionObject", "companionObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getPsiMethodWrapper", "getPsiMethodWrappers", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightMethod;", "getWrappingClass", "getWrappingClasses", "PropertyAccessorsPsiMethods", "light-classes"})
public final class LightClassUtil {
    public static final LightClassUtil INSTANCE;

    @Nullable
    public final PsiClass findClass(@NotNull StubElement<?> stub, @NotNull Function1<? super PsiClassStub<?>, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull(stub, "stub");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        if (stub instanceof PsiClassStub && predicate.invoke((PsiClassStub<?>)stub).booleanValue()) {
            return (PsiClass)((PsiClassStub)stub).getPsi();
        }
        if (stub instanceof PsiClassStub || stub instanceof PsiFileStub) {
            Iterator<StubElement> iterator2 = stub.getChildrenStubs().iterator();
            while (iterator2.hasNext()) {
                StubElement child;
                StubElement stubElement = child = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(stubElement, "child");
                PsiClass answer = this.findClass(stubElement, predicate);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }

    @Nullable
    public final PsiMethod getLightClassAccessorMethod(@NotNull KtPropertyAccessor accessor) {
        Intrinsics.checkParameterIsNotNull(accessor, "accessor");
        return CollectionsKt.firstOrNull(this.getLightClassAccessorMethods(accessor));
    }

    @NotNull
    public final List<PsiMethod> getLightClassAccessorMethods(@NotNull KtPropertyAccessor accessor) {
        Intrinsics.checkParameterIsNotNull(accessor, "accessor");
        PsiElement $this$getNonStrictParentOfType$iv = accessor;
        boolean $i$f$getNonStrictParentOfType = false;
        KtProperty ktProperty = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtProperty.class, false);
        if (ktProperty == null) {
            return CollectionsKt.emptyList();
        }
        KtProperty property = ktProperty;
        Sequence<KtLightMethod> wrappers = this.getPsiMethodWrappers(property);
        return SequencesKt.toList(SequencesKt.filter(wrappers, (Function1)new Function1<KtLightMethod, Boolean>(accessor){
            final /* synthetic */ KtPropertyAccessor $accessor;

            public final boolean invoke(@NotNull KtLightMethod wrapper) {
                Intrinsics.checkParameterIsNotNull(wrapper, "wrapper");
                return this.$accessor.isGetter() && !JvmAbi.isSetterName(wrapper.getName()) || this.$accessor.isSetter() && JvmAbi.isSetterName(wrapper.getName());
            }
            {
                this.$accessor = ktPropertyAccessor;
                super(1);
            }
        }));
    }

    @Nullable
    public final PsiField getLightFieldForCompanionObject(@NotNull KtClassOrObject companionObject) {
        Intrinsics.checkParameterIsNotNull(companionObject, "companionObject");
        PsiClass outerPsiClass = this.getWrappingClass(companionObject);
        if (outerPsiClass != null) {
            for (PsiField fieldOfParent : outerPsiClass.getFields()) {
                if (!(fieldOfParent instanceof KtLightElement) || ((KtLightElement)((Object)fieldOfParent)).getKotlinOrigin() != companionObject.getOriginalElement()) continue;
                return fieldOfParent;
            }
        }
        return null;
    }

    @NotNull
    public final PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull KtProperty property) {
        Intrinsics.checkParameterIsNotNull(property, "property");
        KtPropertyAccessor getter2 = property.getGetter();
        KtPropertyAccessor setter2 = property.getSetter();
        PsiMethod getterWrapper = getter2 != null ? this.getLightClassAccessorMethod(getter2) : null;
        PsiMethod setterWrapper = setter2 != null ? this.getLightClassAccessorMethod(setter2) : null;
        return this.extractPropertyAccessors(property, getterWrapper, setterWrapper);
    }

    @Nullable
    public final PsiField getLightClassBackingField(@NotNull KtDeclaration declaration2) {
        KtLightClass containingLightClass;
        KtClass containingClass;
        KtClassOrObject origin;
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        PsiClass psiClass = this.getWrappingClass(declaration2);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        if (psiClass2 instanceof KtLightClass && (origin = (KtClassOrObject)((KtLightClass)psiClass2).getKotlinOrigin()) instanceof KtObjectDeclaration && ((KtObjectDeclaration)origin).isCompanion() && (containingClass = PsiTreeUtil.getParentOfType((PsiElement)origin, KtClass.class)) != null && (containingLightClass = LightClassUtilsKt.toLightClass(containingClass)) != null) {
            psiClass2 = containingLightClass;
        }
        for (PsiField field : psiClass2.getFields()) {
            if (!(field instanceof KtLightField) || (KtDeclaration)((KtLightField)field).getKotlinOrigin() != declaration2) continue;
            return field;
        }
        return null;
    }

    @NotNull
    public final PropertyAccessorsPsiMethods getLightClassPropertyMethods(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        return this.extractPropertyAccessors(parameter, null, null);
    }

    @Nullable
    public final PsiMethod getLightClassMethod(@NotNull KtFunction function2) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        return this.getPsiMethodWrapper(function2);
    }

    @Nullable
    public final PsiMethod getLightClassMethod(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull(parameter, "parameter");
        return this.getPsiMethodWrapper(parameter);
    }

    @NotNull
    public final List<PsiMethod> getLightClassMethods(@NotNull KtFunction function2) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        return SequencesKt.toList(this.getPsiMethodWrappers(function2));
    }

    private final PsiMethod getPsiMethodWrapper(KtDeclaration declaration2) {
        return SequencesKt.firstOrNull(this.getPsiMethodWrappers(declaration2));
    }

    private final Sequence<KtLightMethod> getPsiMethodWrappers(KtDeclaration declaration2) {
        Sequence $this$filterIsInstance$iv = SequencesKt.flatMap(this.getWrappingClasses(declaration2), getPsiMethodWrappers.1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter($this$filterIsInstance$iv, getPsiMethodWrappers$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        return SequencesKt.filter(sequence2, (Function1)new Function1<KtLightMethod, Boolean>(declaration2){
            final /* synthetic */ KtDeclaration $declaration;

            public final boolean invoke(@NotNull KtLightMethod it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                return (KtDeclaration)it.getKotlinOrigin() == this.$declaration;
            }
            {
                this.$declaration = ktDeclaration;
                super(1);
            }
        });
    }

    private final PsiClass getWrappingClass(KtDeclaration declaration2) {
        KtClassOrObject constructorClass;
        if (declaration2 instanceof KtParameter && (constructorClass = KtPsiUtil.getClassIfParameterIsProperty((KtParameter)declaration2)) != null) {
            return LightClassUtilsKt.toLightClass(constructorClass);
        }
        KtDeclaration ktDeclaration = declaration2;
        if (ktDeclaration instanceof KtPropertyAccessor) {
            KtProperty ktProperty = ((KtPropertyAccessor)ktDeclaration).getProperty();
            Intrinsics.checkExpressionValueIsNotNull(ktProperty, "ktDeclaration.property");
            ktDeclaration = ktProperty;
        }
        if (ktDeclaration instanceof KtConstructor) {
            return LightClassUtilsKt.toLightClass(((KtConstructor)ktDeclaration).getContainingClassOrObject());
        }
        PsiElement parent2 = ktDeclaration.getParent();
        if (parent2 instanceof KtFile) {
            return this.findFileFacade((KtFile)parent2);
        }
        if (parent2 instanceof KtClassBody) {
            boolean bl = ((KtClassBody)parent2).getParent() instanceof KtClassOrObject;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                PsiElement psiElement = ((KtClassBody)parent2).getParent();
                String string2 = "Bad parent: " + (psiElement != null ? psiElement.getClass() : null);
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            PsiElement psiElement = ((KtClassBody)parent2).getParent();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            }
            return LightClassUtilsKt.toLightClass((KtClassOrObject)psiElement);
        }
        return null;
    }

    private final PsiClass findFileFacade(KtFile ktFile) {
        PsiClass psiClass;
        block2: {
            FqName fqName2 = JvmFileClassUtilKt.getJavaFileFacadeFqName(ktFile);
            Project project = ktFile.getProject();
            Intrinsics.checkExpressionValueIsNotNull(project, "ktFile.project");
            Project project2 = project;
            JavaElementFinder javaElementFinder = JavaElementFinder.Companion.getInstance(project2);
            String string2 = fqName2.asString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "fqName.asString()");
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project2);
            Intrinsics.checkExpressionValueIsNotNull(globalSearchScope, "GlobalSearchScope.allScope(project)");
            PsiClass[] classesWithMatchingFqName = javaElementFinder.findClasses(string2, globalSearchScope);
            psiClass = ArraysKt.singleOrNull(classesWithMatchingFqName);
            if (psiClass == null) {
                PsiClass[] psiClassArray = classesWithMatchingFqName;
                boolean bl = false;
                PsiClass[] psiClassArray2 = psiClassArray;
                boolean bl2 = false;
                PsiClass[] psiClassArray3 = psiClassArray2;
                int n = psiClassArray3.length;
                for (int i = 0; i < n; ++i) {
                    PsiClass psiClass2;
                    PsiClass it = psiClass2 = psiClassArray3[i];
                    boolean bl3 = false;
                    PsiFile psiFile = it.getContainingFile();
                    if (!Intrinsics.areEqual(psiFile != null ? psiFile.getVirtualFile() : null, ktFile.getVirtualFile())) continue;
                    psiClass = psiClass2;
                    break block2;
                }
                psiClass = null;
            }
        }
        return psiClass;
    }

    private final Sequence<PsiClass> getWrappingClasses(KtDeclaration declaration2) {
        PsiClass wrapperClass;
        PsiClass psiClass = this.getWrappingClass(declaration2);
        if (psiClass == null) {
            return SequencesKt.emptySequence();
        }
        PsiClass psiClass2 = wrapperClass = psiClass;
        if (psiClass2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.asJava.classes.KtLightClass");
        }
        KtClassOrObject wrapperClassOrigin = (KtClassOrObject)((KtLightClass)psiClass2).getKotlinOrigin();
        if (wrapperClassOrigin instanceof KtObjectDeclaration && ((KtObjectDeclaration)wrapperClassOrigin).isCompanion() && ((KtLightClass)wrapperClass).getParent() instanceof PsiClass) {
            PsiClass[] psiClassArray = new PsiClass[2];
            psiClassArray[0] = wrapperClass;
            PsiElement psiElement = ((KtLightClass)wrapperClass).getParent();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiClass");
            }
            psiClassArray[1] = (PsiClass)psiElement;
            return SequencesKt.sequenceOf(psiClassArray);
        }
        return SequencesKt.sequenceOf((KtLightClass)wrapperClass);
    }

    public final boolean canGenerateLightClass(@NotNull KtDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        return PsiTreeUtil.getParentOfType((PsiElement)declaration2, KtFunction.class, KtProperty.class) == null;
    }

    /*
     * WARNING - void declaration
     */
    private final PropertyAccessorsPsiMethods extractPropertyAccessors(KtDeclaration ktDeclaration, PsiMethod specialGetter, PsiMethod specialSetter) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void setters;
        void $this$filterNotTo$iv$iv2;
        void $this$filterNot$iv2;
        Object $this$partition$iv = this.getPsiMethodWrappers(ktDeclaration);
        boolean $i$f$partition = false;
        ArrayList<KtLightMethod> first$iv = new ArrayList<KtLightMethod>();
        ArrayList<KtLightMethod> second$iv = new ArrayList<KtLightMethod>();
        Iterator<KtLightMethod> iterator2 = $this$partition$iv.iterator();
        while (iterator2.hasNext()) {
            KtLightMethod element$iv = iterator2.next();
            KtLightMethod it = element$iv;
            boolean bl = false;
            if (KtLightMethodImplKt.isSetter(it)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List list2 = pair.component1();
        List getters = pair.component2();
        $this$partition$iv = getters;
        Collection collection = CollectionsKt.listOfNotNull(specialGetter);
        boolean $i$f$filterNot22 = false;
        first$iv = $this$filterNot$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
            KtLightMethod it = (KtLightMethod)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it, specialGetter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        List allGetters = CollectionsKt.plus(collection, (Iterable)list3);
        Iterable $i$f$filterNot22 = (Iterable)setters;
        collection = CollectionsKt.listOfNotNull(specialSetter);
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KtLightMethod it = (KtLightMethod)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it, specialSetter)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        list3 = (List)destination$iv$iv2;
        List allSetters = CollectionsKt.plus(collection, (Iterable)list3);
        PsiField backingField2 = this.getLightClassBackingField(ktDeclaration);
        List additionalAccessors = CollectionsKt.plus((Collection)CollectionsKt.drop(allGetters, 1), (Iterable)CollectionsKt.drop(allSetters, 1));
        return new PropertyAccessorsPsiMethods((PsiMethod)CollectionsKt.firstOrNull(allGetters), (PsiMethod)CollectionsKt.firstOrNull(allSetters), backingField2, additionalAccessors);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PsiTypeParameterList buildLightTypeParameterList(@NotNull PsiTypeParameterListOwner owner, @NotNull KtDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(declaration2, "declaration");
        KotlinLightTypeParameterListBuilder builder = new KotlinLightTypeParameterListBuilder(owner);
        if (declaration2 instanceof KtTypeParameterListOwner) {
            List<KtTypeParameter> list2 = ((KtTypeParameterListOwner)declaration2).getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "declaration.typeParameters");
            List<KtTypeParameter> parameters2 = list2;
            int n = 0;
            int n2 = ((Collection)parameters2).size();
            while (n < n2) {
                void i;
                KtTypeParameter jetTypeParameter;
                KtTypeParameter ktTypeParameter = jetTypeParameter = parameters2.get((int)i);
                Intrinsics.checkExpressionValueIsNotNull(ktTypeParameter, "jetTypeParameter");
                String name = ktTypeParameter.getName();
                String string2 = name;
                if (string2 == null) {
                    string2 = "__no_name__";
                }
                String safeName = string2;
                builder.addParameter(new KtLightTypeParameter(owner, (int)i, safeName));
                ++i;
            }
        }
        return builder;
    }

    private LightClassUtil() {
    }

    static {
        LightClassUtil lightClassUtil;
        INSTANCE = lightClassUtil = new LightClassUtil();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010(\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B1\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0096\u0002R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/asJava/LightClassUtil$PropertyAccessorsPsiMethods;", "", "Lcom/intellij/psi/PsiMethod;", "getter", "setter", "backingField", "Lcom/intellij/psi/PsiField;", "additionalAccessors", "", "(Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiMethod;Lcom/intellij/psi/PsiField;Ljava/util/List;)V", "allDeclarations", "Lcom/intellij/psi/PsiNamedElement;", "getAllDeclarations", "()Ljava/util/List;", "allMethods", "getBackingField", "()Lcom/intellij/psi/PsiField;", "getGetter", "()Lcom/intellij/psi/PsiMethod;", "getSetter", "iterator", "", "light-classes"})
    public static final class PropertyAccessorsPsiMethods
    implements Iterable<PsiMethod>,
    KMappedMarker {
        private final List<PsiMethod> allMethods;
        @NotNull
        private final List<PsiNamedElement> allDeclarations;
        @Nullable
        private final PsiMethod getter;
        @Nullable
        private final PsiMethod setter;
        @Nullable
        private final PsiField backingField;

        @NotNull
        public final List<PsiNamedElement> getAllDeclarations() {
            return this.allDeclarations;
        }

        @Override
        @NotNull
        public Iterator<PsiMethod> iterator() {
            return this.allMethods.iterator();
        }

        @Nullable
        public final PsiMethod getGetter() {
            return this.getter;
        }

        @Nullable
        public final PsiMethod getSetter() {
            return this.setter;
        }

        @Nullable
        public final PsiField getBackingField() {
            return this.backingField;
        }

        /*
         * WARNING - void declaration
         */
        public PropertyAccessorsPsiMethods(@Nullable PsiMethod getter2, @Nullable PsiMethod setter2, @Nullable PsiField backingField2, @NotNull List<? extends PsiMethod> additionalAccessors) {
            void $this$filterIsInstanceTo$iv;
            Intrinsics.checkParameterIsNotNull(additionalAccessors, "additionalAccessors");
            this.getter = getter2;
            this.setter = setter2;
            this.backingField = backingField2;
            PropertyAccessorsPsiMethods propertyAccessorsPsiMethods = this;
            boolean bl = false;
            ArrayList arrayList = new ArrayList();
            propertyAccessorsPsiMethods.allMethods = arrayList;
            ArraysKt.filterNotNullTo(new PsiMethod[]{this.getter, this.setter}, (Collection)this.allMethods);
            Iterable iterable = additionalAccessors;
            Collection destination$iv = this.allMethods;
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv : $this$filterIsInstanceTo$iv) {
                if (!(element$iv instanceof PsiMethod)) continue;
                destination$iv.add(element$iv);
            }
            propertyAccessorsPsiMethods = this;
            boolean bl2 = false;
            arrayList = new ArrayList();
            propertyAccessorsPsiMethods.allDeclarations = arrayList;
            ArraysKt.filterNotNullTo(new PsiNamedElement[]{this.getter, this.setter, this.backingField}, (Collection)this.allDeclarations);
            ((ArrayList)this.allDeclarations).addAll((Collection)additionalAccessors);
        }
    }
}

