/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProviderKt;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartProviderBase;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;", "Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase;", "Lcom/intellij/openapi/vfs/VirtualFile;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/psi/search/GlobalSearchScope;)V", "deserializationConfiguration", "Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "loadedModules", "", "Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase$ModuleMappingInfo;", "getLoadedModules", "()Ljava/util/List;", "addRoots", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "cli"})
public final class JvmPackagePartProvider
extends JvmPackagePartProviderBase<VirtualFile> {
    private final CompilerDeserializationConfiguration deserializationConfiguration;
    @NotNull
    private final List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> loadedModules;
    private final GlobalSearchScope scope;

    @Override
    @NotNull
    protected List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> getLoadedModules() {
        return this.loadedModules;
    }

    public final void addRoots(@NotNull List<JavaRoot> roots2, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkParameterIsNotNull(roots2, "roots");
        Intrinsics.checkParameterIsNotNull(messageCollector, "messageCollector");
        for (JavaRoot javaRoot : roots2) {
            VirtualFile metaInf;
            VirtualFile root2 = javaRoot.component1();
            JavaRoot.RootType type2 = javaRoot.component2();
            if (type2 != JavaRoot.RootType.BINARY || !this.scope.contains(root2)) continue;
            if (root2.findChild("META-INF") == null) {
                continue;
            }
            VirtualFile virtualFile2 = metaInf;
            Intrinsics.checkExpressionValueIsNotNull(virtualFile2, "metaInf");
            VirtualFile[] virtualFileArray = virtualFile2.getChildren();
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                ModuleMapping moduleMapping;
                VirtualFile moduleFile;
                VirtualFile virtualFile3 = moduleFile = virtualFileArray[i];
                Intrinsics.checkExpressionValueIsNotNull(virtualFile3, "moduleFile");
                String string2 = virtualFile3.getName();
                Intrinsics.checkExpressionValueIsNotNull(string2, "moduleFile.name");
                if (!StringsKt.endsWith$default(string2, "kotlin_module", false, 2, null)) continue;
                Function0 function0 = new Function0<byte[]>(moduleFile){
                    final /* synthetic */ VirtualFile $moduleFile;

                    @NotNull
                    public final byte[] invoke() {
                        byte[] byArray = this.$moduleFile.contentsToByteArray();
                        Intrinsics.checkExpressionValueIsNotNull(byArray, "moduleFile.contentsToByteArray()");
                        return byArray;
                    }
                    {
                        this.$moduleFile = virtualFile2;
                        super(0);
                    }
                };
                String string3 = moduleFile.toString();
                Intrinsics.checkExpressionValueIsNotNull(string3, "moduleFile.toString()");
                String string4 = moduleFile.getPath();
                Intrinsics.checkExpressionValueIsNotNull(string4, "moduleFile.path");
                if (JvmPackagePartProviderKt.tryLoadModuleMapping(function0, string3, string4, this.deserializationConfiguration, messageCollector) == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                ModuleMapping it = moduleMapping;
                boolean bl3 = false;
                List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> list2 = this.getLoadedModules();
                String string5 = moduleFile.getNameWithoutExtension();
                Intrinsics.checkExpressionValueIsNotNull(string5, "moduleFile.nameWithoutExtension");
                list2.add(new JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>(root2, it, string5));
            }
        }
    }

    public JvmPackagePartProvider(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        this.scope = scope;
        this.deserializationConfiguration = new CompilerDeserializationConfiguration(languageVersionSettings);
        this.loadedModules = new SmartList();
    }
}

