/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AccessorKind;
import org.jetbrains.kotlin.codegen.AnnotationCodegen;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.AssertCodegenUtilKt;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.codegen.ExceptionLogger;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FrameMap;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.ImplementationBodyCodegen;
import org.jetbrains.kotlin.codegen.InnerClassConsumer;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.PropertyCodegen;
import org.jetbrains.kotlin.codegen.PropertyReferenceCodegen;
import org.jetbrains.kotlin.codegen.ScriptCodegen;
import org.jetbrains.kotlin.codegen.SourceInfo;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.CodegenContextUtil;
import org.jetbrains.kotlin.codegen.context.DelegatingToPartContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.inline.DefaultSourceMapper;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.NameGenerator;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeParametersUsages;
import org.jetbrains.kotlin.codegen.inline.SourceMapper;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.codegen.state.TypeMapperUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotatedImpl;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public abstract class MemberCodegen<T extends KtPureElement>
implements InnerClassConsumer {
    public final GenerationState state;
    protected final T element;
    protected final FieldOwnerContext<?> context;
    public final ClassBuilder v;
    public final FunctionCodegen functionCodegen;
    public final PropertyCodegen propertyCodegen;
    public final KotlinTypeMapper typeMapper;
    public final BindingContext bindingContext;
    private final MemberCodegen<?> parentCodegen;
    private final ReifiedTypeParametersUsages reifiedTypeParametersUsages;
    private final Collection<ClassDescriptor> innerClasses;
    private ExpressionCodegen clInit;
    private NameGenerator inlineNameGenerator;
    private boolean jvmAssertFieldGenerated;
    private DefaultSourceMapper sourceMapper;
    private boolean nopSeparatorNeeded;

    public MemberCodegen(@NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen, @NotNull FieldOwnerContext context2, T element, @NotNull ClassBuilder builder) {
        if (state == null) {
            MemberCodegen.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            MemberCodegen.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            MemberCodegen.$$$reportNull$$$0(2);
        }
        this.reifiedTypeParametersUsages = new ReifiedTypeParametersUsages();
        this.innerClasses = new LinkedHashSet<ClassDescriptor>();
        this.nopSeparatorNeeded = false;
        this.state = state;
        this.typeMapper = state.getTypeMapper();
        this.bindingContext = state.getBindingContext();
        this.element = element;
        this.context = context2;
        this.v = builder;
        this.functionCodegen = new FunctionCodegen(context2, this.v, state, this);
        this.propertyCodegen = new PropertyCodegen(context2, this.v, this.functionCodegen, this);
        this.parentCodegen = parentCodegen;
        this.jvmAssertFieldGenerated = false;
    }

    protected MemberCodegen(@NotNull MemberCodegen<T> wrapped, T declaration2, FieldOwnerContext codegenContext) {
        if (wrapped == null) {
            MemberCodegen.$$$reportNull$$$0(3);
        }
        this(wrapped.state, wrapped.getParentCodegen(), codegenContext, declaration2, wrapped.v);
    }

    public void generate() {
        boolean shouldGenerateSyntheticParts;
        this.generateDeclaration();
        boolean bl = shouldGenerateSyntheticParts = !(this.element instanceof KtClassOrObject) || this.state.getGenerateDeclaredClassFilter().shouldGenerateClassMembers((KtClassOrObject)this.element);
        if (shouldGenerateSyntheticParts) {
            this.generateSyntheticPartsBeforeBody();
        }
        this.generateBody();
        if (shouldGenerateSyntheticParts) {
            this.generateSyntheticPartsAfterBody();
        }
        if (this.state.getClassBuilderMode().generateMetadata) {
            this.generateKotlinMetadataAnnotation();
        }
        this.done();
    }

    protected abstract void generateDeclaration();

    protected void generateSyntheticPartsBeforeBody() {
    }

    protected abstract void generateBody();

    protected void generateSyntheticPartsAfterBody() {
    }

    protected abstract void generateKotlinMetadataAnnotation();

    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return null;
    }

    public static void markLineNumberForDescriptor(@Nullable ClassDescriptor declarationDescriptor, @NotNull InstructionAdapter v) {
        if (v == null) {
            MemberCodegen.$$$reportNull$$$0(4);
        }
        if (declarationDescriptor == null) {
            return;
        }
        PsiElement classElement = DescriptorToSourceUtils.getSourceFromDescriptor(declarationDescriptor);
        if (classElement != null) {
            MemberCodegen.markLineNumberForElement(classElement, v);
        }
    }

    public static void markLineNumberForElement(@NotNull PsiElement element, @NotNull InstructionAdapter v) {
        Integer lineNumber;
        if (element == null) {
            MemberCodegen.$$$reportNull$$$0(5);
        }
        if (v == null) {
            MemberCodegen.$$$reportNull$$$0(6);
        }
        if ((lineNumber = CodegenUtil.getLineNumberForElement(element, false)) != null) {
            Label label = new Label();
            v.visitLabel(label);
            v.visitLineNumber(lineNumber, label);
        }
    }

    protected void done() {
        if (this.clInit != null) {
            this.clInit.v.visitInsn(177);
            FunctionCodegen.endVisit((MethodVisitor)this.clInit.v, "static initializer", this.element);
        }
        this.writeInnerClasses();
        if (this.sourceMapper != null) {
            SourceMapper.Companion.flushToClassBuilder(this.sourceMapper, this.v);
        }
        this.v.done();
    }

    public void genSimpleMember(@NotNull KtDeclaration declaration2) {
        if (declaration2 == null) {
            MemberCodegen.$$$reportNull$$$0(7);
        }
        if (declaration2 instanceof KtNamedFunction) {
            try {
                this.functionCodegen.gen((KtNamedFunction)declaration2);
            }
            catch (ProcessCanceledException | CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate function " + declaration2.getName(), e, declaration2);
            }
        } else if (declaration2 instanceof KtProperty) {
            try {
                this.propertyCodegen.gen((KtProperty)declaration2);
            }
            catch (ProcessCanceledException | CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate property " + declaration2.getName(), e, declaration2);
            }
        } else if (declaration2 instanceof KtTypeAlias) {
            this.genTypeAlias((KtTypeAlias)declaration2);
        } else if (declaration2 instanceof KtDestructuringDeclarationEntry) {
            try {
                this.propertyCodegen.genDestructuringDeclaration((KtDestructuringDeclarationEntry)declaration2);
            }
            catch (ProcessCanceledException | CompilationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationException("Failed to generate destructuring declaration entry " + declaration2.getName(), e, declaration2);
            }
        } else {
            throw new IllegalArgumentException("Unknown parameter: " + declaration2);
        }
    }

    private void genTypeAlias(@NotNull KtTypeAlias typeAlias) {
        if (typeAlias == null) {
            MemberCodegen.$$$reportNull$$$0(8);
        }
        if (!this.state.getClassBuilderMode().generateMetadata) {
            return;
        }
        TypeAliasDescriptor typeAliasDescriptor = this.bindingContext.get(BindingContext.TYPE_ALIAS, typeAlias);
        if (typeAliasDescriptor == null) {
            throw ExceptionLogger.logDescriptorNotFound("Type alias " + typeAlias.getName() + " should have a descriptor", typeAlias);
        }
        this.genTypeAliasAnnotationsMethodIfRequired(typeAliasDescriptor);
    }

    private void genTypeAliasAnnotationsMethodIfRequired(TypeAliasDescriptor typeAliasDescriptor) {
        boolean isAnnotationsMethodOwner = CodegenContextUtil.isImplementationOwner(this.context, typeAliasDescriptor);
        Annotations annotations2 = typeAliasDescriptor.getAnnotations();
        if (!isAnnotationsMethodOwner || annotations2.isEmpty()) {
            return;
        }
        String name = JvmAbi.getSyntheticMethodNameForAnnotatedTypeAlias(typeAliasDescriptor.getName());
        this.generateSyntheticAnnotationsMethod(typeAliasDescriptor, new Method(name, "()V"), annotations2);
    }

    protected void generateSyntheticAnnotationsMethod(@NotNull MemberDescriptor descriptor2, @NotNull Method syntheticMethod, @NotNull Annotations annotations2) {
        if (descriptor2 == null) {
            MemberCodegen.$$$reportNull$$$0(9);
        }
        if (syntheticMethod == null) {
            MemberCodegen.$$$reportNull$$$0(10);
        }
        if (annotations2 == null) {
            MemberCodegen.$$$reportNull$$$0(11);
        }
        int flags = 0x21008 | AsmUtil.getVisibilityAccessFlag(descriptor2);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(descriptor2), flags, syntheticMethod.getName(), syntheticMethod.getDescriptor(), null, null);
        AnnotationCodegen.forMethod(mv, this, this.state).genAnnotations(new AnnotatedImpl(annotations2), Type.VOID_TYPE);
        mv.visitCode();
        mv.visitInsn(177);
        mv.visitEnd();
    }

    public static void genClassOrObject(@NotNull CodegenContext parentContext, @NotNull KtClassOrObject aClass2, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen) {
        ClassDescriptor descriptor2;
        if (parentContext == null) {
            MemberCodegen.$$$reportNull$$$0(12);
        }
        if (aClass2 == null) {
            MemberCodegen.$$$reportNull$$$0(13);
        }
        if (state == null) {
            MemberCodegen.$$$reportNull$$$0(14);
        }
        if ((descriptor2 = state.getBindingContext().get(BindingContext.CLASS, aClass2)) == null || ErrorUtils.isError(descriptor2)) {
            MemberCodegen.badDescriptor(descriptor2, state.getClassBuilderMode());
            return;
        }
        if (descriptor2.getName().equals(SpecialNames.NO_NAME_PROVIDED)) {
            MemberCodegen.badDescriptor(descriptor2, state.getClassBuilderMode());
        }
        MemberCodegen.genClassOrObject(parentContext, aClass2, state, parentCodegen, descriptor2);
    }

    private static void genClassOrObject(@NotNull CodegenContext parentContext, @NotNull KtPureClassOrObject aClass2, @NotNull GenerationState state, @Nullable MemberCodegen<?> parentCodegen, @NotNull ClassDescriptor descriptor2) {
        if (parentContext == null) {
            MemberCodegen.$$$reportNull$$$0(15);
        }
        if (aClass2 == null) {
            MemberCodegen.$$$reportNull$$$0(16);
        }
        if (state == null) {
            MemberCodegen.$$$reportNull$$$0(17);
        }
        if (descriptor2 == null) {
            MemberCodegen.$$$reportNull$$$0(18);
        }
        Type classType = state.getTypeMapper().mapClass(descriptor2);
        ClassBuilder classBuilder2 = state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOriginFromPure(aClass2, descriptor2), classType, aClass2.getContainingKtFile());
        ClassContext classContext = parentContext.intoClass(descriptor2, OwnerKind.IMPLEMENTATION, state);
        new ImplementationBodyCodegen(aClass2, classContext, classBuilder2, state, parentCodegen, false).generate();
    }

    public static void badDescriptor(ClassDescriptor descriptor2, ClassBuilderMode mode) {
        if (mode.generateBodies) {
            throw new IllegalStateException("Generating bad descriptor in ClassBuilderMode = " + mode + ": " + descriptor2);
        }
    }

    public void genClassOrObject(KtClassOrObject aClass2) {
        MemberCodegen.genClassOrObject(this.context, aClass2, this.state, this);
    }

    public void genSyntheticClassOrObject(SyntheticClassOrObjectDescriptor descriptor2) {
        MemberCodegen.genClassOrObject(this.context, descriptor2.getSyntheticDeclaration(), this.state, this, descriptor2);
    }

    private void writeInnerClasses() {
        ClassDescriptor classDescriptor2 = this.classForInnerClassRecord();
        if (classDescriptor2 != null) {
            if (this.parentCodegen != null) {
                this.parentCodegen.innerClasses.add(classDescriptor2);
            }
            this.addParentsToInnerClassesIfNeeded(this.innerClasses);
        }
        for (ClassDescriptor innerClass : this.innerClasses) {
            this.writeInnerClass(innerClass);
        }
    }

    protected void addParentsToInnerClassesIfNeeded(@NotNull Collection<ClassDescriptor> innerClasses2) {
        MemberCodegen<?> parentCodegen;
        ClassDescriptor outerClass2;
        if (innerClasses2 == null) {
            MemberCodegen.$$$reportNull$$$0(19);
        }
        if ((outerClass2 = this.classForInnerClassRecord()) != null) {
            innerClasses2.add(outerClass2);
        }
        if ((parentCodegen = this.getParentCodegen()) != null) {
            parentCodegen.addParentsToInnerClassesIfNeeded(innerClasses2);
        }
    }

    @Override
    public void addInnerClassInfoFromAnnotation(@NotNull ClassDescriptor classDescriptor2) {
        if (classDescriptor2 == null) {
            MemberCodegen.$$$reportNull$$$0(20);
        }
        for (DeclarationDescriptor current = classDescriptor2; current != null && !DescriptorUtils.isTopLevelDeclaration(current); current = current.getContainingDeclaration()) {
            if (!(current instanceof ClassDescriptor)) continue;
            this.innerClasses.add((ClassDescriptor)current);
        }
    }

    private void writeInnerClass(@NotNull ClassDescriptor innerClass) {
        if (innerClass == null) {
            MemberCodegen.$$$reportNull$$$0(21);
        }
        if (!ErrorUtils.isError(innerClass)) {
            MemberCodegen.writeInnerClass(innerClass, this.typeMapper, this.v);
        }
    }

    public static void writeInnerClass(@NotNull ClassDescriptor innerClass, @NotNull KotlinTypeMapper typeMapper, @NotNull ClassBuilder v) {
        if (innerClass == null) {
            MemberCodegen.$$$reportNull$$$0(22);
        }
        if (typeMapper == null) {
            MemberCodegen.$$$reportNull$$$0(23);
        }
        if (v == null) {
            MemberCodegen.$$$reportNull$$$0(24);
        }
        DeclarationDescriptor containing = innerClass.getContainingDeclaration();
        String outerClassInternalName = null;
        if (containing instanceof ClassDescriptor) {
            outerClassInternalName = typeMapper.classInternalName((ClassDescriptor)containing);
        }
        String innerName = innerClass.getName().isSpecial() ? null : innerClass.getName().asString();
        String innerClassInternalName = typeMapper.classInternalName(innerClass);
        v.visitInnerClass(innerClassInternalName, outerClassInternalName, innerName, AsmUtil.calculateInnerClassAccessFlags(innerClass));
    }

    protected void writeOuterClassAndEnclosingMethod() {
        CodegenContext context2 = this.context.getParentContext();
        while (context2 instanceof InlineLambdaContext) {
            context2 = context2.getParentContext().getParentContext();
        }
        assert (context2 != null) : "Outermost context can't be null: " + this.context;
        Type enclosingAsmType = this.computeOuterClass(context2);
        if (enclosingAsmType != null) {
            Method method = this.computeEnclosingMethod(context2);
            this.v.visitOuterClass(enclosingAsmType.getInternalName(), method == null ? null : method.getName(), method == null ? null : method.getDescriptor());
        }
    }

    @Nullable
    private Type computeOuterClass(@NotNull CodegenContext<?> context2) {
        CodegenContext<ClassOrPackageFragmentDescriptor> outermost;
        if (context2 == null) {
            MemberCodegen.$$$reportNull$$$0(25);
        }
        if ((outermost = context2.getClassOrPackageParentContext()) instanceof ClassContext) {
            FunctionDescriptor functionDescriptor;
            ClassDescriptor classDescriptor2 = (ClassDescriptor)((ClassContext)outermost).getContextDescriptor();
            if (context2 instanceof MethodContext && DescriptorUtils.isInterface((functionDescriptor = ((MethodContext)context2).getFunctionDescriptor()).getContainingDeclaration()) && !JvmAnnotationUtilKt.hasJvmDefaultAnnotation(functionDescriptor)) {
                return this.typeMapper.mapDefaultImpls(classDescriptor2);
            }
            return this.typeMapper.mapClass(classDescriptor2);
        }
        if (outermost instanceof MultifileClassFacadeContext || outermost instanceof DelegatingToPartContext) {
            Type implementationOwnerType = CodegenContextUtil.getImplementationOwnerClassType(outermost);
            if (implementationOwnerType != null) {
                return implementationOwnerType;
            }
            return Type.getObjectType(JvmFileClassUtil.getFileClassInternalName(this.element.getContainingKtFile()));
        }
        return null;
    }

    @Nullable
    private Method computeEnclosingMethod(@NotNull CodegenContext context2) {
        if (context2 == null) {
            MemberCodegen.$$$reportNull$$$0(26);
        }
        if (context2 instanceof MethodContext) {
            FunctionDescriptor functionDescriptor = ((MethodContext)context2).getFunctionDescriptor();
            if ("<clinit>".equals(functionDescriptor.getName().asString())) {
                return null;
            }
            if (((MethodContext)context2).isDefaultFunctionContext()) {
                return this.typeMapper.mapDefaultMethod(functionDescriptor, context2.getContextKind());
            }
            return this.typeMapper.mapAsmMethod(functionDescriptor, context2.getContextKind());
        }
        return null;
    }

    @NotNull
    public NameGenerator getInlineNameGenerator() {
        if (this.inlineNameGenerator == null) {
            String prefix = InlineCodegenUtilsKt.getInlineName(this.context, this.typeMapper);
            this.inlineNameGenerator = new NameGenerator(prefix);
        }
        NameGenerator nameGenerator2 = this.inlineNameGenerator;
        if (nameGenerator2 == null) {
            MemberCodegen.$$$reportNull$$$0(27);
        }
        return nameGenerator2;
    }

    @NotNull
    public final ExpressionCodegen createOrGetClInitCodegen() {
        if (this.clInit == null) {
            Object contextDescriptor = this.context.getContextDescriptor();
            SimpleFunctionDescriptorImpl clInitDescriptor = this.createClInitFunctionDescriptor((DeclarationDescriptor)contextDescriptor);
            MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin(contextDescriptor), 8, "<clinit>", "()V", null, null);
            this.clInit = new ExpressionCodegen(mv, new FrameMap(), Type.VOID_TYPE, this.context.intoFunction(clInitDescriptor), this.state, this);
        }
        ExpressionCodegen expressionCodegen = this.clInit;
        if (expressionCodegen == null) {
            MemberCodegen.$$$reportNull$$$0(28);
        }
        return expressionCodegen;
    }

    @NotNull
    private SimpleFunctionDescriptorImpl createClInitFunctionDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            MemberCodegen.$$$reportNull$$$0(29);
        }
        SimpleFunctionDescriptorImpl clInit = SimpleFunctionDescriptorImpl.create(descriptor2, Annotations.Companion.getEMPTY(), Name.special("<clinit>"), CallableMemberDescriptor.Kind.SYNTHESIZED, KotlinSourceElementKt.toSourceElement(this.element));
        clInit.initialize((ReceiverParameterDescriptor)null, (ReceiverParameterDescriptor)null, Collections.emptyList(), Collections.emptyList(), (KotlinType)DescriptorUtilsKt.getModule(descriptor2).getBuiltIns().getUnitType(), (Modality)null, Visibilities.PRIVATE);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = clInit;
        if (simpleFunctionDescriptorImpl == null) {
            MemberCodegen.$$$reportNull$$$0(30);
        }
        return simpleFunctionDescriptorImpl;
    }

    private void generateNopSeparatorIfNeeded(NotNullLazyValue<ExpressionCodegen> codegen2) {
        if (this.nopSeparatorNeeded) {
            this.nopSeparatorNeeded = false;
            ((ExpressionCodegen)codegen2.invoke()).v.nop();
        }
    }

    protected void generateInitializers(@NotNull Function0<ExpressionCodegen> createCodegen) {
        if (createCodegen == null) {
            MemberCodegen.$$$reportNull$$$0(31);
        }
        NotNullLazyValue<ExpressionCodegen> codegen2 = LockBasedStorageManager.NO_LOCKS.createLazyValue(createCodegen);
        List<KtDeclaration> declarations2 = ((KtDeclarationContainer)this.element).getDeclarations();
        for (int i = 0; i < declarations2.size(); ++i) {
            KtExpression body2;
            KtDeclaration declaration2 = declarations2.get(i);
            if (declaration2 instanceof KtProperty) {
                if (!this.shouldInitializeProperty((KtProperty)declaration2)) continue;
                this.generateNopSeparatorIfNeeded(codegen2);
                this.initializeProperty((ExpressionCodegen)codegen2.invoke(), (KtProperty)declaration2);
                continue;
            }
            if (declaration2 instanceof KtDestructuringDeclaration) {
                this.generateNopSeparatorIfNeeded(codegen2);
                ((ExpressionCodegen)codegen2.invoke()).initializeDestructuringDeclaration((KtDestructuringDeclaration)declaration2, true);
                continue;
            }
            if (!(declaration2 instanceof KtAnonymousInitializer) || (body2 = ((KtAnonymousInitializer)declaration2).getBody()) == null) continue;
            this.generateNopSeparatorIfNeeded(codegen2);
            ExpressionCodegen expressionCodegen = (ExpressionCodegen)codegen2.invoke();
            Type bodyExpressionType = Type.VOID_TYPE;
            if (i == declarations2.size() - 1 && this instanceof ScriptCodegen) {
                bodyExpressionType = expressionCodegen.expressionType(body2);
            }
            expressionCodegen.gen(body2, bodyExpressionType);
            expressionCodegen.markLineNumber(declaration2, true);
            this.nopSeparatorNeeded = true;
        }
    }

    public void initializeProperty(@NotNull ExpressionCodegen codegen2, @NotNull KtProperty property) {
        if (codegen2 == null) {
            MemberCodegen.$$$reportNull$$$0(32);
        }
        if (property == null) {
            MemberCodegen.$$$reportNull$$$0(33);
        }
        PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property);
        assert (propertyDescriptor2 != null);
        KtExpression initializer2 = property.getDelegateExpressionOrInitializer();
        assert (initializer2 != null) : "shouldInitializeProperty must return false if initializer is null";
        StackValue.Property propValue = codegen2.intermediateValueForProperty(propertyDescriptor2, true, false, null, true, StackValue.LOCAL_0, null, false);
        if (property.getDelegateExpression() == null) {
            propValue.store(codegen2.gen(initializer2), codegen2.v);
        } else {
            StackValue.Property delegate = propValue.getDelegateOrNull();
            assert (delegate != null) : "No delegate for delegated property: " + propertyDescriptor2;
            ResolvedCall<FunctionDescriptor> provideDelegateResolvedCall = this.bindingContext.get(BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL, propertyDescriptor2);
            if (provideDelegateResolvedCall == null) {
                delegate.store(codegen2.gen(initializer2), codegen2.v);
            } else {
                StackValue provideDelegateReceiver = codegen2.gen(initializer2);
                StackValue delegateValue = PropertyCodegen.invokeDelegatedPropertyConventionMethod(codegen2, provideDelegateResolvedCall, provideDelegateReceiver, propertyDescriptor2);
                delegate.store(delegateValue, codegen2.v);
            }
        }
    }

    public boolean shouldInitializeProperty(@NotNull KtProperty property) {
        ConstantValue<?> initializerValue2;
        if (property == null) {
            MemberCodegen.$$$reportNull$$$0(34);
        }
        if (!property.hasDelegateExpressionOrInitializer()) {
            return false;
        }
        PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)this.bindingContext.get(BindingContext.VARIABLE, property);
        assert (propertyDescriptor2 != null);
        if (propertyDescriptor2.isConst()) {
            return false;
        }
        KtExpression initializer2 = property.getInitializer();
        ConstantValue<?> constantValue = initializerValue2 = initializer2 != null ? ExpressionCodegen.getCompileTimeConstant(initializer2, this.bindingContext, this.state.getShouldInlineConstVals()) : null;
        if (initializerValue2 == null) {
            return this.state.getClassBuilderMode().generateBodies;
        }
        KotlinType jetType = this.getPropertyOrDelegateType(property, propertyDescriptor2);
        Type type2 = this.typeMapper.mapType(jetType);
        return !MemberCodegen.skipDefaultValue(propertyDescriptor2, initializerValue2.getValue(), type2);
    }

    @NotNull
    private KotlinType getPropertyOrDelegateType(@NotNull KtProperty property, @NotNull PropertyDescriptor descriptor2) {
        KtExpression delegateExpression2;
        if (property == null) {
            MemberCodegen.$$$reportNull$$$0(35);
        }
        if (descriptor2 == null) {
            MemberCodegen.$$$reportNull$$$0(36);
        }
        if ((delegateExpression2 = property.getDelegateExpression()) != null) {
            KotlinType delegateType = this.bindingContext.getType(delegateExpression2);
            assert (delegateType != null) : "Type of delegate expression should be recorded";
            KotlinType kotlinType2 = delegateType;
            if (kotlinType2 == null) {
                MemberCodegen.$$$reportNull$$$0(37);
            }
            return kotlinType2;
        }
        KotlinType kotlinType3 = descriptor2.getType();
        if (kotlinType3 == null) {
            MemberCodegen.$$$reportNull$$$0(38);
        }
        return kotlinType3;
    }

    private static boolean skipDefaultValue(@NotNull PropertyDescriptor propertyDescriptor2, Object value2, @NotNull Type type2) {
        if (propertyDescriptor2 == null) {
            MemberCodegen.$$$reportNull$$$0(39);
        }
        if (type2 == null) {
            MemberCodegen.$$$reportNull$$$0(40);
        }
        if (AsmUtil.isPrimitive(type2)) {
            if (!propertyDescriptor2.getType().isMarkedNullable() && value2 instanceof Number) {
                if (type2 == Type.INT_TYPE && ((Number)value2).intValue() == 0) {
                    return true;
                }
                if (type2 == Type.BYTE_TYPE && ((Number)value2).byteValue() == 0) {
                    return true;
                }
                if (type2 == Type.LONG_TYPE && ((Number)value2).longValue() == 0L) {
                    return true;
                }
                if (type2 == Type.SHORT_TYPE && ((Number)value2).shortValue() == 0) {
                    return true;
                }
                if (type2 == Type.DOUBLE_TYPE && value2.equals(0.0)) {
                    return true;
                }
                if (type2 == Type.FLOAT_TYPE && value2.equals(Float.valueOf(0.0f))) {
                    return true;
                }
            }
            if (type2 == Type.BOOLEAN_TYPE && value2 instanceof Boolean && !((Boolean)value2).booleanValue()) {
                return true;
            }
            if (type2 == Type.CHAR_TYPE && value2 instanceof Character && ((Character)value2).charValue() == '\u0000') {
                return true;
            }
        } else if (value2 == null) {
            return true;
        }
        return false;
    }

    protected void generatePropertyMetadataArrayFieldIfNeeded(@NotNull Type thisAsmType) {
        List<VariableDescriptorWithAccessors> delegatedProperties;
        if (thisAsmType == null) {
            MemberCodegen.$$$reportNull$$$0(41);
        }
        if ((delegatedProperties = this.bindingContext.get(CodegenBinding.DELEGATED_PROPERTIES, thisAsmType)) == null || delegatedProperties.isEmpty()) {
            return;
        }
        this.v.newField(JvmDeclarationOrigin.NO_ORIGIN, 4120, "$$delegatedProperties", "[" + AsmTypes.K_PROPERTY_TYPE, null, null);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        InstructionAdapter iv = this.createOrGetClInitCodegen().v;
        iv.iconst(delegatedProperties.size());
        iv.newarray(AsmTypes.K_PROPERTY_TYPE);
        int size = delegatedProperties.size();
        for (int i = 0; i < size; ++i) {
            VariableDescriptorWithAccessors property = delegatedProperties.get(i);
            iv.dup();
            iv.iconst(i);
            int receiverCount = (property.getDispatchReceiverParameter() != null ? 1 : 0) + (property.getExtensionReceiverParameter() != null ? 1 : 0);
            Type implType = property.isVar() ? AsmTypes.MUTABLE_PROPERTY_REFERENCE_IMPL[receiverCount] : AsmTypes.PROPERTY_REFERENCE_IMPL[receiverCount];
            iv.anew(implType);
            iv.dup();
            ClosureCodegen.generateCallableReferenceDeclarationContainer(iv, property, this.state);
            iv.aconst(property.getName().asString());
            PropertyReferenceCodegen.generateCallableReferenceSignature(iv, property, this.state);
            iv.invokespecial(implType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, AsmTypes.K_DECLARATION_CONTAINER_TYPE, AsmTypes.JAVA_STRING_TYPE, AsmTypes.JAVA_STRING_TYPE), false);
            Method wrapper = PropertyReferenceCodegen.getWrapperMethodForPropertyReference(property, receiverCount);
            iv.invokestatic("kotlin/jvm/internal/Reflection", wrapper.getName(), wrapper.getDescriptor(), false);
            StackValue.onStack(implType).put(AsmTypes.K_PROPERTY_TYPE, iv);
            iv.astore(AsmTypes.K_PROPERTY_TYPE);
        }
        iv.putstatic(thisAsmType.getInternalName(), "$$delegatedProperties", "[" + AsmTypes.K_PROPERTY_TYPE);
    }

    public String getClassName() {
        return this.v.getThisName();
    }

    @NotNull
    public FieldOwnerContext<?> getContext() {
        FieldOwnerContext<?> fieldOwnerContext = this.context;
        if (fieldOwnerContext == null) {
            MemberCodegen.$$$reportNull$$$0(42);
        }
        return fieldOwnerContext;
    }

    @NotNull
    public ReifiedTypeParametersUsages getReifiedTypeParametersUsages() {
        ReifiedTypeParametersUsages reifiedTypeParametersUsages = this.reifiedTypeParametersUsages;
        if (reifiedTypeParametersUsages == null) {
            MemberCodegen.$$$reportNull$$$0(43);
        }
        return reifiedTypeParametersUsages;
    }

    public MemberCodegen<?> getParentCodegen() {
        return this.parentCodegen;
    }

    public String toString() {
        return this.context.toString();
    }

    @NotNull
    public DefaultSourceMapper getOrCreateSourceMapper() {
        if (this.sourceMapper == null) {
            this.sourceMapper = new DefaultSourceMapper(SourceInfo.Companion.createInfo((KtElement)this.element, this.getClassName()));
        }
        DefaultSourceMapper defaultSourceMapper = this.sourceMapper;
        if (defaultSourceMapper == null) {
            MemberCodegen.$$$reportNull$$$0(44);
        }
        return defaultSourceMapper;
    }

    protected void generateConstInstance(@NotNull Type thisAsmType, @NotNull Type fieldAsmType) {
        if (thisAsmType == null) {
            MemberCodegen.$$$reportNull$$$0(45);
        }
        if (fieldAsmType == null) {
            MemberCodegen.$$$reportNull$$$0(46);
        }
        this.v.newField(JvmDeclarationOriginKt.OtherOriginFromPure(this.element), 25, "INSTANCE", fieldAsmType.getDescriptor(), null, null);
        if (this.state.getClassBuilderMode().generateBodies) {
            InstructionAdapter iv = this.createOrGetClInitCodegen().v;
            iv.anew(thisAsmType);
            iv.dup();
            iv.invokespecial(thisAsmType.getInternalName(), "<init>", "()V", false);
            iv.putstatic(thisAsmType.getInternalName(), "INSTANCE", fieldAsmType.getDescriptor());
        }
    }

    protected final void generateSyntheticAccessors() {
        for (AccessorForCallableDescriptor<?> accessor : this.context.getAccessors()) {
            boolean hasJvmDefaultAnnotation = JvmAnnotationUtilKt.hasJvmDefaultAnnotation(accessor.getCalleeDescriptor());
            OwnerKind kind = this.context.getContextKind();
            if (DescriptorUtils.isInterface(this.context.getContextDescriptor()) && (!hasJvmDefaultAnnotation || kind != OwnerKind.IMPLEMENTATION) && (hasJvmDefaultAnnotation || kind != OwnerKind.DEFAULT_IMPLS)) continue;
            this.generateSyntheticAccessor(accessor);
        }
        AccessorForCompanionObjectInstanceFieldDescriptor accessorForCompanionObjectInstanceFieldDescriptor = this.context.getAccessorForCompanionObjectDescriptorIfRequired();
        if (accessorForCompanionObjectInstanceFieldDescriptor != null) {
            this.generateSyntheticAccessorForCompanionObject(accessorForCompanionObjectInstanceFieldDescriptor);
        }
    }

    private void generateSyntheticAccessorForCompanionObject(@NotNull AccessorForCompanionObjectInstanceFieldDescriptor accessor) {
        if (accessor == null) {
            MemberCodegen.$$$reportNull$$$0(47);
        }
        final ClassDescriptor companionObjectDescriptor2 = accessor.getCompanionObjectDescriptor();
        DeclarationDescriptor hostClassDescriptor = companionObjectDescriptor2.getContainingDeclaration();
        assert (hostClassDescriptor instanceof ClassDescriptor) : "Class descriptor expected: " + hostClassDescriptor;
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, companionObjectDescriptor2), accessor, new FunctionGenerationStrategy.CodegenBased(this.state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen2, @NotNull JvmMethodSignature signature) {
                if (codegen2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (signature == null) {
                    1.$$$reportNull$$$0(1);
                }
                Type companionObjectType = MemberCodegen.this.typeMapper.mapClass(companionObjectDescriptor2);
                StackValue.singleton(companionObjectDescriptor2, MemberCodegen.this.typeMapper).put(companionObjectType, codegen2.v);
                codegen2.v.areturn(companionObjectType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "codegen";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "signature";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/MemberCodegen$1";
                objectArray[2] = "doGenerateBody";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void generateSyntheticAccessor(final @NotNull AccessorForCallableDescriptor<?> accessorForCallableDescriptor) {
        if (accessorForCallableDescriptor == null) {
            MemberCodegen.$$$reportNull$$$0(48);
        }
        if (accessorForCallableDescriptor instanceof FunctionDescriptor) {
            final FunctionDescriptor accessor = (FunctionDescriptor)((Object)accessorForCallableDescriptor);
            final FunctionDescriptor original = (FunctionDescriptor)accessorForCallableDescriptor.getCalleeDescriptor();
            this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original), accessor, new FunctionGenerationStrategy.CodegenBased(this.state){

                @Override
                public boolean skipNotNullAssertionsForParameters() {
                    return true;
                }

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen2, @NotNull JvmMethodSignature signature) {
                    if (codegen2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (signature == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    MemberCodegen.markLineNumberForElement(MemberCodegen.this.element.getPsiOrParent(), codegen2.v);
                    if (accessorForCallableDescriptor.getAccessorKind() == AccessorKind.JVM_DEFAULT_COMPATIBILITY) {
                        FunctionDescriptor descriptor2 = DescriptorUtils.unwrapFakeOverrideToAnyDeclaration(original).getOriginal();
                        if (descriptor2 != original) {
                            descriptor2 = descriptor2.copy(original.getContainingDeclaration(), descriptor2.getModality(), descriptor2.getVisibility(), descriptor2.getKind(), false);
                        }
                        MemberCodegen.this.generateMethodCallTo(descriptor2, accessor, codegen2.v).coerceTo(signature.getReturnType(), null, codegen2.v);
                    } else {
                        MemberCodegen.this.generateMethodCallTo(original, accessor, codegen2.v).coerceTo(signature.getReturnType(), null, codegen2.v);
                    }
                    codegen2.v.areturn(signature.getReturnType());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "codegen";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "signature";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/kotlin/codegen/MemberCodegen$2";
                    objectArray[2] = "doGenerateBody";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        } else if (accessorForCallableDescriptor instanceof AccessorForPropertyDescriptor) {
            class PropertyAccessorStrategy
            extends FunctionGenerationStrategy.CodegenBased {
                private final PropertyAccessorDescriptor callableDescriptor;

                PropertyAccessorStrategy(PropertyAccessorDescriptor callableDescriptor) {
                    if (callableDescriptor == null) {
                        PropertyAccessorStrategy.$$$reportNull$$$0(0);
                    }
                    super(MemberCodegen.this.state);
                    this.callableDescriptor = callableDescriptor;
                }

                @Override
                public void doGenerateBody(@NotNull ExpressionCodegen codegen2, @NotNull JvmMethodSignature signature) {
                    if (codegen2 == null) {
                        PropertyAccessorStrategy.$$$reportNull$$$0(1);
                    }
                    if (signature == null) {
                        PropertyAccessorStrategy.$$$reportNull$$$0(2);
                    }
                    if (accessorForCallableDescriptor.getAccessorKind() == AccessorKind.JVM_DEFAULT_COMPATIBILITY) {
                        boolean isGetter;
                        MemberCodegen.markLineNumberForElement(MemberCodegen.this.element.getPsiOrParent(), codegen2.v);
                        PropertyDescriptor descriptor2 = DescriptorUtils.unwrapFakeOverrideToAnyDeclaration(original).getOriginal();
                        if (descriptor2 != original) {
                            descriptor2 = (PropertyDescriptor)descriptor2.copy(original.getContainingDeclaration(), descriptor2.getModality(), descriptor2.getVisibility(), descriptor2.getKind(), false);
                        }
                        PropertyAccessorDescriptor originalAccessor = (isGetter = this.callableDescriptor instanceof PropertyGetterDescriptor) ? descriptor2.getGetter() : descriptor2.getSetter();
                        PropertyAccessorDescriptor accessorDescriptor = isGetter ? accessor.getGetter() : accessor.getSetter();
                        MemberCodegen.this.generateMethodCallTo(originalAccessor, accessorDescriptor, codegen2.v).coerceTo(signature.getReturnType(), null, codegen2.v);
                        codegen2.v.areturn(signature.getReturnType());
                        return;
                    }
                    AccessorKind fieldAccessorKind = accessor instanceof AccessorForPropertyBackingField ? accessor.getAccessorKind() : null;
                    boolean syntheticBackingField = fieldAccessorKind == AccessorKind.FIELD_FROM_LOCAL;
                    boolean forceFieldForCompanionProperty = JvmAbi.isPropertyWithBackingFieldInOuterClass(original) && !DescriptorUtils.isCompanionObject(accessor.getContainingDeclaration());
                    boolean forceField = forceFieldForCompanionProperty || syntheticBackingField || original.getVisibility() == JavaVisibilities.PROTECTED_STATIC_VISIBILITY;
                    StackValue.Property property = codegen2.intermediateValueForProperty(original, forceField, syntheticBackingField, accessor.getSuperCallTarget(), forceFieldForCompanionProperty, StackValue.none(), null, fieldAccessorKind == AccessorKind.LATEINIT_INTRINSIC);
                    InstructionAdapter iv = codegen2.v;
                    MemberCodegen.markLineNumberForElement(MemberCodegen.this.element.getPsiOrParent(), iv);
                    Type[] argTypes = signature.getAsmMethod().getArgumentTypes();
                    int reg = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        iv.load(reg, argType);
                        reg += argType.getSize();
                    }
                    if (this.callableDescriptor instanceof PropertyGetterDescriptor) {
                        property.put(signature.getReturnType(), iv);
                    } else {
                        ((StackValue)property).store(StackValue.onStack(property.type, property.kotlinType), iv, true);
                    }
                    iv.areturn(signature.getReturnType());
                }

                @Override
                public boolean skipNotNullAssertionsForParameters() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "callableDescriptor";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "codegen";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "signature";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/kotlin/codegen/MemberCodegen$1PropertyAccessorStrategy";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "<init>";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "doGenerateBody";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            final AccessorForPropertyDescriptor accessor = (AccessorForPropertyDescriptor)accessorForCallableDescriptor;
            final PropertyDescriptor original = accessor.getCalleeDescriptor();
            if (accessor.isWithSyntheticGetterAccessor()) {
                PropertyGetterDescriptorImpl getter2 = accessor.getGetter();
                assert (getter2 != null);
                this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original.getGetter() != null ? original.getGetter() : original), getter2, new PropertyAccessorStrategy(getter2));
            }
            if (accessor.isVar() && accessor.isWithSyntheticSetterAccessor()) {
                PropertySetterDescriptor setter2 = accessor.getSetter();
                assert (setter2 != null);
                this.functionCodegen.generateMethod(JvmDeclarationOriginKt.Synthetic(null, original.getSetter() != null ? original.getSetter() : original), setter2, new PropertyAccessorStrategy(setter2));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected StackValue generateMethodCallTo(@NotNull FunctionDescriptor functionDescriptor, @Nullable FunctionDescriptor accessorDescriptor, @NotNull InstructionAdapter iv) {
        int reg;
        if (functionDescriptor == null) {
            MemberCodegen.$$$reportNull$$$0(49);
        }
        if (iv == null) {
            MemberCodegen.$$$reportNull$$$0(50);
        }
        CallableMethod callableMethod = this.typeMapper.mapToCallableMethod(functionDescriptor, accessorDescriptor instanceof AccessorForCallableDescriptor && (((AccessorForCallableDescriptor)((Object)accessorDescriptor)).getSuperCallTarget() != null || ((AccessorForCallableDescriptor)((Object)accessorDescriptor)).getAccessorKind() == AccessorKind.JVM_DEFAULT_COMPATIBILITY), accessorDescriptor != null && TypeMapperUtilsKt.isInlineClassConstructorAccessor(accessorDescriptor) ? OwnerKind.ERASED_INLINE_CLASS : null);
        boolean isJvmStaticInObjectOrClass = CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor);
        boolean hasDispatchReceiver = !DescriptorUtils.isStaticDeclaration(functionDescriptor) && !JvmCodegenUtil.isNonDefaultInterfaceMember(functionDescriptor) && !isJvmStaticInObjectOrClass && !InlineClassesUtilsKt.isInlineClass(functionDescriptor.getContainingDeclaration());
        boolean accessorIsConstructor = accessorDescriptor instanceof AccessorForConstructorDescriptor;
        ReceiverParameterDescriptor dispatchReceiver = functionDescriptor.getDispatchReceiverParameter();
        Type dispatchReceiverType = dispatchReceiver != null && !accessorIsConstructor ? this.typeMapper.mapType(dispatchReceiver.getType()) : AsmTypes.OBJECT_TYPE;
        int accessorParam = hasDispatchReceiver && !accessorIsConstructor ? 1 : 0;
        int n = reg = hasDispatchReceiver ? dispatchReceiverType.getSize() : 0;
        if (!accessorIsConstructor && functionDescriptor instanceof ConstructorDescriptor) {
            iv.anew(callableMethod.getOwner());
            iv.dup();
            reg = 0;
            accessorParam = 0;
        } else if (KotlinTypeMapper.isAccessor(accessorDescriptor) && (hasDispatchReceiver || accessorIsConstructor) && !isJvmStaticInObjectOrClass) {
            iv.load(0, dispatchReceiverType);
        }
        Type[] calleeParameterTypes = callableMethod.getParameterTypes();
        Type[] accessorParameterTypes = accessorDescriptor != null ? this.typeMapper.mapToCallableMethod(accessorDescriptor, false).getParameterTypes() : calleeParameterTypes;
        for (Type calleeArgType : calleeParameterTypes) {
            if (AsmTypes.DEFAULT_CONSTRUCTOR_MARKER.equals(calleeArgType)) {
                iv.aconst(null);
            } else {
                Type accessorParameterType = accessorParameterTypes[accessorParam];
                iv.load(reg, accessorParameterType);
                StackValue.coerce(accessorParameterType, calleeArgType, iv);
                reg += accessorParameterType.getSize();
            }
            ++accessorParam;
        }
        callableMethod.genInvokeInstruction(iv);
        return StackValue.onStack(callableMethod.getReturnType(), functionDescriptor.getReturnType());
    }

    public void generateAssertField() {
        if (this.jvmAssertFieldGenerated) {
            return;
        }
        AssertCodegenUtilKt.generateAssertionsDisabledFieldInitialization(this.v, this.createOrGetClInitCodegen().v);
        this.jvmAssertFieldGenerated = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapped";
                break;
            }
            case 4: 
            case 6: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAlias";
                break;
            }
            case 9: 
            case 18: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntheticMethod";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClasses";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/MemberCodegen";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createCodegen";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisAsmType";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldAsmType";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorForCallableDescriptor";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iv";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/MemberCodegen";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineNameGenerator";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrGetClInitCodegen";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createClInitFunctionDescriptor";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyOrDelegateType";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getReifiedTypeParametersUsages";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSourceMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markLineNumberForDescriptor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markLineNumberForElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "genSimpleMember";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "genTypeAlias";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateSyntheticAnnotationsMethod";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "genClassOrObject";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addParentsToInnerClassesIfNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addInnerClassInfoFromAnnotation";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "writeInnerClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "computeOuterClass";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "computeEnclosingMethod";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createClInitFunctionDescriptor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "generateInitializers";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "initializeProperty";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "shouldInitializeProperty";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyOrDelegateType";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "skipDefaultValue";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "generatePropertyMetadataArrayFieldIfNeeded";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "generateConstInstance";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "generateSyntheticAccessorForCompanionObject";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "generateSyntheticAccessor";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodCallTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

