/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.ExpressionVisitor;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.KTypeConstructor$WhenMappings;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.types.DynamicType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\rH\u0002J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KTypeConstructor;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getContext", "()Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "callHelperFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "name", "", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "createDynamicType", "createKClassifier", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "createKType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "createKTypeParameter", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "createKTypeProjection", "tp", "Lorg/jetbrains/kotlin/types/TypeProjection;", "createSimpleKType", "Lorg/jetbrains/kotlin/types/SimpleType;", "js.translator"})
public final class KTypeConstructor {
    @NotNull
    private final TranslationContext context;

    @NotNull
    public final JsInvocation callHelperFunction(@NotNull String name, JsExpression ... arguments2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        return new JsInvocation(this.context.getReferenceToIntrinsic(name), Arrays.copyOf(arguments2, arguments2.length));
    }

    @NotNull
    public final JsExpression createKType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        UnwrappedType unwrappedType = type2.unwrap();
        if (unwrappedType instanceof SimpleType) {
            return this.createSimpleKType((SimpleType)unwrappedType);
        }
        if (unwrappedType instanceof DynamicType) {
            return this.createDynamicType();
        }
        String string2 = "Unexpected type " + type2;
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    private final JsExpression createDynamicType() {
        return this.callHelperFunction("createDynamicKType", new JsExpression[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression createSimpleKType(SimpleType type2) {
        Collection<JsExpression> collection;
        void $this$mapTo$iv$iv;
        ClassifierDescriptor classifier2;
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            Intrinsics.throwNpe();
        }
        if ((classifier2 = classifierDescriptor) instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)classifier2).isReified()) {
            JsName jsName = this.context.getNameForIntrinsic(SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE.getSuggestedName());
            Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForIntrin\u2026ETER_KTYPE.suggestedName)");
            JsName kClassName = jsName;
            MetadataProperties.setSpecialFunction(kClassName, SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE);
            JsInvocation reifiedTypeParameterType = new JsInvocation((JsExpression)kClassName.makeRef(), UtilsKt.getReferenceToJsClass(classifier2, this.context));
            if (type2.isMarkedNullable()) {
                return this.callHelperFunction("markKTypeNullable", reifiedTypeParameterType);
            }
            return reifiedTypeParameterType;
        }
        JsExpression kClassifier = this.createKClassifier(classifier2);
        Iterable $this$map$iv = type2.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JsExpression jsExpression = this.createKTypeProjection((TypeProjection)it);
            collection.add(jsExpression);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        JsArrayLiteral arguments2 = new JsArrayLiteral(list2);
        JsBooleanLiteral isMarkedNullable = new JsBooleanLiteral(type2.isMarkedNullable());
        return this.callHelperFunction("createKType", kClassifier, arguments2, isMarkedNullable);
    }

    @NotNull
    public final JsExpression createKTypeProjection(@NotNull TypeProjection tp) {
        String string2;
        Intrinsics.checkParameterIsNotNull(tp, "tp");
        if (tp.isStarProjection()) {
            return this.callHelperFunction("getStarKTypeProjection", new JsExpression[0]);
        }
        switch (KTypeConstructor$WhenMappings.$EnumSwitchMapping$0[tp.getProjectionKind().ordinal()]) {
            case 1: {
                string2 = "createInvariantKTypeProjection";
                break;
            }
            case 2: {
                string2 = "createContravariantKTypeProjection";
                break;
            }
            case 3: {
                string2 = "createCovariantKTypeProjection";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String factoryName = string2;
        KotlinType kotlinType2 = tp.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "tp.type");
        JsExpression kType = this.createKType(kotlinType2);
        return this.callHelperFunction(factoryName, kType);
    }

    @NotNull
    public final JsExpression createKClassifier(@NotNull ClassifierDescriptor classifier2) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull(classifier2, "classifier");
        ClassifierDescriptor classifierDescriptor = classifier2;
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            jsExpression = this.createKTypeParameter((TypeParameterDescriptor)classifier2);
        } else {
            JsExpression jsExpression2 = ExpressionVisitor.getObjectKClass(this.context, classifier2);
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "ExpressionVisitor.getObj\u2026lass(context, classifier)");
        }
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsExpression createKTypeParameter(@NotNull TypeParameterDescriptor typeParameter) {
        JsStringLiteral jsStringLiteral;
        Collection<JsExpression> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(typeParameter, "typeParameter");
        JsStringLiteral name = new JsStringLiteral(typeParameter.getName().asString());
        List<KotlinType> list2 = typeParameter.getUpperBounds();
        Intrinsics.checkExpressionValueIsNotNull(list2, "typeParameter.upperBounds");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType2 = (KotlinType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull(v1, "it");
            JsExpression jsExpression = this.createKType((KotlinType)v1);
            collection.add(jsExpression);
        }
        collection = (List)destination$iv$iv;
        List list3 = collection;
        JsArrayLiteral upperBounds = new JsArrayLiteral(list3);
        switch (KTypeConstructor$WhenMappings.$EnumSwitchMapping$1[typeParameter.getVariance().ordinal()]) {
            case 1: {
                jsStringLiteral = new JsStringLiteral("invariant");
                break;
            }
            case 2: {
                jsStringLiteral = new JsStringLiteral("in");
                break;
            }
            case 3: {
                jsStringLiteral = new JsStringLiteral("out");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        JsStringLiteral variance = jsStringLiteral;
        if (typeParameter.isReified()) {
            JsName jsName = this.context.getNameForIntrinsic(SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE.getSuggestedName());
            Intrinsics.checkExpressionValueIsNotNull(jsName, "context.getNameForIntrin\u2026ETER_KTYPE.suggestedName)");
            JsName kClassName = jsName;
            MetadataProperties.setSpecialFunction(kClassName, SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE);
            return new JsInvocation((JsExpression)kClassName.makeRef(), UtilsKt.getReferenceToJsClass(typeParameter, this.context));
        }
        return this.callHelperFunction("createKTypeParameter", name, upperBounds, variance);
    }

    @NotNull
    public final TranslationContext getContext() {
        return this.context;
    }

    public KTypeConstructor(@NotNull TranslationContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.context = context2;
    }
}

