/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReceiver;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceCandidate;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferencesCandidateFactory;
import org.jetbrains.kotlin.resolve.calls.components.CreateFreshVariablesSubstitutor;
import org.jetbrains.kotlin.resolve.calls.components.InputOutputTypes;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemOperation;
import org.jetbrains.kotlin.resolve.calls.inference.components.FreshVariableNewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.LHSResult;
import org.jetbrains.kotlin.resolve.calls.tower.PrioritizedCompositeScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.SamePriorityCompositeScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.SimpleScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.VisibilityError;
import org.jetbrains.kotlin.resolve.scopes.receivers.DetailedReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewCapturedTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0002\u001a0\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001aV\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b*\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00022\b\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010$\u001a\u00020%\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006&"}, d2={"asReceiverValueForVisibilityChecks", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReceiver;", "getAsReceiverValueForVisibilityChecks", "(Lorg/jetbrains/kotlin/resolve/calls/components/CallableReceiver;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "createCallableReferenceProcessor", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceCandidate;", "factory", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferencesCandidateFactory;", "extractInputOutputTypesFromCallableReferenceExpectedType", "Lorg/jetbrains/kotlin/resolve/calls/components/InputOutputTypes;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "extractInputOutputTypesFromFunctionType", "functionType", "addReceiverConstraint", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemOperation;", "toFreshSubstitutor", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/FreshVariableNewTypeSubstitutor;", "receiverArgument", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ArgumentConstraintPosition;", "checkCallableReference", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/CallableReferenceKotlinCallArgument;", "dispatchReceiver", "extensionReceiver", "candidateDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "reflectionCandidateType", "ownerDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolution"})
public final class CallableReferenceResolutionKt {
    private static final ReceiverValue getAsReceiverValueForVisibilityChecks(@NotNull CallableReceiver $this$asReceiverValueForVisibilityChecks) {
        return $this$asReceiverValueForVisibilityChecks.getReceiver().getReceiverValue();
    }

    @NotNull
    public static final ScopeTowerProcessor<CallableReferenceCandidate> createCallableReferenceProcessor(@NotNull CallableReferencesCandidateFactory factory2) {
        LHSResult lhsResult;
        Intrinsics.checkParameterIsNotNull(factory2, "factory");
        LHSResult lHSResult = lhsResult = factory2.getArgument().getLhsResult();
        if (Intrinsics.areEqual(lHSResult, LHSResult.Empty.INSTANCE) || Intrinsics.areEqual(lHSResult, LHSResult.Error.INSTANCE) || lHSResult instanceof LHSResult.Expression) {
            Object object;
            LHSResult lHSResult2 = lhsResult;
            if (!(lHSResult2 instanceof LHSResult.Expression)) {
                lHSResult2 = null;
            }
            ReceiverValueWithSmartCastInfo explicitReceiver = (object = (LHSResult.Expression)lHSResult2) != null && (object = ((LHSResult.Expression)object).getLshCallArgument()) != null ? object.getReceiver() : null;
            return factory2.createCallableProcessor(explicitReceiver);
        }
        if (lHSResult instanceof LHSResult.Type) {
            SimpleScopeTowerProcessor<CallableReferenceCandidate> simpleScopeTowerProcessor = factory2.createCallableProcessor(((LHSResult.Type)lhsResult).getQualifier());
            SimpleScopeTowerProcessor<CallableReferenceCandidate> unbound = factory2.createCallableProcessor(((LHSResult.Type)lhsResult).getUnboundDetailedReceiver());
            SamePriorityCompositeScopeTowerProcessor staticOrUnbound = new SamePriorityCompositeScopeTowerProcessor(simpleScopeTowerProcessor, unbound);
            DetailedReceiver detailedReceiver = ((LHSResult.Type)lhsResult).getQualifier();
            if (detailedReceiver == null || (detailedReceiver = detailedReceiver.getClassValueReceiverWithSmartCastInfo()) == null) {
                return staticOrUnbound;
            }
            DetailedReceiver asValue = detailedReceiver;
            return new PrioritizedCompositeScopeTowerProcessor(staticOrUnbound, factory2.createCallableProcessor(asValue));
        }
        if (lHSResult instanceof LHSResult.Object) {
            SimpleScopeTowerProcessor<CallableReferenceCandidate> simpleScopeTowerProcessor = factory2.createCallableProcessor(((LHSResult.Object)lhsResult).getQualifier());
            SimpleScopeTowerProcessor<CallableReferenceCandidate> boundObjectReference = factory2.createCallableProcessor(((LHSResult.Object)lhsResult).getObjectValueReceiver());
            return new SamePriorityCompositeScopeTowerProcessor(simpleScopeTowerProcessor, boundObjectReference);
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public static final Pair<FreshVariableNewTypeSubstitutor, KotlinCallDiagnostic> checkCallableReference(@NotNull ConstraintSystemOperation $this$checkCallableReference, @NotNull CallableReferenceKotlinCallArgument argument, @Nullable CallableReceiver dispatchReceiver, @Nullable CallableReceiver extensionReceiver, @NotNull CallableDescriptor candidateDescriptor, @NotNull UnwrappedType reflectionCandidateType, @Nullable UnwrappedType expectedType, @NotNull DeclarationDescriptor ownerDescriptor) {
        VisibilityError visibilityError;
        Intrinsics.checkParameterIsNotNull($this$checkCallableReference, "$this$checkCallableReference");
        Intrinsics.checkParameterIsNotNull(argument, "argument");
        Intrinsics.checkParameterIsNotNull(candidateDescriptor, "candidateDescriptor");
        Intrinsics.checkParameterIsNotNull(reflectionCandidateType, "reflectionCandidateType");
        Intrinsics.checkParameterIsNotNull(ownerDescriptor, "ownerDescriptor");
        ArgumentConstraintPosition position = new ArgumentConstraintPosition(argument);
        FreshVariableNewTypeSubstitutor toFreshSubstitutor = CreateFreshVariablesSubstitutor.INSTANCE.createToFreshVariableSubstitutorAndAddInitialConstraints(candidateDescriptor, $this$checkCallableReference);
        if (expectedType != null) {
            $this$checkCallableReference.addSubtypeConstraint(toFreshSubstitutor.safeSubstitute(reflectionCandidateType), expectedType, position);
        }
        if (!ErrorUtils.isError(candidateDescriptor)) {
            CallableReferenceResolutionKt.addReceiverConstraint($this$checkCallableReference, toFreshSubstitutor, dispatchReceiver, candidateDescriptor.getDispatchReceiverParameter(), position);
            CallableReferenceResolutionKt.addReceiverConstraint($this$checkCallableReference, toFreshSubstitutor, extensionReceiver, candidateDescriptor.getExtensionReceiverParameter(), position);
        }
        CallableReceiver callableReceiver = dispatchReceiver;
        DeclarationDescriptorWithVisibility invisibleMember = Visibilities.findInvisibleMember(callableReceiver != null ? CallableReferenceResolutionKt.getAsReceiverValueForVisibilityChecks(callableReceiver) : null, candidateDescriptor, ownerDescriptor);
        FreshVariableNewTypeSubstitutor freshVariableNewTypeSubstitutor = toFreshSubstitutor;
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = invisibleMember;
        if (declarationDescriptorWithVisibility != null) {
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility2 = declarationDescriptorWithVisibility;
            FreshVariableNewTypeSubstitutor freshVariableNewTypeSubstitutor2 = freshVariableNewTypeSubstitutor;
            boolean bl = false;
            boolean bl2 = false;
            DeclarationDescriptorWithVisibility p1 = declarationDescriptorWithVisibility2;
            boolean bl3 = false;
            VisibilityError visibilityError2 = new VisibilityError(p1);
            freshVariableNewTypeSubstitutor = freshVariableNewTypeSubstitutor2;
            visibilityError = visibilityError2;
        } else {
            visibilityError = null;
        }
        return TuplesKt.to(freshVariableNewTypeSubstitutor, visibilityError);
    }

    private static final void addReceiverConstraint(@NotNull ConstraintSystemOperation $this$addReceiverConstraint, FreshVariableNewTypeSubstitutor toFreshSubstitutor, CallableReceiver receiverArgument, ReceiverParameterDescriptor receiverParameter, ArgumentConstraintPosition position) {
        if (receiverArgument == null || receiverParameter == null) {
            boolean bl = receiverArgument == null;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-CallableReferenceResolutionKt$addReceiverConstraint$32 = false;
                String $i$a$-assert-CallableReferenceResolutionKt$addReceiverConstraint$32 = "Receiver argument should be null if parameter is: " + receiverArgument;
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallableReferenceResolutionKt$addReceiverConstraint$32));
            }
            bl = receiverParameter == null;
            bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "Receiver parameter should be null if argument is: " + receiverParameter;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            return;
        }
        ReceiverValue receiverValue = receiverParameter.getValue();
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "receiverParameter.value");
        UnwrappedType expectedType = toFreshSubstitutor.safeSubstitute(receiverValue.getType().unwrap());
        UnwrappedType unwrappedType = ArgumentsUtilsKt.getStableType(receiverArgument.getReceiver());
        boolean bl = false;
        boolean bl4 = false;
        UnwrappedType it = unwrappedType;
        boolean bl5 = false;
        UnwrappedType unwrappedType2 = NewCapturedTypeKt.captureFromExpression(it);
        if (unwrappedType2 == null) {
            unwrappedType2 = it;
        }
        UnwrappedType receiverType = unwrappedType2;
        $this$addReceiverConstraint.addSubtypeConstraint(receiverType, expectedType, position);
    }

    @Nullable
    public static final InputOutputTypes extractInputOutputTypesFromCallableReferenceExpectedType(@Nullable UnwrappedType expectedType) {
        InputOutputTypes inputOutputTypes;
        if (expectedType == null) {
            return null;
        }
        if (FunctionTypesKt.isFunctionType(expectedType) || FunctionTypesKt.isSuspendFunctionType(expectedType)) {
            inputOutputTypes = CallableReferenceResolutionKt.extractInputOutputTypesFromFunctionType(expectedType);
        } else if (ReflectionTypes.Companion.isBaseTypeForNumberedReferenceTypes(expectedType)) {
            inputOutputTypes = new InputOutputTypes(CollectionsKt.emptyList(), CollectionsKt.single(expectedType.getArguments()).getType().unwrap());
        } else if (ReflectionTypes.Companion.isNumberedKFunction(expectedType)) {
            Object element$iv2;
            block14: {
                Iterable $this$first$iv = TypeUtilsKt.immediateSupertypes(expectedType);
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    KotlinType it = (KotlinType)element$iv2;
                    boolean bl = false;
                    if (!FunctionTypesKt.isFunctionType(it)) continue;
                    break block14;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            UnwrappedType functionFromSupertype = ((KotlinType)element$iv2).unwrap();
            inputOutputTypes = CallableReferenceResolutionKt.extractInputOutputTypesFromFunctionType(functionFromSupertype);
        } else if (ReflectionTypes.Companion.isNumberedKSuspendFunction(expectedType)) {
            Object element$iv3;
            block15: {
                Iterable $this$first$iv = TypeUtilsKt.immediateSupertypes(expectedType);
                boolean $i$f$first = false;
                for (Object element$iv3 : $this$first$iv) {
                    KotlinType it = (KotlinType)element$iv3;
                    boolean bl = false;
                    if (!FunctionTypesKt.isSuspendFunctionType(it)) continue;
                    break block15;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            UnwrappedType kSuspendFunctionType = ((KotlinType)element$iv3).unwrap();
            inputOutputTypes = CallableReferenceResolutionKt.extractInputOutputTypesFromFunctionType(kSuspendFunctionType);
        } else if (ReflectionTypes.Companion.isNumberedKPropertyOrKMutablePropertyType(expectedType)) {
            Object element$iv4;
            block16: {
                Iterable $this$first$iv = TypeUtilsKt.supertypes(expectedType);
                boolean $i$f$first = false;
                for (Object element$iv4 : $this$first$iv) {
                    KotlinType it = (KotlinType)element$iv4;
                    boolean bl = false;
                    if (!FunctionTypesKt.isFunctionType(it)) continue;
                    break block16;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            UnwrappedType functionFromSupertype = ((KotlinType)element$iv4).unwrap();
            inputOutputTypes = CallableReferenceResolutionKt.extractInputOutputTypesFromFunctionType(functionFromSupertype);
        } else {
            inputOutputTypes = null;
        }
        return inputOutputTypes;
    }

    /*
     * WARNING - void declaration
     */
    private static final InputOutputTypes extractInputOutputTypesFromFunctionType(UnwrappedType functionType) {
        void $this$mapTo$iv$iv;
        KotlinType kotlinType2 = FunctionTypesKt.getReceiverTypeFromFunctionType(functionType);
        UnwrappedType receiver = kotlinType2 != null ? kotlinType2.unwrap() : null;
        Iterable $this$map$iv = FunctionTypesKt.getValueParameterTypesFromFunctionType(functionType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UnwrappedType unwrappedType = it.getType().unwrap();
            collection.add(unwrappedType);
        }
        List parameters2 = (List)destination$iv$iv;
        List inputTypes = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(receiver), (Iterable)parameters2);
        UnwrappedType outputType = FunctionTypesKt.getReturnTypeFromFunctionType(functionType).unwrap();
        return new InputOutputTypes(inputTypes, outputType);
    }

    public static final /* synthetic */ ReceiverValue access$getAsReceiverValueForVisibilityChecks$p(CallableReceiver $this$access_u24asReceiverValueForVisibilityChecks_u24p) {
        return CallableReferenceResolutionKt.getAsReceiverValueForVisibilityChecks($this$access_u24asReceiverValueForVisibilityChecks_u24p);
    }
}

