/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.StandardTypesKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypedProjection;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001c\u0010\u0004\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"arrayElementType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "createArrayOf", "nullable", "", "resolve"})
public final class ArrayUtilsKt {
    @NotNull
    public static final ConeKotlinType createArrayOf(@NotNull ConeKotlinType $this$createArrayOf, @NotNull FirSession session, boolean nullable) {
        ClassId primitiveArrayId;
        Intrinsics.checkParameterIsNotNull($this$createArrayOf, "$this$createArrayOf");
        Intrinsics.checkParameterIsNotNull(session, "session");
        FirSymbolProvider symbolProvider2 = ResolveUtilsKt.getFirSymbolProvider(session);
        ConeKotlinType type2 = ConeTypesKt.lowerBoundIfFlexible($this$createArrayOf);
        if (type2 instanceof ConeClassLikeType && (primitiveArrayId = StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().get(((ConeClassLikeType)type2).getLookupTag().getClassId())) != null) {
            FirClassifierSymbol firClassifierSymbol = StandardTypesKt.invoke(primitiveArrayId, symbolProvider2);
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = new ConeKotlinTypeProjection[]{};
            return ResolveUtilsKt.constructType(firClassifierSymbol, coneKotlinTypeProjectionArray, nullable);
        }
        return ResolveUtilsKt.constructType((FirClassifierSymbol)StandardTypesKt.invoke(StandardClassIds.INSTANCE.getArray(), symbolProvider2), new ConeKotlinTypeProjection[]{$this$createArrayOf}, nullable);
    }

    public static /* synthetic */ ConeKotlinType createArrayOf$default(ConeKotlinType coneKotlinType, FirSession firSession, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return ArrayUtilsKt.createArrayOf(coneKotlinType, firSession, bl);
    }

    @Nullable
    public static final ConeKotlinType arrayElementType(@NotNull ConeKotlinType $this$arrayElementType, @NotNull FirSession session) {
        Intrinsics.checkParameterIsNotNull($this$arrayElementType, "$this$arrayElementType");
        Intrinsics.checkParameterIsNotNull(session, "session");
        ConeKotlinType type2 = ConeTypesKt.lowerBoundIfFlexible($this$arrayElementType);
        if (!(type2 instanceof ConeClassLikeType)) {
            return null;
        }
        ClassId classId = ((ConeClassLikeType)type2).getLookupTag().getClassId();
        if (Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getArray())) {
            ConeKotlinTypeProjection coneKotlinTypeProjection = ArraysKt.first(type2.getTypeArguments());
            if (coneKotlinTypeProjection == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeTypedProjection");
            }
            return ((ConeTypedProjection)((Object)coneKotlinTypeProjection)).getType();
        }
        ClassId elementType = StandardClassIds.INSTANCE.getElementTypeByPrimitiveArrayType().get(classId);
        if (elementType != null) {
            FirClassifierSymbol firClassifierSymbol = StandardTypesKt.invoke(elementType, ResolveUtilsKt.getFirSymbolProvider(session));
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = new ConeKotlinTypeProjection[]{};
            return ResolveUtilsKt.constructType(firClassifierSymbol, coneKotlinTypeProjectionArray, false);
        }
        return null;
    }
}

