/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedType;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintIncorporationKt$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.CompoundConstraintPosition;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typesApproximation.ApproximationBounds;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"addConstraintFromBounds", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilderImpl;", "old", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "new", "generateNewBound", "bound", "substitution", "incorporateBound", "newBound", "frontend"})
public final class ConstraintIncorporationKt {
    /*
     * WARNING - void declaration
     */
    public static final void incorporateBound(@NotNull ConstraintSystemBuilderImpl $this$incorporateBound, @NotNull TypeBounds.Bound newBound) {
        Intrinsics.checkParameterIsNotNull($this$incorporateBound, "$this$incorporateBound");
        Intrinsics.checkParameterIsNotNull(newBound, "newBound");
        TypeVariable typeVariable2 = newBound.getTypeVariable();
        TypeBoundsImpl typeBounds = $this$incorporateBound.getTypeBounds$frontend(typeVariable2);
        int n = 0;
        int n2 = typeBounds.getBounds().size();
        while (n < n2) {
            void oldBoundIndex;
            Object e = ((ArrayList)typeBounds.getBounds()).get((int)oldBoundIndex);
            Intrinsics.checkExpressionValueIsNotNull(e, "typeBounds.bounds[oldBoundIndex]");
            ConstraintIncorporationKt.addConstraintFromBounds($this$incorporateBound, (TypeBounds.Bound)e, newBound);
            ++oldBoundIndex;
        }
        List<TypeBounds.Bound> list2 = $this$incorporateBound.getUsedInBounds$frontend().get(typeVariable2);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List<TypeBounds.Bound> boundsUsedIn = list2;
        n2 = 0;
        int n3 = ((Collection)boundsUsedIn).size();
        while (n2 < n3) {
            void index2;
            TypeBounds.Bound boundUsedIn = boundsUsedIn.get((int)index2);
            ConstraintIncorporationKt.generateNewBound($this$incorporateBound, boundUsedIn, newBound);
            ++index2;
        }
        KotlinType constrainingType = newBound.getConstrainingType();
        if ($this$incorporateBound.isMyTypeVariable$frontend(constrainingType)) {
            ConstraintContext context2 = new ConstraintContext(newBound.getPosition(), newBound.getDerivedFrom(), false, false, 12, null);
            TypeVariable typeVariable3 = $this$incorporateBound.getMyTypeVariable$frontend(constrainingType);
            if (typeVariable3 == null) {
                Intrinsics.throwNpe();
            }
            $this$incorporateBound.addBound$frontend(typeVariable3, typeVariable2.getType(), TypeBoundsKt.reverse(newBound.getKind()), context2);
            return;
        }
        Iterable $this$forEach$iv = $this$incorporateBound.getNestedTypeVariables$frontend(constrainingType);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeVariable it = (TypeVariable)element$iv;
            boolean bl = false;
            Collection boundsForNestedVariable = $this$incorporateBound.getTypeBounds$frontend(it).getBounds();
            int n4 = 0;
            int n5 = boundsForNestedVariable.size();
            while (n4 < n5) {
                void index3;
                Object e = ((ArrayList)boundsForNestedVariable).get((int)index3);
                Intrinsics.checkExpressionValueIsNotNull(e, "boundsForNestedVariable[index]");
                ConstraintIncorporationKt.generateNewBound($this$incorporateBound, newBound, (TypeBounds.Bound)e);
                ++index3;
            }
        }
    }

    private static final void addConstraintFromBounds(@NotNull ConstraintSystemBuilderImpl $this$addConstraintFromBounds, TypeBounds.Bound old, TypeBounds.Bound bound) {
        block2: {
            ConstraintContext context2;
            KotlinType newType;
            KotlinType oldType;
            block3: {
                block1: {
                    if (Intrinsics.areEqual(old, bound)) {
                        return;
                    }
                    oldType = old.getConstrainingType();
                    newType = bound.getConstrainingType();
                    context2 = new ConstraintContext(new CompoundConstraintPosition(old.getPosition(), bound.getPosition()), SetsKt.plus(old.getDerivedFrom(), (Iterable)bound.getDerivedFrom()), false, false, 12, null);
                    if (old.getKind().ordinal() >= bound.getKind().ordinal()) break block1;
                    $this$addConstraintFromBounds.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.SUB_TYPE, oldType, newType, context2);
                    break block2;
                }
                if (old.getKind().ordinal() <= bound.getKind().ordinal()) break block3;
                $this$addConstraintFromBounds.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.SUB_TYPE, newType, oldType, context2);
                break block2;
            }
            if (old.getKind() != bound.getKind() || old.getKind() != TypeBounds.BoundKind.EXACT_BOUND) break block2;
            $this$addConstraintFromBounds.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.EQUAL, oldType, newType, context2);
        }
    }

    private static final void generateNewBound(@NotNull ConstraintSystemBuilderImpl $this$generateNewBound, TypeBounds.Bound bound, TypeBounds.Bound substitution2) {
        KotlinType kotlinType;
        if (bound == substitution2) {
            return;
        }
        switch (ConstraintIncorporationKt$WhenMappings.$EnumSwitchMapping$0[substitution2.getKind().ordinal()]) {
            case 1: {
                kotlinType = substitution2.getConstrainingType();
                break;
            }
            case 2: {
                kotlinType = new CapturedType(new TypeProjectionImpl(Variance.OUT_VARIANCE, substitution2.getConstrainingType()), null, false, null, 14, null);
                break;
            }
            case 3: {
                kotlinType = new CapturedType(new TypeProjectionImpl(Variance.IN_VARIANCE, substitution2.getConstrainingType()), null, false, null, 14, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KotlinType substitutedType = kotlinType;
        TypeProjectionImpl newTypeProjection = new TypeProjectionImpl(substitutedType);
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(MapsKt.mapOf(TuplesKt.to(substitution2.getTypeVariable().getType().getConstructor(), newTypeProjection)));
        Intrinsics.checkExpressionValueIsNotNull(typeSubstitutor2, "TypeSubstitutor.create(m\u2026or to newTypeProjection))");
        TypeSubstitutor substitutor2 = typeSubstitutor2;
        KotlinType kotlinType2 = substitutor2.substitute(bound.getConstrainingType(), Variance.INVARIANT);
        if (kotlinType2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "substitutor.substitute(b\u2026ype, INVARIANT) ?: return");
        KotlinType type2 = kotlinType2;
        CompoundConstraintPosition position = new CompoundConstraintPosition(bound.getPosition(), substitution2.getPosition());
        Function2<KotlinType, TypeBounds.BoundKind, Unit> $fun$addNewBound$1 = new Function2<KotlinType, TypeBounds.BoundKind, Unit>($this$generateNewBound, bound, substitution2, position){
            final /* synthetic */ ConstraintSystemBuilderImpl $this_generateNewBound;
            final /* synthetic */ TypeBounds.Bound $bound;
            final /* synthetic */ TypeBounds.Bound $substitution;
            final /* synthetic */ CompoundConstraintPosition $position;

            public final void invoke(@NotNull KotlinType newConstrainingType, @NotNull TypeBounds.BoundKind newBoundKind) {
                Intrinsics.checkParameterIsNotNull(newConstrainingType, "newConstrainingType");
                Intrinsics.checkParameterIsNotNull((Object)((Object)newBoundKind), "newBoundKind");
                if (this.$this_generateNewBound.getNestedTypeVariables$frontend(newConstrainingType).contains(this.$bound.getTypeVariable())) {
                    return;
                }
                HashSet<TypeVariable> derivedFrom = new HashSet<TypeVariable>((Collection)SetsKt.plus(this.$bound.getDerivedFrom(), (Iterable)this.$substitution.getDerivedFrom()));
                if (derivedFrom.contains(this.$substitution.getTypeVariable())) {
                    return;
                }
                derivedFrom.add(this.$substitution.getTypeVariable());
                this.$this_generateNewBound.addBound$frontend(this.$bound.getTypeVariable(), newConstrainingType, newBoundKind, new ConstraintContext(this.$position, derivedFrom, false, false, 12, null));
            }
            {
                this.$this_generateNewBound = constraintSystemBuilderImpl;
                this.$bound = bound;
                this.$substitution = bound2;
                this.$position = compoundConstraintPosition;
                super(2);
            }
        };
        if (substitution2.getKind() == TypeBounds.BoundKind.EXACT_BOUND) {
            $fun$addNewBound$1.invoke(type2, bound.getKind());
            return;
        }
        Function1<KotlinType, Boolean> $fun$containsConstrainingTypeWithoutProjection$2 = new Function1<KotlinType, Boolean>(substitution2){
            final /* synthetic */ TypeBounds.Bound $substitution;

            public final boolean invoke(@NotNull KotlinType $this$containsConstrainingTypeWithoutProjection) {
                boolean bl;
                block3: {
                    Intrinsics.checkParameterIsNotNull($this$containsConstrainingTypeWithoutProjection, "$this$containsConstrainingTypeWithoutProjection");
                    Iterable $this$any$iv = ConstraintSystemUtilsKt.getNestedArguments($this$containsConstrainingTypeWithoutProjection);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            TypeProjection it = (TypeProjection)element$iv;
                            boolean bl2 = false;
                            if (!(Intrinsics.areEqual(it.getType().getConstructor(), this.$substitution.getConstrainingType().getConstructor()) && it.getProjectionKind() == Variance.INVARIANT)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$substitution = bound;
                super(1);
            }
        };
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(type2);
        if ($fun$containsConstrainingTypeWithoutProjection$2.invoke(approximationBounds.getUpper()) && bound.getKind() != TypeBounds.BoundKind.LOWER_BOUND) {
            $fun$addNewBound$1.invoke(approximationBounds.getUpper(), TypeBounds.BoundKind.UPPER_BOUND);
        }
        if ($fun$containsConstrainingTypeWithoutProjection$2.invoke(approximationBounds.getLower()) && bound.getKind() != TypeBounds.BoundKind.UPPER_BOUND) {
            $fun$addNewBound$1.invoke(approximationBounds.getLower(), TypeBounds.BoundKind.LOWER_BOUND);
        }
    }
}

