/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BooleanComparison;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/PrimitiveToObjectComparison;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "op", "Lcom/intellij/psi/tree/IElementType;", "boxedValue", "Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "useNullCheck", "", "primitiveType", "Lorg/jetbrains/org/objectweb/asm/Type;", "loadOther", "Lkotlin/Function0;", "(Lcom/intellij/psi/tree/IElementType;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;ZLorg/jetbrains/org/objectweb/asm/Type;Lkotlin/jvm/functions/Function0;)V", "getOp", "()Lcom/intellij/psi/tree/IElementType;", "discard", "", "jumpIfFalse", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "backend.jvm"})
public final class PrimitiveToObjectComparison
extends BooleanValue {
    @NotNull
    private final IElementType op;
    private final MaterialValue boxedValue;
    private final boolean useNullCheck;
    private final Type primitiveType;
    private final Function0<MaterialValue> loadOther;

    @Override
    public void jumpIfFalse(@NotNull Label target) {
        Intrinsics.checkNotNullParameter(target, "target");
        Label compareLabel = new Label();
        this.getMv().dup();
        if (this.useNullCheck) {
            this.getMv().ifnonnull(compareLabel);
        } else {
            this.getMv().instanceOf(AsmUtil.boxType(this.primitiveType));
            this.getMv().ifne(compareLabel);
        }
        this.getMv().pop();
        this.getMv().goTo(target);
        this.getMv().mark(compareLabel);
        MaterialValue unboxedValue = PromisedValueKt.materializedAt(this.boxedValue, this.primitiveType, this.boxedValue.getIrType());
        new BooleanComparison(this.op, unboxedValue, this.loadOther.invoke()).jumpIfFalse(target);
    }

    @Override
    public void jumpIfTrue(@NotNull Label target) {
        Intrinsics.checkNotNullParameter(target, "target");
        Label compareLabel = new Label();
        Label endLabel = new Label();
        this.getMv().dup();
        if (this.useNullCheck) {
            this.getMv().ifnonnull(compareLabel);
        } else {
            this.getMv().instanceOf(AsmUtil.boxType(this.primitiveType));
            this.getMv().ifne(compareLabel);
        }
        this.getMv().pop();
        this.getMv().goTo(endLabel);
        this.getMv().mark(compareLabel);
        MaterialValue unboxedValue = PromisedValueKt.materializedAt(this.boxedValue, this.primitiveType, this.boxedValue.getIrType());
        new BooleanComparison(this.op, unboxedValue, this.loadOther.invoke()).jumpIfTrue(target);
        this.getMv().mark(endLabel);
    }

    @Override
    public void discard() {
        this.boxedValue.discard();
    }

    @NotNull
    public final IElementType getOp() {
        return this.op;
    }

    public PrimitiveToObjectComparison(@NotNull IElementType op, @NotNull MaterialValue boxedValue, boolean useNullCheck, @NotNull Type primitiveType, @NotNull Function0<MaterialValue> loadOther) {
        Intrinsics.checkNotNullParameter(op, "op");
        Intrinsics.checkNotNullParameter(boxedValue, "boxedValue");
        Intrinsics.checkNotNullParameter(primitiveType, "primitiveType");
        Intrinsics.checkNotNullParameter(loadOther, "loadOther");
        super(boxedValue.getCodegen());
        this.op = op;
        this.boxedValue = boxedValue;
        this.useNullCheck = useNullCheck;
        this.primitiveType = primitiveType;
        this.loadOther = loadOther;
    }
}

