/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u0006*\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegationSuperCallInEnumConstructorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirMemberDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "report", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "checkers"})
public final class FirDelegationSuperCallInEnumConstructorChecker
extends FirDeclarationChecker<FirMemberDeclaration> {
    @NotNull
    public static final FirDelegationSuperCallInEnumConstructorChecker INSTANCE;

    @Override
    public void check(@NotNull FirMemberDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!(declaration2 instanceof FirRegularClass) || ((FirRegularClass)declaration2).getClassKind() != ClassKind.ENUM_CLASS) {
            return;
        }
        for (FirDeclaration it : ((FirRegularClass)declaration2).getDeclarations()) {
            if (!(it instanceof FirConstructor) || ((FirConstructor)it).isPrimary()) continue;
            FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)it).getDelegatedConstructor();
            if (firDelegatedConstructorCall == null) continue;
            if (firDelegatedConstructorCall.isThis()) continue;
            Object object = ((FirConstructor)it).getDelegatedConstructor();
            if ((object != null && (object = ((FirDelegatedConstructorCall)object).getSource()) != null ? ((FirSourceElement)object).getKind() : null) instanceof FirFakeSourceElementKind) continue;
            FirDelegatedConstructorCall firDelegatedConstructorCall2 = ((FirConstructor)it).getDelegatedConstructor();
            this.report(reporter, firDelegatedConstructorCall2 != null ? firDelegatedConstructorCall2.getSource() : null);
        }
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source) {
        block0: {
            FirSourceElement firSourceElement = source;
            if (firSourceElement == null) break block0;
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getDELEGATION_SUPER_CALL_IN_ENUM_CONSTRUCTOR().on(it));
        }
    }

    private FirDelegationSuperCallInEnumConstructorChecker() {
    }

    static {
        FirDelegationSuperCallInEnumConstructorChecker firDelegationSuperCallInEnumConstructorChecker;
        INSTANCE = firDelegationSuperCallInEnumConstructorChecker = new FirDelegationSuperCallInEnumConstructorChecker();
    }
}

