/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.builder.FirTypeParameterBuilder;
import org.jetbrains.kotlin.fir.deserialization.FirTypeDeserializer;
import org.jetbrains.kotlin.fir.deserialization.FirTypeDeserializer$WhenMappings;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLikeLookupTagImpl;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.ProtoEnumFlags;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0019H\u0002J3\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010+J5\u0010,\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002\u00a2\u0006\u0002\u0010+J\u0018\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u0010)\u001a\u00020*J\u0016\u00101\u001a\u0002022\u0006\u0010/\u001a\u0002002\u0006\u0010)\u001a\u00020*J\u0010\u00103\u001a\u00020&2\u0006\u00104\u001a\u000205H\u0002J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020\u0019H\u0002J\u0012\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010/\u001a\u000200H\u0002J\f\u0010;\u001a\u00020<*\u00020=H\u0002J\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00100\t*\u0006\u0012\u0002\b\u00030?R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00100\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00100\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "typeParameterProtos", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter;", "parent", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;Ljava/util/List;Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;)V", "getNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "ownTypeParameters", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getOwnTypeParameters", "()Ljava/util/List;", "getParent", "()Lorg/jetbrains/kotlin/fir/deserialization/FirTypeDeserializer;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "typeParameterDescriptors", "", "", "typeParameterNames", "", "getTypeTable", "()Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "computeClassifier", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "fqNameIndex", "createSuspendFunctionType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "functionTypeConstructor", "arguments", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "isNullable", "", "attributes", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "(Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;ZLorg/jetbrains/kotlin/fir/types/ConeAttributes;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "createSuspendFunctionTypeForBasicCase", "simpleType", "Lorg/jetbrains/kotlin/fir/types/ConeLookupTagBasedType;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "typeArgument", "typeArgumentProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Argument;", "typeParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/ConeTypeParameterLookupTag;", "typeParameterId", "typeSymbol", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassifierLookupTag;", "convertVariance", "Lorg/jetbrains/kotlin/types/Variance;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter$Variance;", "typeParameters", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "fir-deserialization"})
public final class FirTypeDeserializer {
    private final Map<Integer, FirTypeParameterSymbol> typeParameterDescriptors;
    private final Map<String, FirTypeParameterSymbol> typeParameterNames;
    private final FirSession session;
    private final NameResolver nameResolver;
    private final TypeTable typeTable;
    private final FirTypeDeserializer parent;

    @NotNull
    public final List<FirTypeParameterSymbol> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    private final ConeClassLikeLookupTag computeClassifier(int fqNameIndex) {
        try {
            ClassId id = NameResolverUtilKt.getClassId(this.nameResolver, fqNameIndex);
            return new ConeClassLikeLookupTagImpl(id);
        }
        catch (Throwable e) {
            throw (Throwable)new RuntimeException("Looking up for " + NameResolverUtilKt.getClassId(this.nameResolver, fqNameIndex), e);
        }
    }

    @NotNull
    public final ConeKotlinType type(@NotNull ProtoBuf.Type proto, @NotNull ConeAttributes attributes) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            ConeLookupTagBasedType lowerBound = this.simpleType(proto, attributes);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.typeTable);
            Intrinsics.checkNotNull(type2);
            ConeLookupTagBasedType upperBound = this.simpleType(type2, attributes);
            ConeLookupTagBasedType coneLookupTagBasedType = lowerBound;
            Intrinsics.checkNotNull(coneLookupTagBasedType);
            ConeKotlinType coneKotlinType = coneLookupTagBasedType;
            ConeLookupTagBasedType coneLookupTagBasedType2 = upperBound;
            Intrinsics.checkNotNull(coneLookupTagBasedType2);
            return new ConeFlexibleType(coneKotlinType, coneLookupTagBasedType2);
        }
        ConeLookupTagBasedType coneLookupTagBasedType = this.simpleType(proto, attributes);
        return coneLookupTagBasedType != null ? (ConeKotlinType)coneLookupTagBasedType : (ConeKotlinType)new ConeClassErrorType(new ConeSimpleDiagnostic("?!id:0", DiagnosticKind.DeserializationError));
    }

    private final ConeTypeParameterLookupTag typeParameterSymbol(int typeParameterId) {
        Object object = this.typeParameterDescriptors.get(typeParameterId);
        if (object == null || (object = ((FirTypeParameterSymbol)object).toLookupTag()) == null) {
            FirTypeDeserializer firTypeDeserializer = this.parent;
            object = firTypeDeserializer != null ? firTypeDeserializer.typeParameterSymbol(typeParameterId) : null;
        }
        return object;
    }

    private final Variance convertVariance(ProtoBuf.TypeParameter.Variance $this$convertVariance) {
        Variance variance;
        switch (FirTypeDeserializer$WhenMappings.$EnumSwitchMapping$0[$this$convertVariance.ordinal()]) {
            case 1: {
                variance = Variance.IN_VARIANCE;
                break;
            }
            case 2: {
                variance = Variance.OUT_VARIANCE;
                break;
            }
            case 3: {
                variance = Variance.INVARIANT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return variance;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameterSymbol> typeParameters(@NotNull FirClassLikeSymbol<?> $this$typeParameters) {
        List list2;
        Object object;
        Intrinsics.checkNotNullParameter($this$typeParameters, "$this$typeParameters");
        Object e = $this$typeParameters.getFir();
        if (!(e instanceof FirTypeParameterRefsOwner)) {
            e = null;
        }
        if ((object = (FirTypeParameterRefsOwner)e) != null && (object = object.getTypeParameters()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirTypeParameterSymbol firTypeParameterSymbol = it.getSymbol();
                collection.add(firTypeParameterSymbol);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        List list3 = list2;
        boolean bl = false;
        List list4 = list3;
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        return list4;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConeLookupTagBasedType simpleType(@NotNull ProtoBuf.Type proto, @NotNull ConeAttributes attributes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        ConeClassifierLookupTag coneClassifierLookupTag = this.typeSymbol(proto);
        if (coneClassifierLookupTag == null) {
            return null;
        }
        ConeClassifierLookupTag constructor2 = coneClassifierLookupTag;
        if (constructor2 instanceof ConeTypeParameterLookupTag) {
            return new ConeTypeParameterTypeImpl((ConeTypeParameterLookupTag)constructor2, proto.getNullable(), null, 4, null);
        }
        if (!(constructor2 instanceof ConeClassLikeLookupTag)) {
            return null;
        }
        Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>> $fun$collectAllArguments$1 = new Function1<ProtoBuf.Type, List<? extends ProtoBuf.Type.Argument>>(this){
            final /* synthetic */ FirTypeDeserializer this$0;

            @NotNull
            public final List<ProtoBuf.Type.Argument> invoke(@NotNull ProtoBuf.Type $this$collectAllArguments) {
                Intrinsics.checkNotNullParameter($this$collectAllArguments, "$this$collectAllArguments");
                List<ProtoBuf.Type.Argument> list2 = $this$collectAllArguments.getArgumentList();
                Intrinsics.checkNotNullExpressionValue(list2, "argumentList");
                Collection collection = list2;
                ProtoBuf.Type type2 = ProtoTypeTableUtilKt.outerType($this$collectAllArguments, this.this$0.getTypeTable());
                List<ProtoBuf.Type.Argument> list3 = type2 != null ? this.invoke(type2) : null;
                boolean bl = false;
                List<ProtoBuf.Type.Argument> list4 = list3;
                if (list4 == null) {
                    list4 = CollectionsKt.emptyList();
                }
                return CollectionsKt.plus(collection, (Iterable)list4);
            }
            {
                this.this$0 = firTypeDeserializer;
                super(1);
            }
        };
        Iterable iterable = $fun$collectAllArguments$1.invoke(proto);
        FirTypeDeserializer firTypeDeserializer = this;
        boolean $i$f$map = false;
        void var9_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            ProtoBuf.Type.Argument argument = (ProtoBuf.Type.Argument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConeTypeProjection coneTypeProjection = firTypeDeserializer.typeArgument((ProtoBuf.Type.Argument)p1);
            collection.add(coneTypeProjection);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeProjection[] coneTypeProjectionArray = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (coneTypeProjectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ConeTypeProjection[] arguments2 = coneTypeProjectionArray;
        Boolean bl = Flags.SUSPEND_TYPE.get(proto.getFlags());
        Intrinsics.checkNotNullExpressionValue(bl, "Flags.SUSPEND_TYPE.get(proto.flags)");
        ConeClassLikeType simpleType2 = bl != false ? this.createSuspendFunctionType((ConeClassLikeLookupTag)constructor2, arguments2, proto.getNullable(), attributes) : (ConeClassLikeType)new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)constructor2, arguments2, proto.getNullable(), attributes);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.abbreviatedType(proto, this.typeTable);
        if (type2 == null) {
            return simpleType2;
        }
        ProtoBuf.Type abbreviatedTypeProto = type2;
        return this.simpleType(abbreviatedTypeProto, attributes);
    }

    private final ConeClassLikeType createSuspendFunctionTypeForBasicCase(ConeClassLikeLookupTag functionTypeConstructor, ConeTypeProjection[] arguments2, boolean isNullable, ConeAttributes attributes) {
        createSuspendFunctionTypeForBasicCase.1 $fun$isContinuation$1 = createSuspendFunctionTypeForBasicCase.1.INSTANCE;
        ConeTypeProjection returnType2 = ArraysKt.lastOrNull(arguments2);
        ConeTypeProjection coneTypeProjection = ArraysKt.getOrNull(arguments2, ArraysKt.getLastIndex(arguments2) - 1);
        if (!(coneTypeProjection instanceof ConeClassLikeType)) {
            coneTypeProjection = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneTypeProjection;
        if (coneClassLikeType == null) {
            return null;
        }
        ConeClassLikeType continuationType = coneClassLikeType;
        if (!$fun$isContinuation$1.invoke(continuationType)) {
            return new ConeClassLikeTypeImpl(functionTypeConstructor, arguments2, isNullable, attributes);
        }
        ConeTypeProjection coneTypeProjection2 = ArraysKt.single(continuationType.getTypeArguments());
        if (coneTypeProjection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection");
        }
        ConeKotlinTypeProjection suspendReturnType = (ConeKotlinTypeProjection)coneTypeProjection2;
        List<ConeTypeProjection> valueParameters2 = ArraysKt.dropLast(arguments2, 2);
        FunctionClassKind kind = FunctionClassKind.SuspendFunction;
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)valueParameters2, suspendReturnType);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeProjection[] coneTypeProjectionArray = thisCollection$iv.toArray(new ConeTypeProjection[0]);
        if (coneTypeProjectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(new ClassId(kind.getPackageFqName(), kind.numberedClassName(valueParameters2.size()))), coneTypeProjectionArray, isNullable, attributes);
    }

    private final ConeClassLikeType createSuspendFunctionType(ConeClassLikeLookupTag functionTypeConstructor, ConeTypeProjection[] arguments2, boolean isNullable, ConeAttributes attributes) {
        ConeClassLikeType result2;
        ConeClassLikeType coneClassLikeType;
        ConeClassLikeType coneClassLikeType2;
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(functionTypeConstructor, this.session);
        Intrinsics.checkNotNull(firClassLikeSymbol);
        FirBasedSymbol $this$firUnsafe$iv = firClassLikeSymbol;
        boolean $i$f$firUnsafe = false;
        Object fir$iv = $this$firUnsafe$iv.getFir();
        boolean bl = fir$iv instanceof FirTypeParameterRefsOwner;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirTypeParameterRefsOwner.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType$default((FirElement)fir$iv, null, 1, null);
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        switch (((FirTypeParameterRefsOwner)((FirElement)fir$iv)).getTypeParameters().size() - arguments2.length) {
            case 0: {
                coneClassLikeType2 = this.createSuspendFunctionTypeForBasicCase(functionTypeConstructor, arguments2, isNullable, attributes);
                break;
            }
            case 1: {
                ConeClassLikeTypeImpl coneClassLikeTypeImpl;
                int arity = arguments2.length - 1;
                if (arity >= 0) {
                    FunctionClassKind kind = FunctionClassKind.SuspendFunction;
                    coneClassLikeTypeImpl = new ConeClassLikeTypeImpl(new ConeClassLikeLookupTagImpl(new ClassId(kind.getPackageFqName(), kind.numberedClassName(arity))), arguments2, isNullable, attributes);
                } else {
                    coneClassLikeTypeImpl = null;
                }
                coneClassLikeType2 = coneClassLikeTypeImpl;
                break;
            }
            default: {
                coneClassLikeType2 = null;
            }
        }
        if ((coneClassLikeType = (result2 = coneClassLikeType2)) == null) {
            coneClassLikeType = new ConeClassErrorType(new ConeSimpleDiagnostic("Bad suspend function in metadata with constructor: " + functionTypeConstructor, DiagnosticKind.DeserializationError));
        }
        return coneClassLikeType;
    }

    private final ConeClassifierLookupTag typeSymbol(ProtoBuf.Type proto) {
        ConeClassifierLookupTag coneClassifierLookupTag;
        if (proto.hasClassName()) {
            coneClassifierLookupTag = this.computeClassifier(proto.getClassName());
        } else if (proto.hasTypeAliasName()) {
            coneClassifierLookupTag = this.computeClassifier(proto.getTypeAliasName());
        } else if (proto.hasTypeParameter()) {
            coneClassifierLookupTag = this.typeParameterSymbol(proto.getTypeParameter());
        } else if (proto.hasTypeParameterName()) {
            String name = this.nameResolver.getString(proto.getTypeParameterName());
            FirTypeParameterSymbol firTypeParameterSymbol = this.typeParameterNames.get(name);
            coneClassifierLookupTag = firTypeParameterSymbol != null ? firTypeParameterSymbol.toLookupTag() : null;
        } else {
            coneClassifierLookupTag = null;
        }
        return coneClassifierLookupTag;
    }

    private final ConeTypeProjection typeArgument(ProtoBuf.Type.Argument typeArgumentProto) {
        if (typeArgumentProto.getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            return ConeStarProjection.INSTANCE;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkNotNullExpressionValue(projection, "typeArgumentProto.projection");
        Variance variance = ProtoEnumFlags.INSTANCE.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.typeTable);
        if (type2 == null) {
            return new ConeClassErrorType(new ConeSimpleDiagnostic("No type recorded", DiagnosticKind.DeserializationError));
        }
        ProtoBuf.Type type3 = type2;
        ConeKotlinType coneType = this.type(type3, ConeAttributes.Companion.getEmpty());
        return ConeTypeUtilsKt.toTypeProjection(coneType, variance);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    @Nullable
    public final FirTypeDeserializer getParent() {
        return this.parent;
    }

    /*
     * WARNING - void declaration
     */
    public FirTypeDeserializer(@NotNull FirSession session2, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @Nullable FirTypeDeserializer parent2) {
        Map map2;
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(nameResolver2, "nameResolver");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        Intrinsics.checkNotNullParameter(typeParameterProtos, "typeParameterProtos");
        this.session = session2;
        this.nameResolver = nameResolver2;
        this.typeTable = typeTable;
        this.parent = parent2;
        Collection collection = typeParameterProtos;
        boolean bl = false;
        if (!collection.isEmpty()) {
            map2 = new LinkedHashMap();
        } else {
            boolean bl2 = false;
            map2 = MapsKt.emptyMap();
        }
        this.typeParameterDescriptors = map2;
        collection = typeParameterProtos;
        bl = false;
        if (!collection.isEmpty()) {
            boolean bl3;
            Object object;
            boolean bl4 = false;
            this.typeParameterNames = new LinkedHashMap();
            Map<Integer, FirTypeParameterSymbol> map3 = this.typeParameterDescriptors;
            if (map3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.LinkedHashMap<kotlin.Int, org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol>");
            }
            LinkedHashMap result2 = (LinkedHashMap)map3;
            boolean bl5 = false;
            List builders = new ArrayList();
            for (ProtoBuf.TypeParameter proto : typeParameterProtos) {
                if (!proto.hasId()) continue;
                Name name = NameResolverUtilKt.getName(this.nameResolver, proto.getName());
                object = new FirTypeParameterSymbol();
                boolean bl6 = false;
                bl3 = false;
                Object it22 = object;
                boolean bl7 = false;
                String string2 = name.asString();
                Intrinsics.checkNotNullExpressionValue(string2, "name.asString()");
                this.typeParameterNames.put(string2, (FirTypeParameterSymbol)it22);
                Object symbol2 = object;
                object = builders;
                FirTypeParameterBuilder firTypeParameterBuilder = new FirTypeParameterBuilder();
                bl3 = false;
                boolean it22 = false;
                FirTypeParameterBuilder $this$apply = firTypeParameterBuilder;
                boolean bl8 = false;
                $this$apply.setSession(this.session);
                $this$apply.setOrigin(FirDeclarationOrigin.Library.INSTANCE);
                $this$apply.setName(name);
                $this$apply.setSymbol((FirTypeParameterSymbol)symbol2);
                ProtoBuf.TypeParameter.Variance variance = proto.getVariance();
                Intrinsics.checkNotNullExpressionValue(variance, "proto.variance");
                $this$apply.setVariance(this.convertVariance(variance));
                $this$apply.setReified(proto.getReified());
                bl3 = false;
                object.add(firTypeParameterBuilder);
                ((Map)result2).put(proto.getId(), symbol2);
            }
            boolean proto = false;
            for (ProtoBuf.TypeParameter proto2 : (Iterable)typeParameterProtos) {
                void $this$mapTo$iv;
                void index2;
                FirTypeParameterBuilder builder = (FirTypeParameterBuilder)builders.get((int)index2);
                object = builder;
                boolean bl9 = false;
                bl3 = false;
                Object $this$apply = object;
                boolean bl10 = false;
                List<ProtoBuf.Type> list2 = proto2.getUpperBoundList();
                Intrinsics.checkNotNullExpressionValue(list2, "proto.upperBoundList");
                Iterable bl8 = list2;
                Collection destination$iv = ((FirTypeParameterBuilder)$this$apply).getBounds();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    ProtoBuf.Type type2 = (ProtoBuf.Type)item$iv;
                    Collection collection2 = destination$iv;
                    boolean bl11 = false;
                    boolean $i$f$buildResolvedTypeRef = false;
                    boolean bl12 = false;
                    FirResolvedTypeRefBuilder firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
                    boolean bl13 = false;
                    boolean bl14 = false;
                    FirResolvedTypeRefBuilder $this$buildResolvedTypeRef = firResolvedTypeRefBuilder;
                    boolean bl15 = false;
                    void v5 = it;
                    Intrinsics.checkNotNullExpressionValue(v5, "it");
                    $this$buildResolvedTypeRef.setType(this.type((ProtoBuf.Type)v5, ConeAttributes.Companion.getEmpty()));
                    FirResolvedTypeRef firResolvedTypeRef = firResolvedTypeRefBuilder.build();
                    collection2.add(firResolvedTypeRef);
                }
                FirDeclarationUtilKt.addDefaultBoundIfNecessary$default((FirTypeParameterBuilder)$this$apply, false, 1, null);
                ((FirTypeParameterBuilder)object).build();
                ++index2;
            }
        } else {
            this.typeParameterNames = MapsKt.emptyMap();
        }
    }
}

