/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XmlExtensionAdapter
extends ExtensionComponentAdapter {
    @Nullable
    private Element myExtensionElement;
    private volatile Object extensionInstance;
    private boolean initializing;

    XmlExtensionAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable Element extensionElement) {
        if (implementationClassName == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(0);
        }
        if (pluginDescriptor == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(1);
        }
        if (order == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(2);
        }
        super(implementationClassName, pluginDescriptor, orderId, order);
        this.myExtensionElement = extensionElement;
    }

    @Override
    synchronized boolean isInstanceCreated() {
        return this.extensionInstance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public <T> T createInstance(@NotNull ComponentManager componentManager) {
        Object instance;
        if (componentManager == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(3);
        }
        if ((instance = this.extensionInstance) != null) {
            Object object = instance;
            if (object == null) {
                XmlExtensionAdapter.$$$reportNull$$$0(4);
            }
            return (T)object;
        }
        XmlExtensionAdapter xmlExtensionAdapter = this;
        synchronized (xmlExtensionAdapter) {
            instance = this.extensionInstance;
            if (instance != null) {
                Object object = instance;
                // MONITOREXIT @DISABLED, blocks:[3, 10] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                if (object == null) {
                    XmlExtensionAdapter.$$$reportNull$$$0(5);
                }
                return (T)object;
            }
            if (this.initializing) {
                componentManager.logError(new IllegalStateException("Cyclic extension initialization: " + this.toString()), this.getPluginDescriptor().getPluginId());
            }
            try {
                this.initializing = true;
                instance = super.createInstance(componentManager);
                Element element = this.myExtensionElement;
                if (element != null) {
                    XmlSerializer.deserializeInto(instance, element);
                    this.myExtensionElement = null;
                }
                this.extensionInstance = instance;
            }
            finally {
                this.initializing = false;
            }
        }
        Object object = instance;
        if (object == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(6);
        }
        return (T)object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/XmlExtensionAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/XmlExtensionAdapter";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class SimpleConstructorInjectionAdapter
    extends XmlExtensionAdapter {
        SimpleConstructorInjectionAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable Element extensionElement) {
            if (implementationClassName == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(1);
            }
            if (order == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(2);
            }
            super(implementationClassName, pluginDescriptor, orderId, order, extensionElement);
        }

        @Override
        @NotNull
        protected <T> T instantiateClass(@NotNull Class<T> aClass2, @NotNull ComponentManager componentManager) {
            if (aClass2 == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(3);
            }
            if (componentManager == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(4);
            }
            if (componentManager.getPicoContainer().getParent() == null) {
                T t;
                try {
                    t = super.instantiateClass(aClass2, componentManager);
                }
                catch (ExtensionNotApplicableException | ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof NoSuchMethodException) && !(cause instanceof IllegalArgumentException)) {
                        throw e;
                    }
                    String message2 = "Cannot create extension without pico container (class=" + aClass2.getName() + "), please remove extra constructor parameters";
                    PluginDescriptor pluginDescriptor = this.getPluginDescriptor();
                    if (pluginDescriptor.isBundled() && !SimpleConstructorInjectionAdapter.isKnownBadPlugin(pluginDescriptor)) {
                        ExtensionPointImpl.LOG.error(message2, e);
                    }
                    ExtensionPointImpl.LOG.warn(message2, e);
                }
                if (t == null) {
                    SimpleConstructorInjectionAdapter.$$$reportNull$$$0(5);
                }
                return t;
            }
            T t = componentManager.instantiateClassWithConstructorInjection(aClass2, aClass2, this.getPluginDescriptor().getPluginId());
            if (t == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(6);
            }
            return t;
        }

        private static boolean isKnownBadPlugin(@NotNull PluginDescriptor pluginDescriptor) {
            String id;
            if (pluginDescriptor == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(7);
            }
            return (id = pluginDescriptor.getPluginId().getIdString()).equals("org.jetbrains.kotlin") || id.equals("Lombook Plugin");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implementationClassName";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "order";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentManager";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/extensions/impl/XmlExtensionAdapter$SimpleConstructorInjectionAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/extensions/impl/XmlExtensionAdapter$SimpleConstructorInjectionAdapter";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instantiateClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "instantiateClass";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isKnownBadPlugin";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

