/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.FirSourceChildrenKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/ArrayEqualityCanBeReplacedWithEquals;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class ArrayEqualityCanBeReplacedWithEquals
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final ArrayEqualityCanBeReplacedWithEquals INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirStatement expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block8: {
            void $this$report$iv;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (!(expression2 instanceof FirEqualityOperatorCall)) {
                return;
            }
            if (((FirEqualityOperatorCall)expression2).getOperation() != FirOperation.EQ && ((FirEqualityOperatorCall)expression2).getOperation() != FirOperation.NOT_EQ) {
                return;
            }
            FirCall $this$arguments$iv = (FirCall)expression2;
            boolean $i$f$getArguments = false;
            FirExpression firExpression2 = CollectionsKt.getOrNull($this$arguments$iv.getArgumentList().getArguments(), 0);
            if (firExpression2 == null) {
                return;
            }
            FirExpression left = firExpression2;
            FirCall $this$arguments$iv2 = (FirCall)expression2;
            boolean $i$f$getArguments2 = false;
            FirExpression firExpression3 = CollectionsKt.getOrNull($this$arguments$iv2.getArgumentList().getArguments(), 1);
            if (firExpression3 == null) {
                return;
            }
            FirExpression right = firExpression3;
            FirTypeRef $this$coneType$iv = left.getTypeRef();
            boolean $i$f$getConeType = false;
            FirTypeRef $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            boolean $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            if (Intrinsics.areEqual(ConeTypeUtilsKt.getClassId(coneKotlinType), StandardClassIds.INSTANCE.getArray()) ^ true) {
                return;
            }
            $this$coneType$iv = right.getTypeRef();
            $i$f$getConeType = false;
            $this$coneTypeUnsafe$iv$iv = $this$coneType$iv;
            $i$f$coneTypeUnsafe = false;
            ConeKotlinType coneKotlinType2 = ((FirResolvedTypeRef)$this$coneTypeUnsafe$iv$iv).getType();
            if (coneKotlinType2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
            }
            if (Intrinsics.areEqual(ConeTypeUtilsKt.getClassId(coneKotlinType2), StandardClassIds.INSTANCE.getArray()) ^ true) {
                return;
            }
            FirSourceElement firSourceElement = expression2.getSource();
            FirSourceElement source = firSourceElement != null ? FirSourceChildrenKt.getChild$default(firSourceElement, SetsKt.setOf(KtTokens.EQEQ, KtTokens.EXCLEQ), 0, 0, 6, null) : null;
            DiagnosticReporter $i$f$getConeType2 = reporter;
            FirDiagnosticFactory0<FirSourceElement, PsiElement> factory$iv = FirErrors.INSTANCE.getARRAY_EQUALITY_OPERATOR_CAN_BE_REPLACED_WITH_EQUALS();
            boolean $i$f$report = false;
            FirSourceElement firSourceElement2 = source;
            if (firSourceElement2 == null) break block8;
            FirSourceElement firSourceElement3 = firSourceElement2;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it$iv = firSourceElement3;
            boolean bl3 = false;
            $this$report$iv.report((FirDiagnostic)factory$iv.on(it$iv));
        }
    }

    private ArrayEqualityCanBeReplacedWithEquals() {
    }

    static {
        ArrayEqualityCanBeReplacedWithEquals arrayEqualityCanBeReplacedWithEquals;
        INSTANCE = arrayEqualityCanBeReplacedWithEquals = new ArrayEqualityCanBeReplacedWithEquals();
    }
}

