/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.calls.KotlinCallResolver$WhenMappings;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolver;
import org.jetbrains.kotlin.resolve.calls.components.KotlinCallCompleter;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.NewOverloadingConflictResolver;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.model.CallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.CandidateChosenUsingOverloadResolutionByLambdaAnnotation;
import org.jetbrains.kotlin.resolve.calls.model.GivenCandidate;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKind;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKt;
import org.jetbrains.kotlin.resolve.calls.model.KotlinResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleCandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactoryProviderForInvoke;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.InvokeProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.KnownResultProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.TowerResolver;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.DetailedReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002JD\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170!0 J>\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00162\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/KotlinCallResolver;", "", "towerResolver", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver;", "kotlinCallCompleter", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinCallCompleter;", "overloadingConflictResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/NewOverloadingConflictResolver;", "callableReferenceResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver;Lorg/jetbrains/kotlin/resolve/calls/components/KotlinCallCompleter;Lorg/jetbrains/kotlin/resolve/calls/components/NewOverloadingConflictResolver;Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceResolver;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;)V", "choseMostSpecific", "Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;", "candidateFactory", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleCandidateFactory;", "resolutionCallbacks", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "expectedType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "candidates", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinResolutionCandidate;", "resolveCall", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "kotlinCall", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "collectAllCandidates", "", "createFactoryProviderForInvoke", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactoryProviderForInvoke;", "resolveGivenCandidates", "givenCandidates", "Lorg/jetbrains/kotlin/resolve/calls/model/GivenCandidate;", "Companion", "resolution"})
public final class KotlinCallResolver {
    private final TowerResolver towerResolver;
    private final KotlinCallCompleter kotlinCallCompleter;
    private final NewOverloadingConflictResolver overloadingConflictResolver;
    private final CallableReferenceResolver callableReferenceResolver;
    private final KotlinCallComponents callComponents;
    private static final FqName OVERLOAD_RESOLUTION_BY_LAMBDA_ANNOTATION;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final CallResolutionResult resolveCall(@NotNull ImplicitScopeTower scopeTower, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull KotlinCall kotlinCall, @Nullable UnwrappedType expectedType2, boolean collectAllCandidates, @NotNull Function0<? extends CandidateFactoryProviderForInvoke<KotlinResolutionCandidate>> createFactoryProviderForInvoke) {
        ScopeTowerProcessor scopeTowerProcessor;
        Intrinsics.checkNotNullParameter(scopeTower, "scopeTower");
        Intrinsics.checkNotNullParameter(resolutionCallbacks, "resolutionCallbacks");
        Intrinsics.checkNotNullParameter(kotlinCall, "kotlinCall");
        Intrinsics.checkNotNullParameter(createFactoryProviderForInvoke, "createFactoryProviderForInvoke");
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        KotlinCallKt.checkCallInvariants(kotlinCall);
        SimpleCandidateFactory candidateFactory = new SimpleCandidateFactory(this.callComponents, scopeTower, kotlinCall, resolutionCallbacks, this.callableReferenceResolver);
        switch (KotlinCallResolver$WhenMappings.$EnumSwitchMapping$0[kotlinCall.getCallKind().ordinal()]) {
            case 1: {
                ReceiverKotlinCallArgument receiverKotlinCallArgument = kotlinCall.getExplicitReceiver();
                scopeTowerProcessor = ScopeTowerProcessorsKt.createVariableAndObjectProcessor$default(scopeTower, kotlinCall.getName(), candidateFactory, receiverKotlinCallArgument != null ? receiverKotlinCallArgument.getReceiver() : null, false, 16, null);
                break;
            }
            case 2: {
                ReceiverKotlinCallArgument receiverKotlinCallArgument = kotlinCall.getExplicitReceiver();
                scopeTowerProcessor = ScopeTowerProcessorsKt.createFunctionProcessor(scopeTower, kotlinCall.getName(), candidateFactory, createFactoryProviderForInvoke.invoke(), receiverKotlinCallArgument != null ? receiverKotlinCallArgument.getReceiver() : null);
                break;
            }
            case 3: {
                ReceiverKotlinCallArgument receiverKotlinCallArgument = kotlinCall.getExplicitReceiver();
                scopeTowerProcessor = ScopeTowerProcessorsKt.createProcessorWithReceiverValueOrEmpty(receiverKotlinCallArgument != null ? receiverKotlinCallArgument.getReceiver() : null, (Function1)new Function1<ReceiverValueWithSmartCastInfo, ScopeTowerProcessor<? extends KotlinResolutionCandidate>>(scopeTower, candidateFactory, kotlinCall){
                    final /* synthetic */ ImplicitScopeTower $scopeTower;
                    final /* synthetic */ SimpleCandidateFactory $candidateFactory;
                    final /* synthetic */ KotlinCall $kotlinCall;

                    @NotNull
                    public final ScopeTowerProcessor<KotlinResolutionCandidate> invoke(@Nullable ReceiverValueWithSmartCastInfo it) {
                        ReceiverKotlinCallArgument receiverKotlinCallArgument = this.$kotlinCall.getDispatchReceiverForInvokeExtension();
                        DetailedReceiver detailedReceiver = receiverKotlinCallArgument != null ? receiverKotlinCallArgument.getReceiver() : null;
                        if (detailedReceiver == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo");
                        }
                        return InvokeProcessorsKt.createCallTowerProcessorForExplicitInvoke(this.$scopeTower, this.$candidateFactory, (ReceiverValueWithSmartCastInfo)detailedReceiver, it);
                    }
                    {
                        this.$scopeTower = implicitScopeTower;
                        this.$candidateFactory = simpleCandidateFactory;
                        this.$kotlinCall = kotlinCall;
                        super(1);
                    }
                });
                break;
            }
            case 4: {
                throw (Throwable)new UnsupportedOperationException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ScopeTowerProcessor processor2 = scopeTowerProcessor;
        if (collectAllCandidates) {
            Collection<KotlinResolutionCandidate> allCandidates = this.towerResolver.collectAllCandidates(scopeTower, processor2, kotlinCall.getName());
            return this.kotlinCallCompleter.createAllCandidatesResult(allCandidates, expectedType2, resolutionCallbacks);
        }
        Collection<KotlinResolutionCandidate> candidates2 = this.towerResolver.runResolve(scopeTower, processor2, kotlinCall.getCallKind() != KotlinCallKind.UNSUPPORTED, kotlinCall.getName());
        return this.choseMostSpecific(candidateFactory, resolutionCallbacks, expectedType2, candidates2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CallResolutionResult resolveGivenCandidates(@NotNull ImplicitScopeTower scopeTower, @NotNull KotlinResolutionCallbacks resolutionCallbacks, @NotNull KotlinCall kotlinCall, @Nullable UnwrappedType expectedType2, @NotNull Collection<GivenCandidate> givenCandidates, boolean collectAllCandidates) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(scopeTower, "scopeTower");
        Intrinsics.checkNotNullParameter(resolutionCallbacks, "resolutionCallbacks");
        Intrinsics.checkNotNullParameter(kotlinCall, "kotlinCall");
        Intrinsics.checkNotNullParameter(givenCandidates, "givenCandidates");
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        KotlinCallKt.checkCallInvariants(kotlinCall);
        SimpleCandidateFactory candidateFactory = new SimpleCandidateFactory(this.callComponents, scopeTower, kotlinCall, resolutionCallbacks, this.callableReferenceResolver);
        Iterable $this$map$iv = givenCandidates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GivenCandidate givenCandidate = (GivenCandidate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KotlinResolutionCandidate kotlinResolutionCandidate = (KotlinResolutionCandidate)TowerUtilsKt.forceResolution((Candidate)candidateFactory.createCandidate((GivenCandidate)it));
            collection.add(kotlinResolutionCandidate);
        }
        List resolutionCandidates = (List)destination$iv$iv;
        if (collectAllCandidates) {
            Collection<KotlinResolutionCandidate> allCandidates = this.towerResolver.runWithEmptyTowerData(new KnownResultProcessor(resolutionCandidates), new TowerResolver.AllCandidatesCollector(), false);
            return this.kotlinCallCompleter.createAllCandidatesResult(allCandidates, expectedType2, resolutionCallbacks);
        }
        Collection<KotlinResolutionCandidate> candidates2 = this.towerResolver.runWithEmptyTowerData(new KnownResultProcessor(resolutionCandidates), new TowerResolver.SuccessfulResultCollector(), true);
        return this.choseMostSpecific(candidateFactory, resolutionCallbacks, expectedType2, candidates2);
    }

    /*
     * WARNING - void declaration
     */
    private final CallResolutionResult choseMostSpecific(SimpleCandidateFactory candidateFactory, KotlinResolutionCallbacks resolutionCallbacks, UnwrappedType expectedType2, Collection<KotlinResolutionCandidate> candidates2) {
        Set<KotlinResolutionCandidate> maximallySpecificCandidates;
        block16: {
            boolean bl;
            KotlinResolutionCandidate it;
            block14: {
                Collection refinedCandidates = candidates2;
                if (!this.callComponents.getLanguageVersionSettings().supportsFeature(LanguageFeature.RefinedSamAdaptersPriority)) {
                    Iterator $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = candidates2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    Iterator iterator2 = $this$filterTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv = iterator2.next();
                        it = (KotlinResolutionCandidate)element$iv$iv;
                        boolean bl2 = false;
                        if (!(!TowerUtilsKt.isSynthesized(it.getResolvedCall().getCandidateDescriptor()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List nonSynthesized = (List)destination$iv$iv;
                    if (!nonSynthesized.isEmpty()) {
                        refinedCandidates = nonSynthesized;
                    }
                }
                if ((maximallySpecificCandidates = this.overloadingConflictResolver.chooseMaximallySpecificCandidates(refinedCandidates, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, true)).size() <= 1 || !this.callComponents.getLanguageVersionSettings().supportsFeature(LanguageFeature.OverloadResolutionByLambdaReturnType)) break block16;
                Iterable $this$all$iv = candidates2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KotlinResolutionCandidate it2 = (KotlinResolutionCandidate)element$iv;
                        boolean bl3 = false;
                        if (resolutionCallbacks.getInferenceSession().shouldRunCompletion(it2)) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Set<KotlinResolutionCandidate> newCandidates;
                void $this$filterTo$iv$iv2;
                Object element$iv;
                Iterable $this$filter$iv = candidates2;
                boolean $i$f$filter22 = false;
                element$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    KotlinResolutionCandidate it3 = (KotlinResolutionCandidate)element$iv$iv;
                    boolean bl4 = false;
                    if (!it3.getResolvedCall().getCandidateDescriptor().getAnnotations().hasAnnotation(OVERLOAD_RESOLUTION_BY_LAMBDA_ANNOTATION)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List candidatesWithAnnotation = (List)destination$iv$iv;
                List candidatesWithoutAnnotation = CollectionsKt.minus((Iterable)candidates2, candidatesWithAnnotation);
                Collection $i$f$filter22 = candidatesWithAnnotation;
                boolean $this$filterTo$iv$iv2 = false;
                if (!$i$f$filter22.isEmpty() && (maximallySpecificCandidates = this.overloadingConflictResolver.chooseMaximallySpecificCandidates((Collection)(newCandidates = this.kotlinCallCompleter.chooseCandidateRegardingOverloadResolutionByLambdaReturnType(maximallySpecificCandidates, resolutionCallbacks)), CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, true)).size() > 1) {
                    boolean bl5;
                    block15: {
                        Iterable $this$any$iv = candidatesWithoutAnnotation;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it = (KotlinResolutionCandidate)element$iv2;
                                boolean bl6 = false;
                                if (!maximallySpecificCandidates.contains(it)) continue;
                                bl5 = true;
                                break block15;
                            }
                            bl5 = false;
                        }
                    }
                    if (bl5) {
                        Set set = CollectionsKt.toMutableSet((Iterable)maximallySpecificCandidates);
                        boolean bl7 = false;
                        boolean bl8 = false;
                        Set $this$apply = set;
                        boolean bl9 = false;
                        $this$apply.removeAll(candidatesWithAnnotation);
                        Unit unit = Unit.INSTANCE;
                        maximallySpecificCandidates = set;
                        KotlinResolutionCandidate kotlinResolutionCandidate = (KotlinResolutionCandidate)CollectionsKt.singleOrNull((Iterable)maximallySpecificCandidates);
                        if (kotlinResolutionCandidate != null) {
                            kotlinResolutionCandidate.addDiagnostic(new CandidateChosenUsingOverloadResolutionByLambdaAnnotation());
                        }
                    }
                }
            }
        }
        return this.kotlinCallCompleter.runCompletion(candidateFactory, (Collection<KotlinResolutionCandidate>)maximallySpecificCandidates, expectedType2, resolutionCallbacks);
    }

    public KotlinCallResolver(@NotNull TowerResolver towerResolver, @NotNull KotlinCallCompleter kotlinCallCompleter, @NotNull NewOverloadingConflictResolver overloadingConflictResolver, @NotNull CallableReferenceResolver callableReferenceResolver, @NotNull KotlinCallComponents callComponents) {
        Intrinsics.checkNotNullParameter(towerResolver, "towerResolver");
        Intrinsics.checkNotNullParameter(kotlinCallCompleter, "kotlinCallCompleter");
        Intrinsics.checkNotNullParameter(overloadingConflictResolver, "overloadingConflictResolver");
        Intrinsics.checkNotNullParameter(callableReferenceResolver, "callableReferenceResolver");
        Intrinsics.checkNotNullParameter(callComponents, "callComponents");
        this.towerResolver = towerResolver;
        this.kotlinCallCompleter = kotlinCallCompleter;
        this.overloadingConflictResolver = overloadingConflictResolver;
        this.callableReferenceResolver = callableReferenceResolver;
        this.callComponents = callComponents;
    }

    static {
        Companion = new Companion(null);
        FqName fqName2 = FqName.fromSegments(CollectionsKt.listOf("kotlin", "OverloadResolutionByLambdaReturnType"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "FqName.fromSegments(list\u2026tionByLambdaReturnType\"))");
        OVERLOAD_RESOLUTION_BY_LAMBDA_ANNOTATION = fqName2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/KotlinCallResolver$Companion;", "", "()V", "OVERLOAD_RESOLUTION_BY_LAMBDA_ANNOTATION", "Lorg/jetbrains/kotlin/name/FqName;", "getOVERLOAD_RESOLUTION_BY_LAMBDA_ANNOTATION", "()Lorg/jetbrains/kotlin/name/FqName;", "resolution"})
    public static final class Companion {
        @NotNull
        public final FqName getOVERLOAD_RESOLUTION_BY_LAMBDA_ANNOTATION() {
            return OVERLOAD_RESOLUTION_BY_LAMBDA_ANNOTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

