/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.reference.CallArgumentTranslatorKt;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VarargValueArgument;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 )2\u00020\u0001:\u0002()B%\b\u0002\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J \u0010\u001a\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002J6\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u001f2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010%\u001a\u00020\n*\u00020\u0013H\u0002J\u0014\u0010&\u001a\u00020\u0005*\u00020\u00052\u0006\u0010'\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "isNativeFunctionCall", "", "typeToUTypeArray", "", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "prepareConcatArguments", "", "arguments", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "list", "varargElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "removeLastUndefinedArguments", "", "result", "toArray", "elements", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "translateUnresolvedArguments", "", "translateVarargArgument", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "translatedArgs", "shouldWrapVarargInArray", "hasSpreadElementOrNamedArgument", "wrapInUArray", "elementType", "ArgumentsInfo", "Companion", "js.translator"})
public final class CallArgumentTranslator
extends AbstractTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResolvedCall<?> resolvedCall;
    @Nullable
    private final JsExpression receiver;
    @NotNull
    private final TranslationContext context;
    private final boolean isNativeFunctionCall;
    @NotNull
    private final Map<PrimitiveType, ClassDescriptor> typeToUTypeArray;

    private CallArgumentTranslator(ResolvedCall<?> resolvedCall2, JsExpression receiver, TranslationContext context2) {
        super(context2);
        this.resolvedCall = resolvedCall2;
        this.receiver = receiver;
        this.context = context2;
        this.isNativeFunctionCall = AnnotationsUtils.isNativeObject((DeclarationDescriptor)this.resolvedCall.getCandidateDescriptor());
        boolean bl = false;
        this.typeToUTypeArray = new LinkedHashMap();
    }

    private final void removeLastUndefinedArguments(List<JsExpression> result2) {
        int i = CollectionsKt.getLastIndex(result2);
        while (i >= 0 && JsAstUtils.isUndefinedExpression(result2.get(i))) {
            int n = i;
            i = n + -1;
        }
        result2.subList(i + 1, result2.size()).clear();
    }

    private final boolean hasSpreadElementOrNamedArgument(ValueArgument $this$hasSpreadElementOrNamedArgument) {
        return $this$hasSpreadElementOrNamedArgument.getSpreadElement() != null || this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions) && $this$hasSpreadElementOrNamedArgument.isNamed();
    }

    private final ArgumentsInfo translate() {
        Object callableDescriptor;
        List<ResolvedValueArgument> list2;
        List<ValueParameterDescriptor> list3 = this.resolvedCall.getResultingDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list3, "resolvedCall.resultingDescriptor.valueParameters");
        List<ValueParameterDescriptor> valueParameters2 = list3;
        boolean hasSpreadOperator = false;
        TemporaryConstVariable cachedReceiver = null;
        List<Object> result2 = null;
        result2 = new ArrayList(valueParameters2.size());
        List<ResolvedValueArgument> list4 = this.resolvedCall.getValueArgumentsByIndex();
        if (list4 == null) {
            throw new IllegalStateException(Intrinsics.stringPlus("Failed to arrange value arguments by index: ", this.resolvedCall.getResultingDescriptor()));
        }
        List<ResolvedValueArgument> valueArgumentsByIndex = list2 = list4;
        List argsBeforeVararg = null;
        List<JsExpression> concatArguments = null;
        TranslationContext translationContext = this.context();
        Intrinsics.checkNotNullExpressionValue(translationContext, "context()");
        Map<ValueArgument, JsExpression> argsToJsExpr = this.translateUnresolvedArguments(translationContext, this.resolvedCall);
        Object varargElementType = null;
        for (ValueParameterDescriptor parameterDescriptor : valueParameters2) {
            ResolvedValueArgument actualArgument = valueArgumentsByIndex.get(parameterDescriptor.getIndex());
            if (actualArgument instanceof VarargValueArgument) {
                Object it;
                Object object = actualArgument.getArguments();
                Intrinsics.checkNotNullExpressionValue(object, "actualArgument.getArguments()");
                List<ValueArgument> arguments2 = object;
                if (!hasSpreadOperator) {
                    boolean bl;
                    block20: {
                        Iterable $this$any$iv = arguments2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (ValueArgument)element$iv;
                                boolean bl2 = false;
                                Intrinsics.checkNotNullExpressionValue(it, "it");
                                if (!this.hasSpreadElementOrNamedArgument((ValueArgument)it)) continue;
                                bl = true;
                                break block20;
                            }
                            bl = false;
                        }
                    }
                    hasSpreadOperator = bl;
                }
                object = parameterDescriptor.getOriginal().getVarargElementType();
                Intrinsics.checkNotNull(object);
                varargElementType = object;
                if (hasSpreadOperator) {
                    if (this.isNativeFunctionCall) {
                        argsBeforeVararg = result2;
                        boolean bl = false;
                        result2 = new ArrayList();
                        concatArguments = this.prepareConcatArguments(arguments2, CallArgumentTranslator.Companion.translateResolvedArgument(actualArgument, argsToJsExpr), null);
                        continue;
                    }
                    object = this.translateVarargArgument(actualArgument, argsToJsExpr, ((VarargValueArgument)actualArgument).getArguments().size() > 1, (KotlinType)varargElementType);
                    if (object == null) continue;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl3 = false;
                    it = object2;
                    boolean bl4 = false;
                    result2.add(it);
                    continue;
                }
                if (this.isNativeFunctionCall) {
                    ((List)result2).addAll(CallArgumentTranslator.Companion.translateResolvedArgument(actualArgument, argsToJsExpr));
                    continue;
                }
                object = this.translateVarargArgument(actualArgument, argsToJsExpr, true, (KotlinType)varargElementType);
                if (object == null) continue;
                Object object3 = object;
                boolean bl = false;
                boolean bl5 = false;
                it = object3;
                boolean bl6 = false;
                ((List)result2).add(it);
                continue;
            }
            List list5 = result2;
            Intrinsics.checkNotNullExpressionValue(actualArgument, "actualArgument");
            list5.addAll(CallArgumentTranslator.Companion.translateResolvedArgument(actualArgument, argsToJsExpr));
        }
        if (this.isNativeFunctionCall && hasSpreadOperator) {
            boolean bl = argsBeforeVararg != null;
            boolean bl7 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-CallArgumentTranslator$translate$62 = false;
                String $i$a$-assert-CallArgumentTranslator$translate$62 = "argsBeforeVararg should not be null";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$translate$62));
            }
            bl = concatArguments != null;
            bl7 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl8 = false;
                String string2 = "concatArguments should not be null";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            if (!((List)result2).isEmpty()) {
                Intrinsics.checkNotNull(concatArguments);
                concatArguments.add(this.toArray(null, (List<? extends JsExpression>)result2));
            }
            Intrinsics.checkNotNull(argsBeforeVararg);
            if (!argsBeforeVararg.isEmpty()) {
                Intrinsics.checkNotNull(concatArguments);
                concatArguments.add(0, this.toArray(null, argsBeforeVararg));
            }
            Object object = new JsExpression[1];
            Intrinsics.checkNotNull(concatArguments);
            object[0] = CallArgumentTranslator.Companion.concatArgumentsIfNeeded(concatArguments, (KotlinType)varargElementType, true);
            result2 = CollectionsKt.mutableListOf(object);
            if (this.receiver != null) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(this.receiver);
                object = cachedReceiver.reference();
                Intrinsics.checkNotNullExpressionValue(object, "cachedReceiver.reference()");
                result2.add(0, object);
            } else if (DescriptorUtils.isObject(this.resolvedCall.getResultingDescriptor().getContainingDeclaration())) {
                cachedReceiver = this.context().getOrDeclareTemporaryConstVariable(ReferenceTranslator.translateAsValueReference(this.resolvedCall.getResultingDescriptor().getContainingDeclaration(), this.context()));
                object = cachedReceiver.reference();
                Intrinsics.checkNotNullExpressionValue(object, "cachedReceiver.reference()");
                result2.add(0, object);
            } else {
                result2.add(0, new JsNullLiteral());
            }
        }
        if ((callableDescriptor = this.resolvedCall.getResultingDescriptor()) instanceof FunctionDescriptor && ((FunctionDescriptor)callableDescriptor).isSuspend()) {
            List list6 = result2;
            JsExpression jsExpression = TranslationUtils.translateContinuationArgument(this.context());
            Intrinsics.checkNotNullExpressionValue(jsExpression, "translateContinuationArgument(context())");
            list6.add(jsExpression);
        }
        this.removeLastUndefinedArguments((List<JsExpression>)result2);
        return new ArgumentsInfo(result2, hasSpreadOperator, cachedReceiver, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<ValueArgument, JsExpression> translateUnresolvedArguments(TranslationContext context2, ResolvedCall<?> resolvedCall2) {
        boolean bl;
        boolean argumentsAreOrdered;
        ValueArgument arg;
        Object $this$associateTo$iv$iv;
        Object destination$iv$iv;
        Map<ValueArgument, JsExpression> result2;
        Object object;
        Map argumentContexts;
        Object object2;
        block23: {
            boolean bl2;
            block22: {
                void $this$associate$iv;
                Object element$iv$iv2;
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                void $this$associateTo$iv$iv2;
                void $this$associateTo$iv$iv3;
                Object $dstr$param$arg;
                void $this$associateTo$iv$iv4;
                void $this$associate$iv2;
                Object it;
                Object param;
                void $this$flatMapTo$iv$iv2;
                Iterable $this$flatMap$iv2;
                Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(map, "resolvedCall.valueArguments");
                boolean $i$f$flatMap = false;
                void var6_6 = $this$flatMap$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                void var9_17 = $this$flatMapTo$iv$iv2;
                boolean bl3 = false;
                Iterator iterator2 = var9_17.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void $this$mapTo$iv$iv;
                    Map.Entry entry;
                    Map.Entry $dstr$param$args = entry = iterator2.next();
                    boolean bl4 = false;
                    Map.Entry entry2 = $dstr$param$args;
                    boolean bl5 = false;
                    param = (ValueParameterDescriptor)entry2.getKey();
                    Object object3 = $dstr$param$args;
                    boolean bl6 = false;
                    ResolvedValueArgument args = (ResolvedValueArgument)object3.getValue();
                    object3 = args.getArguments();
                    Intrinsics.checkNotNullExpressionValue(object3, "args.arguments");
                    Iterable $this$map$iv = (Iterable)object3;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    object2 = $this$mapTo$iv$iv.iterator();
                    while (object2.hasNext()) {
                        Object item$iv$iv = object2.next();
                        ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                        Collection collection = destination$iv$iv3;
                        boolean bl7 = false;
                        Pair<ValueParameterDescriptor, void> pair = TuplesKt.to(param, it);
                        collection.add(pair);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv3;
                    CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
                }
                $this$flatMap$iv2 = (List)destination$iv$iv2;
                boolean $i$f$associate232 = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv2, 10)), 16);
                destination$iv$iv2 = $this$associate$iv2;
                Object destination$iv$iv4 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv3 : $this$associateTo$iv$iv4) {
                    Map map2 = destination$iv$iv4;
                    $dstr$param$arg = (Pair<ValueArgument, ValueParameterDescriptor>)element$iv$iv3;
                    boolean bl8 = false;
                    ValueParameterDescriptor param2 = (ValueParameterDescriptor)((Pair)$dstr$param$arg).component1();
                    ValueArgument arg2 = (ValueArgument)((Pair)$dstr$param$arg).component2();
                    $dstr$param$arg = TuplesKt.to(arg2, param2);
                    bl8 = false;
                    map2.put(((Pair)$dstr$param$arg).getFirst(), ((Pair)$dstr$param$arg).getSecond());
                }
                Map argsToParameters = destination$iv$iv4;
                List<? extends ValueArgument> $i$f$associate232 = resolvedCall2.getCall().getValueArguments();
                Intrinsics.checkNotNullExpressionValue($i$f$associate232, "resolvedCall.call.valueArguments");
                Iterable $this$associate$iv3 = $i$f$associate232;
                boolean $i$f$associate332 = false;
                int capacity$iv2 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv3, 10)), 16);
                destination$iv$iv4 = $this$associate$iv3;
                Object destination$iv$iv5 = new LinkedHashMap(capacity$iv2);
                boolean $i$f$associateTo2 = false;
                for (Object e : $this$associateTo$iv$iv3) {
                    $dstr$param$arg = destination$iv$iv5;
                    Object it2 = (ValueArgument)e;
                    boolean bl9 = false;
                    it2 = TuplesKt.to(it2, context2.innerBlock());
                    bl9 = false;
                    $dstr$param$arg.put(((Pair)it2).getFirst(), ((Pair)it2).getSecond());
                }
                argumentContexts = destination$iv$iv5;
                List<? extends ValueArgument> $i$f$associate332 = resolvedCall2.getCall().getValueArguments();
                Intrinsics.checkNotNullExpressionValue($i$f$associate332, "resolvedCall.call.valueArguments");
                Iterable $this$associate$iv4 = $i$f$associate332;
                boolean $i$f$associate432 = false;
                int capacity$iv3 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv4, 10)), 16);
                destination$iv$iv5 = $this$associate$iv4;
                Map<ValueArgument, JsExpression> destination$iv$iv6 = new LinkedHashMap(capacity$iv3);
                boolean $i$f$associateTo3 = false;
                for (Object element$iv$iv4 : $this$associateTo$iv$iv2) {
                    Object object4;
                    Object $i$f$map;
                    Map<ValueArgument, JsExpression> it2 = destination$iv$iv6;
                    ValueArgument arg232 = (ValueArgument)element$iv$iv4;
                    boolean bl10 = false;
                    param = (TranslationContext)argumentContexts.get(arg232);
                    Intrinsics.checkNotNull(param);
                    Object argumentContext = $i$f$map = param;
                    KtExpression parenthisedArgumentExpression = arg232.getArgumentExpression();
                    ValueParameterDescriptor destination$iv$iv3 = (ValueParameterDescriptor)argsToParameters.get(arg232);
                    Intrinsics.checkNotNull(destination$iv$iv3);
                    param = destination$iv$iv3.getOriginal();
                    Object $i$f$mapTo = resolvedCall2.getResultingDescriptor();
                    boolean bl7 = false;
                    boolean bl8 = false;
                    it = $i$f$mapTo;
                    boolean bl13 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    boolean isLambda232 = FunctionTypesKt.getFunctionalClassKind((DeclarationDescriptor)it) != null || it instanceof FunctionInvokeDescriptor;
                    if (!isLambda232) {
                        object2 = param.getVarargElementType();
                        if (object2 == null) {
                            KotlinType kotlinType = param.getType();
                            Intrinsics.checkNotNullExpressionValue(kotlinType, "param.type");
                            object4 = kotlinType;
                        } else {
                            object4 = object2;
                        }
                    } else {
                        object2 = context2.getCurrentModule().getBuiltIns().getAnyType();
                        Intrinsics.checkNotNullExpressionValue(object2, "context.currentModule.builtIns.anyType");
                        object4 = (KotlinType)object2;
                    }
                    Object parameterType = object4;
                    Intrinsics.checkNotNull(parenthisedArgumentExpression);
                    object = Translation.translateAsExpression(parenthisedArgumentExpression, (TranslationContext)argumentContext);
                    Intrinsics.checkNotNullExpressionValue(object, "translateAsExpression(parenthisedArgumentExpression!!, argumentContext)");
                    JsExpression argJs = object;
                    if (!ArgumentsUtilsKt.isVararg((ValueParameterDescriptor)param) || arg232.getSpreadElement() == null) {
                        object = TranslationUtils.coerce(context2, argJs, (KotlinType)parameterType);
                        Intrinsics.checkNotNullExpressionValue(object, "coerce(context, argJs, parameterType)");
                        argJs = object;
                    }
                    Pair<ValueArgument, JsExpression> pair = TuplesKt.to(arg232, argJs);
                    boolean arg232 = false;
                    it2.put(pair.getFirst(), pair.getSecond());
                }
                result2 = destination$iv$iv6;
                Iterable<ResolvedValueArgument> $i$f$associate432 = resolvedCall2.getValueArgumentsByIndex();
                capacity$iv3 = 0;
                List<ResolvedValueArgument> list2 = $i$f$associate432;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                $i$f$associate432 = list2;
                boolean $i$f$flatMap2 = false;
                $this$associateTo$iv$iv2 = $this$flatMap$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                    ResolvedValueArgument it3 = (ResolvedValueArgument)element$iv$iv2;
                    boolean bl14 = false;
                    List<ValueArgument> bl10 = it3.getArguments();
                    Intrinsics.checkNotNullExpressionValue(bl10, "it.arguments");
                    Iterable list$iv$iv = bl10;
                    CollectionsKt.addAll(destination$iv$iv3, list$iv$iv);
                }
                $this$flatMap$iv = CollectionsKt.withIndex((List)destination$iv$iv3);
                boolean $i$f$associate532 = false;
                int capacity$iv4 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                destination$iv$iv3 = $this$associate$iv;
                destination$iv$iv = new LinkedHashMap(capacity$iv4);
                boolean bl9 = false;
                element$iv$iv2 = $this$associateTo$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    Object element$iv$iv5 = element$iv$iv2.next();
                    Map bl14 = destination$iv$iv;
                    Object $dstr$index$arg2 = (IndexedValue)element$iv$iv5;
                    boolean bl15 = false;
                    int index2 = ((IndexedValue)$dstr$index$arg2).component1();
                    arg = (ValueArgument)((IndexedValue)$dstr$index$arg2).component2();
                    $dstr$index$arg2 = TuplesKt.to(arg, index2);
                    bl15 = false;
                    bl14.put(((Pair)$dstr$index$arg2).getFirst(), ((Pair)$dstr$index$arg2).getSecond());
                }
                Map resolvedOrder = destination$iv$iv;
                List<? extends ValueArgument> $i$f$associate532 = resolvedCall2.getCall().getValueArguments();
                Intrinsics.checkNotNullExpressionValue($i$f$associate532, "resolvedCall.call.valueArguments");
                Iterable $this$none$iv = CollectionsKt.withIndex((Iterable)$i$f$associate532);
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    $this$associateTo$iv$iv = $this$none$iv.iterator();
                    while ($this$associateTo$iv$iv.hasNext()) {
                        IndexedValue element$iv;
                        IndexedValue indexedValue = element$iv = $this$associateTo$iv$iv.next();
                        boolean bl16 = false;
                        int index3 = indexedValue.component1();
                        ValueArgument arg3 = (ValueArgument)indexedValue.component2();
                        Integer n = (Integer)resolvedOrder.get(arg3);
                        int $dstr$index$arg2 = index3;
                        if (!(n == null || n != $dstr$index$arg2)) continue;
                        bl2 = false;
                        break block22;
                    }
                    bl2 = true;
                }
            }
            argumentsAreOrdered = bl2;
            Iterable $this$any$iv = argumentContexts.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (IndexedValue element$iv : $this$any$iv) {
                    TranslationContext translationContext = (TranslationContext)((Object)element$iv);
                    boolean bl17 = false;
                    if (!(!translationContext.currentBlockIsEmpty())) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
        }
        if (bl || !argumentsAreOrdered) {
            void $this$mapTo$iv$iv;
            Map<ValueArgument, JsExpression> $this$map$iv = result2;
            boolean $i$f$map = false;
            $this$associateTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean bl10 = false;
            void bl17 = $this$mapTo$iv$iv;
            boolean bl11 = false;
            Iterator iterator3 = bl17.entrySet().iterator();
            while (iterator3.hasNext()) {
                void $dstr$arg$expr;
                Map.Entry item$iv$iv;
                Map.Entry bl15 = item$iv$iv = iterator3.next();
                Object object5 = destination$iv$iv;
                boolean bl19 = false;
                arg = $dstr$arg$expr;
                boolean isLambda232 = false;
                ValueArgument arg4 = (ValueArgument)arg.getKey();
                void isLambda232 = $dstr$arg$expr;
                boolean bl12 = false;
                JsExpression expr = (JsExpression)isLambda232.getValue();
                object = (TranslationContext)argumentContexts.get(arg4);
                Intrinsics.checkNotNull(object);
                Object argumentContext = object2 = object;
                Pair<ValueArgument, JsExpression> pair = TuplesKt.to(arg4, ((TranslationContext)argumentContext).cacheExpressionIfNeeded(expr));
                object5.add(pair);
            }
            result2 = MapsKt.toMap((List)destination$iv$iv);
        }
        Iterable $this$forEach$iv = argumentContexts.values();
        boolean $i$f$forEach = false;
        for (IndexedValue element$iv : $this$forEach$iv) {
            TranslationContext translationContext = (TranslationContext)((Object)element$iv);
            boolean bl21 = false;
            context2.moveVarsFrom(translationContext);
            context2.addStatementsToCurrentBlockFrom(translationContext);
        }
        return result2;
    }

    private final JsExpression wrapInUArray(JsExpression $this$wrapInUArray, KotlinType elementType) {
        JsExpression jsExpression;
        PrimitiveType primitiveType = ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(elementType);
        if (primitiveType == null) {
            jsExpression = $this$wrapInUArray;
        } else {
            PrimitiveType primitiveType2 = primitiveType;
            boolean bl = false;
            boolean bl2 = false;
            PrimitiveType primitiveType3 = primitiveType2;
            boolean bl3 = false;
            ModuleDescriptor moduleDescriptor = this.context.getCurrentModule();
            FqName fqName2 = new FqNameUnsafe("kotlin").toSafe();
            Intrinsics.checkNotNullExpressionValue(fqName2, "FqNameUnsafe(\"kotlin\").toSafe()");
            MemberScope kotlinMemberScope = moduleDescriptor.getPackage(fqName2).getMemberScope();
            ClassDescriptor classDescriptor2 = this.typeToUTypeArray.computeIfAbsent(primitiveType3, new Function<PrimitiveType, ClassDescriptor>(primitiveType3, kotlinMemberScope){
                final /* synthetic */ PrimitiveType $primitiveType;
                final /* synthetic */ MemberScope $kotlinMemberScope;
                {
                    this.$primitiveType = $primitiveType;
                    this.$kotlinMemberScope = $kotlinMemberScope;
                }

                @NotNull
                public final ClassDescriptor apply(@NotNull PrimitiveType it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), "it");
                    Object object = Name.identifier("" + 'U' + this.$primitiveType.getTypeName() + "Array");
                    Intrinsics.checkNotNullExpressionValue(object, "identifier(\"U${primitiveType.typeName}Array\")");
                    Name className2 = object;
                    object = this.$kotlinMemberScope.getContributedClassifier(className2, NoLookupLocation.FROM_BACKEND);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    }
                    return (ClassDescriptor)object;
                }
            });
            Intrinsics.checkNotNullExpressionValue(classDescriptor2, "primitiveType ->\n            val kotlinMemberScope = context.currentModule.getPackage(FqNameUnsafe(\"kotlin\").toSafe()).memberScope\n            val classDescriptor = typeToUTypeArray.computeIfAbsent(primitiveType) {\n                val className = Name.identifier(\"U${primitiveType.typeName}Array\")\n                kotlinMemberScope.getContributedClassifier(className, NoLookupLocation.FROM_BACKEND) as ClassDescriptor\n            }");
            ClassDescriptor classDescriptor3 = classDescriptor2;
            JsNew jsNew = new JsNew(ReferenceTranslator.translateAsTypeReference(classDescriptor3, this.context), CollectionsKt.listOf($this$wrapInUArray));
            jsExpression = jsNew;
        }
        return jsExpression;
    }

    private final JsExpression translateVarargArgument(ResolvedValueArgument resolvedArgument, Map<ValueArgument, ? extends JsExpression> translatedArgs, boolean shouldWrapVarargInArray, KotlinType varargElementType) {
        JsExpression jsExpression;
        List<ValueArgument> list2 = resolvedArgument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "resolvedArgument.arguments");
        List<ValueArgument> arguments2 = list2;
        if (arguments2.isEmpty()) {
            if (shouldWrapVarargInArray) {
                boolean bl = false;
                return this.wrapInUArray(this.toArray(varargElementType, new ArrayList()), varargElementType);
            }
            return null;
        }
        List list3 = CallArgumentTranslator.Companion.translateResolvedArgument(resolvedArgument, translatedArgs);
        CallArgumentTranslator callArgumentTranslator = this;
        if (shouldWrapVarargInArray) {
            JsExpression concatExpression;
            List<JsExpression> concatArguments = this.prepareConcatArguments(arguments2, list3, varargElementType);
            jsExpression = concatExpression = CallArgumentTranslator.Companion.concatArgumentsIfNeeded(concatArguments, varargElementType, false);
        } else {
            JsInvocation jsInvocation;
            PrimitiveType primitiveType = ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType);
            if (primitiveType == null) {
                jsInvocation = null;
            } else {
                PrimitiveType primitiveType2 = primitiveType;
                boolean bl = false;
                boolean bl2 = false;
                PrimitiveType primitiveType3 = primitiveType2;
                CallArgumentTranslator callArgumentTranslator2 = callArgumentTranslator;
                boolean bl3 = false;
                JsInvocation jsInvocation2 = new JsInvocation((JsExpression)new JsNameRef("unbox", (JsExpression)list3.get(0)), new JsExpression[0]);
                callArgumentTranslator = callArgumentTranslator2;
                jsInvocation = jsInvocation2;
            }
            JsInvocation jsInvocation3 = jsInvocation;
            JsExpression arg = jsInvocation3 == null ? (JsExpression)list3.get(0) : (JsExpression)jsInvocation3;
            JsInvocation jsInvocation4 = JsAstUtils.invokeMethod(arg, "slice", new JsExpression[0]);
            Intrinsics.checkNotNullExpressionValue(jsInvocation4, "{\n            val arg = ArrayFIF.unsignedPrimitiveToSigned(varargElementType)?.let { _ ->\n                JsInvocation(JsNameRef(\"unbox\", list[0]))\n            } ?: list[0]\n            JsAstUtils.invokeMethod(arg, \"slice\")\n        }");
            jsExpression = jsInvocation4;
        }
        return callArgumentTranslator.wrapInUArray(jsExpression, varargElementType);
    }

    private final JsExpression toArray(KotlinType varargElementType, List<? extends JsExpression> elements) {
        Object object = new JsArrayLiteral(elements);
        boolean bl = false;
        boolean bl2 = false;
        JsArrayLiteral $this$toArray_u24lambda_u2d19 = object;
        boolean bl3 = false;
        MetadataProperties.setSideEffects($this$toArray_u24lambda_u2d19, SideEffectKind.PURE);
        JsArrayLiteral argument = object;
        if (varargElementType == null) {
            return argument;
        }
        object = this.context();
        Intrinsics.checkNotNullExpressionValue(object, "context()");
        return ArrayFIF.INSTANCE.castOrCreatePrimitiveArray((TranslationContext)object, varargElementType, argument);
    }

    private final List<JsExpression> prepareConcatArguments(List<? extends ValueArgument> arguments2, List<? extends JsExpression> list2, KotlinType varargElementType) {
        Collection collection = arguments2;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32 = false;
            String $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32 = "arguments.size should not be 0";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$prepareConcatArguments$32));
        }
        bl2 = arguments2.size() == list2.size();
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42 = false;
            String $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42 = "arguments.size: " + arguments2.size() + " != list.size: " + list2.size();
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42));
        }
        bl = false;
        List concatArguments = new ArrayList();
        boolean $i$a$-assert-CallArgumentTranslator$prepareConcatArguments$42 = false;
        List lastArrayContent = new ArrayList();
        int n = 0;
        int size = arguments2.size();
        if (n < size) {
            do {
                int index2 = n++;
                ValueArgument valueArgument = arguments2.get(index2);
                JsExpression expressionArgument = list2.get(index2);
                if (this.hasSpreadElementOrNamedArgument(valueArgument)) {
                    if (lastArrayContent.size() > 0) {
                        concatArguments.add(this.toArray(varargElementType, lastArrayContent));
                        boolean bl3 = false;
                        lastArrayContent = new ArrayList();
                    }
                    JsExpression e = varargElementType != null && ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType) != null ? (JsExpression)new JsInvocation((JsExpression)new JsNameRef("unbox", expressionArgument), new JsExpression[0]) : expressionArgument;
                    concatArguments.add(e);
                    continue;
                }
                lastArrayContent.add(expressionArgument);
            } while (n < size);
        }
        if (lastArrayContent.size() > 0) {
            concatArguments.add(this.toArray(varargElementType, lastArrayContent));
        }
        return concatArguments;
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
        return Companion.translate(resolvedCall2, receiver, context2);
    }

    @JvmStatic
    @NotNull
    public static final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context2, @NotNull JsBlock block) {
        return Companion.translate(resolvedCall2, receiver, context2, block);
    }

    public /* synthetic */ CallArgumentTranslator(ResolvedCall resolvedCall2, JsExpression receiver, TranslationContext context2, DefaultConstructorMarker $constructor_marker) {
        this(resolvedCall2, receiver, context2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J?\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "", "valueArguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "hasSpreadOperator", "", "cachedReceiver", "Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "reifiedArguments", "(Ljava/util/List;ZLorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;Ljava/util/List;)V", "getCachedReceiver", "()Lorg/jetbrains/kotlin/js/translate/context/TemporaryConstVariable;", "getHasSpreadOperator", "()Z", "getReifiedArguments", "()Ljava/util/List;", "translateArguments", "getTranslateArguments", "getValueArguments", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "js.translator"})
    public static final class ArgumentsInfo {
        @NotNull
        private final List<JsExpression> valueArguments;
        private final boolean hasSpreadOperator;
        @Nullable
        private final TemporaryConstVariable cachedReceiver;
        @NotNull
        private final List<JsExpression> reifiedArguments;

        public ArgumentsInfo(@NotNull List<? extends JsExpression> valueArguments, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkNotNullParameter(valueArguments, "valueArguments");
            Intrinsics.checkNotNullParameter(reifiedArguments, "reifiedArguments");
            this.valueArguments = valueArguments;
            this.hasSpreadOperator = hasSpreadOperator;
            this.cachedReceiver = cachedReceiver;
            this.reifiedArguments = reifiedArguments;
        }

        public /* synthetic */ ArgumentsInfo(List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                boolean bl2 = false;
                list3 = CollectionsKt.emptyList();
            }
            this(list2, bl, temporaryConstVariable, list3);
        }

        @NotNull
        public final List<JsExpression> getValueArguments() {
            return this.valueArguments;
        }

        public final boolean getHasSpreadOperator() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable getCachedReceiver() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> getReifiedArguments() {
            return this.reifiedArguments;
        }

        @NotNull
        public final List<JsExpression> getTranslateArguments() {
            return CollectionsKt.plus((Collection)this.reifiedArguments, (Iterable)this.valueArguments);
        }

        @NotNull
        public final List<JsExpression> component1() {
            return this.valueArguments;
        }

        public final boolean component2() {
            return this.hasSpreadOperator;
        }

        @Nullable
        public final TemporaryConstVariable component3() {
            return this.cachedReceiver;
        }

        @NotNull
        public final List<JsExpression> component4() {
            return this.reifiedArguments;
        }

        @NotNull
        public final ArgumentsInfo copy(@NotNull List<? extends JsExpression> valueArguments, boolean hasSpreadOperator, @Nullable TemporaryConstVariable cachedReceiver, @NotNull List<? extends JsExpression> reifiedArguments) {
            Intrinsics.checkNotNullParameter(valueArguments, "valueArguments");
            Intrinsics.checkNotNullParameter(reifiedArguments, "reifiedArguments");
            return new ArgumentsInfo(valueArguments, hasSpreadOperator, cachedReceiver, reifiedArguments);
        }

        public static /* synthetic */ ArgumentsInfo copy$default(ArgumentsInfo argumentsInfo, List list2, boolean bl, TemporaryConstVariable temporaryConstVariable, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = argumentsInfo.valueArguments;
            }
            if ((n & 2) != 0) {
                bl = argumentsInfo.hasSpreadOperator;
            }
            if ((n & 4) != 0) {
                temporaryConstVariable = argumentsInfo.cachedReceiver;
            }
            if ((n & 8) != 0) {
                list3 = argumentsInfo.reifiedArguments;
            }
            return argumentsInfo.copy(list2, bl, temporaryConstVariable, list3);
        }

        @NotNull
        public String toString() {
            return "ArgumentsInfo(valueArguments=" + this.valueArguments + ", hasSpreadOperator=" + this.hasSpreadOperator + ", cachedReceiver=" + this.cachedReceiver + ", reifiedArguments=" + this.reifiedArguments + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.valueArguments).hashCode();
            int n = this.hasSpreadOperator ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + (this.cachedReceiver == null ? 0 : this.cachedReceiver.hashCode());
            result2 = result2 * 31 + ((Object)this.reifiedArguments).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArgumentsInfo)) {
                return false;
            }
            ArgumentsInfo argumentsInfo = (ArgumentsInfo)other;
            if (!Intrinsics.areEqual(this.valueArguments, argumentsInfo.valueArguments)) {
                return false;
            }
            if (this.hasSpreadOperator != argumentsInfo.hasSpreadOperator) {
                return false;
            }
            if (!Intrinsics.areEqual(this.cachedReceiver, argumentsInfo.cachedReceiver)) {
                return false;
            }
            return Intrinsics.areEqual(this.reifiedArguments, argumentsInfo.reifiedArguments);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J.\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$Companion;", "", "()V", "concatArgumentsIfNeeded", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "concatArguments", "", "varargElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isMixed", "", "translate", "Lorg/jetbrains/kotlin/js/translate/reference/CallArgumentTranslator$ArgumentsInfo;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "receiver", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "block", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "translateResolvedArgument", "resolvedArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "translatedArgs", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "js.translator"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context2) {
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(context2, "context");
            JsBlock jsBlock = context2.dynamicContext().jsBlock();
            Intrinsics.checkNotNullExpressionValue(jsBlock, "context.dynamicContext().jsBlock()");
            return this.translate(resolvedCall2, receiver, context2, jsBlock);
        }

        @JvmStatic
        @NotNull
        public final ArgumentsInfo translate(@NotNull ResolvedCall<?> resolvedCall2, @Nullable JsExpression receiver, @NotNull TranslationContext context2, @NotNull JsBlock block) {
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(block, "block");
            TranslationContext translationContext = context2.innerBlock(block);
            Intrinsics.checkNotNullExpressionValue(translationContext, "context.innerBlock(block)");
            TranslationContext innerContext = translationContext;
            CallArgumentTranslator argumentTranslator = new CallArgumentTranslator(resolvedCall2, receiver, innerContext, null);
            ArgumentsInfo result2 = argumentTranslator.translate();
            context2.moveVarsFrom(innerContext);
            Object callDescriptor = resolvedCall2.getCandidateDescriptor();
            if (CallExpressionTranslator.shouldBeInlined(callDescriptor)) {
                Map<TypeParameterDescriptor, KotlinType> map = resolvedCall2.getTypeArguments();
                Intrinsics.checkNotNullExpressionValue(map, "resolvedCall.typeArguments");
                Map<TypeParameterDescriptor, KotlinType> typeArgs = map;
                return ArgumentsInfo.copy$default(result2, null, false, null, CallArgumentTranslatorKt.buildReifiedTypeArgs(typeArgs, context2), 7, null);
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        private final List<JsExpression> translateResolvedArgument(ResolvedValueArgument resolvedArgument, Map<ValueArgument, ? extends JsExpression> translatedArgs) {
            void $this$mapTo$iv$iv;
            if (resolvedArgument instanceof DefaultValueArgument) {
                JsExpression jsExpression = Namer.getUndefinedExpression();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "getUndefinedExpression()");
                return CollectionsKt.listOf(jsExpression);
            }
            List<ValueArgument> list2 = resolvedArgument.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "resolvedArgument.arguments");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JsExpression jsExpression = translatedArgs.get(it);
                Intrinsics.checkNotNull(jsExpression);
                JsExpression jsExpression2 = jsExpression;
                collection.add(jsExpression2);
            }
            return (List)destination$iv$iv;
        }

        private final JsExpression concatArgumentsIfNeeded(List<? extends JsExpression> concatArguments, KotlinType varargElementType, boolean isMixed) {
            JsExpression jsExpression;
            Collection collection = concatArguments;
            boolean bl = false;
            boolean bl2 = !collection.isEmpty();
            bl = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl3 = false;
                String string2 = "concatArguments.size should not be 0";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            if (concatArguments.size() > 1) {
                JsInvocation jsInvocation;
                if (varargElementType != null && (TypeUtilsKt.isPrimitiveNumberType(varargElementType) || ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(varargElementType) != null)) {
                    String method = isMixed ? "arrayConcat" : "primitiveArrayConcat";
                    SpreadBuilder spreadBuilder2 = new SpreadBuilder(2);
                    spreadBuilder2.add(concatArguments.get(0));
                    Collection $this$toTypedArray$iv = concatArguments.subList(1, concatArguments.size());
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    JsExpression[] jsExpressionArray = thisCollection$iv.toArray(new JsExpression[0]);
                    if (jsExpressionArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    spreadBuilder2.addSpread(jsExpressionArray);
                    jsInvocation = JsAstUtils.invokeKotlinFunction(method, (JsExpression[])spreadBuilder2.toArray(new JsExpression[spreadBuilder2.size()]));
                } else {
                    jsInvocation = new JsInvocation((JsExpression)new JsNameRef("concat", concatArguments.get(0)), concatArguments.subList(1, concatArguments.size()));
                }
                JsInvocation jsInvocation2 = jsInvocation;
                Intrinsics.checkNotNullExpressionValue(jsInvocation2, "{\n                if (varargElementType != null && (varargElementType.isPrimitiveNumberType() || ArrayFIF.unsignedPrimitiveToSigned(varargElementType) != null)) {\n                    val method = if (isMixed) \"arrayConcat\" else \"primitiveArrayConcat\"\n                    JsAstUtils.invokeKotlinFunction(\n                        method, concatArguments[0],\n                        *concatArguments.subList(1, concatArguments.size).toTypedArray()\n                    )\n                } else {\n                    JsInvocation(JsNameRef(\"concat\", concatArguments[0]), concatArguments.subList(1, concatArguments.size))\n                }\n            }");
                jsExpression = jsInvocation2;
            } else {
                jsExpression = concatArguments.get(0);
            }
            return jsExpression;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

