/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java.enhancement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.builder.FirAbstractConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirPrimaryConstructorBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirSimpleFunctionBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirValueParameterBuilder;
import org.jetbrains.kotlin.fir.declarations.impl.FirDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirResolvedDeclarationStatusImpl;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyBuilder;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticPropertyBuilderKt;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirConstExpressionBuilderKt;
import org.jetbrains.kotlin.fir.java.JavaTypeParameterStack;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaClass;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaConstructor;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaField;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaFieldBuilder;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaMethod;
import org.jetbrains.kotlin.fir.java.declarations.FirJavaValueParameter;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancementSignatureParts;
import org.jetbrains.kotlin.fir.java.enhancement.FirAnnotationTypeQualifierResolver;
import org.jetbrains.kotlin.fir.java.enhancement.FirJavaEnhancementContext;
import org.jetbrains.kotlin.fir.java.enhancement.FirJavaEnhancementContextKt;
import org.jetbrains.kotlin.fir.java.enhancement.FirSignatureEnhancement;
import org.jetbrains.kotlin.fir.java.enhancement.JavaTypeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.jvm.DescriptorUtilsKt;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.jvm.FirJavaTypeRef;
import org.jetbrains.kotlin.load.java.AnnotationQualifierApplicabilityType;
import org.jetbrains.kotlin.load.java.descriptors.AnnotationDefaultValue;
import org.jetbrains.kotlin.load.java.descriptors.NullDefaultValue;
import org.jetbrains.kotlin.load.java.descriptors.StringDefaultValue;
import org.jetbrains.kotlin.load.java.typeEnhancement.JavaTypeQualifiers;
import org.jetbrains.kotlin.load.java.typeEnhancement.NullabilityQualifier;
import org.jetbrains.kotlin.load.java.typeEnhancement.PredefinedEnhancementInfoKt;
import org.jetbrains.kotlin.load.java.typeEnhancement.PredefinedFunctionEnhancementInfo;
import org.jetbrains.kotlin.load.java.typeEnhancement.TypeEnhancementInfo;
import org.jetbrains.kotlin.load.kotlin.SignatureBuildingComponents;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.JavaTypeEnhancementState;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002EFB8\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0004\u0012\u00020\b\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t0\u0007\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J \u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u001d2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J*\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u00192\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010!\u001a\u00020\"2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J*\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010(\u001a\u00020\u000eH\u0002J8\u0010)\u001a\u00020$2\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\n2\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010(\u001a\u00020\u000e2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002JP\u0010,\u001a\u00020-2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030 2\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020\u000e2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J \u00104\u001a\u0006\u0012\u0002\b\u00030\u00192\n\u00105\u001a\u0006\u0012\u0002\b\u00030\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u001e\u00106\u001a\u0006\u0012\u0002\b\u00030\u001d2\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001b\u001a\u00020\u001cJT\u00108\u001a\u000209*\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020/2\u0006\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002JD\u0010B\u001a\u000209*\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u0016\u001a\u00020\u00172\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\b\u0010C\u001a\u0004\u0018\u00010;2\u0006\u0010D\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020AH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001d\u0012\u0004\u0012\u00020\b\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t0\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement;", "", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "overridden", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/fir/FirSession;Lkotlin/jvm/functions/Function1;)V", "context", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirJavaEnhancementContext;", "enhancements", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "javaTypeParameterStack", "Lorg/jetbrains/kotlin/fir/java/JavaTypeParameterStack;", "jsr305State", "Lorg/jetbrains/kotlin/utils/JavaTypeEnhancementState;", "typeQualifierResolver", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirAnnotationTypeQualifierResolver;", "enhance", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "original", "name", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "enhanceMethod", "firMethod", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "methodId", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "enhanceReceiverType", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "ownerFunction", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaMethod;", "overriddenMembers", "memberContext", "enhanceReturnType", "predefinedEnhancementInfo", "Lorg/jetbrains/kotlin/load/java/typeEnhancement/PredefinedFunctionEnhancementInfo;", "enhanceValueParameter", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$EnhanceValueParameterResult;", "hasReceiver", "", "ownerParameter", "Lorg/jetbrains/kotlin/fir/java/declarations/FirJavaValueParameter;", "index", "", "enhancedFunction", "function", "enhancedProperty", "property", "parts", "Lorg/jetbrains/kotlin/fir/java/enhancement/EnhancementSignatureParts;", "typeContainer", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "isCovariant", "containerContext", "containerApplicabilityType", "Lorg/jetbrains/kotlin/load/java/AnnotationQualifierApplicabilityType;", "typeInSignature", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "partsForValueParameter", "parameterContainer", "methodContext", "EnhanceValueParameterResult", "TypeInSignature", "java"})
public final class FirSignatureEnhancement {
    @NotNull
    private final FirRegularClass owner;
    @NotNull
    private final FirSession session;
    @NotNull
    private final Function1<FirSimpleFunction, List<FirCallableMemberDeclaration<?>>> overridden;
    @NotNull
    private final JavaTypeParameterStack javaTypeParameterStack;
    @NotNull
    private final JavaTypeEnhancementState jsr305State;
    @NotNull
    private final FirAnnotationTypeQualifierResolver typeQualifierResolver;
    @NotNull
    private final FirJavaEnhancementContext context;
    @NotNull
    private final Map<FirCallableSymbol<?>, FirCallableSymbol<?>> enhancements;

    public FirSignatureEnhancement(@NotNull FirRegularClass owner, @NotNull FirSession session2, @NotNull Function1<? super FirSimpleFunction, ? extends List<? extends FirCallableMemberDeclaration<?>>> overridden) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(overridden, "overridden");
        this.owner = owner;
        this.session = session2;
        this.overridden = overridden;
        this.javaTypeParameterStack = this.owner instanceof FirJavaClass ? ((FirJavaClass)this.owner).getJavaTypeParameterStack$java() : JavaTypeParameterStack.Companion.getEMPTY();
        JavaTypeEnhancementState javaTypeEnhancementState = this.session.getJavaTypeEnhancementState();
        this.jsr305State = javaTypeEnhancementState == null ? JavaTypeEnhancementState.DEFAULT : javaTypeEnhancementState;
        this.typeQualifierResolver = new FirAnnotationTypeQualifierResolver(this.session, this.jsr305State);
        this.context = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(new FirJavaEnhancementContext(this.session, context.1.INSTANCE), this.typeQualifierResolver, this.jsr305State, this.owner.getAnnotations());
        boolean bl = false;
        this.enhancements = new LinkedHashMap();
    }

    @NotNull
    public final FirFunctionSymbol<?> enhancedFunction(@NotNull FirFunctionSymbol<?> function2, @Nullable Name name) {
        FirCallableSymbol firCallableSymbol;
        Intrinsics.checkNotNullParameter(function2, "function");
        Map<FirCallableSymbol<?>, FirCallableSymbol<?>> $this$getOrPut$iv = this.enhancements;
        boolean $i$f$getOrPut = false;
        FirCallableSymbol value$iv = $this$getOrPut$iv.get(function2);
        if (value$iv == null) {
            boolean bl = false;
            FirCallableSymbol answer$iv = this.enhance(function2, name);
            $this$getOrPut$iv.put(function2, answer$iv);
            firCallableSymbol = answer$iv;
        } else {
            firCallableSymbol = value$iv;
        }
        return (FirFunctionSymbol)firCallableSymbol;
    }

    @NotNull
    public final FirVariableSymbol<?> enhancedProperty(@NotNull FirVariableSymbol<?> property2, @NotNull Name name) {
        FirCallableSymbol firCallableSymbol;
        Intrinsics.checkNotNullParameter(property2, "property");
        Intrinsics.checkNotNullParameter(name, "name");
        Map<FirCallableSymbol<?>, FirCallableSymbol<?>> $this$getOrPut$iv = this.enhancements;
        boolean $i$f$getOrPut = false;
        FirCallableSymbol value$iv = $this$getOrPut$iv.get(property2);
        if (value$iv == null) {
            boolean bl = false;
            FirCallableSymbol answer$iv = this.enhance(property2, name);
            $this$getOrPut$iv.put(property2, answer$iv);
            firCallableSymbol = answer$iv;
        } else {
            firCallableSymbol = value$iv;
        }
        return (FirVariableSymbol)firCallableSymbol;
    }

    private final FirVariableSymbol<?> enhance(FirVariableSymbol<?> original, Name name) {
        FirVariable firElement = (FirVariable)original.getFir();
        if (firElement instanceof FirEnumEntry) {
            if (!(firElement.getReturnTypeRef() instanceof FirJavaTypeRef)) {
                return original;
            }
            FirJavaEnhancementContext memberContext = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(this.context, this.typeQualifierResolver, this.jsr305State, firElement.getAnnotations());
            Pair[] pairArray = new Pair[]{TuplesKt.to(0, new JavaTypeQualifiers(NullabilityQualifier.NOT_NULL, null, false, false, 8, null))};
            PredefinedFunctionEnhancementInfo predefinedInfo = new PredefinedFunctionEnhancementInfo(new TypeEnhancementInfo(pairArray), CollectionsKt.emptyList());
            FirResolvedTypeRef newReturnTypeRef = this.enhanceReturnType((FirCallableMemberDeclaration)((Object)firElement), CollectionsKt.emptyList(), memberContext, predefinedInfo);
            FirVariableSymbol<FirEnumEntry> firVariableSymbol = ((FirEnumEntry)firElement).getSymbol();
            boolean bl = false;
            boolean bl2 = false;
            FirVariableSymbol<FirEnumEntry> $this$enhance_u24lambda_u2d2 = firVariableSymbol;
            boolean bl3 = false;
            ((FirEnumEntry)$this$enhance_u24lambda_u2d2.getFir()).replaceReturnTypeRef(newReturnTypeRef);
            return firVariableSymbol;
        }
        if (firElement instanceof FirField) {
            if (!(firElement.getReturnTypeRef() instanceof FirJavaTypeRef)) {
                return original;
            }
            FirJavaEnhancementContext memberContext = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(this.context, this.typeQualifierResolver, this.jsr305State, firElement.getAnnotations());
            FirResolvedTypeRef newReturnTypeRef = this.enhanceReturnType((FirCallableMemberDeclaration)((Object)firElement), CollectionsKt.emptyList(), memberContext, null);
            FirFieldSymbol symbol2 = new FirFieldSymbol(original.getCallableId());
            boolean $i$f$buildJavaField = false;
            boolean bl = false;
            FirJavaFieldBuilder firJavaFieldBuilder = new FirJavaFieldBuilder();
            boolean bl4 = false;
            boolean bl5 = false;
            FirJavaFieldBuilder $this$enhance_u24lambda_u2d3 = firJavaFieldBuilder;
            boolean bl6 = false;
            $this$enhance_u24lambda_u2d3.setSource(firElement.getSource());
            $this$enhance_u24lambda_u2d3.setSession(this.session);
            $this$enhance_u24lambda_u2d3.setSymbol(symbol2);
            $this$enhance_u24lambda_u2d3.setName(name);
            $this$enhance_u24lambda_u2d3.setReturnTypeRef(newReturnTypeRef);
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)((Object)firElement);
            boolean $i$f$getVisibility = false;
            $this$enhance_u24lambda_u2d3.setVisibility($this$visibility$iv.getStatus().getVisibility());
            FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)((Object)firElement);
            boolean $i$f$getModality = false;
            $this$enhance_u24lambda_u2d3.setModality($this$modality$iv.getStatus().getModality());
            $this$enhance_u24lambda_u2d3.setVar(firElement.isVar());
            FirMemberDeclaration $this$isStatic$iv = (FirMemberDeclaration)((Object)firElement);
            boolean $i$f$isStatic = false;
            $this$enhance_u24lambda_u2d3.setStatic($this$isStatic$iv.getStatus().isStatic());
            FirJavaFieldBuilder firJavaFieldBuilder2 = $this$enhance_u24lambda_u2d3;
            Collection collection = firJavaFieldBuilder2.getAnnotations();
            Iterable iterable = firElement.getAnnotations();
            boolean bl7 = false;
            CollectionsKt.addAll(collection, iterable);
            $this$enhance_u24lambda_u2d3.setStatus(((FirField)firElement).getStatus());
            $this$enhance_u24lambda_u2d3.setInitializer(firElement.getInitializer());
            $this$enhance_u24lambda_u2d3.setDispatchReceiverType(((FirField)firElement).getDispatchReceiverType());
            $this$enhance_u24lambda_u2d3.setAttributes(firElement.getAttributes().copy());
            firJavaFieldBuilder.build();
            return symbol2;
        }
        if (firElement instanceof FirSyntheticProperty) {
            FirSimpleFunction firSimpleFunction;
            FirSimpleFunction setterDelegate;
            FirAccessorSymbol accessorSymbol = ((FirSyntheticProperty)firElement).getSymbol();
            FirSimpleFunction getterDelegate = ((FirSyntheticProperty)firElement).getGetter().getDelegate();
            FirFunctionSymbol<FirSimpleFunction> enhancedGetterSymbol = getterDelegate instanceof FirJavaMethod ? this.enhanceMethod(getterDelegate, accessorSymbol.getAccessorId(), accessorSymbol.getAccessorId().getCallableName()) : getterDelegate.getSymbol();
            FirSyntheticPropertyAccessor firSyntheticPropertyAccessor = ((FirSyntheticProperty)firElement).getSetter();
            FirSimpleFunction firSimpleFunction2 = setterDelegate = firSyntheticPropertyAccessor == null ? null : firSyntheticPropertyAccessor.getDelegate();
            FirFunctionSymbol<FirSimpleFunction> enhancedSetterSymbol = setterDelegate instanceof FirJavaMethod ? this.enhanceMethod(setterDelegate, accessorSymbol.getAccessorId(), accessorSymbol.getAccessorId().getCallableName()) : ((firSimpleFunction = setterDelegate) == null ? null : firSimpleFunction.getSymbol());
            return FirSyntheticPropertyBuilderKt.buildSyntheticProperty((Function1<? super FirSyntheticPropertyBuilder, Unit>)new Function1<FirSyntheticPropertyBuilder, Unit>(this, name, accessorSymbol, enhancedGetterSymbol, enhancedSetterSymbol){
                final /* synthetic */ FirSignatureEnhancement this$0;
                final /* synthetic */ Name $name;
                final /* synthetic */ FirAccessorSymbol $accessorSymbol;
                final /* synthetic */ FirFunctionSymbol<? extends FirFunction<?>> $enhancedGetterSymbol;
                final /* synthetic */ FirFunctionSymbol<? extends FirFunction<?>> $enhancedSetterSymbol;
                {
                    this.this$0 = $receiver;
                    this.$name = $name;
                    this.$accessorSymbol = $accessorSymbol;
                    this.$enhancedGetterSymbol = $enhancedGetterSymbol;
                    this.$enhancedSetterSymbol = $enhancedSetterSymbol;
                    super(1);
                }

                public final void invoke(@NotNull FirSyntheticPropertyBuilder firSyntheticPropertyBuilder) {
                    Intrinsics.checkNotNullParameter(firSyntheticPropertyBuilder, "<this>");
                    firSyntheticPropertyBuilder.setSession(FirSignatureEnhancement.access$getSession$p(this.this$0));
                    firSyntheticPropertyBuilder.setName(this.$name);
                    firSyntheticPropertyBuilder.setSymbol(new FirAccessorSymbol(this.$accessorSymbol.getCallableId(), this.$accessorSymbol.getAccessorId()));
                    firSyntheticPropertyBuilder.setDelegateGetter((FirSimpleFunction)((FirFunction)this.$enhancedGetterSymbol.getFir()));
                    FirFunctionSymbol<FirFunction<?>> firFunctionSymbol = this.$enhancedSetterSymbol;
                    firSyntheticPropertyBuilder.setDelegateSetter((FirSimpleFunction)(firFunctionSymbol == null ? null : (FirFunction)firFunctionSymbol.getFir()));
                }
            }).getSymbol();
        }
        if (original instanceof FirPropertySymbol || original instanceof FirAccessorSymbol) {
            return original;
        }
        String string2 = "Can't make enhancement for " + original + ": `" + FirRendererKt.render$default(firElement, null, 1, null) + '`';
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string2.toString());
    }

    private final FirFunctionSymbol<?> enhance(FirFunctionSymbol<?> original, Name name) {
        FirFunction firMethod = (FirFunction)original.getFir();
        if (!(firMethod instanceof FirJavaMethod) && !(firMethod instanceof FirJavaConstructor)) {
            return original;
        }
        return this.enhanceMethod(firMethod, original.getCallableId(), name);
    }

    /*
     * WARNING - void declaration
     */
    private final FirFunctionSymbol<?> enhanceMethod(FirFunction<?> firMethod, CallableId methodId, Name name) {
        FirFunctionBuilder firFunctionBuilder;
        Iterable iterable;
        Object newTypeRef;
        Object object;
        int n;
        Object object2;
        boolean bl;
        FirSimpleFunction overriddenMembers;
        PredefinedFunctionEnhancementInfo predefinedEnhancementInfo;
        FirJavaEnhancementContext memberContext;
        block18: {
            Unit unit;
            memberContext = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(this.context, this.typeQualifierResolver, this.jsr305State, firMethod.getAnnotations());
            Object object3 = SignatureBuildingComponents.INSTANCE.signature(this.owner.getSymbol().getClassId(), DescriptorUtilsKt.computeJvmDescriptor(firMethod));
            boolean bl2 = false;
            boolean bl3 = false;
            String signature22 = object3;
            boolean bl4 = false;
            predefinedEnhancementInfo = PredefinedEnhancementInfoKt.getPREDEFINED_FUNCTION_ENHANCEMENT_INFO_BY_SIGNATURE().get(signature22);
            object3 = predefinedEnhancementInfo;
            if (object3 == null) {
                unit = null;
            } else {
                Object object4 = object3;
                bl3 = false;
                boolean signature22 = false;
                Object it = object4;
                boolean bl5 = false;
                boolean bl6 = ((PredefinedFunctionEnhancementInfo)it).getParametersInfo().size() == firMethod.getValueParameters().size();
                boolean bl7 = false;
                if (_Assertions.ENABLED && !bl6) {
                    boolean $i$a$-assert-FirSignatureEnhancement$enhanceMethod$1$22 = false;
                    String $i$a$-assert-FirSignatureEnhancement$enhanceMethod$1$22 = "Predefined enhancement info for " + this + " has " + ((PredefinedFunctionEnhancementInfo)it).getParametersInfo().size() + ", but " + firMethod.getValueParameters().size() + " expected";
                    throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FirSignatureEnhancement$enhanceMethod$1$22));
                }
                unit = Unit.INSTANCE;
            }
            FirSimpleFunction firSimpleFunction = firMethod instanceof FirSimpleFunction ? (FirSimpleFunction)firMethod : null;
            firSimpleFunction = firSimpleFunction == null ? null : this.overridden.invoke(firSimpleFunction);
            bl3 = false;
            Object object5 = firSimpleFunction;
            if (object5 == null) {
                object5 = CollectionsKt.emptyList();
            }
            overriddenMembers = object5;
            Iterable $this$any$iv = (Iterable)((Object)overriddenMembers);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv22 : $this$any$iv) {
                    FirCallableMemberDeclaration it = (FirCallableMemberDeclaration)element$iv22;
                    boolean bl8 = false;
                    if (!(it.getReceiverTypeRef() != null)) continue;
                    bl = true;
                    break block18;
                }
                bl = false;
            }
        }
        boolean hasReceiver = bl;
        FirResolvedTypeRef newReceiverTypeRef = firMethod instanceof FirJavaMethod && hasReceiver ? this.enhanceReceiverType((FirJavaMethod)firMethod, (List<? extends FirCallableMemberDeclaration<?>>)((Object)overriddenMembers), memberContext) : null;
        FirTypeRef newReturnTypeRef = !(firMethod instanceof FirJavaMethod) ? firMethod.getReturnTypeRef() : (FirTypeRef)this.enhanceReturnType((FirCallableMemberDeclaration)((Object)firMethod), (List<? extends FirCallableMemberDeclaration<?>>)((Object)overriddenMembers), memberContext, predefinedEnhancementInfo);
        boolean element$iv22 = false;
        List newValueParameterInfo = new ArrayList();
        Iterator<FirValueParameter> element$iv22 = firMethod.getValueParameters().iterator();
        int it = 0;
        while (element$iv22.hasNext()) {
            int index2 = it++;
            FirValueParameter valueParameter = element$iv22.next();
            if (hasReceiver && index2 == 0) continue;
            object2 = newValueParameterInfo;
            EnhanceValueParameterResult enhanceValueParameterResult = this.enhanceValueParameter(firMethod, (List<? extends FirCallableMemberDeclaration<?>>)((Object)overriddenMembers), hasReceiver, memberContext, predefinedEnhancementInfo, (FirJavaValueParameter)valueParameter, hasReceiver ? index2 - 1 : index2);
            n = 0;
            object2.add(enhanceValueParameterResult);
        }
        Iterable $this$zip$iv = firMethod.getValueParameters();
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = ((Iterable)newValueParameterInfo).iterator();
        int n2 = CollectionsKt.collectionSizeOrDefault($this$zip$iv, 10);
        n = CollectionsKt.collectionSizeOrDefault(newValueParameterInfo, 10);
        boolean bl9 = false;
        ArrayList<FirValueParameter> list$iv = new ArrayList<FirValueParameter>(Math.min(n2, n));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void valueParameter;
            void newInfo;
            object = (EnhanceValueParameterResult)second$iv.next();
            FirValueParameter firValueParameter = (FirValueParameter)first$iv.next();
            ArrayList<FirValueParameter> arrayList = list$iv;
            boolean bl10 = false;
            void var23_58 = newInfo;
            newTypeRef = var23_58.component1();
            FirExpression newDefaultValue = var23_58.component2();
            boolean $i$f$buildValueParameter = false;
            boolean bl11 = false;
            FirValueParameterBuilder firValueParameterBuilder = new FirValueParameterBuilder();
            boolean bl12 = false;
            boolean bl13 = false;
            FirValueParameterBuilder $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8 = firValueParameterBuilder;
            boolean bl14 = false;
            $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.setSource(valueParameter.getSource());
            $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.setSession(this.session);
            $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.setOrigin(FirDeclarationOrigin.Enhancement.INSTANCE);
            $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.setReturnTypeRef((FirTypeRef)newTypeRef);
            $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.setName(valueParameter.getName());
            $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.setSymbol(new FirVariableSymbol<FirValueParameter>($this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.getName()));
            Object object6 = valueParameter.getDefaultValue();
            $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.setDefaultValue((FirExpression)(object6 == null ? newDefaultValue : object6));
            $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.setCrossinline(valueParameter.isCrossinline());
            $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.setNoinline(valueParameter.isNoinline());
            $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.setVararg(valueParameter.isVararg());
            $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
            object6 = $this$enhanceMethod_u24lambda_u2d9_u24lambda_u2d8;
            Collection collection = ((FirValueParameterBuilder)object6).getAnnotations();
            Iterable iterable2 = valueParameter.getAnnotations();
            boolean bl15 = false;
            CollectionsKt.addAll(collection, iterable2);
            FirValueParameter firValueParameter2 = firValueParameterBuilder.build();
            arrayList.add(firValueParameter2);
        }
        List newValueParameters = list$iv;
        FirFunction<?> firFunction = firMethod;
        if (firFunction instanceof FirJavaConstructor) {
            FirAbstractConstructorBuilder firAbstractConstructorBuilder;
            FirConstructorSymbol symbol2 = new FirConstructorSymbol(methodId);
            if (((FirJavaConstructor)firMethod).isPrimary()) {
                void $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10;
                FirDeclarationStatusImpl firDeclarationStatusImpl;
                boolean $i$f$getVisibility;
                FirMemberDeclaration $this$visibility$iv;
                FirResolvedDeclarationStatus resolvedStatus;
                object2 = new FirPrimaryConstructorBuilder();
                n2 = 0;
                n = 0;
                Object $this$enhanceMethod_u24lambda_u2d11 = object2;
                boolean bl16 = false;
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d11).setReturnTypeRef(newReturnTypeRef);
                FirDeclarationStatus $this$safeAs$iv = ((FirJavaConstructor)firMethod).getStatus();
                boolean $i$f$safeAs = false;
                FirDeclarationStatus firDeclarationStatus = $this$safeAs$iv;
                if (!(firDeclarationStatus instanceof FirResolvedDeclarationStatus)) {
                    firDeclarationStatus = null;
                }
                if ((resolvedStatus = (FirResolvedDeclarationStatus)firDeclarationStatus) != null) {
                    $this$visibility$iv = (FirMemberDeclaration)((Object)firMethod);
                    $i$f$getVisibility = false;
                    firDeclarationStatusImpl = new FirResolvedDeclarationStatusImpl($this$visibility$iv.getStatus().getVisibility(), Modality.FINAL);
                } else {
                    $this$visibility$iv = (FirMemberDeclaration)((Object)firMethod);
                    $i$f$getVisibility = false;
                    FirDeclarationStatusImpl firDeclarationStatusImpl2 = new FirDeclarationStatusImpl($this$visibility$iv.getStatus().getVisibility(), Modality.FINAL);
                    firDeclarationStatusImpl = firDeclarationStatusImpl2;
                }
                object = firDeclarationStatusImpl;
                boolean bl17 = false;
                boolean bl18 = false;
                newTypeRef = object;
                Object object7 = $this$enhanceMethod_u24lambda_u2d11;
                boolean bl19 = false;
                $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setExpect(false);
                $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setActual(false);
                $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setOverride(false);
                FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)((Object)firMethod);
                boolean $i$f$isInner = false;
                $this$enhanceMethod_u24lambda_u2d11_u24lambda_u2d10.setInner($this$isInner$iv.getStatus().isInner());
                Unit unit = Unit.INSTANCE;
                ((FirPrimaryConstructorBuilder)object7).setStatus((FirDeclarationStatus)object);
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d11).setSymbol(symbol2);
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d11).setDispatchReceiverType(((FirJavaConstructor)firMethod).getDispatchReceiverType());
                ((FirPrimaryConstructorBuilder)$this$enhanceMethod_u24lambda_u2d11).setAttributes(firMethod.getAttributes().copy());
                firAbstractConstructorBuilder = (FirAbstractConstructorBuilder)object2;
            } else {
                object2 = new FirConstructorBuilder();
                n2 = 0;
                n = 0;
                Object $this$enhanceMethod_u24lambda_u2d12 = object2;
                boolean bl20 = false;
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d12).setReturnTypeRef(newReturnTypeRef);
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d12).setStatus(((FirJavaConstructor)firMethod).getStatus());
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d12).setSymbol(symbol2);
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d12).setDispatchReceiverType(((FirJavaConstructor)firMethod).getDispatchReceiverType());
                ((FirConstructorBuilder)$this$enhanceMethod_u24lambda_u2d12).setAttributes(firMethod.getAttributes().copy());
                firAbstractConstructorBuilder = (FirAbstractConstructorBuilder)object2;
            }
            object2 = firAbstractConstructorBuilder;
            n2 = 0;
            n = 0;
            Object $this$enhanceMethod_u24lambda_u2d13 = object2;
            boolean bl21 = false;
            $this$enhanceMethod_u24lambda_u2d13.setSource(firMethod.getSource());
            $this$enhanceMethod_u24lambda_u2d13.setSession(this.session);
            $this$enhanceMethod_u24lambda_u2d13.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
            $this$enhanceMethod_u24lambda_u2d13.setOrigin(FirDeclarationOrigin.Enhancement.INSTANCE);
            object = $this$enhanceMethod_u24lambda_u2d13;
            iterable = object.getValueParameters();
            boolean bl22 = false;
            CollectionsKt.addAll(iterable, newValueParameters);
            object = $this$enhanceMethod_u24lambda_u2d13;
            iterable = object.getTypeParameters();
            Iterable iterable3 = ((FirJavaConstructor)firMethod).getTypeParameters();
            boolean bl23 = false;
            CollectionsKt.addAll(iterable, iterable3);
            firFunctionBuilder = (FirFunctionBuilder)object2;
        } else if (firFunction instanceof FirJavaMethod) {
            FirSimpleFunctionBuilder firSimpleFunctionBuilder = new FirSimpleFunctionBuilder();
            boolean bl24 = false;
            n2 = 0;
            FirSimpleFunctionBuilder $this$enhanceMethod_u24lambda_u2d14 = firSimpleFunctionBuilder;
            boolean bl25 = false;
            $this$enhanceMethod_u24lambda_u2d14.setSource(firMethod.getSource());
            $this$enhanceMethod_u24lambda_u2d14.setSession(this.session);
            $this$enhanceMethod_u24lambda_u2d14.setOrigin(FirDeclarationOrigin.Enhancement.INSTANCE);
            $this$enhanceMethod_u24lambda_u2d14.setReturnTypeRef(newReturnTypeRef);
            $this$enhanceMethod_u24lambda_u2d14.setReceiverTypeRef(newReceiverTypeRef);
            Intrinsics.checkNotNull(name);
            $this$enhanceMethod_u24lambda_u2d14.setName(name);
            $this$enhanceMethod_u24lambda_u2d14.setStatus(((FirJavaMethod)firMethod).getStatus());
            $this$enhanceMethod_u24lambda_u2d14.setSymbol(new FirNamedFunctionSymbol(methodId));
            $this$enhanceMethod_u24lambda_u2d14.setResolvePhase(FirResolvePhase.Companion.getANALYZED_DEPENDENCIES());
            FirSimpleFunctionBuilder firSimpleFunctionBuilder2 = $this$enhanceMethod_u24lambda_u2d14;
            object = firSimpleFunctionBuilder2.getValueParameters();
            boolean bl26 = false;
            CollectionsKt.addAll(object, newValueParameters);
            firSimpleFunctionBuilder2 = $this$enhanceMethod_u24lambda_u2d14;
            object = firSimpleFunctionBuilder2.getTypeParameters();
            iterable = ((FirJavaMethod)firMethod).getTypeParameters();
            boolean bl27 = false;
            CollectionsKt.addAll(object, iterable);
            $this$enhanceMethod_u24lambda_u2d14.setDispatchReceiverType(((FirJavaMethod)firMethod).getDispatchReceiverType());
            $this$enhanceMethod_u24lambda_u2d14.setAttributes(firMethod.getAttributes().copy());
            firFunctionBuilder = firSimpleFunctionBuilder;
        } else {
            throw new AssertionError((Object)Intrinsics.stringPlus("Unknown Java method to enhance: ", FirRendererKt.render$default(firMethod, null, 1, null)));
        }
        firFunction = firFunctionBuilder;
        boolean bl28 = false;
        boolean bl29 = false;
        FirFunction<?> $this$enhanceMethod_u24lambda_u2d15 = firFunction;
        boolean bl30 = false;
        FirFunction<?> firFunction2 = $this$enhanceMethod_u24lambda_u2d15;
        Collection collection = firFunction2.getAnnotations();
        object = firMethod.getAnnotations();
        boolean bl31 = false;
        CollectionsKt.addAll(collection, object);
        FirFunction<?> function2 = firFunction.build();
        return function2.getSymbol();
    }

    private final FirResolvedTypeRef enhanceReceiverType(FirJavaMethod ownerFunction, List<? extends FirCallableMemberDeclaration<?>> overriddenMembers, FirJavaEnhancementContext memberContext) {
        EnhancementSignatureParts.PartEnhancementResult signatureParts = EnhancementSignatureParts.enhance$java$default(this.partsForValueParameter(ownerFunction, this.typeQualifierResolver, overriddenMembers, ownerFunction, memberContext, TypeInSignature.Receiver.INSTANCE), this.session, this.jsr305State, null, false, 12, null);
        return signatureParts.getType();
    }

    private final EnhanceValueParameterResult enhanceValueParameter(FirFunction<?> ownerFunction, List<? extends FirCallableMemberDeclaration<?>> overriddenMembers, boolean hasReceiver, FirJavaEnhancementContext memberContext, PredefinedFunctionEnhancementInfo predefinedEnhancementInfo, FirJavaValueParameter ownerParameter, int index2) {
        FirExpression firExpression2;
        List<TypeEnhancementInfo> list2;
        PredefinedFunctionEnhancementInfo predefinedFunctionEnhancementInfo;
        EnhancementSignatureParts.PartEnhancementResult signatureParts = this.partsForValueParameter(ownerFunction, this.typeQualifierResolver, overriddenMembers, ownerParameter, memberContext, new TypeInSignature.ValueParameter(hasReceiver, index2)).enhance$java(this.session, this.jsr305State, (predefinedFunctionEnhancementInfo = predefinedEnhancementInfo) == null ? null : ((list2 = predefinedFunctionEnhancementInfo.getParametersInfo()) == null ? null : CollectionsKt.getOrNull(list2, index2)), this.owner.getClassKind() == ClassKind.ANNOTATION_CLASS);
        FirResolvedTypeRef firResolvedTypeRef = signatureParts.getType();
        AnnotationDefaultValue defaultValue2 = JavaTypeUtilsKt.getDefaultValueFromAnnotation(ownerParameter);
        if (Intrinsics.areEqual(defaultValue2, NullDefaultValue.INSTANCE)) {
            firExpression2 = FirConstExpressionBuilderKt.buildConstExpression$default(null, FirConstKind.Null.INSTANCE, null, null, 8, null);
        } else if (defaultValue2 instanceof StringDefaultValue) {
            firExpression2 = JavaTypeUtilsKt.lexicalCastFrom(firResolvedTypeRef.getType(), this.session, ((StringDefaultValue)defaultValue2).getValue());
        } else if (defaultValue2 == null) {
            firExpression2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        FirExpression defaultValueExpression = firExpression2;
        return new EnhanceValueParameterResult(firResolvedTypeRef, defaultValueExpression);
    }

    private final FirResolvedTypeRef enhanceReturnType(FirCallableMemberDeclaration<?> owner, List<? extends FirCallableMemberDeclaration<?>> overriddenMembers, FirJavaEnhancementContext memberContext, PredefinedFunctionEnhancementInfo predefinedEnhancementInfo) {
        PredefinedFunctionEnhancementInfo predefinedFunctionEnhancementInfo = predefinedEnhancementInfo;
        EnhancementSignatureParts.PartEnhancementResult signatureParts = EnhancementSignatureParts.enhance$java$default(this.parts(owner, this.typeQualifierResolver, overriddenMembers, owner, true, memberContext, owner instanceof FirJavaField ? AnnotationQualifierApplicabilityType.FIELD : AnnotationQualifierApplicabilityType.METHOD_RETURN_TYPE, TypeInSignature.Return.INSTANCE), this.session, this.jsr305State, predefinedFunctionEnhancementInfo == null ? null : predefinedFunctionEnhancementInfo.getReturnTypeInfo(), false, 8, null);
        return signatureParts.getType();
    }

    /*
     * WARNING - void declaration
     */
    private final EnhancementSignatureParts partsForValueParameter(FirFunction<?> $this$partsForValueParameter, FirAnnotationTypeQualifierResolver typeQualifierResolver, List<? extends FirCallableMemberDeclaration<?>> overriddenMembers, FirAnnotationContainer parameterContainer, FirJavaEnhancementContext methodContext2, TypeInSignature typeInSignature) {
        FirJavaEnhancementContext firJavaEnhancementContext;
        FirSignatureEnhancement firSignatureEnhancement = this;
        FirCallableMemberDeclaration firCallableMemberDeclaration = (FirCallableMemberDeclaration)((Object)$this$partsForValueParameter);
        FirAnnotationTypeQualifierResolver firAnnotationTypeQualifierResolver = typeQualifierResolver;
        List<FirCallableMemberDeclaration<?>> list2 = overriddenMembers;
        FirAnnotationContainer firAnnotationContainer = parameterContainer;
        boolean bl = false;
        FirAnnotationContainer firAnnotationContainer2 = parameterContainer;
        if (firAnnotationContainer2 == null) {
            firJavaEnhancementContext = methodContext2;
        } else {
            void it;
            FirAnnotationContainer firAnnotationContainer3 = firAnnotationContainer2;
            boolean bl2 = false;
            boolean bl3 = false;
            FirAnnotationContainer firAnnotationContainer4 = firAnnotationContainer3;
            boolean bl4 = bl;
            FirAnnotationContainer firAnnotationContainer5 = firAnnotationContainer;
            List<FirCallableMemberDeclaration<?>> list3 = list2;
            FirAnnotationTypeQualifierResolver firAnnotationTypeQualifierResolver2 = firAnnotationTypeQualifierResolver;
            FirCallableMemberDeclaration firCallableMemberDeclaration2 = firCallableMemberDeclaration;
            FirSignatureEnhancement firSignatureEnhancement2 = firSignatureEnhancement;
            boolean bl5 = false;
            FirJavaEnhancementContext firJavaEnhancementContext2 = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(methodContext2, typeQualifierResolver, this.jsr305State, it.getAnnotations());
            firSignatureEnhancement = firSignatureEnhancement2;
            firCallableMemberDeclaration = firCallableMemberDeclaration2;
            firAnnotationTypeQualifierResolver = firAnnotationTypeQualifierResolver2;
            list2 = list3;
            firAnnotationContainer = firAnnotationContainer5;
            bl = bl4;
            FirJavaEnhancementContext firJavaEnhancementContext3 = firJavaEnhancementContext2;
            firJavaEnhancementContext = firJavaEnhancementContext3 == null ? methodContext2 : firJavaEnhancementContext3;
        }
        return firSignatureEnhancement.parts(firCallableMemberDeclaration, firAnnotationTypeQualifierResolver, list2, firAnnotationContainer, bl, firJavaEnhancementContext, AnnotationQualifierApplicabilityType.VALUE_PARAMETER, typeInSignature);
    }

    /*
     * WARNING - void declaration
     */
    private final EnhancementSignatureParts parts(FirCallableMemberDeclaration<?> $this$parts, FirAnnotationTypeQualifierResolver typeQualifierResolver, List<? extends FirCallableMemberDeclaration<?>> overriddenMembers, FirAnnotationContainer typeContainer, boolean isCovariant, FirJavaEnhancementContext containerContext, AnnotationQualifierApplicabilityType containerApplicabilityType, TypeInSignature typeInSignature) {
        Collection<FirTypeRef> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        FirTypeRef typeRef = typeInSignature.getTypeRef($this$parts);
        Iterable iterable = overriddenMembers;
        FirJavaTypeRef firJavaTypeRef = (FirJavaTypeRef)typeRef;
        JavaTypeParameterStack javaTypeParameterStack = this.javaTypeParameterStack;
        FirAnnotationContainer firAnnotationContainer = typeContainer;
        FirAnnotationTypeQualifierResolver firAnnotationTypeQualifierResolver = typeQualifierResolver;
        boolean $i$f$map = false;
        void var12_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirCallableMemberDeclaration firCallableMemberDeclaration = (FirCallableMemberDeclaration)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            FirTypeRef firTypeRef = typeInSignature.getTypeRef((FirCallableMemberDeclaration<?>)it);
            collection.add(firTypeRef);
        }
        collection = (List)destination$iv$iv;
        AnnotationQualifierApplicabilityType annotationQualifierApplicabilityType = containerApplicabilityType;
        FirJavaEnhancementContext firJavaEnhancementContext = FirJavaEnhancementContextKt.copyWithNewDefaultTypeQualifiers(containerContext, typeQualifierResolver, this.jsr305State, ((FirJavaTypeRef)typeRef).getAnnotations());
        boolean bl = isCovariant;
        Collection collection2 = collection;
        FirJavaTypeRef firJavaTypeRef2 = firJavaTypeRef;
        JavaTypeParameterStack javaTypeParameterStack2 = javaTypeParameterStack;
        FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer;
        FirAnnotationTypeQualifierResolver firAnnotationTypeQualifierResolver2 = firAnnotationTypeQualifierResolver;
        return new EnhancementSignatureParts(firAnnotationTypeQualifierResolver2, firAnnotationContainer2, javaTypeParameterStack2, firJavaTypeRef2, collection2, bl, firJavaEnhancementContext, annotationQualifierApplicabilityType);
    }

    public static final /* synthetic */ FirSession access$getSession$p(FirSignatureEnhancement $this) {
        return $this.session;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$EnhanceValueParameterResult;", "", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "defaultValue", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "getDefaultValue", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getTypeRef", "()Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "java"})
    private static final class EnhanceValueParameterResult {
        @NotNull
        private final FirResolvedTypeRef typeRef;
        @Nullable
        private final FirExpression defaultValue;

        public EnhanceValueParameterResult(@NotNull FirResolvedTypeRef typeRef, @Nullable FirExpression defaultValue2) {
            Intrinsics.checkNotNullParameter(typeRef, "typeRef");
            this.typeRef = typeRef;
            this.defaultValue = defaultValue2;
        }

        @NotNull
        public final FirResolvedTypeRef getTypeRef() {
            return this.typeRef;
        }

        @Nullable
        public final FirExpression getDefaultValue() {
            return this.defaultValue;
        }

        @NotNull
        public final FirResolvedTypeRef component1() {
            return this.typeRef;
        }

        @Nullable
        public final FirExpression component2() {
            return this.defaultValue;
        }

        @NotNull
        public final EnhanceValueParameterResult copy(@NotNull FirResolvedTypeRef typeRef, @Nullable FirExpression defaultValue2) {
            Intrinsics.checkNotNullParameter(typeRef, "typeRef");
            return new EnhanceValueParameterResult(typeRef, defaultValue2);
        }

        public static /* synthetic */ EnhanceValueParameterResult copy$default(EnhanceValueParameterResult enhanceValueParameterResult, FirResolvedTypeRef firResolvedTypeRef, FirExpression firExpression2, int n, Object object) {
            if ((n & 1) != 0) {
                firResolvedTypeRef = enhanceValueParameterResult.typeRef;
            }
            if ((n & 2) != 0) {
                firExpression2 = enhanceValueParameterResult.defaultValue;
            }
            return enhanceValueParameterResult.copy(firResolvedTypeRef, firExpression2);
        }

        @NotNull
        public String toString() {
            return "EnhanceValueParameterResult(typeRef=" + this.typeRef + ", defaultValue=" + this.defaultValue + ')';
        }

        public int hashCode() {
            int result2 = this.typeRef.hashCode();
            result2 = result2 * 31 + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EnhanceValueParameterResult)) {
                return false;
            }
            EnhanceValueParameterResult enhanceValueParameterResult = (EnhanceValueParameterResult)other;
            if (!Intrinsics.areEqual(this.typeRef, enhanceValueParameterResult.typeRef)) {
                return false;
            }
            return Intrinsics.areEqual(this.defaultValue, enhanceValueParameterResult.defaultValue);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H&\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "", "()V", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "Receiver", "Return", "ValueParameter", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Return;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Receiver;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$ValueParameter;", "java"})
    private static abstract class TypeInSignature {
        private TypeInSignature() {
        }

        @NotNull
        public abstract FirTypeRef getTypeRef(@NotNull FirCallableMemberDeclaration<?> var1);

        public /* synthetic */ TypeInSignature(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Return;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "()V", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "java"})
        public static final class Return
        extends TypeInSignature {
            @NotNull
            public static final Return INSTANCE = new Return();

            private Return() {
                super(null);
            }

            @Override
            @NotNull
            public FirTypeRef getTypeRef(@NotNull FirCallableMemberDeclaration<?> member2) {
                Intrinsics.checkNotNullParameter(member2, "member");
                return member2.getReturnTypeRef();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$Receiver;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "()V", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "java"})
        public static final class Receiver
        extends TypeInSignature {
            @NotNull
            public static final Receiver INSTANCE = new Receiver();

            private Receiver() {
                super(null);
            }

            @Override
            @NotNull
            public FirTypeRef getTypeRef(@NotNull FirCallableMemberDeclaration<?> member2) {
                Intrinsics.checkNotNullParameter(member2, "member");
                if (member2 instanceof FirJavaMethod) {
                    return ((FirJavaMethod)member2).getValueParameters().get(0).getReturnTypeRef();
                }
                FirTypeRef firTypeRef = member2.getReceiverTypeRef();
                Intrinsics.checkNotNull(firTypeRef);
                return firTypeRef;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature$ValueParameter;", "Lorg/jetbrains/kotlin/fir/java/enhancement/FirSignatureEnhancement$TypeInSignature;", "hasReceiver", "", "index", "", "(ZI)V", "getHasReceiver", "()Z", "getIndex", "()I", "getTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "member", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "java"})
        public static final class ValueParameter
        extends TypeInSignature {
            private final boolean hasReceiver;
            private final int index;

            public ValueParameter(boolean hasReceiver, int index2) {
                super(null);
                this.hasReceiver = hasReceiver;
                this.index = index2;
            }

            public final boolean getHasReceiver() {
                return this.hasReceiver;
            }

            public final int getIndex() {
                return this.index;
            }

            @Override
            @NotNull
            public FirTypeRef getTypeRef(@NotNull FirCallableMemberDeclaration<?> member2) {
                Intrinsics.checkNotNullParameter(member2, "member");
                if (this.hasReceiver && member2 instanceof FirJavaMethod) {
                    return ((FirJavaMethod)member2).getValueParameters().get(this.index + 1).getReturnTypeRef();
                }
                return ((FirFunction)((Object)member2)).getValueParameters().get(this.index).getReturnTypeRef();
            }
        }
    }
}

