/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.resolver.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolveResult;
import org.jetbrains.kotlin.library.resolver.KotlinLibraryResolver;
import org.jetbrains.kotlin.library.resolver.KotlinResolvedLibrary;
import org.jetbrains.kotlin.library.resolver.impl.KotlinLibraryResolverResultImpl;
import org.jetbrains.kotlin.library.resolver.impl.KotlinResolvedLibraryImpl;
import org.jetbrains.kotlin.util.Logger;
import org.jetbrains.kotlin.util.WithLogger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J4\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J.\u0010\u0016\u001a\u00020\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0016\u0010\u001d\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0002J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f*\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0002J\u0012\u0010 \u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0002R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/library/resolver/impl/KotlinLibraryResolverImpl;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/resolver/KotlinLibraryResolver;", "Lorg/jetbrains/kotlin/util/WithLogger;", "searchPathResolver", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "(Lorg/jetbrains/kotlin/library/SearchPathResolver;)V", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "getLogger", "()Lorg/jetbrains/kotlin/util/Logger;", "getSearchPathResolver", "()Lorg/jetbrains/kotlin/library/SearchPathResolver;", "findLibraries", "", "unresolvedLibraries", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "noStdLib", "", "noDefaultLibs", "noEndorsedLibs", "resolveWithDependencies", "Lorg/jetbrains/kotlin/library/resolver/KotlinLibraryResolveResult;", "warnOnLibraryDuplicateNames", "", "duplicatedPaths", "", "", "warnOnLibraryDuplicates", "leaveDistinct", "omitDuplicateNames", "resolveDependencies", "kotlin-util-klib-metadata"})
public final class KotlinLibraryResolverImpl<L extends KotlinLibrary>
implements KotlinLibraryResolver<L>,
WithLogger {
    @NotNull
    private final SearchPathResolver<L> searchPathResolver;

    public KotlinLibraryResolverImpl(@NotNull SearchPathResolver<L> searchPathResolver) {
        Intrinsics.checkNotNullParameter(searchPathResolver, "searchPathResolver");
        this.searchPathResolver = searchPathResolver;
    }

    @Override
    @NotNull
    public SearchPathResolver<L> getSearchPathResolver() {
        return this.searchPathResolver;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.searchPathResolver.getLogger();
    }

    @Override
    @NotNull
    public KotlinLibraryResolveResult resolveWithDependencies(@NotNull List<UnresolvedLibrary> unresolvedLibraries, boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs) {
        Intrinsics.checkNotNullParameter(unresolvedLibraries, "unresolvedLibraries");
        return this.resolveDependencies(this.omitDuplicateNames(this.leaveDistinct(this.findLibraries(unresolvedLibraries, noStdLib, noDefaultLibs, noEndorsedLibs))));
    }

    private final List<KotlinLibrary> findLibraries(List<UnresolvedLibrary> unresolvedLibraries, boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs) {
        List userProvidedLibraries2 = SequencesKt.toList(SequencesKt.map(CollectionsKt.asSequence((Iterable)unresolvedLibraries), new Function1<UnresolvedLibrary, L>(this){
            final /* synthetic */ KotlinLibraryResolverImpl<L> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final L invoke(@NotNull UnresolvedLibrary it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return (L)SearchPathResolver.DefaultImpls.resolve$default(this.this$0.getSearchPathResolver(), it, false, 2, null);
            }
        }));
        List<L> defaultLibraries = this.getSearchPathResolver().defaultLinks(noStdLib, noDefaultLibs, noEndorsedLibs);
        return CollectionsKt.plus((Collection)userProvidedLibraries2, (Iterable)defaultLibraries);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KotlinLibrary> leaveDistinct(List<? extends KotlinLibrary> $this$leaveDistinct) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$leaveDistinct;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            KotlinLibrary it2 = (KotlinLibrary)element$iv$iv;
            boolean bl5 = false;
            String key$iv$iv = it2.getLibraryFile().getAbsolutePath();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map map = destination$iv$iv;
        boolean bl = false;
        boolean bl3 = false;
        Map groupedByAbsolutePath = map;
        boolean bl4 = false;
        Map map2 = groupedByAbsolutePath;
        Object object = this;
        boolean $i$f$filter = false;
        void bl5 = $this$filter$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var13_18 = $this$filterTo$iv$iv;
        boolean bl6 = false;
        Iterator iterator2 = var13_18.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator2.next();
            boolean bl7 = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object object2 = destination$iv$iv2;
        ((KotlinLibraryResolverImpl)object).warnOnLibraryDuplicates(object2.keySet());
        Map $this$map$iv = groupedByAbsolutePath;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        var13_18 = $this$mapTo$iv$iv;
        bl6 = false;
        for (Map.Entry item$iv$iv : var13_18.entrySet()) {
            it = item$iv$iv;
            object = destination$iv$iv2;
            boolean bl8 = false;
            object2 = (KotlinLibrary)CollectionsKt.first((List)it.getValue());
            object.add(object2);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KotlinLibrary> omitDuplicateNames(List<? extends KotlinLibrary> $this$omitDuplicateNames) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = $this$omitDuplicateNames;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            KotlinLibrary it2 = (KotlinLibrary)element$iv$iv;
            boolean bl5 = false;
            String key$iv$iv = KotlinLibraryKt.getUniqueName(it2);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map map = destination$iv$iv;
        boolean bl = false;
        boolean bl3 = false;
        Map groupedByUniqName = map;
        boolean bl4 = false;
        Map map2 = groupedByUniqName;
        Object object = this;
        boolean $i$f$filter = false;
        void bl5 = $this$filter$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var13_18 = $this$filterTo$iv$iv;
        boolean bl6 = false;
        Iterator iterator2 = var13_18.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator2.next();
            boolean bl7 = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Object object2 = destination$iv$iv2;
        ((KotlinLibraryResolverImpl)object).warnOnLibraryDuplicateNames(object2.keySet());
        Map $this$map$iv = groupedByUniqName;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        var13_18 = $this$mapTo$iv$iv;
        bl6 = false;
        for (Map.Entry item$iv$iv : var13_18.entrySet()) {
            it = item$iv$iv;
            object = destination$iv$iv2;
            boolean bl8 = false;
            object2 = (KotlinLibrary)CollectionsKt.first((List)it.getValue());
            object.add(object2);
        }
        return (List)destination$iv$iv2;
    }

    private final void warnOnLibraryDuplicates(Iterable<String> duplicatedPaths) {
        Iterable<String> $this$forEach$iv = duplicatedPaths;
        boolean $i$f$forEach = false;
        Iterator<String> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            String element$iv;
            String it = element$iv = iterator2.next();
            boolean bl = false;
            this.getLogger().warning(Intrinsics.stringPlus("library included more than once: ", it));
        }
    }

    private final void warnOnLibraryDuplicateNames(Iterable<String> duplicatedPaths) {
        Iterable<String> $this$forEach$iv = duplicatedPaths;
        boolean $i$f$forEach = false;
        Iterator<String> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            String element$iv;
            String it = element$iv = iterator2.next();
            boolean bl = false;
            this.getLogger().warning(Intrinsics.stringPlus("duplicate library name: ", it));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinLibraryResolveResult resolveDependencies(List<? extends KotlinLibrary> $this$resolveDependencies) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list2;
        Object object;
        void $this$mapTo$iv$iv222;
        Iterable $this$map$iv2 = $this$resolveDependencies;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv222) {
            Iterator it;
            KotlinLibrary kotlinLibrary = (KotlinLibrary)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            list2 = new KotlinResolvedLibraryImpl((KotlinLibrary)((Object)it));
            object.add(list2);
        }
        List rootLibraries = (List)destination$iv$iv;
        KotlinLibraryResolverResultImpl result2 = new KotlinLibraryResolverResultImpl(rootLibraries);
        boolean $this$mapTo$iv$iv222 = false;
        Map cache2 = new LinkedHashMap();
        Iterable $this$mapTo$iv$iv222 = rootLibraries;
        object = cache2;
        boolean $i$f$map2 = false;
        void $i$f$mapTo22 = $this$map$iv;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinResolvedLibraryImpl kotlinResolvedLibraryImpl = (KotlinResolvedLibraryImpl)item$iv$iv;
            list2 = destination$iv$iv2;
            boolean bl = false;
            Pair<File, void> pair = TuplesKt.to(it.getLibrary().getLibraryFile().getAbsoluteFile(), it);
            list2.add(pair);
        }
        list2 = (List)destination$iv$iv2;
        MapsKt.putAll(object, list2);
        List newDependencies = rootLibraries;
        do {
            void $this$mapTo$iv$iv3;
            Iterable $this$map$iv3 = newDependencies;
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void library;
                KotlinResolvedLibraryImpl bl = (KotlinResolvedLibraryImpl)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl2 = false;
                list2 = SequencesKt.toList(SequencesKt.filterNotNull(SequencesKt.map(SequencesKt.map(SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)KotlinLibraryKt.getUnresolvedDependencies(library.getLibrary())), (Function1)new Function1<UnresolvedLibrary, Boolean>(this){
                    final /* synthetic */ KotlinLibraryResolverImpl<L> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final boolean invoke(@NotNull UnresolvedLibrary it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.this$0.getSearchPathResolver().isProvidedByDefault(it);
                    }
                }), (Function1)new Function1<UnresolvedLibrary, KotlinResolvedLibraryImpl>(this){
                    final /* synthetic */ KotlinLibraryResolverImpl<L> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final KotlinResolvedLibraryImpl invoke(@NotNull UnresolvedLibrary it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return new KotlinResolvedLibraryImpl(SearchPathResolver.DefaultImpls.resolve$default(this.this$0.getSearchPathResolver(), it, false, 2, null));
                    }
                }), (Function1)new Function1<KotlinResolvedLibraryImpl, KotlinResolvedLibraryImpl>((Map<File, KotlinResolvedLibrary>)cache2, (KotlinResolvedLibraryImpl)library){
                    final /* synthetic */ Map<File, KotlinResolvedLibrary> $cache;
                    final /* synthetic */ KotlinResolvedLibraryImpl $library;
                    {
                        this.$cache = $cache;
                        this.$library = $library;
                        super(1);
                    }

                    @Nullable
                    public final KotlinResolvedLibraryImpl invoke(@NotNull KotlinResolvedLibraryImpl resolved) {
                        KotlinResolvedLibraryImpl kotlinResolvedLibraryImpl;
                        Intrinsics.checkNotNullParameter(resolved, "resolved");
                        File absoluteFile = resolved.getLibrary().getLibraryFile().getAbsoluteFile();
                        Object object = this.$cache;
                        boolean bl = false;
                        Map<File, KotlinResolvedLibrary> map = object;
                        boolean bl2 = false;
                        if (map.containsKey(absoluteFile)) {
                            object = this.$cache.get(absoluteFile);
                            Intrinsics.checkNotNull(object);
                            this.$library.addDependency$kotlin_util_klib_metadata((KotlinResolvedLibrary)object);
                            kotlinResolvedLibraryImpl = null;
                        } else {
                            this.$cache.put(absoluteFile, resolved);
                            this.$library.addDependency$kotlin_util_klib_metadata(resolved);
                            kotlinResolvedLibraryImpl = resolved;
                        }
                        return kotlinResolvedLibraryImpl;
                    }
                })));
                object.add(list2);
            }
            newDependencies = CollectionsKt.flatten((List)destination$iv$iv3);
            collection = newDependencies;
            boolean bl = false;
        } while (!collection.isEmpty());
        return result2;
    }
}

