/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis;

import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\tJ\u0012\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011*\u00020\u0004H\u0002R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/LighterTreeElementFinderByType;", "", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "Lcom/intellij/lang/LighterASTNode;", "types", "", "Lcom/intellij/psi/tree/IElementType;", "index", "", "depth", "(Lcom/intellij/util/diff/FlyweightCapableTreeStructure;Ljava/util/Collection;II)V", "find", "node", "visitNode", "currentDepth", "getChildren", "", "checkers"})
public final class LighterTreeElementFinderByType {
    @NotNull
    private final FlyweightCapableTreeStructure<LighterASTNode> tree;
    @NotNull
    private Collection<? extends IElementType> types;
    private int index;
    private final int depth;

    public LighterTreeElementFinderByType(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull Collection<? extends IElementType> types2, int index2, int depth) {
        Intrinsics.checkNotNullParameter(tree, "tree");
        Intrinsics.checkNotNullParameter(types2, "types");
        this.tree = tree;
        this.types = types2;
        this.index = index2;
        this.depth = depth;
    }

    @Nullable
    public final LighterASTNode find(@Nullable LighterASTNode node) {
        if (node == null) {
            return null;
        }
        return this.visitNode(node, 0);
    }

    @Nullable
    public final LighterASTNode visitNode(@NotNull LighterASTNode node, int currentDepth) {
        Intrinsics.checkNotNullParameter(node, "node");
        if (this.types.contains(node.getTokenType())) {
            if (this.index == 0) {
                return node;
            }
            LighterTreeElementFinderByType lighterTreeElementFinderByType = this;
            int n = lighterTreeElementFinderByType.index;
            lighterTreeElementFinderByType.index = n + -1;
        }
        if (currentDepth == this.depth) {
            return null;
        }
        for (LighterASTNode child : this.getChildren(node)) {
            LighterASTNode result2 = this.visitNode(child, currentDepth + 1);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    private final List<LighterASTNode> getChildren(LighterASTNode $this$getChildren) {
        Ref<T[]> ref = new Ref<T[]>();
        this.tree.getChildren($this$getChildren, ref);
        LighterASTNode[] lighterASTNodeArray = (LighterASTNode[])ref.get();
        List<LighterASTNode> list2 = lighterASTNodeArray == null ? null : ArraysKt.filterNotNull(lighterASTNodeArray);
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }
}

