/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyAccessorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkGetter", "property", "checkSetter", "checkers"})
public final class FirPropertyAccessorChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirPropertyAccessorChecker INSTANCE = new FirPropertyAccessorChecker();

    private FirPropertyAccessorChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.checkGetter(declaration2, context2, reporter);
        this.checkSetter(declaration2, context2, reporter);
    }

    private final void checkGetter(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter) {
        List<String> list2;
        FirAnnotationContainer firAnnotationContainer;
        FirPropertyAccessor firPropertyAccessor = property2.getGetter();
        if (firPropertyAccessor == null) {
            return;
        }
        FirPropertyAccessor getter2 = firPropertyAccessor;
        boolean $i$f$withSuppressedDiagnostics = false;
        FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer = (FirElement)getter2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)getter2) : null;
        if (firAnnotationContainer == null) {
            list2 = null;
        } else {
            FirAnnotationContainer firAnnotationContainer3 = firAnnotationContainer;
            boolean bl = false;
            boolean bl2 = false;
            FirAnnotationContainer it$iv = firAnnotationContainer3;
            boolean bl3 = false;
            list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
        }
        List<String> arguments$iv = list2;
        if (arguments$iv != null) {
            CheckerContext it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            boolean bl = false;
            FirMemberDeclaration $this$visibility$iv = getter2;
            boolean $i$f$getVisibility = false;
            Visibility visibility2 = ((FirPropertyAccessor)$this$visibility$iv).getStatus().getVisibility();
            $this$visibility$iv = property2;
            $i$f$getVisibility = false;
            if (!Intrinsics.areEqual(visibility2, $this$visibility$iv.getStatus().getVisibility())) {
                DiagnosticReporterKt.reportOn(reporter, getter2.getSource(), FirErrors.INSTANCE.getGETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY(), context2);
            }
        } else {
            CheckerContext it = context2;
            boolean bl = false;
            FirMemberDeclaration $this$visibility$iv = getter2;
            boolean $i$f$getVisibility = false;
            Visibility visibility3 = ((FirPropertyAccessor)$this$visibility$iv).getStatus().getVisibility();
            $this$visibility$iv = property2;
            $i$f$getVisibility = false;
            if (!Intrinsics.areEqual(visibility3, $this$visibility$iv.getStatus().getVisibility())) {
                DiagnosticReporterKt.reportOn(reporter, getter2.getSource(), FirErrors.INSTANCE.getGETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY(), context2);
            }
        }
    }

    private final void checkSetter(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter) {
        List<String> list2;
        FirAnnotationContainer firAnnotationContainer;
        FirPropertyAccessor firPropertyAccessor = property2.getSetter();
        if (firPropertyAccessor == null) {
            return;
        }
        FirPropertyAccessor setter2 = firPropertyAccessor;
        boolean $i$f$withSuppressedDiagnostics = false;
        FirAnnotationContainer firAnnotationContainer2 = firAnnotationContainer = (FirElement)setter2 instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)setter2) : null;
        if (firAnnotationContainer == null) {
            list2 = null;
        } else {
            FirAnnotationContainer firAnnotationContainer3 = firAnnotationContainer;
            boolean bl = false;
            boolean bl2 = false;
            FirAnnotationContainer it$iv = firAnnotationContainer3;
            boolean bl3 = false;
            list2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
        }
        List<String> arguments$iv = list2;
        if (arguments$iv != null) {
            FirValueParameter valueSetterParameter;
            CheckerContext it = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            boolean bl = false;
            if (property2.isVal()) {
                DiagnosticReporterKt.reportOn(reporter, setter2.getSource(), FirErrors.INSTANCE.getVAL_WITH_SETTER(), context2);
            }
            if ((valueSetterParameter = CollectionsKt.first(setter2.getValueParameters())).isVararg()) {
                return;
            }
            ConeKotlinType valueSetterType = FirTypeUtilsKt.getConeType(valueSetterParameter.getReturnTypeRef());
            FirSourceElement valueSetterTypeSource = valueSetterParameter.getReturnTypeRef().getSource();
            ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!Intrinsics.areEqual(valueSetterType, propertyType)) {
                List<String> list3;
                FirAnnotationContainer firAnnotationContainer4;
                boolean $i$f$withSuppressedDiagnostics2 = false;
                FirAnnotationContainer firAnnotationContainer5 = firAnnotationContainer4 = (FirElement)valueSetterParameter instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)valueSetterParameter) : null;
                if (firAnnotationContainer4 == null) {
                    list3 = null;
                } else {
                    FirAnnotationContainer firAnnotationContainer6 = firAnnotationContainer4;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    FirAnnotationContainer it$iv = firAnnotationContainer6;
                    boolean bl6 = false;
                    list3 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                List<String> arguments$iv2 = list3;
                if (arguments$iv2 != null) {
                    CheckerContext it2 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv2, arguments$iv2.contains("infos"), arguments$iv2.contains("warnings"), arguments$iv2.contains("errors"));
                    boolean bl7 = false;
                    DiagnosticReporterKt.reportOn(reporter, valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), propertyType, valueSetterType, context2);
                } else {
                    CheckerContext it3 = context2;
                    boolean bl8 = false;
                    DiagnosticReporterKt.reportOn(reporter, valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), propertyType, valueSetterType, context2);
                }
            }
            ConeKotlinType setterReturnType = FirTypeUtilsKt.getConeType(setter2.getReturnTypeRef());
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!ConeTypeUtilsKt.isUnit(setterReturnType)) {
                DiagnosticReporterKt.reportOn(reporter, setter2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), context2);
            }
        } else {
            FirValueParameter valueSetterParameter;
            CheckerContext it = context2;
            boolean bl = false;
            if (property2.isVal()) {
                DiagnosticReporterKt.reportOn(reporter, setter2.getSource(), FirErrors.INSTANCE.getVAL_WITH_SETTER(), context2);
            }
            if ((valueSetterParameter = CollectionsKt.first(setter2.getValueParameters())).isVararg()) {
                return;
            }
            ConeKotlinType valueSetterType = FirTypeUtilsKt.getConeType(valueSetterParameter.getReturnTypeRef());
            FirSourceElement valueSetterTypeSource = valueSetterParameter.getReturnTypeRef().getSource();
            ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!Intrinsics.areEqual(valueSetterType, propertyType)) {
                List<String> list4;
                FirAnnotationContainer firAnnotationContainer7;
                boolean $i$f$withSuppressedDiagnostics3 = false;
                FirAnnotationContainer firAnnotationContainer8 = firAnnotationContainer7 = (FirElement)valueSetterParameter instanceof FirAnnotationContainer ? (FirAnnotationContainer)((FirElement)valueSetterParameter) : null;
                if (firAnnotationContainer7 == null) {
                    list4 = null;
                } else {
                    FirAnnotationContainer firAnnotationContainer9 = firAnnotationContainer7;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    FirAnnotationContainer it$iv = firAnnotationContainer9;
                    boolean bl11 = false;
                    list4 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(it$iv);
                }
                List<String> arguments$iv3 = list4;
                if (arguments$iv3 != null) {
                    CheckerContext it4 = context2.addSuppressedDiagnostics((Collection<String>)arguments$iv3, arguments$iv3.contains("infos"), arguments$iv3.contains("warnings"), arguments$iv3.contains("errors"));
                    boolean bl12 = false;
                    DiagnosticReporterKt.reportOn(reporter, valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), propertyType, valueSetterType, context2);
                } else {
                    CheckerContext it5 = context2;
                    boolean bl13 = false;
                    DiagnosticReporterKt.reportOn(reporter, valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), propertyType, valueSetterType, context2);
                }
            }
            ConeKotlinType setterReturnType = FirTypeUtilsKt.getConeType(setter2.getReturnTypeRef());
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!ConeTypeUtilsKt.isUnit(setterReturnType)) {
                DiagnosticReporterKt.reportOn(reporter, setter2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), context2);
            }
        }
    }
}

