/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.containers.Interner;
import com.intellij.util.containers.MultiMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.Position;
import org.jetbrains.kotlin.incremental.components.ScopeKind;
import org.jetbrains.kotlin.utils.PlatformUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a#\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00060\u00060\b\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/incremental/LookupTrackerImpl;", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "delegate", "(Lorg/jetbrains/kotlin/incremental/components/LookupTracker;)V", "interner", "Lcom/intellij/util/containers/Interner;", "", "lookups", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getLookups", "()Lcom/intellij/util/containers/MultiMap;", "pathInterner", "getPathInterner", "()Lcom/intellij/util/containers/Interner;", "requiresPosition", "", "getRequiresPosition", "()Z", "record", "", "filePath", "position", "Lorg/jetbrains/kotlin/incremental/components/Position;", "scopeFqName", "scopeKind", "Lorg/jetbrains/kotlin/incremental/components/ScopeKind;", "name", "kotlin-build-common"})
public final class LookupTrackerImpl
implements LookupTracker {
    @NotNull
    private final LookupTracker delegate;
    @NotNull
    private final MultiMap<LookupSymbol, String> lookups;
    @NotNull
    private final Interner<String> pathInterner;
    @NotNull
    private final Interner<String> interner;

    public LookupTrackerImpl(@NotNull LookupTracker delegate2) {
        Intrinsics.checkNotNullParameter(delegate2, "delegate");
        this.delegate = delegate2;
        MultiMap multiMap = MultiMap.createSet();
        Intrinsics.checkNotNullExpressionValue(multiMap, "createSet<LookupSymbol, String>()");
        this.lookups = multiMap;
        this.pathInterner = PlatformUtilsKt.createStringInterner();
        this.interner = PlatformUtilsKt.createStringInterner();
    }

    @NotNull
    public final MultiMap<LookupSymbol, String> getLookups() {
        return this.lookups;
    }

    @NotNull
    public final Interner<String> getPathInterner() {
        return this.pathInterner;
    }

    @Override
    public boolean getRequiresPosition() {
        return this.delegate.getRequiresPosition();
    }

    @Override
    public void record(@NotNull String filePath, @NotNull Position position, @NotNull String scopeFqName, @NotNull ScopeKind scopeKind, @NotNull String name) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(scopeFqName, "scopeFqName");
        Intrinsics.checkNotNullParameter((Object)scopeKind, "scopeKind");
        Intrinsics.checkNotNullParameter(name, "name");
        String string2 = this.interner.intern(scopeFqName);
        Intrinsics.checkNotNullExpressionValue(string2, "interner.intern(scopeFqName)");
        String internedScopeFqName = string2;
        String string3 = this.interner.intern(name);
        Intrinsics.checkNotNullExpressionValue(string3, "interner.intern(name)");
        String internedName = string3;
        String string4 = this.pathInterner.intern(filePath);
        Intrinsics.checkNotNullExpressionValue(string4, "pathInterner.intern(filePath)");
        String internedFilePath = string4;
        this.lookups.putValue(new LookupSymbol(internedName, internedScopeFqName), internedFilePath);
        this.delegate.record(internedFilePath, position, internedScopeFqName, scopeKind, internedName);
    }
}

