/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrDeclarationDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012$\u0010\u0010\u001a \u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u0014\u0012\u0004\u0012\u00020\u000f0\u0011\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0012J\u0006\u0010(\u001a\u00020&J\u0006\u0010)\u001a\u00020&R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u001fj\b\u0012\u0004\u0012\u00020\u0012` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState;", "", "linker", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "fileReader", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "deserializeBodies", "", "allowErrorNodes", "deserializeInlineFunctions", "moduleDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "handleNoModuleDeserializerFound", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;ZZZLorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;Lkotlin/jvm/functions/Function3;)V", "declarationDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;", "fileDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "getFileDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "getLinker", "()Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "reachableTopLevels", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "symbolDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "getSymbolDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "addIdSignature", "", "key", "deserializeAllFileReachableTopLevel", "enqueueAllDeclarations", "ir.serialization.common"})
public final class FileDeserializationState {
    @NotNull
    private final KotlinIrLinker linker;
    @NotNull
    private final IrSymbolDeserializer symbolDeserializer;
    @NotNull
    private final IrDeclarationDeserializer declarationDeserializer;
    @NotNull
    private final IrFileDeserializer fileDeserializer;
    @NotNull
    private final LinkedHashSet<IdSignature> reachableTopLevels;

    public FileDeserializationState(@NotNull KotlinIrLinker linker, @NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull IrLibraryFile fileReader, @NotNull IrFile fileProto, boolean deserializeBodies, boolean allowErrorNodes, boolean deserializeInlineFunctions, @NotNull IrModuleDeserializer moduleDeserializer, @NotNull Function3<? super IdSignature, ? super ModuleDescriptor, ? super Collection<? extends IrModuleDeserializer>, ? extends IrModuleDeserializer> handleNoModuleDeserializerFound) {
        Intrinsics.checkNotNullParameter(linker, "linker");
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(fileReader, "fileReader");
        Intrinsics.checkNotNullParameter(fileProto, "fileProto");
        Intrinsics.checkNotNullParameter(moduleDeserializer, "moduleDeserializer");
        Intrinsics.checkNotNullParameter(handleNoModuleDeserializerFound, "handleNoModuleDeserializerFound");
        this.linker = linker;
        ReferenceSymbolTable referenceSymbolTable = this.linker.getSymbolTable();
        List<Serializable> list2 = fileProto.getActualsList();
        Intrinsics.checkNotNullExpressionValue(list2, "fileProto.actualsList");
        this.symbolDeserializer = new IrSymbolDeserializer(referenceSymbolTable, fileReader, list2, (Function1<? super IdSignature, Unit>)new Function1<IdSignature, Unit>(this){

            public final void invoke(@NotNull IdSignature p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((FileDeserializationState)this.receiver).addIdSignature(p0);
            }

            @NotNull
            public final String getSignature() {
                return "addIdSignature(Lorg/jetbrains/kotlin/ir/util/IdSignature;)V";
            }

            @NotNull
            public final String getName() {
                return "addIdSignature";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(FileDeserializationState.class);
            }
        }, (Function2<? super IdSignature, ? super IrSymbol, ? extends IrSymbol>)new Function2<IdSignature, IrSymbol, IrSymbol>(this.linker){

            @NotNull
            public final IrSymbol invoke(@NotNull IdSignature p0, @NotNull IrSymbol p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((KotlinIrLinker)this.receiver).handleExpectActualMapping(p0, p1);
            }

            @NotNull
            public final String getSignature() {
                return "handleExpectActualMapping(Lorg/jetbrains/kotlin/ir/util/IdSignature;Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;";
            }

            @NotNull
            public final String getName() {
                return "handleExpectActualMapping";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(KotlinIrLinker.class);
            }
        }, (Function2<? super IdSignature, ? super BinarySymbolData.SymbolKind, ? extends IrSymbol>)new Function2<IdSignature, BinarySymbolData.SymbolKind, IrSymbol>(moduleDeserializer, handleNoModuleDeserializerFound){
            final /* synthetic */ IrModuleDeserializer $moduleDeserializer;
            final /* synthetic */ Function3<IdSignature, ModuleDescriptor, Collection<? extends IrModuleDeserializer>, IrModuleDeserializer> $handleNoModuleDeserializerFound;
            {
                this.$moduleDeserializer = $moduleDeserializer;
                this.$handleNoModuleDeserializerFound = $handleNoModuleDeserializerFound;
                super(2);
            }

            @NotNull
            public final IrSymbol invoke(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
                Intrinsics.checkNotNullParameter(idSig, "idSig");
                Intrinsics.checkNotNullParameter((Object)((Object)symbolKind), "symbolKind");
                boolean bl = idSig.isPublic();
                boolean bl2 = false;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl4 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                IdSignature topLevelSig = idSig.topLevelSignature();
                IrModuleDeserializer irModuleDeserializer = BasicIrModuleDeserializerKt.findModuleDeserializerForTopLevelId(this.$moduleDeserializer, topLevelSig);
                IrModuleDeserializer actualModuleDeserializer = irModuleDeserializer == null ? this.$handleNoModuleDeserializerFound.invoke(idSig, this.$moduleDeserializer.getModuleDescriptor(), this.$moduleDeserializer.getModuleDependencies()) : irModuleDeserializer;
                return actualModuleDeserializer.deserializeIrSymbol(idSig, symbolKind);
            }
        });
        this.declarationDeserializer = new IrDeclarationDeserializer(this.linker.getBuiltIns(), this.linker.getSymbolTable(), this.linker.getSymbolTable().getIrFactory(), fileReader, file2, allowErrorNodes, deserializeInlineFunctions, deserializeBodies, this.symbolDeserializer, this.linker.getFakeOverrideBuilder().getPlatformSpecificClassFilter(), this.linker.getFakeOverrideBuilder(), false, 2048, null);
        this.fileDeserializer = new IrFileDeserializer(file2, fileReader, fileProto, this.symbolDeserializer, this.declarationDeserializer);
        this.reachableTopLevels = new LinkedHashSet();
        list2 = fileProto.getExplicitlyExportedToCompilerList();
        Intrinsics.checkNotNullExpressionValue(list2, "fileProto.explicitlyExportedToCompilerList");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Long it = (Long)element$iv;
            boolean bl = false;
            IrSymbolDeserializer irSymbolDeserializer = this.getSymbolDeserializer();
            Intrinsics.checkNotNullExpressionValue(it, "it");
            long symbolData = irSymbolDeserializer.parseSymbolData-9x8F8T0(it);
            IdSignature sig = this.getSymbolDeserializer().deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
            boolean bl2 = !sig.isPackageSignature();
            boolean bl3 = false;
            boolean bl4 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl5 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            this.addIdSignature(sig.topLevelSignature());
        }
    }

    @NotNull
    public final KotlinIrLinker getLinker() {
        return this.linker;
    }

    @NotNull
    public final IrSymbolDeserializer getSymbolDeserializer() {
        return this.symbolDeserializer;
    }

    @NotNull
    public final IrFileDeserializer getFileDeserializer() {
        return this.fileDeserializer;
    }

    public final void addIdSignature(@NotNull IdSignature key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.reachableTopLevels.add(key);
    }

    public final void enqueueAllDeclarations() {
        this.reachableTopLevels.addAll((Collection<IdSignature>)this.fileDeserializer.getReversedSignatureIndex().keySet());
    }

    public final void deserializeAllFileReachableTopLevel() {
        while (true) {
            Collection collection = this.reachableTopLevels;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            IdSignature reachableKey = (IdSignature)CollectionsKt.first((Iterable)this.reachableTopLevels);
            IrSymbol existedSymbol = this.symbolDeserializer.getDeserializedSymbols().get(reachableKey);
            if (existedSymbol == null || !existedSymbol.isBound()) {
                this.fileDeserializer.deserializeDeclaration$ir_serialization_common(reachableKey);
            }
            this.reachableTopLevels.remove(reachableKey);
        }
    }
}

