/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.backend.js.utils.StableNamesCollector;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001BW\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u0007J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0018J\u000e\u0010!\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\"J\"\u0010#\u001a\u00020\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040%J\b\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J8\u0010+\u001a\u00020\u001a\"\u0004\b\u0000\u0010,\"\u0004\b\u0001\u0010-*\u000e\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u0002H-0\n2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u0002H-0/H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTables;", "", "packages", "", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "reservedForGlobal", "", "", "reservedForMember", "mappedNames", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Ljava/lang/Iterable;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "globalNames", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getGlobalNames", "()Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "loopNames", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "getMappedNames", "()Ljava/util/Map;", "memberNames", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "acceptNonExternalClass", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "dump", "generateNameForMemberField", "field", "getNameForMemberField", "getNameForStaticDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "merge", "files", "", "additionalPackages", "packagesAdded", "", "processNonTopLevelLocalDecl", "processTopLevelLocalDecl", "addAllIfAbsent", "T", "K", "other", "", "backend.js"})
public final class NameTables {
    @Nullable
    private final Map<String, String> mappedNames;
    @Nullable
    private final JsIrBackendContext context;
    @NotNull
    private final NameTable<IrDeclaration> globalNames;
    @NotNull
    private final NameTable<IrField> memberNames;
    @NotNull
    private final Map<IrLoop, String> loopNames;

    public NameTables(@NotNull Iterable<? extends IrPackageFragment> packages2, @NotNull Set<String> reservedForGlobal, @NotNull Set<String> reservedForMember, @Nullable Map<String, String> mappedNames, @Nullable JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(packages2, "packages");
        Intrinsics.checkNotNullParameter(reservedForGlobal, "reservedForGlobal");
        Intrinsics.checkNotNullParameter(reservedForMember, "reservedForMember");
        this.mappedNames = mappedNames;
        this.context = context2;
        boolean bl = false;
        this.loopNames = new LinkedHashMap();
        StableNamesCollector stableNamesCollector = new StableNamesCollector();
        Iterable<? extends IrPackageFragment> $this$forEach$iv = packages2;
        boolean bl2 = false;
        Iterator<IrSymbolOwner> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IrPackageFragment element$iv;
            IrPackageFragment it = element$iv = iterator2.next();
            boolean bl22 = false;
            IrElementVisitorVoidKt.acceptChildrenVoid(it, stableNamesCollector);
        }
        this.globalNames = new NameTable(null, CollectionsKt.toMutableSet((Iterable)SetsKt.plus(stableNamesCollector.getStaticNames(), (Iterable)reservedForGlobal)), this.mappedNames, 1, null);
        this.memberNames = new NameTable(null, CollectionsKt.toMutableSet((Iterable)SetsKt.plus(stableNamesCollector.getMemberNames(), (Iterable)reservedForMember)), this.mappedNames, 1, null);
        for (IrPackageFragment irPackageFragment : packages2) {
            for (IrDeclaration declaration2 : irPackageFragment.getDeclarations()) {
                this.processTopLevelLocalDecl(declaration2);
                this.processNonTopLevelLocalDecl(declaration2);
                IrElementVisitorVoidKt.acceptChildrenVoid(declaration2, new IrElementVisitorVoid(){

                    @Override
                    public void visitElement(@NotNull IrElement element) {
                        Intrinsics.checkNotNullParameter(element, "element");
                        IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
                    }

                    @Override
                    public void visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                        Intrinsics.checkNotNullParameter(declaration2, "declaration");
                        this.processNonTopLevelLocalDecl(declaration2);
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
                    }

                    @Override
                    public <T> void visitConst(@NotNull IrConst<T> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                    }

                    @Override
                    public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
                    }

                    @Override
                    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
                    }

                    @Override
                    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
                    }

                    @Override
                    public void visitBlock(@NotNull IrBlock expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                    }

                    @Override
                    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
                    }

                    @Override
                    public void visitBlockBody(@NotNull IrBlockBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
                    }

                    @Override
                    public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
                    }

                    @Override
                    public void visitBody(@NotNull IrBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
                    }

                    @Override
                    public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
                    }

                    @Override
                    public void visitBranch(@NotNull IrBranch branch) {
                        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                    }

                    @Override
                    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
                    }

                    @Override
                    public void visitBreak(@NotNull IrBreak jump) {
                        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                    }

                    @Override
                    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
                    }

                    @Override
                    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                    }

                    @Override
                    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
                    }

                    @Override
                    public void visitCall(@NotNull IrCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
                    }

                    @Override
                    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
                    }

                    @Override
                    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                    }

                    @Override
                    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
                    }

                    @Override
                    public void visitCatch(@NotNull IrCatch aCatch) {
                        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                    }

                    @Override
                    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
                    }

                    @Override
                    public void visitClass(@NotNull IrClass declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
                    }

                    @Override
                    public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
                    }

                    @Override
                    public void visitClassReference(@NotNull IrClassReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                    }

                    @Override
                    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
                    }

                    @Override
                    public void visitComposite(@NotNull IrComposite expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                    }

                    @Override
                    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
                    }

                    @Override
                    public void visitConstructor(@NotNull IrConstructor declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
                    }

                    @Override
                    public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
                    }

                    @Override
                    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2);
                    }

                    @Override
                    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression2, data);
                    }

                    @Override
                    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                    }

                    @Override
                    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
                    }

                    @Override
                    public void visitContinue(@NotNull IrContinue jump) {
                        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                    }

                    @Override
                    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
                    }

                    @Override
                    public void visitDeclaration(@NotNull IrDeclarationBase declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
                    }

                    @Override
                    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                    }

                    @Override
                    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
                    }

                    @Override
                    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                    }

                    @Override
                    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
                    }

                    @Override
                    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
                    }

                    @Override
                    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
                    }

                    @Override
                    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2);
                    }

                    @Override
                    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression2, data);
                    }

                    @Override
                    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2);
                    }

                    @Override
                    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
                    }

                    @Override
                    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2);
                    }

                    @Override
                    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
                    }

                    @Override
                    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
                    }

                    @Override
                    public void visitElseBranch(@NotNull IrElseBranch branch) {
                        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                    }

                    @Override
                    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
                    }

                    @Override
                    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                    }

                    @Override
                    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
                    }

                    @Override
                    public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
                    }

                    @Override
                    public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
                    }

                    @Override
                    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                    }

                    @Override
                    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
                    }

                    @Override
                    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
                    }

                    @Override
                    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
                    }

                    @Override
                    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                    }

                    @Override
                    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
                    }

                    @Override
                    public void visitExpression(@NotNull IrExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
                    }

                    @Override
                    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
                    }

                    @Override
                    public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
                    }

                    @Override
                    public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
                    }

                    @Override
                    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
                    }

                    @Override
                    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
                    }

                    @Override
                    public void visitField(@NotNull IrField declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
                    }

                    @Override
                    public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
                    }

                    @Override
                    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                    }

                    @Override
                    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
                    }

                    @Override
                    public void visitFile(@NotNull IrFile declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
                    }

                    @Override
                    public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
                    }

                    @Override
                    public void visitFunction(@NotNull IrFunction declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
                    }

                    @Override
                    public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
                    }

                    @Override
                    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                    }

                    @Override
                    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
                    }

                    @Override
                    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2);
                    }

                    @Override
                    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression2, data);
                    }

                    @Override
                    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                    }

                    @Override
                    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
                    }

                    @Override
                    public void visitGetClass(@NotNull IrGetClass expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                    }

                    @Override
                    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
                    }

                    @Override
                    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                    }

                    @Override
                    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
                    }

                    @Override
                    public void visitGetField(@NotNull IrGetField expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                    }

                    @Override
                    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
                    }

                    @Override
                    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                    }

                    @Override
                    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
                    }

                    @Override
                    public void visitGetValue(@NotNull IrGetValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                    }

                    @Override
                    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
                    }

                    @Override
                    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                    }

                    @Override
                    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
                    }

                    @Override
                    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
                    }

                    @Override
                    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
                    }

                    @Override
                    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                    }

                    @Override
                    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
                    }

                    @Override
                    public void visitLoop(@NotNull IrLoop loop2) {
                        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
                    }

                    @Override
                    public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
                    }

                    @Override
                    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                    }

                    @Override
                    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
                    }

                    @Override
                    public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
                    }

                    @Override
                    public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
                    }

                    @Override
                    public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
                    }

                    @Override
                    public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
                    }

                    @Override
                    public void visitProperty(@NotNull IrProperty declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
                    }

                    @Override
                    public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
                    }

                    @Override
                    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                    }

                    @Override
                    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
                    }

                    @Override
                    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2);
                    }

                    @Override
                    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression2, data);
                    }

                    @Override
                    public void visitReturn(@NotNull IrReturn expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                    }

                    @Override
                    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
                    }

                    @Override
                    public void visitScript(@NotNull IrScript declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2);
                    }

                    @Override
                    public void visitScript(@NotNull IrScript declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration2, data);
                    }

                    @Override
                    public void visitSetField(@NotNull IrSetField expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                    }

                    @Override
                    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
                    }

                    @Override
                    public void visitSetValue(@NotNull IrSetValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2);
                    }

                    @Override
                    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression2, data);
                    }

                    @Override
                    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
                    }

                    @Override
                    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
                    }

                    @Override
                    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                    }

                    @Override
                    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
                    }

                    @Override
                    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                    }

                    @Override
                    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
                    }

                    @Override
                    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
                    }

                    @Override
                    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
                    }

                    @Override
                    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
                    }

                    @Override
                    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
                    }

                    @Override
                    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
                    }

                    @Override
                    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
                    }

                    @Override
                    public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
                    }

                    @Override
                    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
                    }

                    @Override
                    public void visitThrow(@NotNull IrThrow expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                    }

                    @Override
                    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
                    }

                    @Override
                    public void visitTry(@NotNull IrTry aTry) {
                        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                    }

                    @Override
                    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
                    }

                    @Override
                    public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
                    }

                    @Override
                    public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
                    }

                    @Override
                    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                    }

                    @Override
                    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
                    }

                    @Override
                    public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
                    }

                    @Override
                    public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
                    }

                    @Override
                    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
                    }

                    @Override
                    public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
                    }

                    @Override
                    public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
                    }

                    @Override
                    public void visitVararg(@NotNull IrVararg expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                    }

                    @Override
                    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
                    }

                    @Override
                    public void visitVariable(@NotNull IrVariable declaration2) {
                        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
                    }

                    @Override
                    public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
                    }

                    @Override
                    public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
                    }

                    @Override
                    public void visitWhen(@NotNull IrWhen expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                    }

                    @Override
                    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
                    }

                    @Override
                    public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
                    }

                    @Override
                    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
                    }
                });
                if (!(declaration2 instanceof IrScript)) continue;
                for (IrStatement memberDecl : ((IrScript)declaration2).getStatements()) {
                    if (!(memberDecl instanceof IrDeclaration)) continue;
                    this.processTopLevelLocalDecl((IrDeclaration)memberDecl);
                    if (!(memberDecl instanceof IrClass)) continue;
                    this.processNonTopLevelLocalDecl((IrDeclaration)memberDecl);
                }
            }
        }
    }

    public /* synthetic */ NameTables(Iterable iterable, Set set, Set set2, Map map, JsIrBackendContext jsIrBackendContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 2) != 0) {
            bl = false;
            set = new LinkedHashSet();
        }
        if ((n & 4) != 0) {
            bl = false;
            set2 = new LinkedHashSet();
        }
        if ((n & 8) != 0) {
            map = null;
        }
        if ((n & 0x10) != 0) {
            jsIrBackendContext = null;
        }
        this(iterable, set, set2, map, jsIrBackendContext);
    }

    @Nullable
    public final Map<String, String> getMappedNames() {
        return this.mappedNames;
    }

    @NotNull
    public final NameTable<IrDeclaration> getGlobalNames() {
        return this.globalNames;
    }

    private final void acceptNonExternalClass(IrClass declaration2) {
        for (IrDeclaration memberDecl : declaration2.getDeclarations()) {
            IrDeclaration irDeclaration2 = memberDecl;
            if (!(irDeclaration2 instanceof IrField)) continue;
            this.generateNameForMemberField((IrField)memberDecl);
        }
    }

    private final void processNonTopLevelLocalDecl(IrDeclaration declaration2) {
        if (declaration2 instanceof IrClass && !IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)declaration2)) {
            this.acceptNonExternalClass((IrClass)declaration2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <T, K> void addAllIfAbsent(Map<T, K> $this$addAllIfAbsent, Map<T, ? extends K> other) {
        void $this$filterTo$iv$iv;
        Map<T, K> map = $this$addAllIfAbsent;
        Map<T, ? extends K> $this$filter$iv = other;
        boolean $i$f$filter = false;
        Map<T, ? extends K> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var9_9 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var9_9.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map<T, K> map3 = $this$addAllIfAbsent;
            Object k = it.getKey();
            boolean bl3 = false;
            Map<T, K> map4 = map3;
            boolean bl4 = false;
            boolean bl5 = !map4.containsKey(k);
            if (!bl5) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map5 = destination$iv$iv;
        boolean bl6 = false;
        map.putAll(map5);
    }

    private final boolean packagesAdded() {
        Map<String, String> map = this.mappedNames;
        boolean bl = false;
        boolean bl2 = false;
        return map == null || map.isEmpty();
    }

    public final void merge(@NotNull List<? extends IrPackageFragment> files2, @NotNull List<? extends IrPackageFragment> additionalPackages) {
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(additionalPackages, "additionalPackages");
        boolean bl = false;
        List list2 = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List it = list2;
        boolean bl4 = false;
        it.addAll((Collection)files2);
        List packages2 = list2;
        if (this.packagesAdded()) {
            packages2.addAll((Collection)additionalPackages);
        }
        NameTables table = new NameTables(packages2, this.globalNames.getReserved(), this.memberNames.getReserved(), this.mappedNames, this.context);
        this.addAllIfAbsent(this.globalNames.getNames(), table.globalNames.getNames());
        this.addAllIfAbsent(this.memberNames.getNames(), table.memberNames.getNames());
        this.addAllIfAbsent(this.loopNames, table.loopNames);
        this.globalNames.getReserved().addAll((Collection<String>)table.globalNames.getReserved());
        this.memberNames.getReserved().addAll((Collection<String>)table.memberNames.getReserved());
    }

    private final void generateNameForMemberField(IrField field) {
        boolean bl = !org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isTopLevel(field);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        bl = !field.isStatic();
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string3 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        if (IrUtilsKt.isEffectivelyExternal(field)) {
            String string4 = field.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue(string4, "field.name.identifier");
            this.memberNames.declareStableName(field, string4);
        } else {
            String string5 = field.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string5, "field.name.asString()");
            this.memberNames.declareFreshName(field, Intrinsics.stringPlus("_", NameTablesKt.sanitizeName(string5)));
        }
    }

    @NotNull
    public final String dump() {
        return Intrinsics.stringPlus("Global names:\n", NameTablesKt.dump(this.globalNames));
    }

    @NotNull
    public final String getNameForStaticDeclaration(@NotNull IrDeclarationWithName declaration2) {
        String string2;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        String global = this.globalNames.getNames().get(declaration2);
        if (global != null) {
            return global;
        }
        Map<String, String> map = this.mappedNames;
        if (map != null && (string2 = map.get(NameTablesKt.access$mapToKey(declaration2))) != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            return it;
        }
        map = Intrinsics.stringPlus("Can't find name for declaration ", RenderIrElementKt.render(declaration2));
        boolean bl = false;
        throw (Throwable)new IllegalStateException(map.toString());
    }

    @NotNull
    public final String getNameForMemberField(@NotNull IrField field) {
        String name;
        Map<String, String> map;
        Intrinsics.checkNotNullParameter(field, "field");
        String string2 = this.memberNames.getNames().get(field);
        Object object = string2 == null ? ((map = this.mappedNames) == null ? null : map.get(NameTablesKt.access$mapToKey(field))) : (name = string2);
        if (name == null) {
            string2 = field.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "field.name.asString()");
            return Intrinsics.stringPlus(NameTablesKt.sanitizeName(string2), "__error");
        }
        return name;
    }

    private final void processTopLevelLocalDecl(IrDeclaration declaration2) {
        if (!(declaration2 instanceof IrDeclarationWithName)) {
            return;
        }
        if (IrUtilsKt.isEffectivelyExternal(declaration2) && (AnnotationUtilsKt.getJsModule(declaration2) == null || AnnotationUtilsKt.isJsNonModule(declaration2))) {
            if (AnnotationUtilsKt.getJsModule(IrUtilsKt.getFile(declaration2)) != null) {
                String string2 = ((IrDeclarationWithName)declaration2).getName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "declaration.name.asString()");
                this.globalNames.declareFreshName(declaration2, string2);
            } else {
                String string3 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)declaration2).getIdentifier();
                Intrinsics.checkNotNullExpressionValue(string3, "declaration.getJsNameOrKotlinName().identifier");
                this.globalNames.declareStableName(declaration2, string3);
            }
        } else {
            String string4 = ((IrDeclarationWithName)declaration2).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string4, "declaration.name.asString()");
            this.globalNames.declareFreshName(declaration2, string4);
        }
    }
}

