/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.types.CustomTypeVariable;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeWithEnhancementKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.refinement.TypeRefinement;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/types/FlexibleTypeImpl;", "Lorg/jetbrains/kotlin/types/FlexibleType;", "Lorg/jetbrains/kotlin/types/CustomTypeVariable;", "lowerBound", "Lorg/jetbrains/kotlin/types/SimpleType;", "upperBound", "(Lorg/jetbrains/kotlin/types/SimpleType;Lorg/jetbrains/kotlin/types/SimpleType;)V", "assertionsDone", "", "delegate", "getDelegate", "()Lorg/jetbrains/kotlin/types/SimpleType;", "isTypeVariable", "()Z", "makeNullableAsSpecified", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "newNullability", "refine", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "render", "", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "options", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "replaceAnnotations", "newAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotations;", "runAssertions", "", "substitutionResult", "Lorg/jetbrains/kotlin/types/KotlinType;", "replacement", "Companion", "descriptors"})
public final class FlexibleTypeImpl
extends FlexibleType
implements CustomTypeVariable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean assertionsDone;
    @JvmField
    public static boolean RUN_SLOW_ASSERTIONS;

    public FlexibleTypeImpl(@NotNull SimpleType lowerBound, @NotNull SimpleType upperBound) {
        Intrinsics.checkNotNullParameter(lowerBound, "lowerBound");
        Intrinsics.checkNotNullParameter(upperBound, "upperBound");
        super(lowerBound, upperBound);
    }

    private final void runAssertions() {
        if (!RUN_SLOW_ASSERTIONS || this.assertionsDone) {
            return;
        }
        this.assertionsDone = true;
        boolean bl = !FlexibleTypesKt.isFlexible(this.getLowerBound());
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FlexibleTypeImpl$runAssertions$52 = false;
            String $i$a$-assert-FlexibleTypeImpl$runAssertions$52 = Intrinsics.stringPlus("Lower bound of a flexible type can not be flexible: ", this.getLowerBound());
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FlexibleTypeImpl$runAssertions$52));
        }
        bl = !FlexibleTypesKt.isFlexible(this.getUpperBound());
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FlexibleTypeImpl$runAssertions$62 = false;
            String $i$a$-assert-FlexibleTypeImpl$runAssertions$62 = Intrinsics.stringPlus("Upper bound of a flexible type can not be flexible: ", this.getUpperBound());
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FlexibleTypeImpl$runAssertions$62));
        }
        bl = !Intrinsics.areEqual(this.getLowerBound(), this.getUpperBound());
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FlexibleTypeImpl$runAssertions$72 = false;
            String $i$a$-assert-FlexibleTypeImpl$runAssertions$72 = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FlexibleTypeImpl$runAssertions$72));
        }
        bl = KotlinTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
    }

    @Override
    @NotNull
    public SimpleType getDelegate() {
        this.runAssertions();
        return this.getLowerBound();
    }

    @Override
    public boolean isTypeVariable() {
        return this.getLowerBound().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor && Intrinsics.areEqual(this.getLowerBound().getConstructor(), this.getUpperBound().getConstructor());
    }

    @Override
    @NotNull
    public KotlinType substitutionResult(@NotNull KotlinType replacement) {
        UnwrappedType unwrappedType;
        UnwrappedType unwrapped2;
        Intrinsics.checkNotNullParameter(replacement, "replacement");
        UnwrappedType unwrappedType2 = unwrapped2 = replacement.unwrap();
        if (unwrappedType2 instanceof FlexibleType) {
            unwrappedType = unwrapped2;
        } else if (unwrappedType2 instanceof SimpleType) {
            unwrappedType = KotlinTypeFactory.flexibleType((SimpleType)unwrapped2, ((SimpleType)unwrapped2).makeNullableAsSpecified(true));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return TypeWithEnhancementKt.inheritEnhancement(unwrappedType, unwrapped2);
    }

    @Override
    @NotNull
    public UnwrappedType replaceAnnotations(@NotNull Annotations newAnnotations) {
        Intrinsics.checkNotNullParameter(newAnnotations, "newAnnotations");
        return KotlinTypeFactory.flexibleType(this.getLowerBound().replaceAnnotations(newAnnotations), this.getUpperBound().replaceAnnotations(newAnnotations));
    }

    @Override
    @NotNull
    public String render(@NotNull DescriptorRenderer renderer, @NotNull DescriptorRendererOptions options) {
        Intrinsics.checkNotNullParameter(renderer, "renderer");
        Intrinsics.checkNotNullParameter(options, "options");
        if (options.getDebugMode()) {
            return '(' + renderer.renderType(this.getLowerBound()) + ".." + renderer.renderType(this.getUpperBound()) + ')';
        }
        return renderer.renderFlexibleType(renderer.renderType(this.getLowerBound()), renderer.renderType(this.getUpperBound()), TypeUtilsKt.getBuiltIns(this));
    }

    @Override
    @NotNull
    public UnwrappedType makeNullableAsSpecified(boolean newNullability) {
        return KotlinTypeFactory.flexibleType(this.getLowerBound().makeNullableAsSpecified(newNullability), this.getUpperBound().makeNullableAsSpecified(newNullability));
    }

    @Override
    @TypeRefinement
    @NotNull
    public FlexibleType refine(@NotNull KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        return new FlexibleTypeImpl((SimpleType)kotlinTypeRefiner.refineType(this.getLowerBound()), (SimpleType)kotlinTypeRefiner.refineType(this.getUpperBound()));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/types/FlexibleTypeImpl$Companion;", "", "()V", "RUN_SLOW_ASSERTIONS", "", "descriptors"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

