/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J\u0018\u0010\u001e\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0010H\u0002J\u0014\u0010!\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010H\u0002J\u0015\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010#J\u001e\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/NonCachingLazyStorage;", "K", "V", "Lorg/jetbrains/kotlin/incremental/storage/LazyStorage;", "storageFile", "Ljava/io/File;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "(Ljava/io/File;Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;)V", "keys", "", "getKeys", "()Ljava/util/Collection;", "storage", "Lcom/intellij/util/io/PersistentHashMap;", "append", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "clean", "close", "contains", "", "(Ljava/lang/Object;)Z", "createMap", "flush", "memoryCachesOnly", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getStorageIfExists", "getStorageOrCreateNew", "remove", "(Ljava/lang/Object;)V", "set", "kotlin-build-common"})
public final class NonCachingLazyStorage<K, V>
implements LazyStorage<K, V> {
    @NotNull
    private final File storageFile;
    @NotNull
    private final KeyDescriptor<K> keyDescriptor;
    @NotNull
    private final DataExternalizer<V> valueExternalizer;
    @Nullable
    private PersistentHashMap<K, V> storage;

    public NonCachingLazyStorage(@NotNull File storageFile, @NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer) {
        Intrinsics.checkNotNullParameter(storageFile, "storageFile");
        Intrinsics.checkNotNullParameter(keyDescriptor, "keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, "valueExternalizer");
        this.storageFile = storageFile;
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
    }

    private final PersistentHashMap<K, V> getStorageIfExists() {
        if (this.storage != null) {
            return this.storage;
        }
        if (this.storageFile.exists()) {
            this.storage = this.createMap();
            return this.storage;
        }
        return null;
    }

    private final PersistentHashMap<K, V> getStorageOrCreateNew() {
        if (this.storage == null) {
            this.storage = this.createMap();
        }
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        Intrinsics.checkNotNull(persistentHashMap);
        return persistentHashMap;
    }

    @Override
    @NotNull
    public synchronized Collection<K> getKeys() {
        Collection collection;
        Collection collection2;
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        Collection collection3 = collection2 = persistentHashMap == null ? null : persistentHashMap.getAllKeysWithExistingMapping();
        if (collection2 == null) {
            boolean bl = false;
            collection = CollectionsKt.emptyList();
        } else {
            collection = collection2;
        }
        return collection;
    }

    @Override
    public synchronized boolean contains(K key) {
        boolean bl;
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return persistentHashMap == null ? false : (bl = persistentHashMap.containsMapping(key));
    }

    @Override
    @Nullable
    public synchronized V get(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        return persistentHashMap == null ? null : (V)persistentHashMap.get(key);
    }

    @Override
    public synchronized void set(K key, V value2) {
        this.getStorageOrCreateNew().put(key, value2);
    }

    @Override
    public synchronized void remove(K key) {
        PersistentHashMap<K, V> persistentHashMap = this.getStorageIfExists();
        if (persistentHashMap != null) {
            persistentHashMap.remove(key);
        }
    }

    @Override
    public synchronized void append(K key, V value2) {
        this.getStorageOrCreateNew().appendData(key, arg_0 -> NonCachingLazyStorage.append$lambda-0(this, value2, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clean() {
        try {
            PersistentHashMap<K, V> persistentHashMap = this.storage;
            if (persistentHashMap == null) {
            } else {
                persistentHashMap.close();
            }
        }
        finally {
            this.storage = null;
            if (!IOUtil.deleteAllFilesStartingWith(this.storageFile)) {
                throw new IOException(Intrinsics.stringPlus("Could not delete internal storage: ", this.storageFile.getAbsolutePath()));
            }
        }
    }

    @Override
    public synchronized void flush(boolean memoryCachesOnly) {
        PersistentHashMap<K, V> persistentHashMap = this.storage;
        if (persistentHashMap == null) {
            return;
        }
        PersistentHashMap<K, V> existingStorage = persistentHashMap;
        if (memoryCachesOnly) {
            if (existingStorage.isDirty()) {
                existingStorage.dropMemoryCaches();
            }
        } else {
            existingStorage.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            PersistentHashMap<K, V> persistentHashMap = this.storage;
            if (persistentHashMap == null) {
            } else {
                persistentHashMap.close();
            }
        }
        finally {
            this.storage = null;
        }
    }

    private final PersistentHashMap<K, V> createMap() {
        return new PersistentHashMap<K, V>(this.storageFile, this.keyDescriptor, this.valueExternalizer);
    }

    private static final void append$lambda-0(NonCachingLazyStorage this$0, Object $value, DataOutput dataOutput) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.valueExternalizer.save(dataOutput, $value);
    }
}

