/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import org.jetbrains.kotlin.ir.interpreter.CustomInstruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0094\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010!\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\"2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010+\u001a\u00020\u00012\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u0002002\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u0002032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u0002062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u00107\u001a\u00020\u00012\u0006\u00105\u001a\u0002082\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u00109\u001a\u00020\u00012\u0006\u00105\u001a\u00020:2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u0010;\u001a\u00020\u00012\u0006\u0010<\u001a\u00020=2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010>\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010?2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u001a\u0018\u0010@\u001a\u00020\u00012\u0006\u0010A\u001a\u00020B2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010C\u001a\u00020\u00012\u0006\u00105\u001a\u00020D2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010E\u001a\u00020\u00012\u0006\u00105\u001a\u00020F2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010G\u001a\u00020\u00012\u0006\u00105\u001a\u00020H2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010I\u001a\u00020\u00012\f\u0010J\u001a\b\u0012\u0004\u0012\u00020L0K2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010M\u001a\u00020\u00012\u0006\u00105\u001a\u00020N2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u0010O\u001a\u00020\u00012\u0006\u00105\u001a\u00020P2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010Q\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020R2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010S\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020T2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010U\u001a\u00020\u00012\u0006\u00105\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010V\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020W2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010X\u001a\u00020\u00012\u0006\u0010Y\u001a\u00020Z2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010[\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\\2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010]\u001a\u00020\u00012\u0006\u0010&\u001a\u00020^2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010_\u001a\u00020\u0001*\u00020`2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010a\u001a\u00020bH\u0000\u00a8\u0006c"}, d2={"unfoldBlock", "", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "unfoldBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "unfoldBranch", "branch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "unfoldBreak", "element", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "unfoldCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "unfoldCatch", "Lorg/jetbrains/kotlin/ir/expressions/IrCatch;", "unfoldClassReference", "classReference", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "unfoldComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "unfoldConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "unfoldConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "unfoldContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "unfoldDelegatingConstructorCall", "delegatingConstructorCall", "unfoldDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "unfoldEnumConstructorCall", "enumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "unfoldField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "unfoldFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unfoldFunctionReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "unfoldGetEnumValue", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "unfoldGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "unfoldGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "unfoldInstanceInitializerCall", "instanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "unfoldInstruction", "Lorg/jetbrains/kotlin/ir/IrElement;", "unfoldPropertyReference", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "unfoldReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "unfoldSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "unfoldSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "unfoldStatements", "statements", "", "Lorg/jetbrains/kotlin/ir/IrStatement;", "unfoldStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "unfoldThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "unfoldTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "unfoldTypeOperatorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "unfoldValueParameters", "unfoldVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "unfoldVariable", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "unfoldWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "unfoldWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "handleAndDropResult", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "dropOnlyUnit", "", "ir.interpreter"})
public final class InstructionsUnfolderKt {
    public static final void handleAndDropResult(@NotNull IrExpression $this$handleAndDropResult, @NotNull CallStack callStack, boolean dropOnlyUnit) {
        Intrinsics.checkNotNullParameter($this$handleAndDropResult, "<this>");
        Intrinsics.checkNotNullParameter(callStack, "callStack");
        Function0 dropResult2 = new Function0<Unit>(dropOnlyUnit, $this$handleAndDropResult, callStack){
            final /* synthetic */ boolean $dropOnlyUnit;
            final /* synthetic */ IrExpression $this_handleAndDropResult;
            final /* synthetic */ CallStack $callStack;
            {
                this.$dropOnlyUnit = $dropOnlyUnit;
                this.$this_handleAndDropResult = $receiver;
                this.$callStack = $callStack;
                super(0);
            }

            public final void invoke() {
                if (!this.$dropOnlyUnit && !IrTypePredicatesKt.isUnit(this.$this_handleAndDropResult.getType()) || StateKt.isUnit(this.$callStack.peekState())) {
                    this.$callStack.popState();
                }
            }
        };
        callStack.addInstruction(new CustomInstruction(dropResult2));
        callStack.addInstruction(new CompoundInstruction($this$handleAndDropResult));
    }

    public static /* synthetic */ void handleAndDropResult$default(IrExpression irExpression, CallStack callStack, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        InstructionsUnfolderKt.handleAndDropResult(irExpression, callStack, bl);
    }

    public static final void unfoldInstruction(@Nullable IrElement element, @NotNull IrInterpreterEnvironment environment) {
        Intrinsics.checkNotNullParameter(environment, "environment");
        CallStack callStack = environment.getCallStack();
        IrElement irElement = element;
        if (irElement == null) {
            return;
        }
        if (irElement instanceof IrSimpleFunction) {
            InstructionsUnfolderKt.unfoldFunction((IrSimpleFunction)element, environment);
        } else if (irElement instanceof IrConstructor) {
            InstructionsUnfolderKt.unfoldConstructor((IrConstructor)element, environment);
        } else if (irElement instanceof IrCall) {
            InstructionsUnfolderKt.unfoldCall((IrCall)element, callStack);
        } else if (irElement instanceof IrConstructorCall) {
            InstructionsUnfolderKt.unfoldConstructorCall((IrFunctionAccessExpression)element, callStack);
        } else if (irElement instanceof IrEnumConstructorCall) {
            InstructionsUnfolderKt.unfoldEnumConstructorCall((IrEnumConstructorCall)element, callStack);
        } else if (irElement instanceof IrDelegatingConstructorCall) {
            InstructionsUnfolderKt.unfoldDelegatingConstructorCall((IrFunctionAccessExpression)element, callStack);
        } else if (irElement instanceof IrInstanceInitializerCall) {
            InstructionsUnfolderKt.unfoldInstanceInitializerCall((IrInstanceInitializerCall)element, callStack);
        } else if (irElement instanceof IrField) {
            InstructionsUnfolderKt.unfoldField((IrField)element, callStack);
        } else if (irElement instanceof IrBody) {
            InstructionsUnfolderKt.unfoldBody((IrBody)element, callStack);
        } else if (irElement instanceof IrBlock) {
            InstructionsUnfolderKt.unfoldBlock((IrBlock)element, callStack);
        } else if (irElement instanceof IrReturn) {
            InstructionsUnfolderKt.unfoldReturn((IrReturn)element, callStack);
        } else if (irElement instanceof IrSetField) {
            InstructionsUnfolderKt.unfoldSetField((IrSetField)element, callStack);
        } else if (irElement instanceof IrGetField) {
            callStack.addInstruction(new SimpleInstruction(element));
        } else if (irElement instanceof IrGetValue) {
            InstructionsUnfolderKt.unfoldGetValue((IrGetValue)element, environment);
        } else if (irElement instanceof IrGetObjectValue) {
            InstructionsUnfolderKt.unfoldGetObjectValue((IrGetObjectValue)element, environment);
        } else if (irElement instanceof IrGetEnumValue) {
            InstructionsUnfolderKt.unfoldGetEnumValue((IrGetEnumValue)element, environment);
        } else if (irElement instanceof IrConst) {
            callStack.addInstruction(new SimpleInstruction(element));
        } else if (irElement instanceof IrVariable) {
            InstructionsUnfolderKt.unfoldVariable((IrVariable)element, callStack);
        } else if (irElement instanceof IrSetValue) {
            InstructionsUnfolderKt.unfoldSetValue((IrSetValue)element, callStack);
        } else if (irElement instanceof IrTypeOperatorCall) {
            InstructionsUnfolderKt.unfoldTypeOperatorCall((IrTypeOperatorCall)element, callStack);
        } else if (irElement instanceof IrBranch) {
            InstructionsUnfolderKt.unfoldBranch((IrBranch)element, callStack);
        } else if (irElement instanceof IrWhileLoop) {
            InstructionsUnfolderKt.unfoldWhileLoop((IrWhileLoop)element, callStack);
        } else if (irElement instanceof IrDoWhileLoop) {
            InstructionsUnfolderKt.unfoldDoWhileLoop((IrDoWhileLoop)element, callStack);
        } else if (irElement instanceof IrWhen) {
            InstructionsUnfolderKt.unfoldWhen((IrWhen)element, callStack);
        } else if (irElement instanceof IrBreak) {
            InstructionsUnfolderKt.unfoldBreak((IrBreak)element, callStack);
        } else if (irElement instanceof IrContinue) {
            InstructionsUnfolderKt.unfoldContinue((IrContinue)element, callStack);
        } else if (irElement instanceof IrVararg) {
            InstructionsUnfolderKt.unfoldVararg((IrVararg)element, callStack);
        } else if (irElement instanceof IrSpreadElement) {
            callStack.addInstruction(new CompoundInstruction(((IrSpreadElement)element).getExpression()));
        } else if (irElement instanceof IrTry) {
            InstructionsUnfolderKt.unfoldTry((IrTry)element, callStack);
        } else if (irElement instanceof IrCatch) {
            InstructionsUnfolderKt.unfoldCatch((IrCatch)element, callStack);
        } else if (irElement instanceof IrThrow) {
            InstructionsUnfolderKt.unfoldThrow((IrThrow)element, callStack);
        } else if (irElement instanceof IrStringConcatenation) {
            InstructionsUnfolderKt.unfoldStringConcatenation((IrStringConcatenation)element, environment);
        } else if (irElement instanceof IrFunctionExpression) {
            callStack.addInstruction(new SimpleInstruction(element));
        } else if (irElement instanceof IrFunctionReference) {
            InstructionsUnfolderKt.unfoldFunctionReference((IrFunctionReference)element, callStack);
        } else if (irElement instanceof IrPropertyReference) {
            InstructionsUnfolderKt.unfoldPropertyReference((IrPropertyReference)element, callStack);
        } else if (irElement instanceof IrClassReference) {
            InstructionsUnfolderKt.unfoldClassReference((IrClassReference)element, callStack);
        } else if (irElement instanceof IrComposite) {
            InstructionsUnfolderKt.unfoldComposite((IrComposite)element, callStack);
        } else {
            String string2 = element.getClass() + " not supported";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
    }

    private static final void unfoldFunction(IrSimpleFunction function2, IrInterpreterEnvironment environment) {
        Unit unit;
        Unit unit2;
        if (environment.getCallStack().getStackCount() >= 10000) {
            UtilsKt.handleUserException(new StackOverflowError(), environment);
            return;
        }
        IrBody irBody = function2.getBody();
        if (irBody == null) {
            unit2 = null;
        } else {
            IrBody irBody2 = irBody;
            boolean bl = false;
            boolean bl2 = false;
            IrBody it = irBody2;
            boolean bl3 = false;
            environment.getCallStack().addInstruction(new CompoundInstruction(it));
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            throw new InterpreterError("Ir function must be with body");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static final void unfoldConstructor(IrConstructor constructor2, IrInterpreterEnvironment environment) {
        String string2;
        CallStack callStack = environment.getCallStack();
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(constructor2);
        String string3 = string2 = fqName2 == null ? null : fqName2.asString();
        if (string2 != null) {
            int n = -1;
            switch (string2.hashCode()) {
                case -930046350: {
                    if (!string2.equals("kotlin.Enum.<init>")) break;
                    n = 1;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    void $this$forEachIndexed$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    IrClass irClass2 = IrUtilsKt.getParentAsClass(constructor2);
                    IrValueParameter irValueParameter = irClass2.getThisReceiver();
                    Intrinsics.checkNotNull(irValueParameter);
                    IrValueParameterSymbol receiver = irValueParameter.getSymbol();
                    State receiverState = callStack.getState(receiver);
                    Iterable $this$filterIsInstance$iv = irClass2.getDeclarations();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof IrProperty)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    Iterator iterator2 = $this$forEachIndexed$iv.iterator();
                    while (iterator2.hasNext()) {
                        void property2;
                        Object item$iv = iterator2.next();
                        int n2 = index$iv++;
                        boolean bl = false;
                        if (n2 < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        IrProperty irProperty2 = (IrProperty)item$iv;
                        int index2 = n2;
                        boolean bl2 = false;
                        receiverState.setField(new Variable(property2.getSymbol(), callStack.getState(constructor2.getValueParameters().get(index2).getSymbol())));
                    }
                    return;
                }
            }
        }
        IrBody irBody = constructor2.getBody();
        Intrinsics.checkNotNull(irBody);
        callStack.addInstruction(new CompoundInstruction(irBody));
    }

    private static final void unfoldCall(IrCall call2, CallStack callStack) {
        InstructionsUnfolderKt.unfoldValueParameters(call2, callStack);
    }

    private static final void unfoldConstructorCall(IrFunctionAccessExpression constructorCall, CallStack callStack) {
        IrFunction constructor2 = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
        InstructionsUnfolderKt.unfoldValueParameters(constructorCall, callStack);
        callStack.addVariable(new Variable(UtilsKt.getThisReceiver(constructorCall), new Common(IrUtilsKt.getParentAsClass(constructor2))));
    }

    private static final void unfoldEnumConstructorCall(IrEnumConstructorCall enumConstructorCall, CallStack callStack) {
        InstructionsUnfolderKt.unfoldValueParameters(enumConstructorCall, callStack);
    }

    private static final void unfoldDelegatingConstructorCall(IrFunctionAccessExpression delegatingConstructorCall, CallStack callStack) {
        InstructionsUnfolderKt.unfoldValueParameters(delegatingConstructorCall, callStack);
    }

    /*
     * WARNING - void declaration
     */
    private static final void unfoldValueParameters(IrFunctionAccessExpression expression2, CallStack callStack) {
        int it;
        Object object;
        void $this$mapTo$iv$iv;
        IrFunction irFunction2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        callStack.newSubFrame(expression2);
        callStack.addInstruction(new SimpleInstruction(expression2));
        Iterable $this$map$iv = irFunction2.getValueParameters();
        boolean $i$f$map = false;
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            object = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrValueParameterSymbol irValueParameterSymbol = it2.getSymbol();
            collection.add(irValueParameterSymbol);
        }
        List valueParametersSymbols = (List)destination$iv$iv;
        Object $this$forEach$iv = RangesKt.downTo(expression2.getValueArgumentsCount() - 1, 0);
        boolean $i$f$forEach2 = false;
        object2 = $this$forEach$iv.iterator();
        while (object2.hasNext()) {
            Unit unit;
            Object it3;
            boolean bl;
            boolean bl2;
            Unit unit2;
            int element$iv;
            int index2 = element$iv = ((IntIterator)object2).nextInt();
            boolean bl3 = false;
            if (expression2.getValueArgument(index2) != null) continue;
            callStack.addInstruction(new SimpleInstruction((IrElement)((IrValueParameterSymbol)valueParametersSymbols.get(index2)).getOwner()));
            Object object3 = InstructionsUnfolderKt.unfoldValueParameters$getDefaultForParameterAt(irFunction2, index2);
            if (object3 == null) {
                unit2 = null;
            } else {
                object = object3;
                bl2 = false;
                bl = false;
                it3 = object;
                boolean bl4 = false;
                callStack.addInstruction(new CompoundInstruction((IrElement)it3));
                unit2 = Unit.INSTANCE;
            }
            if ((unit = unit2) != null || (object3 = UtilsKt.getVarargType(expression2, index2)) == null) continue;
            object = object3;
            bl2 = false;
            bl = false;
            it3 = object;
            boolean bl5 = false;
            callStack.addInstruction(new SimpleInstruction(IrConstImpl.Companion.constNull(-1, -1, (IrType)it3)));
        }
        $this$forEach$iv = expression2.getDispatchReceiver();
        if ($this$forEach$iv != null) {
            Object $i$f$forEach2 = $this$forEach$iv;
            boolean bl = false;
            boolean element$iv = false;
            Object it4 = $i$f$forEach2;
            boolean bl6 = false;
            IrValueParameter irValueParameter = irFunction2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            callStack.addInstruction(new SimpleInstruction(irValueParameter));
        }
        $this$forEach$iv = expression2.getExtensionReceiver();
        if ($this$forEach$iv != null) {
            Object $i$f$forEach2 = $this$forEach$iv;
            boolean bl = false;
            boolean element$iv = false;
            Object it5 = $i$f$forEach2;
            boolean bl7 = false;
            IrValueParameter irValueParameter = irFunction2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            callStack.addInstruction(new SimpleInstruction(irValueParameter));
        }
        $this$forEach$iv = RangesKt.until(0, expression2.getValueArgumentsCount());
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if (expression2.getValueArgument(it) == null) continue;
            callStack.addInstruction(new SimpleInstruction(irFunction2.getValueParameters().get(it)));
        }
        $this$forEach$iv = RangesKt.downTo(expression2.getValueArgumentsCount() - 1, 0);
        $i$f$forEach3 = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            callStack.addInstruction(new CompoundInstruction(expression2.getValueArgument(it)));
        }
        IrExpression irExpression = expression2.getExtensionReceiver();
        if (irExpression != null) {
            IrExpression irExpression2 = irExpression;
            boolean bl = false;
            boolean bl8 = false;
            IrExpression it6 = irExpression2;
            boolean bl9 = false;
            callStack.addInstruction(new CompoundInstruction(it6));
        }
        irExpression = expression2.getDispatchReceiver();
        if (irExpression != null) {
            IrExpression irExpression3 = irExpression;
            boolean bl = false;
            boolean bl10 = false;
            IrExpression it7 = irExpression3;
            boolean bl11 = false;
            callStack.addInstruction(new CompoundInstruction(it7));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void unfoldInstanceInitializerCall(IrInstanceInitializerCall instanceInitializerCall, CallStack callStack) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Object element$iv2;
        Iterator $this$filterTo$iv$iv2;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        IrClass irClass2 = (IrClass)instanceInitializerCall.getClassSymbol().getOwner();
        Iterable $this$filterIsInstance$iv = irClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof IrAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            element$iv$iv = iterator2.next();
            IrAnonymousInitializer it = (IrAnonymousInitializer)element$iv$iv;
            boolean bl = false;
            if (!(!it.isStatic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List anonymousInitializer = (List)destination$iv$iv;
        Iterable $this$forEach$iv2 = CollectionsKt.reversed(anonymousInitializer);
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            IrAnonymousInitializer it = (IrAnonymousInitializer)element$iv2;
            boolean bl = false;
            callStack.addInstruction(new CompoundInstruction(it.getBody()));
        }
        Iterable $this$filterIsInstance$iv2 = irClass2.getDeclarations();
        boolean $i$f$filterIsInstance2 = false;
        element$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrProperty)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List classProperties = (List)destination$iv$iv2;
        Iterable $this$filter$iv2 = classProperties;
        boolean $i$f$filter2 = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv2;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrExpressionBody irExpressionBody;
            IrProperty it = (IrProperty)element$iv$iv;
            boolean bl = false;
            IrField irField = it.getBackingField();
            if (!((irField == null ? null : ((irExpressionBody = irField.getInitializer()) == null ? null : irExpressionBody.getExpression())) != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = CollectionsKt.reversed((List)destination$iv$iv2);
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            IrProperty it = (IrProperty)element$iv3;
            boolean bl = false;
            callStack.addInstruction(new CompoundInstruction(it.getBackingField()));
        }
    }

    private static final void unfoldField(IrField field2, CallStack callStack) {
        callStack.addInstruction(new SimpleInstruction(field2));
        IrExpressionBody irExpressionBody = field2.getInitializer();
        callStack.addInstruction(new CompoundInstruction(irExpressionBody == null ? null : irExpressionBody.getExpression()));
    }

    private static final void unfoldBody(IrBody body2, CallStack callStack) {
        callStack.addInstruction(new SimpleInstruction(body2));
        InstructionsUnfolderKt.unfoldStatements(IrUtilsKt.getStatements(body2), callStack);
    }

    private static final void unfoldBlock(IrBlock block, CallStack callStack) {
        callStack.newSubFrame(block);
        callStack.addInstruction(new SimpleInstruction(block));
        InstructionsUnfolderKt.unfoldStatements(block.getStatements(), callStack);
    }

    private static final void unfoldStatements(List<? extends IrStatement> statements2, CallStack callStack) {
        int n = statements2.size() + -1;
        if (0 <= n) {
            do {
                int i;
                IrStatement statement2;
                if ((statement2 = statements2.get(i = n--)) instanceof IrClass) {
                    if (AdditionalIrUtilsKt.isLocal((IrDeclaration)statement2)) continue;
                    String string2 = "Only local classes are supported";
                    boolean bl = false;
                    throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
                }
                if (statement2 instanceof IrFunction) {
                    if (AdditionalIrUtilsKt.isLocal((IrDeclaration)statement2)) continue;
                    String string3 = "Only local functions are supported";
                    boolean bl = false;
                    throw (Throwable)new NotImplementedError("An operation is not implemented: " + string3);
                }
                if (statement2 instanceof IrExpression) {
                    InstructionsUnfolderKt.handleAndDropResult((IrExpression)statement2, callStack, true);
                    continue;
                }
                callStack.addInstruction(new CompoundInstruction(statement2));
            } while (0 <= n);
        }
    }

    private static final void unfoldReturn(IrReturn expression2, CallStack callStack) {
        callStack.addInstruction(new SimpleInstruction(expression2));
        callStack.addInstruction(new CompoundInstruction(expression2.getValue()));
    }

    private static final void unfoldSetField(IrSetField expression2, CallStack callStack) {
        if (UtilsKt.accessesTopLevelOrObjectField(expression2)) {
            String string2 = "Cannot interpret set method on top level properties";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        callStack.addInstruction(new SimpleInstruction(expression2));
        callStack.addInstruction(new CompoundInstruction(expression2.getValue()));
    }

    private static final void unfoldGetValue(IrGetValue expression2, IrInterpreterEnvironment environment) {
        IrClass expectedClass;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        IrClass irClass2 = expectedClass = irClassSymbol == null ? null : (IrClass)irClassSymbol.getOwner();
        if (expectedClass != null && IrUtilsKt.isObject(expectedClass) && Intrinsics.areEqual(expression2.getSymbol().getOwner().getOrigin(), IrDeclarationOrigin.INSTANCE_RECEIVER.INSTANCE)) {
            IrGetObjectValueImpl irGetObject = new IrGetObjectValueImpl(-1, -1, IrUtilsKt.getDefaultType(expectedClass), expectedClass.getSymbol());
            InstructionsUnfolderKt.unfoldGetObjectValue(irGetObject, environment);
            return;
        }
        environment.getCallStack().pushState(environment.getCallStack().getState(expression2.getSymbol()));
    }

    private static final void unfoldGetObjectValue(IrGetObjectValue expression2, IrInterpreterEnvironment environment) {
        CallStack callStack = environment.getCallStack();
        IrClass objectClass = (IrClass)expression2.getSymbol().getOwner();
        Complex complex = environment.getMapOfObjects().get(objectClass.getSymbol());
        if (complex != null) {
            Complex complex2 = complex;
            boolean bl = false;
            boolean bl2 = false;
            Complex it = complex2;
            boolean bl3 = false;
            callStack.pushState(it);
            return;
        }
        callStack.addInstruction(new SimpleInstruction(expression2));
    }

    /*
     * WARNING - void declaration
     */
    private static final void unfoldGetEnumValue(IrGetEnumValue expression2, IrInterpreterEnvironment environment) {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        CallStack callStack = environment.getCallStack();
        Complex complex = environment.getMapOfEnums().get(expression2.getSymbol());
        if (complex != null) {
            Complex complex2 = complex;
            boolean bl = false;
            boolean bl2 = false;
            Complex it = complex2;
            boolean bl3 = false;
            callStack.pushState(it);
            return;
        }
        callStack.addInstruction(new SimpleInstruction(expression2));
        IrEnumEntry enumEntry = (IrEnumEntry)expression2.getSymbol().getOwner();
        IrClass enumClass2 = IrUtilsKt.getParentAsClass((IrDeclaration)enumEntry.getSymbol().getOwner());
        Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable it = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrEnumEntry it2 = (IrEnumEntry)element$iv;
            boolean bl = false;
            callStack.addInstruction(new SimpleInstruction(it2));
        }
    }

    private static final void unfoldVariable(IrVariable variable2, CallStack callStack) {
        IrExpression irExpression = variable2.getInitializer();
        if (irExpression == null) {
            callStack.addVariable(new Variable(variable2.getSymbol()));
        } else {
            callStack.addInstruction(new SimpleInstruction(variable2));
            IrExpression irExpression2 = variable2.getInitializer();
            Intrinsics.checkNotNull(irExpression2);
            callStack.addInstruction(new CompoundInstruction(irExpression2));
        }
    }

    private static final void unfoldSetValue(IrSetValue expression2, CallStack callStack) {
        callStack.addInstruction(new SimpleInstruction(expression2));
        callStack.addInstruction(new CompoundInstruction(expression2.getValue()));
    }

    private static final void unfoldTypeOperatorCall(IrTypeOperatorCall element, CallStack callStack) {
        callStack.addInstruction(new SimpleInstruction(element));
        callStack.addInstruction(new CompoundInstruction(element.getArgument()));
    }

    private static final void unfoldBranch(IrBranch branch, CallStack callStack) {
        callStack.addInstruction(new SimpleInstruction(branch));
        callStack.addInstruction(new CompoundInstruction(branch.getCondition()));
    }

    private static final void unfoldWhileLoop(IrWhileLoop loop2, CallStack callStack) {
        callStack.newSubFrame(loop2);
        callStack.addInstruction(new SimpleInstruction(loop2));
        callStack.addInstruction(new CompoundInstruction(loop2.getCondition()));
    }

    private static final void unfoldDoWhileLoop(IrDoWhileLoop loop2, CallStack callStack) {
        callStack.newSubFrame(loop2);
        callStack.addInstruction(new SimpleInstruction(loop2));
        callStack.addInstruction(new CompoundInstruction(loop2.getCondition()));
        callStack.addInstruction(new CompoundInstruction(loop2.getBody()));
    }

    private static final void unfoldWhen(IrWhen element, CallStack callStack) {
        callStack.newSubFrame(element);
        callStack.addInstruction(new SimpleInstruction(element));
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)element.getBranches());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrBranch it = (IrBranch)element$iv;
            boolean bl = false;
            callStack.addInstruction(new CompoundInstruction(it));
        }
    }

    private static final void unfoldContinue(IrContinue element, CallStack callStack) {
        callStack.unrollInstructionsForBreakContinue(element);
    }

    private static final void unfoldBreak(IrBreak element, CallStack callStack) {
        callStack.unrollInstructionsForBreakContinue(element);
    }

    private static final void unfoldVararg(IrVararg element, CallStack callStack) {
        callStack.addInstruction(new SimpleInstruction(element));
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)element.getElements());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrVarargElement it = (IrVarargElement)element$iv;
            boolean bl = false;
            callStack.addInstruction(new CompoundInstruction(it));
        }
    }

    private static final void unfoldTry(IrTry element, CallStack callStack) {
        callStack.newSubFrame(element);
        callStack.addInstruction(new SimpleInstruction(element));
        callStack.addInstruction(new CompoundInstruction(element.getTryResult()));
    }

    private static final void unfoldCatch(IrCatch element, CallStack callStack) {
        ExceptionState exceptionState;
        State state = callStack.peekState();
        ExceptionState exceptionState2 = exceptionState = state instanceof ExceptionState ? (ExceptionState)state : null;
        if (exceptionState == null) {
            return;
        }
        ExceptionState exceptionState3 = exceptionState;
        if (StateKt.isSubtypeOf(exceptionState3, element.getCatchParameter().getType())) {
            callStack.popState();
            IrTry frameOwner = (IrTry)callStack.getCurrentFrameOwner$ir_interpreter();
            callStack.dropSubFrame();
            callStack.newSubFrame(element);
            callStack.addVariable(new Variable(element.getCatchParameter().getSymbol(), exceptionState3));
            callStack.addInstruction(new SimpleInstruction(frameOwner));
            callStack.addInstruction(new CompoundInstruction(element.getResult()));
        }
    }

    private static final void unfoldThrow(IrThrow expression2, CallStack callStack) {
        callStack.addInstruction(new SimpleInstruction(expression2));
        callStack.addInstruction(new CompoundInstruction(expression2.getValue()));
    }

    private static final void unfoldStringConcatenation(IrStringConcatenation expression2, IrInterpreterEnvironment environment) {
        CallStack callStack = environment.getCallStack();
        callStack.newSubFrame(expression2);
        callStack.addInstruction(new SimpleInstruction(expression2));
        Function0 explicitToStringCheck2 = new Function0<Unit>(callStack, environment){
            final /* synthetic */ CallStack $callStack;
            final /* synthetic */ IrInterpreterEnvironment $environment;
            {
                this.$callStack = $callStack;
                this.$environment = $environment;
                super(0);
            }

            public final void invoke() {
                State state = this.$callStack.peekState();
                if (state instanceof Common) {
                    this.$callStack.popState();
                    if (UtilsKt.isUnsigned(IrUtilsKt.getDefaultType(((Common)state).getIrClass()))) {
                        String string2;
                        boolean bl;
                        T value2 = ((Primitive)CollectionsKt.single(((Common)state).getFields()).getState()).getValue();
                        if (value2 instanceof Byte) {
                            byte by = ((Number)value2).byteValue();
                            bl = false;
                            string2 = UByte.toString-impl(UByte.constructor-impl(by));
                        } else if (value2 instanceof Short) {
                            short s = ((Number)value2).shortValue();
                            bl = false;
                            string2 = UShort.toString-impl(UShort.constructor-impl(s));
                        } else if (value2 instanceof Integer) {
                            int n = ((Number)value2).intValue();
                            bl = false;
                            string2 = Integer.toUnsignedString(UInt.constructor-impl(n));
                        } else {
                            if (value2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.Number");
                            }
                            long l = ((Number)value2).longValue();
                            boolean bl2 = false;
                            string2 = Long.toUnsignedString(ULong.constructor-impl(l));
                        }
                        String result2 = string2;
                        this.$callStack.pushState(UtilsKt.toState(result2, this.$environment.getIrBuiltIns().getStringType()));
                        return;
                    }
                    IrCall toStringCall = ((Common)state).createToStringIrCall();
                    this.$callStack.newSubFrame(toStringCall);
                    this.$callStack.addInstruction(new SimpleInstruction(toStringCall));
                    IrValueParameter irValueParameter = ((IrSimpleFunction)toStringCall.getSymbol().getOwner()).getDispatchReceiverParameter();
                    Intrinsics.checkNotNull(irValueParameter);
                    this.$callStack.addVariable(new Variable(irValueParameter.getSymbol(), state));
                }
            }
        };
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)expression2.getArguments());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrExpression it = (IrExpression)element$iv;
            boolean bl = false;
            callStack.addInstruction(new CustomInstruction(explicitToStringCheck2));
            callStack.addInstruction(new CompoundInstruction(it));
        }
    }

    private static final void unfoldComposite(IrComposite element, CallStack callStack) {
        IrStatementOrigin irStatementOrigin = element.getOrigin();
        if (Intrinsics.areEqual(irStatementOrigin, IrStatementOrigin.DESTRUCTURING_DECLARATION.INSTANCE) ? true : Intrinsics.areEqual(irStatementOrigin, IrStatementOrigin.DO_WHILE_LOOP.INSTANCE)) {
            Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)element.getStatements());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrStatement it = (IrStatement)element$iv;
                boolean bl = false;
                callStack.addInstruction(new CompoundInstruction(it));
            }
        } else {
            String string2 = element.getOrigin() + " not implemented";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
    }

    private static final void unfoldFunctionReference(IrFunctionReference reference, CallStack callStack) {
        IrExpression it;
        boolean bl;
        boolean bl2;
        IrExpression irExpression;
        IrFunction function2 = ((IrFunctionSymbol)reference.getSymbol()).getOwner();
        callStack.newSubFrame(reference);
        callStack.addInstruction(new SimpleInstruction(reference));
        IrExpression irExpression2 = reference.getDispatchReceiver();
        if (irExpression2 != null) {
            irExpression = irExpression2;
            bl2 = false;
            bl = false;
            it = irExpression;
            boolean bl3 = false;
            IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            callStack.addInstruction(new SimpleInstruction(irValueParameter));
        }
        irExpression2 = reference.getExtensionReceiver();
        if (irExpression2 != null) {
            irExpression = irExpression2;
            bl2 = false;
            bl = false;
            it = irExpression;
            boolean bl4 = false;
            IrValueParameter irValueParameter = function2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            callStack.addInstruction(new SimpleInstruction(irValueParameter));
        }
        irExpression2 = reference.getExtensionReceiver();
        if (irExpression2 != null) {
            irExpression = irExpression2;
            bl2 = false;
            bl = false;
            it = irExpression;
            boolean bl5 = false;
            callStack.addInstruction(new CompoundInstruction(it));
        }
        irExpression2 = reference.getDispatchReceiver();
        if (irExpression2 != null) {
            irExpression = irExpression2;
            bl2 = false;
            bl = false;
            it = irExpression;
            boolean bl6 = false;
            callStack.addInstruction(new CompoundInstruction(it));
        }
    }

    private static final void unfoldPropertyReference(IrPropertyReference propertyReference, CallStack callStack) {
        IrExpression it;
        boolean bl;
        boolean bl2;
        IrExpression irExpression;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = propertyReference.getGetter();
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        IrSimpleFunction getter2 = (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
        callStack.newSubFrame(propertyReference);
        callStack.addInstruction(new SimpleInstruction(propertyReference));
        IrExpression irExpression2 = propertyReference.getDispatchReceiver();
        if (irExpression2 != null) {
            irExpression = irExpression2;
            bl2 = false;
            bl = false;
            it = irExpression;
            boolean bl3 = false;
            IrValueParameter irValueParameter = getter2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            callStack.addInstruction(new SimpleInstruction(irValueParameter));
        }
        irExpression2 = propertyReference.getExtensionReceiver();
        if (irExpression2 != null) {
            irExpression = irExpression2;
            bl2 = false;
            bl = false;
            it = irExpression;
            boolean bl4 = false;
            IrValueParameter irValueParameter = getter2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            callStack.addInstruction(new SimpleInstruction(irValueParameter));
        }
        irExpression2 = propertyReference.getExtensionReceiver();
        if (irExpression2 != null) {
            irExpression = irExpression2;
            bl2 = false;
            bl = false;
            it = irExpression;
            boolean bl5 = false;
            callStack.addInstruction(new CompoundInstruction(it));
        }
        irExpression2 = propertyReference.getDispatchReceiver();
        if (irExpression2 != null) {
            irExpression = irExpression2;
            bl2 = false;
            bl = false;
            it = irExpression;
            boolean bl6 = false;
            callStack.addInstruction(new CompoundInstruction(it));
        }
    }

    private static final void unfoldClassReference(IrClassReference classReference, CallStack callStack) {
        callStack.addInstruction(new SimpleInstruction(classReference));
    }

    /*
     * WARNING - void declaration
     */
    private static final IrExpressionBody unfoldValueParameters$getDefaultForParameterAt$getDefault(IrValueParameter $this$unfoldValueParameters_u24getDefaultForParameterAt_u24getDefault) {
        IrExpressionBody irExpressionBody;
        block8: {
            IrExpressionBody irExpressionBody2 = $this$unfoldValueParameters_u24getDefaultForParameterAt_u24getDefault.getDefaultValue();
            if (irExpressionBody2 == null) {
                IrSimpleFunction irSimpleFunction;
                List list2 = $this$unfoldValueParameters_u24getDefaultForParameterAt_u24getDefault.getParent();
                IrSimpleFunction irSimpleFunction2 = irSimpleFunction = list2 instanceof IrSimpleFunction ? (IrSimpleFunction)((Object)list2) : null;
                if (irSimpleFunction == null) {
                    irExpressionBody = null;
                } else {
                    list2 = irSimpleFunction.getOverriddenSymbols();
                    if (list2 == null) {
                        irExpressionBody = null;
                    } else {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = list2;
                        boolean $i$f$map = false;
                        Iterator iterator2 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            IrExpressionBody irExpressionBody3 = InstructionsUnfolderKt.unfoldValueParameters$getDefaultForParameterAt$getDefault(((IrSimpleFunction)it.getOwner()).getValueParameters().get($this$unfoldValueParameters_u24getDefaultForParameterAt_u24getDefault.getIndex()));
                            collection.add(irExpressionBody3);
                        }
                        List list3 = (List)destination$iv$iv;
                        iterable = list3;
                        boolean bl = false;
                        for (Object t : iterable) {
                            IrExpressionBody it = (IrExpressionBody)t;
                            boolean bl2 = false;
                            IrExpressionBody irExpressionBody4 = it;
                            if (irExpressionBody4 == null) continue;
                            irExpressionBody = irExpressionBody4;
                            break block8;
                        }
                        irExpressionBody = null;
                    }
                }
            } else {
                irExpressionBody = irExpressionBody2;
            }
        }
        return irExpressionBody;
    }

    private static final IrExpression unfoldValueParameters$getDefaultForParameterAt(IrFunction irFunction2, int index2) {
        IrExpressionBody irExpressionBody = InstructionsUnfolderKt.unfoldValueParameters$getDefaultForParameterAt$getDefault(irFunction2.getValueParameters().get(index2));
        return irExpressionBody == null ? null : irExpressionBody.getExpression();
    }
}

