/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/EmptyStatementElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;)V", "hasChanges", "", "apply", "js.translator"})
public final class EmptyStatementElimination {
    @NotNull
    private final JsStatement root;
    private boolean hasChanges;

    public EmptyStatementElimination(@NotNull JsStatement root2) {
        Intrinsics.checkNotNullParameter(root2, "root");
        this.root = root2;
    }

    public final boolean apply() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ EmptyStatementElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx2) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx2, "ctx");
                return false;
            }

            public void endVisit(@NotNull JsLabel x, @NotNull JsContext<JsNode> ctx2) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx2, "ctx");
                if (MetadataProperties.getSynthetic(x)) {
                    JsStatement jsStatement = x.getStatement();
                    Intrinsics.checkNotNullExpressionValue(jsStatement, "x.statement");
                    if (this.isEmpty(jsStatement)) {
                        ctx2.replaceMe((JsNode)x.getStatement());
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    }
                }
            }

            public void endVisit(@NotNull JsBlock x, @NotNull JsContext<?> ctx2) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx2, "ctx");
                List<JsStatement> list2 = x.getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, "x.statements");
                this.processStatements(list2);
            }

            public void endVisit(@NotNull JsIf x, @NotNull JsContext<JsNode> ctx2) {
                boolean bl;
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx2, "ctx");
                JsStatement jsStatement = x.getThenStatement();
                Intrinsics.checkNotNullExpressionValue(jsStatement, "x.thenStatement");
                boolean thenEmpty = this.isEmpty(jsStatement);
                JsStatement jsStatement2 = x.getElseStatement();
                if (jsStatement2 == null) {
                    bl = true;
                } else {
                    JsStatement jsStatement3;
                    JsStatement it = jsStatement3 = jsStatement2;
                    boolean bl2 = false;
                    bl = this.isEmpty(it);
                }
                boolean elseEmpty = bl;
                if (thenEmpty && elseEmpty) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    ctx2.replaceMe((JsNode)JsAstUtils.asSyntheticStatement(x.getIfExpression()));
                } else if (elseEmpty) {
                    if (x.getElseStatement() != null) {
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                        x.setElseStatement(null);
                    }
                } else if (thenEmpty) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    JsStatement jsStatement4 = x.getElseStatement();
                    Intrinsics.checkNotNull(jsStatement4);
                    x.setThenStatement(jsStatement4);
                    x.setElseStatement(null);
                    x.setIfExpression(JsAstUtils.notOptimized(x.getIfExpression()));
                }
            }

            public void endVisit(@NotNull JsTry x, @NotNull JsContext<JsNode> ctx2) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx2, "ctx");
                JsBlock finallyBlock = x.getFinallyBlock();
                if (x.getTryBlock().isEmpty()) {
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    JsBlock jsBlock = finallyBlock;
                    ctx2.replaceMe(jsBlock == null ? (JsNode)JsEmpty.INSTANCE : (JsNode)jsBlock);
                }
            }

            public void endVisit(@NotNull JsSwitch x, @NotNull JsContext<JsNode> ctx2) {
                block16: {
                    Object object;
                    block15: {
                        boolean bl;
                        block13: {
                            JsSwitchMember it;
                            JsSwitchMember element$iv;
                            boolean $i$f$all;
                            Iterable<JsSwitchMember> $this$all$iv;
                            block14: {
                                boolean bl2;
                                block12: {
                                    Intrinsics.checkNotNullParameter(x, "x");
                                    Intrinsics.checkNotNullParameter(ctx2, "ctx");
                                    for (JsSwitchMember jsSwitchMember : x.getCases()) {
                                        object = jsSwitchMember.getStatements();
                                        Intrinsics.checkNotNullExpressionValue(object, "case.statements");
                                        this.processStatements((List<JsStatement>)object);
                                    }
                                    List<JsSwitchMember> list2 = x.getCases();
                                    Intrinsics.checkNotNullExpressionValue(list2, "x.cases");
                                    if (!(CollectionsKt.lastOrNull(list2) instanceof JsDefault)) break block14;
                                    list2 = x.getCases();
                                    Intrinsics.checkNotNullExpressionValue(list2, "x.cases");
                                    $this$all$iv = CollectionsKt.dropLast(list2, 1);
                                    $i$f$all = false;
                                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                        bl2 = true;
                                    } else {
                                        object = $this$all$iv.iterator();
                                        while (object.hasNext()) {
                                            it = element$iv = object.next();
                                            boolean bl3 = false;
                                            if (it.getStatements().isEmpty()) continue;
                                            bl2 = false;
                                            break block12;
                                        }
                                        bl2 = true;
                                    }
                                }
                                if (bl2) break block15;
                            }
                            $this$all$iv = x.getCases();
                            Intrinsics.checkNotNullExpressionValue($this$all$iv, "x.cases");
                            $this$all$iv = $this$all$iv;
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                            } else {
                                object = $this$all$iv.iterator();
                                while (object.hasNext()) {
                                    it = element$iv = object.next();
                                    boolean bl4 = false;
                                    if (it.getStatements().isEmpty()) continue;
                                    bl = false;
                                    break block13;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) break block16;
                    }
                    EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                    Object object2 = new JsStatement[]{JsAstUtils.asSyntheticStatement(x.getExpression())};
                    List<JsStatement> replacement = CollectionsKt.mutableListOf(object2);
                    object = x.getCases();
                    Intrinsics.checkNotNullExpressionValue(object, "x.cases");
                    object2 = (JsSwitchMember)CollectionsKt.lastOrNull(object);
                    if (object2 != null) {
                        Object $this$endVisit_u24lambda_u2d3 = object = object2;
                        boolean bl = false;
                        List<JsStatement> list3 = ((JsSwitchMember)$this$endVisit_u24lambda_u2d3).getStatements();
                        Intrinsics.checkNotNullExpressionValue(list3, "statements");
                        replacement.addAll((Collection<JsStatement>)list3);
                    }
                    ctx2.replaceMe((JsNode)new JsBlock(replacement));
                }
            }

            private final void processStatements(List<JsStatement> statements2) {
                for (IndexedValue<T> indexedValue : CollectionsKt.reversed(CollectionsKt.withIndex((Iterable)statements2))) {
                    int index2 = indexedValue.component1();
                    JsStatement statement2 = (JsStatement)indexedValue.component2();
                    if (statement2 instanceof JsEmpty) {
                        statements2.remove(index2);
                        EmptyStatementElimination.access$setHasChanges$p(this.this$0, true);
                        continue;
                    }
                    if (!(statement2 instanceof JsBlock)) continue;
                    statements2.remove(index2);
                    List<JsStatement> list2 = ((JsBlock)statement2).getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, "statement.statements");
                    statements2.addAll(index2, (Collection<JsStatement>)list2);
                }
            }

            private final boolean isEmpty(JsStatement statement2) {
                return statement2 instanceof JsBlock && ((JsBlock)statement2).isEmpty() || statement2 instanceof JsEmpty;
            }
        }.accept((JsNode)this.root);
        return this.hasChanges;
    }

    public static final /* synthetic */ void access$setHasChanges$p(EmptyStatementElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }
}

