/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.InvocationUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/RedundantCallElimination;", "", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "(Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;)V", "changed", "", "apply", "js.translator"})
public final class RedundantCallElimination {
    @NotNull
    private final JsBlock root;
    private boolean changed;

    public RedundantCallElimination(@NotNull JsBlock root2) {
        Intrinsics.checkNotNullParameter(root2, "root");
        this.root = root2;
    }

    public final boolean apply() {
        this.root.accept(new RecursiveJsVisitor(this){
            final /* synthetic */ RedundantCallElimination this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkNotNullParameter(invocation, "invocation");
                this.tryEliminate(invocation);
                super.visitInvocation(invocation);
            }

            private final void tryEliminate(JsInvocation invocation) {
                JsNameRef jsNameRef;
                if (!InvocationUtilsKt.isCallInvocation(invocation)) {
                    return;
                }
                JsExpression jsExpression = invocation.getQualifier();
                JsNameRef jsNameRef2 = jsNameRef = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
                if (jsNameRef == null) {
                    return;
                }
                JsNameRef call2 = jsNameRef;
                if (!MetadataProperties.isJsCall(call2)) {
                    return;
                }
                JsExpression jsExpression2 = call2.getQualifier();
                JsExpression jsExpression3 = jsExpression = jsExpression2 instanceof JsNameRef ? (JsNameRef)jsExpression2 : null;
                if (jsExpression == null) {
                    return;
                }
                JsExpression qualifier = jsExpression;
                JsExpression jsExpression4 = ((JsNameRef)qualifier).getQualifier();
                JsExpression jsExpression5 = jsExpression2 = jsExpression4 instanceof JsNameRef ? (JsNameRef)jsExpression4 : null;
                if (jsExpression2 == null) {
                    return;
                }
                JsExpression receiver = jsExpression2;
                List<JsExpression> list2 = invocation.getArguments();
                Intrinsics.checkNotNullExpressionValue(list2, "invocation.arguments");
                JsExpression jsExpression6 = CollectionsKt.firstOrNull(list2);
                JsExpression jsExpression7 = jsExpression4 = jsExpression6 instanceof JsNameRef ? (JsNameRef)jsExpression6 : null;
                if (jsExpression4 == null) {
                    return;
                }
                JsExpression firstArg = jsExpression4;
                if (((JsNameRef)receiver).getQualifier() == null && ((JsNameRef)receiver).getName() != null && ((JsNameRef)firstArg).getQualifier() == null && Intrinsics.areEqual(((JsNameRef)receiver).getName(), ((JsNameRef)firstArg).getName())) {
                    invocation.getArguments().remove(0);
                    invocation.setQualifier(qualifier);
                    RedundantCallElimination.access$setChanged$p(this.this$0, true);
                }
            }
        });
        return this.changed;
    }

    public static final /* synthetic */ void access$setChanged$p(RedundantCallElimination $this, boolean bl) {
        $this.changed = bl;
    }
}

