/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ContractNotAllowedCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ContractNotAllowedCallChecker
implements CallChecker {
    @NotNull
    public static final ContractNotAllowedCallChecker INSTANCE = new ContractNotAllowedCallChecker();

    private ContractNotAllowedCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        FunctionDescriptor functionDescriptor;
        HierarchicalScope hierarchicalScope;
        boolean acceptableParent;
        boolean bl;
        Object owner;
        FunctionDescriptor functionDescriptor2;
        FunctionDescriptor functionDescriptor3;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!(reportOn instanceof KtElement)) {
            return;
        }
        Object obj = resolvedCall2.getResultingDescriptor();
        FunctionDescriptor functionDescriptor4 = functionDescriptor3 = obj instanceof FunctionDescriptor ? (FunctionDescriptor)obj : null;
        if (functionDescriptor3 == null) {
            return;
        }
        FunctionDescriptor descriptor2 = functionDescriptor3;
        if (!PsiContractsUtilsKt.isContractCallDescriptor(descriptor2)) {
            return;
        }
        boolean allowedOnMembers = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.AllowContractsForNonOverridableMembers);
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "resolvedCall.call.callElement");
        KtElement callElement = ktElement;
        Ref.BooleanRef hasErrors = new Ref.BooleanRef();
        LexicalScope scope2 = context2.getScope();
        DeclarationDescriptor declarationDescriptor = scope2.getOwnerDescriptor();
        FunctionDescriptor functionDescriptor5 = functionDescriptor2 = declarationDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)declarationDescriptor : null;
        if (functionDescriptor2 == null || functionDescriptor2 instanceof PropertyAccessorDescriptor) {
            ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context2, reportOn, "Contracts are allowed only for functions");
        }
        boolean inFunctionBodyBlock = true;
        DeclarationDescriptor declarationOwner = scope2.getOwnerDescriptor().getContainingDeclaration();
        if (allowedOnMembers) {
            owner = declarationOwner;
            boolean result2 = true;
            while (!(owner instanceof PackageFragmentDescriptor)) {
                if (!(owner instanceof ClassDescriptor)) {
                    result2 = false;
                    break;
                }
                owner = ((ClassDescriptor)owner).getContainingDeclaration();
            }
            bl = result2;
        } else {
            bl = acceptableParent = declarationOwner instanceof PackageFragmentDescriptor;
        }
        if (!acceptableParent || scope2.getKind() != LexicalScopeKind.CODE_BLOCK || ((owner = (hierarchicalScope = scope2.getParent()) instanceof LexicalScope ? (LexicalScope)hierarchicalScope : null) == null ? null : owner.getKind()) != LexicalScopeKind.FUNCTION_INNER_SCOPE) {
            if (scope2.getKind() == LexicalScopeKind.FUNCTION_INNER_SCOPE) {
                ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context2, reportOn, "Contracts are allowed only in function body block");
                inFunctionBodyBlock = false;
            } else {
                String message2 = allowedOnMembers ? "Contracts are allowed only for functions" : "Contracts are allowed only for top-level functions";
                ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context2, reportOn, message2);
            }
        }
        if ((functionDescriptor = functionDescriptor2) == null ? false : functionDescriptor.isOperator()) {
            ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context2, reportOn, "Contracts are not allowed for operator functions");
        }
        if (!allowedOnMembers && ((functionDescriptor = functionDescriptor2) == null ? false : ModalityUtilsKt.isOverridable(functionDescriptor))) {
            ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context2, reportOn, "Contracts are not allowed for open functions");
        }
        if (allowedOnMembers && ((functionDescriptor = functionDescriptor2) == null ? false : ModalityUtilsKt.isOverridableOrOverrides(functionDescriptor))) {
            ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context2, reportOn, "Contracts are not allowed for open or override functions");
        }
        if (!KtPsiUtilKt.isFirstStatement(callElement) && inFunctionBodyBlock) {
            ContractNotAllowedCallChecker.check$contractNotAllowed(hasErrors, context2, reportOn, "Contract should be the first statement");
        }
        if (hasErrors.element) {
            context2.getTrace().record(BindingContext.CONTRACT_NOT_ALLOWED, callElement, true);
        }
    }

    private static final void check$contractNotAllowed(Ref.BooleanRef hasErrors, CallCheckerContext $context, PsiElement $reportOn, String message2) {
        hasErrors.element = true;
        $context.getTrace().report(Errors.CONTRACT_NOT_ALLOWED.on((KtElement)$reportOn, message2));
    }
}

