/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JShellLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiJShellHolderMethodImpl;
import com.intellij.psi.impl.source.PsiJShellImportHolderImpl;
import com.intellij.psi.impl.source.PsiJShellRootClassImpl;
import com.intellij.psi.impl.source.tree.IJShellElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import java.util.concurrent.atomic.AtomicInteger;

public interface JShellElementType {
    public static final IFileElementType FILE = new IFileElementType("JSHELL_FILE", JShellLanguage.INSTANCE);
    public static final IElementType ROOT_CLASS = new IJShellElementType("JSHELL_ROOT_CLASS"){
        private final AtomicInteger ourClassCounter = new AtomicInteger();

        @Override
        public PsiElement createPsi(ASTNode node) {
            return new PsiJShellRootClassImpl(node, this.ourClassCounter.getAndIncrement());
        }
    };
    public static final IElementType STATEMENTS_HOLDER = new IJShellElementType("JSHELL_STATEMENTS_HOLDER"){
        private final AtomicInteger ourMethodCounter = new AtomicInteger();

        @Override
        public PsiElement createPsi(ASTNode node) {
            return new PsiJShellHolderMethodImpl(node, this.ourMethodCounter.getAndIncrement());
        }
    };
    public static final IElementType IMPORT_HOLDER = new IJShellElementType("JSHELL_IMPORT_HOLDER"){

        @Override
        public PsiElement createPsi(ASTNode node) {
            return new PsiJShellImportHolderImpl(node);
        }
    };
}

