/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PluginLoadingError {
    @NotNull
    private final IdeaPluginDescriptor myPlugin;
    private final Supplier<String> myDetailedMessage;
    private final Supplier<String> myShortMessage;
    private final boolean myNotifyUser;
    private PluginId myDisabledDependency;

    static PluginLoadingError create(@NotNull IdeaPluginDescriptor plugin, @NotNull Supplier<String> detailedMessage, @NotNull @NotNull Supplier<@NotNull String> shortMessage) {
        if (plugin == null) {
            PluginLoadingError.$$$reportNull$$$0(0);
        }
        if (detailedMessage == null) {
            PluginLoadingError.$$$reportNull$$$0(1);
        }
        if (shortMessage == null) {
            PluginLoadingError.$$$reportNull$$$0(2);
        }
        return new PluginLoadingError(plugin, detailedMessage, shortMessage, true);
    }

    static PluginLoadingError createWithoutNotification(@NotNull IdeaPluginDescriptor plugin, @NotNull @NotNull Supplier<@NotNull String> shortMessage) {
        if (plugin == null) {
            PluginLoadingError.$$$reportNull$$$0(6);
        }
        if (shortMessage == null) {
            PluginLoadingError.$$$reportNull$$$0(7);
        }
        return new PluginLoadingError(plugin, null, shortMessage, false);
    }

    private PluginLoadingError(@NotNull IdeaPluginDescriptor plugin, Supplier<String> detailedMessage, Supplier<String> shortMessage, boolean notifyUser) {
        if (plugin == null) {
            PluginLoadingError.$$$reportNull$$$0(8);
        }
        this.myPlugin = plugin;
        this.myDetailedMessage = detailedMessage;
        this.myShortMessage = shortMessage;
        this.myNotifyUser = notifyUser;
    }

    void setDisabledDependency(PluginId disabledDependency) {
        this.myDisabledDependency = disabledDependency;
    }

    void register(Map<PluginId, PluginLoadingError> errorsMap) {
        errorsMap.put(this.myPlugin.getPluginId(), this);
    }

    @NotNull
    public String toString() {
        String string2 = this.getInternalMessage();
        if (string2 == null) {
            PluginLoadingError.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    @NonNls
    public String getInternalMessage() {
        return PluginLoadingError.formatErrorMessage(this.myPlugin, ObjectUtils.notNull(this.myDetailedMessage, this.myShortMessage).get());
    }

    @NonNls
    @NotNull
    static String formatErrorMessage(IdeaPluginDescriptor descriptor2, @NotNull String message) {
        if (message == null) {
            PluginLoadingError.$$$reportNull$$$0(10);
        }
        String path2 = descriptor2.getPluginPath().toString();
        StringBuilder builder2 = new StringBuilder();
        builder2.append("The ").append(descriptor2.getName()).append(" (id=").append(descriptor2.getPluginId()).append(", path=");
        builder2.append(FileUtil.getLocationRelativeToUserHome(path2, false));
        String version = descriptor2.getVersion();
        if (version != null && !descriptor2.isBundled() && !version.equals(PluginManagerCore.getBuildNumber().asString())) {
            builder2.append(", version=").append(version);
        }
        builder2.append(") plugin ").append(message);
        String string2 = builder2.toString();
        if (string2 == null) {
            PluginLoadingError.$$$reportNull$$$0(11);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailedMessage";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortMessage";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginLoadingError";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginLoadingError";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "formatErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createWithoutNotification";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

