/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import com.intellij.mock.MockProject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.CompilationException;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoaderKind;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.backend.wasm.dce.DceKt;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.CreatePhaseConfigKt;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.UtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.extensions.ScriptEvaluationExtension;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.js.K2JsIrCompiler;
import org.jetbrains.kotlin.cli.js.K2JsIrCompilerKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalNextRoundChecker;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.ir.backend.js.CompilationOutputs;
import org.jetbrains.kotlin.ir.backend.js.CompilerKt;
import org.jetbrains.kotlin.ir.backend.js.CompilerResult;
import org.jetbrains.kotlin.ir.backend.js.JsLoweringPhasesKt;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.LoweredIr;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.WholeWorldStageController;
import org.jetbrains.kotlin.ir.backend.js.codegen.JsGenerationGranularity;
import org.jetbrains.kotlin.ir.backend.js.ic.CacheUpdateStatus;
import org.jetbrains.kotlin.ir.backend.js.ic.CacheUpdater;
import org.jetbrains.kotlin.ir.backend.js.ic.JsExecutableProducer;
import org.jetbrains.kotlin.ir.backend.js.ic.ModuleArtifact;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrModuleToJsTransformerTmp;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.SourceMapsInfo;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.TranslationMode;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.AbstractIrFactoryImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImplForJsIC;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.EcmaVersion;
import org.jetbrains.kotlin.js.config.ErrorTolerancePolicy;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.config.RuntimeDiagnostic;
import org.jetbrains.kotlin.js.config.SourceMapSourceEmbedding;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u001a\u0010\u001c\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\u00170\u001d2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0014\u0010\u001e\u001a\u00020\u0019*\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "()V", "defaultPerformanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "getDefaultPerformanceManager", "()Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "createArguments", "createMetadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "versionArray", "", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "arguments", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "addPlatformOptions", "", "write", "Ljava/io/File;", "outputs", "Lorg/jetbrains/kotlin/ir/backend/js/CompilationOutputs;", "Companion", "cli-js"})
public final class K2JsIrCompiler
extends CLICompiler<K2JSCompilerArguments> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonCompilerPerformanceManager defaultPerformanceManager = new CommonCompilerPerformanceManager(){};
    @NotNull
    private static final Map<String, ModuleKind> moduleKindMap;
    @NotNull
    private static final Map<String, SourceMapSourceEmbedding> sourceMapContentEmbeddingMap;

    @Override
    @NotNull
    public CommonCompilerPerformanceManager getDefaultPerformanceManager() {
        return this.defaultPerformanceManager;
    }

    @Override
    @NotNull
    public K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JSCompilerArguments arguments2, @NotNull CompilerConfiguration configuration2, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        ModulesStructure module2;
        PhaseConfig phaseConfig;
        List<String> mainCallArguments;
        File outputFile;
        MessageCollector messageCollector;
        block55: {
            WasmLoaderKind wasmLoaderKind;
            WasmCompilerResult res2;
            block57: {
                block56: {
                    ModulesStructure modulesStructure;
                    Object includesPath;
                    List<ModuleArtifact> list2;
                    CharSequence charSequence2;
                    Unit unit2;
                    Intrinsics.checkNotNullParameter(arguments2, "arguments");
                    Intrinsics.checkNotNullParameter(configuration2, "configuration");
                    Intrinsics.checkNotNullParameter(rootDisposable, "rootDisposable");
                    MessageCollector messageCollector2 = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
                    Intrinsics.checkNotNullExpressionValue(messageCollector2, "configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
                    messageCollector = messageCollector2;
                    if (configuration2.getBoolean(CommonConfigurationKeys.USE_FIR)) {
                        MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "K2 does not support JS target right now", null, 4, null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    ExitCode pluginLoadResult = this.loadPlugins(paths, (CommonCompilerArguments)arguments2, configuration2);
                    if (pluginLoadResult != ExitCode.OK) {
                        return pluginLoadResult;
                    }
                    if (arguments2.getScript()) {
                        Object v2;
                        KotlinCoreEnvironment.ProjectEnvironment projectEnv;
                        block53: {
                            if (!arguments2.getEnableJsScripting()) {
                                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Script for K/JS should be enabled explicitly, see -Xenable-js-scripting", null, 4, null);
                                return ExitCode.COMPILATION_ERROR;
                            }
                            configuration2.put(CommonConfigurationKeys.MODULE_NAME, "repl.kts");
                            KotlinCoreApplicationEnvironment environment = KotlinCoreEnvironment.Companion.getOrCreateApplicationEnvironmentForProduction(rootDisposable, configuration2);
                            projectEnv = new KotlinCoreEnvironment.ProjectEnvironment(rootDisposable, environment, configuration2);
                            projectEnv.registerExtensionsFromPlugins(configuration2);
                            MockProject mockProject = projectEnv.getProject();
                            Intrinsics.checkNotNullExpressionValue(mockProject, "projectEnv.project");
                            List scriptingEvaluators = ScriptEvaluationExtension.Companion.getInstances(mockProject);
                            Iterable iterable = scriptingEvaluators;
                            for (Object t : iterable) {
                                ScriptEvaluationExtension it = (ScriptEvaluationExtension)t;
                                boolean bl = false;
                                if (!it.isAccepted(arguments2)) continue;
                                v2 = t;
                                break block53;
                            }
                            v2 = null;
                        }
                        ScriptEvaluationExtension scriptingEvaluator = v2;
                        if (scriptingEvaluator != null) return scriptingEvaluator.eval(arguments2, configuration2, projectEnv);
                        MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Unable to evaluate script, no scripting plugin loaded", null, 4, null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    if (arguments2.getFreeArgs().isEmpty() && !UtilsKt.incrementalCompilationIsEnabledForJs(arguments2)) {
                        if (arguments2.getVersion()) {
                            return ExitCode.OK;
                        }
                        CharSequence environment = arguments2.getIncludes();
                        if (environment == null || environment.length() == 0) {
                            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify at least one source file or directory", null);
                            return ExitCode.COMPILATION_ERROR;
                        }
                    }
                    List libraries = CollectionsKt.plus((Collection)K2JsIrCompiler.Companion.configureLibraries(arguments2.getLibraries()), (Iterable)CollectionsKt.listOfNotNull(arguments2.getIncludes()));
                    List friendLibraries = K2JsIrCompiler.Companion.configureLibraries(arguments2.getFriendModules());
                    List repositories = K2JsIrCompiler.Companion.configureLibraries(arguments2.getRepositries());
                    configuration2.put(JSConfigurationKeys.LIBRARIES, libraries);
                    configuration2.put(JSConfigurationKeys.TRANSITIVE_LIBRARIES, libraries);
                    configuration2.put(JSConfigurationKeys.REPOSITORIES, repositories);
                    configuration2.put(JSConfigurationKeys.PARTIAL_LINKAGE, arguments2.getPartialLinkage());
                    configuration2.put(JSConfigurationKeys.WASM_ENABLE_ARRAY_RANGE_CHECKS, arguments2.getWasmEnableArrayRangeChecks());
                    String[] commonSourcesArray = arguments2.getCommonSources();
                    Object object = commonSourcesArray;
                    if (commonSourcesArray == null || (object = ArraysKt.toSet(object)) == null) {
                        object = SetsKt.emptySet();
                    }
                    Object commonSources = object;
                    for (String arg : arguments2.getFreeArgs()) {
                        ContentRootsKt.addKotlinSourceRoot(configuration2, arg, commonSources.contains(arg));
                    }
                    String[] stringArray = arguments2.getRelativePathBases();
                    if (stringArray != null) {
                        String[] it = stringArray;
                        boolean bl = false;
                        configuration2.put(CommonConfigurationKeys.KLIB_RELATIVE_PATH_BASES, ArraysKt.toList(it));
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                    configuration2.put(CommonConfigurationKeys.KLIB_NORMALIZE_ABSOLUTE_PATH, arguments2.getNormalizeAbsolutePath());
                    KotlinCoreEnvironment environmentForJS = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration2, EnvironmentConfigFiles.JS_CONFIG_FILES);
                    Project projectJs = environmentForJS.getProject();
                    CompilerConfiguration configurationJs = environmentForJS.getConfiguration();
                    List<KtFile> sourcesFiles = environmentForJS.getSourceFiles();
                    configurationJs.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
                    configurationJs.put(CLIConfigurationKeys.RENDER_DIAGNOSTIC_INTERNAL_NAME, arguments2.getRenderInternalDiagnosticNames());
                    configurationJs.put(JSConfigurationKeys.PROPERTY_LAZY_INITIALIZATION, arguments2.getIrPropertyLazyInitialization());
                    if (!UtilsKt.checkKotlinPackageUsage(environmentForJS.getConfiguration(), (Collection<? extends KtFile>)sourcesFiles)) {
                        return ExitCode.COMPILATION_ERROR;
                    }
                    String outputFilePath = arguments2.getOutputFile();
                    if (outputFilePath == null) {
                        messageCollector.report(CompilerMessageSeverity.ERROR, "IR: Specify output file via -output", null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    if (messageCollector.hasErrors()) {
                        return ExitCode.COMPILATION_ERROR;
                    }
                    if (sourcesFiles.isEmpty() && !UtilsKt.incrementalCompilationIsEnabledForJs(arguments2) && ((charSequence2 = (CharSequence)arguments2.getIncludes()) == null || charSequence2.length() == 0)) {
                        messageCollector.report(CompilerMessageSeverity.ERROR, "No source files", null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    if (arguments2.getVerbose()) {
                        K2JsIrCompiler.Companion.reportCompiledSourcesList(messageCollector, sourcesFiles);
                    }
                    outputFile = new File(outputFilePath);
                    String string2 = arguments2.getIrModuleName();
                    if (string2 == null) {
                        String string3 = FileUtil.getNameWithoutExtension(outputFile);
                        string2 = string3;
                        Intrinsics.checkNotNullExpressionValue(string3, "getNameWithoutExtension(outputFile)");
                    }
                    String moduleName = string2;
                    configurationJs.put(CommonConfigurationKeys.MODULE_NAME, moduleName);
                    JsConfig config = new JsConfig(projectJs, configurationJs, CompilerEnvironment.INSTANCE);
                    File file2 = outputFile.getParentFile();
                    if (file2 == null) {
                        File file3 = outputFile.getAbsoluteFile().getParentFile();
                        file2 = file3;
                        Intrinsics.checkNotNull(file3);
                    }
                    File outputDir2 = file2;
                    try {
                        config.getConfiguration().put(JSConfigurationKeys.OUTPUT_DIR, outputDir2.getCanonicalFile());
                    }
                    catch (IOException e) {
                        messageCollector.report(CompilerMessageSeverity.ERROR, "Could not resolve output directory", null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    mainCallArguments = Intrinsics.areEqual("noCall", arguments2.getMain()) ? null : CollectionsKt.emptyList();
                    List cacheDirectories = K2JsIrCompiler.Companion.configureLibraries(arguments2.getCacheDirectories());
                    if (!((Collection)cacheDirectories).isEmpty()) {
                        MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "", null, 4, null);
                        MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "Building cache:", null, 4, null);
                        MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "to: " + outputFilePath, null, 4, null);
                        String string4 = arguments2.getCacheDirectories();
                        if (string4 == null) {
                            string4 = "";
                        }
                        MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, string4, null, 4, null);
                        MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, libraries.toString(), null, 4, null);
                        String string5 = arguments2.getIncludes();
                        Intrinsics.checkNotNull(string5);
                        String includes = string5;
                        Ref.LongRef start = new Ref.LongRef();
                        start.element = System.currentTimeMillis();
                        CacheUpdater cacheUpdater2 = new CacheUpdater(includes, libraries, configurationJs, cacheDirectories, doExecute.icCaches.cacheUpdater.1.INSTANCE, mainCallArguments, doExecute.icCaches.cacheUpdater.2.INSTANCE);
                        list2 = cacheUpdater2.actualizeCaches((Function2<? super CacheUpdateStatus, ? super String, Unit>)new Function2<CacheUpdateStatus, String, Unit>(start, messageCollector){
                            final /* synthetic */ Ref.LongRef $start;
                            final /* synthetic */ MessageCollector $messageCollector;
                            {
                                this.$start = $start;
                                this.$messageCollector = $messageCollector;
                                super(2);
                            }

                            public final void invoke(@NotNull CacheUpdateStatus updateStatus, @NotNull String updatedModule) {
                                Intrinsics.checkNotNullParameter(updateStatus, "updateStatus");
                                Intrinsics.checkNotNullParameter(updatedModule, "updatedModule");
                                long now = System.currentTimeMillis();
                                CacheUpdateStatus cacheUpdateStatus = updateStatus;
                                if (cacheUpdateStatus instanceof CacheUpdateStatus.FastPath) {
                                    doExecute.icCaches.1.invoke$reportCacheStatus$default(this.$messageCollector, now, this.$start, updatedModule, "up-to-date; fast check", null, null, 96, null);
                                } else if (cacheUpdateStatus instanceof CacheUpdateStatus.NoDirtyFiles) {
                                    doExecute.icCaches.1.invoke$reportCacheStatus$default(this.$messageCollector, now, this.$start, updatedModule, "up-to-date; full check", ((CacheUpdateStatus.NoDirtyFiles)updateStatus).getRemoved(), null, 64, null);
                                } else if (cacheUpdateStatus instanceof CacheUpdateStatus.Dirty) {
                                    StringBuilder stringBuilder2;
                                    Set<String> updated = null;
                                    updated = ((CacheUpdateStatus.Dirty)updateStatus).getUpdated();
                                    StringBuilder $this$invoke_u24lambda_u2d2 = stringBuilder2 = new StringBuilder("dirty");
                                    boolean bl = false;
                                    if (((CacheUpdateStatus.Dirty)updateStatus).getUpdatedAll()) {
                                        $this$invoke_u24lambda_u2d2.append("; all " + updated.size() + " sources updated");
                                        updated = SetsKt.emptySet();
                                    }
                                    $this$invoke_u24lambda_u2d2.append("; cache building");
                                    String string2 = stringBuilder2.toString();
                                    Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder(\"dirty\").a\u2026             }.toString()");
                                    String status2 = string2;
                                    doExecute.icCaches.1.invoke$reportCacheStatus(this.$messageCollector, now, this.$start, updatedModule, status2, ((CacheUpdateStatus.Dirty)updateStatus).getRemoved(), updated);
                                }
                                this.$start.element = now;
                            }

                            private static final void invoke$reportCacheStatus(MessageCollector messageCollector, long now, Ref.LongRef start, String $updatedModule, String status2, Set<String> removed2, Set<String> updated) {
                                String it;
                                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "IC per-file is " + status2 + " duration " + (now - start.element) + "ms; module [" + new File($updatedModule).getName() + ']', null, 4, null);
                                Iterable $this$forEach$iv = removed2;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (String)element$iv;
                                    boolean bl = false;
                                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "  Removed: " + it, null, 4, null);
                                }
                                $this$forEach$iv = updated;
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    it = (String)element$iv;
                                    boolean bl = false;
                                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "  Updated: " + it, null, 4, null);
                                }
                            }

                            static /* synthetic */ void invoke$reportCacheStatus$default(MessageCollector messageCollector, long l, Ref.LongRef longRef, String string2, String string3, Set set, Set set2, int n, Object object) {
                                if ((n & 0x20) != 0) {
                                    set = SetsKt.emptySet();
                                }
                                if ((n & 0x40) != 0) {
                                    set2 = SetsKt.emptySet();
                                }
                                doExecute.icCaches.1.invoke$reportCacheStatus(messageCollector, l, longRef, string2, string3, set, set2);
                            }
                        });
                    } else {
                        list2 = CollectionsKt.emptyList();
                    }
                    List<ModuleArtifact> icCaches2 = list2;
                    ModulesStructure sourceModule = null;
                    String includes = arguments2.getIncludes();
                    if (includes == null) {
                        AnalysisResult result2;
                        do {
                            List<KtFile> list3 = environmentForJS.getSourceFiles();
                            CompilerConfiguration compilerConfiguration = config.getConfiguration();
                            Intrinsics.checkNotNullExpressionValue(compilerConfiguration, "config.configuration");
                            sourceModule = KlibKt.prepareAnalyzedSourceModule$default(projectJs, list3, configurationJs, libraries, friendLibraries, new AnalyzerWithCompilerReport(compilerConfiguration), null, 64, null);
                            ModulesStructure modulesStructure2 = sourceModule;
                            if (modulesStructure2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("sourceModule");
                                modulesStructure2 = null;
                            }
                            if (!((result2 = modulesStructure2.getJsFrontEndResult().getJsAnalysisResult()) instanceof JsAnalysisResult.RetryWithAdditionalRoots)) continue;
                            environmentForJS.addKotlinSourceRoots(((JsAnalysisResult.RetryWithAdditionalRoots)result2).getAdditionalKotlinRoots());
                        } while (result2 instanceof JsAnalysisResult.RetryWithAdditionalRoots);
                        if (!sourceModule.getJsFrontEndResult().getJsAnalysisResult().getShouldGenerateCode()) {
                            return ExitCode.OK;
                        }
                    }
                    if (arguments2.getIrProduceKlibDir() || arguments2.getIrProduceKlibFile()) {
                        if (arguments2.getIrProduceKlibFile() && !Intrinsics.areEqual(FilesKt.getExtension(outputFile), "klib")) {
                            boolean $i$a$-require-K2JsIrCompiler$doExecute$32 = false;
                            String $i$a$-require-K2JsIrCompiler$doExecute$32 = "Please set up .klib file as output";
                            throw new IllegalArgumentException($i$a$-require-K2JsIrCompiler$doExecute$32.toString());
                        }
                        ModulesStructure modulesStructure3 = sourceModule;
                        if (modulesStructure3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("sourceModule");
                            modulesStructure3 = null;
                        }
                        IrFactory irFactory = IrFactoryImpl.INSTANCE;
                        String string6 = outputFile.getPath();
                        Intrinsics.checkNotNullExpressionValue(string6, "outputFile.path");
                        KlibKt.generateKLib$default(modulesStructure3, irFactory, string6, arguments2.getIrProduceKlibDir(), false, null, arguments2.getIrPerModuleOutputName(), 48, null);
                    }
                    if (!arguments2.getIrProduceJs()) return ExitCode.OK;
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "Produce executable: " + outputFilePath, null, 4, null);
                    String string7 = arguments2.getCacheDirectories();
                    if (string7 == null) {
                        string7 = "";
                    }
                    MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, string7, null, 4, null);
                    if (!((Collection)icCaches2).isEmpty()) {
                        long beforeIc2Js = System.currentTimeMillis();
                        ModuleKind moduleKind = configurationJs.get(JSConfigurationKeys.MODULE_KIND);
                        Intrinsics.checkNotNull((Object)moduleKind);
                        JsExecutableProducer jsExecutableProducer = new JsExecutableProducer(moduleName, moduleKind, SourceMapsInfo.Companion.from(configurationJs), icCaches2, true);
                        CompilationOutputs outputs2 = jsExecutableProducer.buildExecutable(arguments2.getIrPerModule(), (Function1<? super String, Unit>)new Function1<String, Unit>(messageCollector){
                            final /* synthetic */ MessageCollector $messageCollector;
                            {
                                this.$messageCollector = $messageCollector;
                                super(1);
                            }

                            public final void invoke(@NotNull String rebuiltModule) {
                                Intrinsics.checkNotNullParameter(rebuiltModule, "rebuiltModule");
                                MessageCollector.DefaultImpls.report$default(this.$messageCollector, CompilerMessageSeverity.INFO, "IC module builder rebuilt module [" + new File(rebuiltModule).getName() + ']', null, 4, null);
                            }
                        });
                        this.write(outputFile, outputs2);
                        Iterable<Pair<String, CompilationOutputs>> $this$forEach$iv = outputs2.getDependencies();
                        boolean $i$f$forEach = false;
                        Iterator<Pair<String, CompilationOutputs>> iterator2 = $this$forEach$iv.iterator();
                        while (iterator2.hasNext()) {
                            Pair<String, CompilationOutputs> element$iv;
                            Pair<String, CompilationOutputs> pair = element$iv = iterator2.next();
                            boolean bl = false;
                            String name = pair.component1();
                            CompilationOutputs content2 = pair.component2();
                            this.write(FilesKt.resolveSibling(outputFile, name + ".js"), content2);
                        }
                        MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "Executable production duration (IC): " + (System.currentTimeMillis() - beforeIc2Js) + "ms", null, 4, null);
                        return ExitCode.OK;
                    }
                    phaseConfig = CreatePhaseConfigKt.createPhaseConfig((CompilerPhase)JsLoweringPhasesKt.getJsPhases(), arguments2, messageCollector);
                    if (includes != null) {
                        Object v21;
                        block54: {
                            if (!((Collection)sourcesFiles).isEmpty()) {
                                MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.ERROR, "Source files are not supported when -Xinclude is present", null, 4, null);
                            }
                            includesPath = new File(includes).getCanonicalPath();
                            Iterable iterable = libraries;
                            for (Object t : iterable) {
                                String it = (String)t;
                                boolean bl = false;
                                if (!Intrinsics.areEqual(new File(it).getCanonicalPath(), includesPath)) continue;
                                v21 = t;
                                break block54;
                            }
                            v21 = null;
                        }
                        String string8 = v21;
                        if (string8 == null) {
                            throw new IllegalStateException(("No library with name " + includes + " (" + (String)includesPath + ") found").toString());
                        }
                        String mainLibPath = string8;
                        MainModule.Klib kLib = new MainModule.Klib(mainLibPath);
                        modulesStructure = new ModulesStructure(projectJs, kLib, configurationJs, libraries, friendLibraries);
                    } else {
                        modulesStructure = sourceModule;
                        if (modulesStructure == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("sourceModule");
                            modulesStructure = module2 = null;
                        }
                    }
                    if (!arguments2.getWasm()) break block55;
                    includesPath = org.jetbrains.kotlin.backend.wasm.CompilerKt.compileToLoweredIr(module2, new PhaseConfig(WasmLoweringPhasesKt.getWasmPhases(), null, null, null, null, null, null, null, null, null, null, false, false, false, 16382, null), IrFactoryImpl.INSTANCE, SetsKt.setOf(new FqName("main")), arguments2.getIrPropertyLazyInitialization());
                    List allModules2 = (List)((Pair)includesPath).component1();
                    WasmBackendContext backendContext = (WasmBackendContext)((Pair)includesPath).component2();
                    if (arguments2.getIrDce()) {
                        DceKt.eliminateDeadDeclarations(allModules2, backendContext);
                    }
                    res2 = org.jetbrains.kotlin.backend.wasm.CompilerKt.compileWasm(allModules2, backendContext, arguments2.getWasmDebug(), arguments2.getIrDce());
                    String element$iv = arguments2.getWasmLauncher();
                    if (element$iv == null) throw new IllegalArgumentException("Unrecognized flavor for the wasm launcher");
                    switch (element$iv.hashCode()) {
                        case 3156: {
                            if (!element$iv.equals("d8")) {
                                throw new IllegalArgumentException("Unrecognized flavor for the wasm launcher");
                            }
                            break block56;
                        }
                        case -1040170293: {
                            if (element$iv.equals("nodejs")) break;
                            throw new IllegalArgumentException("Unrecognized flavor for the wasm launcher");
                        }
                        case 100735: {
                            if (!element$iv.equals("esm")) throw new IllegalArgumentException("Unrecognized flavor for the wasm launcher");
                            wasmLoaderKind = WasmLoaderKind.BROWSER;
                            break block57;
                        }
                    }
                    wasmLoaderKind = WasmLoaderKind.NODE;
                    break block57;
                }
                wasmLoaderKind = WasmLoaderKind.D8;
                break block57;
                throw new IllegalArgumentException("Unrecognized flavor for the wasm launcher");
            }
            WasmLoaderKind launcherKind = wasmLoaderKind;
            File file4 = outputFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue(file4, "outputFile.parentFile");
            org.jetbrains.kotlin.backend.wasm.CompilerKt.writeCompilationResult(res2, file4, launcherKind, FilesKt.getNameWithoutExtension(outputFile));
            return ExitCode.OK;
        }
        long start = System.currentTimeMillis();
        JsGenerationGranularity granularity = arguments2.getIrPerModule() ? JsGenerationGranularity.PER_MODULE : (arguments2.getIrPerFile() ? JsGenerationGranularity.PER_FILE : JsGenerationGranularity.WHOLE_PROGRAM);
        try {
            CompilerResult compilerResult;
            Object transformer2;
            AbstractIrFactoryImpl irFactory = arguments2.getIrNewIr2Js() ? (AbstractIrFactoryImpl)new IrFactoryImplForJsIC(new WholeWorldStageController()) : (AbstractIrFactoryImpl)IrFactoryImpl.INSTANCE;
            LoweredIr ir2 = CompilerKt.compile$default(module2, phaseConfig, irFactory, null, K2JsIrCompilerKt.resolve(RuntimeDiagnostic.Companion, arguments2.getIrDceRuntimeDiagnostic(), messageCollector), false, false, arguments2.getIrBaseClassInMetadata(), arguments2.getIrSafeExternalBoolean(), K2JsIrCompilerKt.resolve(RuntimeDiagnostic.Companion, arguments2.getIrSafeExternalBooleanDiagnostic(), messageCollector), null, granularity, arguments2.getIrNewIr2Js(), 1128, null);
            if (arguments2.getIrNewIr2Js()) {
                transformer2 = new IrModuleToJsTransformerTmp(ir2.getContext(), mainCallArguments, false, true, ir2.getModuleFragmentToUniqueName(), false, 36, null);
                compilerResult = ((IrModuleToJsTransformerTmp)transformer2).generateModule((Iterable<? extends IrModuleFragment>)ir2.getAllModules(), SetsKt.setOf(TranslationMode.Companion.fromFlags(arguments2.getIrDce(), arguments2.getIrPerModule(), arguments2.getIrMinimizedMemberNames())));
            } else {
                transformer2 = new IrModuleToJsTransformer(ir2.getContext(), mainCallArguments, false, null, !arguments2.getIrDce(), arguments2.getIrDce(), arguments2.getIrPerModule(), true, ir2.getModuleFragmentToUniqueName(), false, 524, null);
                compilerResult = ((IrModuleToJsTransformer)transformer2).generateModule((Iterable<? extends IrModuleFragment>)ir2.getAllModules());
            }
            CompilerResult compiledModule = compilerResult;
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "Executable production duration: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
            CompilationOutputs outputs3 = (CompilationOutputs)CollectionsKt.single((Iterable)compiledModule.getOutputs().values());
            this.write(outputFile, outputs3);
            Iterable<Pair<String, CompilationOutputs>> $this$forEach$iv = outputs3.getDependencies();
            boolean $i$f$forEach = false;
            Iterator<Pair<String, CompilationOutputs>> iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                Pair<String, CompilationOutputs> element$iv;
                Pair<String, CompilationOutputs> pair = element$iv = iterator3.next();
                boolean bl = false;
                String name = pair.component1();
                CompilationOutputs content3 = pair.component2();
                this.write(FilesKt.resolveSibling(outputFile, name + ".js"), content3);
            }
            if (!arguments2.getGenerateDts()) return ExitCode.OK;
            File file5 = FileUtilsKt.withReplacedExtensionOrNull(outputFile, FilesKt.getExtension(outputFile), "d.ts");
            Intrinsics.checkNotNull(file5);
            File dtsFile = file5;
            String string9 = compiledModule.getTsDefinitions();
            if (string9 == null) {
                throw new IllegalStateException("No ts definitions".toString());
            }
            FilesKt.writeText$default(dtsFile, string9, null, 2, null);
            return ExitCode.OK;
        }
        catch (CompilationException e) {
            messageCollector.report(CompilerMessageSeverity.ERROR, ExceptionsKt.stackTraceToString(e), CompilerMessageLocation.Companion.create(e.getPath(), e.getLine(), e.getColumn(), e.getContent()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    private final void write(File $this$write, CompilationOutputs outputs2) {
        block0: {
            FilesKt.writeText$default($this$write, outputs2.getJsCode(), null, 2, null);
            String string2 = outputs2.getSourceMap();
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            File mapFile = FilesKt.resolveSibling($this$write, $this$write.getName() + ".map");
            FilesKt.appendText$default($this$write, "\n//# sourceMappingURL=" + mapFile.getName(), null, 2, null);
            FilesKt.writeText$default(mapFile, it, null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration2, @NotNull K2JSCompilerArguments arguments2, @NotNull Services services) {
        String sourceMapEmbedContentString;
        SourceMapSourceEmbedding sourceMapContentEmbedding;
        ErrorTolerancePolicy errorTolerancePolicy;
        ModuleKind moduleKind;
        String moduleKindName;
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(services, "services");
        MessageCollector messageCollector = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue(messageCollector, "configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        MessageCollector messageCollector2 = messageCollector;
        if (arguments2.getTarget() != null) {
            boolean bl = Intrinsics.areEqual("v5", arguments2.getTarget());
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = false;
                StringBuilder stringBuilder2 = new StringBuilder().append("Unsupported ECMA version: ");
                String string2 = arguments2.getTarget();
                Intrinsics.checkNotNull(string2);
                String $i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22 = stringBuilder2.append(string2).toString();
                throw new AssertionError((Object)$i$a$-assert-K2JsIrCompiler$setupPlatformSpecificArgumentsAndServices$22);
            }
        }
        configuration2.put(JSConfigurationKeys.TARGET, EcmaVersion.defaultVersion());
        if (arguments2.getSourceMap()) {
            String sourceMapSourceRoots;
            configuration2.put(JSConfigurationKeys.SOURCE_MAP, true);
            if (arguments2.getSourceMapPrefix() != null) {
                String string3 = arguments2.getSourceMapPrefix();
                Intrinsics.checkNotNull(string3);
                configuration2.put(JSConfigurationKeys.SOURCE_MAP_PREFIX, string3);
            }
            if ((sourceMapSourceRoots = arguments2.getSourceMapBaseDirs()) == null && StringUtil.isNotEmpty(arguments2.getSourceMapPrefix())) {
                sourceMapSourceRoots = K2JSCompiler.calculateSourceMapSourceRoot(messageCollector2, arguments2);
            }
            if (sourceMapSourceRoots != null) {
                List<String> list2 = StringUtil.split(sourceMapSourceRoots, File.pathSeparator);
                Intrinsics.checkNotNullExpressionValue(list2, "split(sourceMapSourceRoots, File.pathSeparator)");
                List<String> sourceMapSourceRootList = list2;
                configuration2.put(JSConfigurationKeys.SOURCE_MAP_SOURCE_ROOTS, sourceMapSourceRootList);
            }
        } else {
            if (arguments2.getSourceMapPrefix() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-prefix argument has no effect without source map", null);
            }
            if (arguments2.getSourceMapBaseDirs() != null) {
                messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-source-root argument has no effect without source map", null);
            }
        }
        if (arguments2.getMetaInfo()) {
            configuration2.put(JSConfigurationKeys.META_INFO, true);
        }
        configuration2.put(JSConfigurationKeys.TYPED_ARRAYS_ENABLED, arguments2.getTypedArrays());
        configuration2.put(JSConfigurationKeys.FRIEND_PATHS_DISABLED, arguments2.getFriendModulesDisabled());
        String friendModules = arguments2.getFriendModules();
        if (!arguments2.getFriendModulesDisabled() && friendModules != null) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            List list3;
            Iterable $this$dropLastWhile$iv;
            Object object = friendModules;
            String string4 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue(string4, "pathSeparator");
            Object object2 = string4;
            object2 = new Regex((String)object2);
            int n = 0;
            object = ((Regex)object2).split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list3 = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list3;
            boolean $i$f$filterNot = false;
            void iterator$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List friendPaths = (List)destination$iv$iv;
            configuration2.put(JSConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        String string5 = moduleKindName = arguments2.getModuleKind();
        ModuleKind moduleKind2 = moduleKind = string5 != null ? moduleKindMap.get(string5) : ModuleKind.PLAIN;
        if (moduleKind == null) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module kind: " + moduleKindName + ". Valid values are: plain, amd, commonjs, umd", null);
            moduleKind = ModuleKind.PLAIN;
        }
        configuration2.put(JSConfigurationKeys.MODULE_KIND, moduleKind);
        configuration2.putIfNotNull(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER, services.get(IncrementalDataProvider.class));
        configuration2.putIfNotNull(JSConfigurationKeys.INCREMENTAL_RESULTS_CONSUMER, services.get(IncrementalResultsConsumer.class));
        configuration2.putIfNotNull(JSConfigurationKeys.INCREMENTAL_NEXT_ROUND_CHECKER, services.get(IncrementalNextRoundChecker.class));
        configuration2.putIfNotNull(CommonConfigurationKeys.LOOKUP_TRACKER, services.get(LookupTracker.class));
        configuration2.putIfNotNull(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER, services.get(ExpectActualTracker.class));
        String string6 = arguments2.getErrorTolerancePolicy();
        if (string6 != null) {
            String it = string6;
            boolean bl = false;
            errorTolerancePolicy = ErrorTolerancePolicy.Companion.resolvePolicy(it);
        } else {
            errorTolerancePolicy = null;
        }
        ErrorTolerancePolicy errorTolerancePolicy2 = errorTolerancePolicy;
        configuration2.putIfNotNull(JSConfigurationKeys.ERROR_TOLERANCE_POLICY, errorTolerancePolicy2);
        ErrorTolerancePolicy errorTolerancePolicy3 = errorTolerancePolicy2;
        boolean bl = errorTolerancePolicy3 != null ? errorTolerancePolicy3.getAllowErrors() : false;
        if (bl) {
            configuration2.put(JSConfigurationKeys.DEVELOPER_MODE, true);
        }
        SourceMapSourceEmbedding sourceMapSourceEmbedding = sourceMapContentEmbedding = (sourceMapEmbedContentString = arguments2.getSourceMapEmbedSources()) != null ? sourceMapContentEmbeddingMap.get(sourceMapEmbedContentString) : SourceMapSourceEmbedding.INLINING;
        if (sourceMapContentEmbedding == null) {
            String message = "Unknown source map source embedding mode: " + sourceMapEmbedContentString + ". Valid values are: " + StringUtil.join((Collection<String>)sourceMapContentEmbeddingMap.keySet(), ", ");
            messageCollector2.report(CompilerMessageSeverity.ERROR, message, null);
            sourceMapContentEmbedding = SourceMapSourceEmbedding.INLINING;
        }
        configuration2.put(JSConfigurationKeys.SOURCE_MAP_EMBED_SOURCES, sourceMapContentEmbedding);
        if (!arguments2.getSourceMap() && sourceMapEmbedContentString != null) {
            messageCollector2.report(CompilerMessageSeverity.WARNING, "source-map-embed-sources argument has no effect without source map", null);
        }
        configuration2.put(JSConfigurationKeys.PRINT_REACHABILITY_INFO, arguments2.getIrDcePrintReachabilityInfo());
        configuration2.put(JSConfigurationKeys.FAKE_OVERRIDE_VALIDATOR, arguments2.getFakeOverrideValidator());
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        String string2 = "Provide a proper way to run the compiler with IR BE";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    protected BinaryVersion createMetadataVersion(@NotNull int[] versionArray) {
        Intrinsics.checkNotNullParameter(versionArray, "versionArray");
        return new KlibMetadataVersion(Arrays.copyOf(versionArray, versionArray.length));
    }

    @Override
    protected void addPlatformOptions(@NotNull List<String> $this$addPlatformOptions, @NotNull K2JSCompilerArguments arguments2) {
        Intrinsics.checkNotNullParameter($this$addPlatformOptions, "<this>");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("plain", ModuleKind.PLAIN), TuplesKt.to("commonjs", ModuleKind.COMMON_JS), TuplesKt.to("amd", ModuleKind.AMD), TuplesKt.to("umd", ModuleKind.UMD), TuplesKt.to("es", ModuleKind.ES)};
        moduleKindMap = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to("always", SourceMapSourceEmbedding.ALWAYS), TuplesKt.to("never", SourceMapSourceEmbedding.NEVER), TuplesKt.to("inlining", SourceMapSourceEmbedding.INLINING)};
        sourceMapContentEmbeddingMap = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0002J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\nH\u0002J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\n*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/cli/js/K2JsIrCompiler$Companion;", "", "()V", "moduleKindMap", "", "", "Lorg/jetbrains/kotlin/serialization/js/ModuleKind;", "sourceMapContentEmbeddingMap", "Lorg/jetbrains/kotlin/js/config/SourceMapSourceEmbedding;", "configureLibraries", "", "libraryString", "main", "", "args", "", "([Ljava/lang/String;)V", "reportCompiledSourcesList", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "sourceFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "splitByPathSeparator", "cli-js"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter(args, "args");
            CLITool.Companion.doMain(new K2JsIrCompiler(), args);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportCompiledSourcesList(MessageCollector messageCollector, List<? extends KtFile> sourceFiles2) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = sourceFiles2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void file2;
                KtFile ktFile = (KtFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = file2.getVirtualFile();
                collection.add(virtualFile2 != null ? MessageUtil.virtualFileToPath(virtualFile2) : file2.getName() + " (no virtual file)");
            }
            List fileNames = (List)destination$iv$iv;
            messageCollector.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + StringsKt.join(fileNames, ", "), null);
        }

        private final List<String> configureLibraries(String libraryString) {
            Object object = libraryString;
            if (object == null || (object = this.splitByPathSeparator((String)object)) == null) {
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> splitByPathSeparator(String $this$splitByPathSeparator) {
            void $this$filterNotTo$iv$iv;
            List list2;
            CharSequence charSequence2 = $this$splitByPathSeparator;
            String string2 = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue(string2, "pathSeparator");
            Object object = string2;
            object = new Regex((String)object);
            int n = 0;
            List<String> $this$dropLastWhile$iv = ((Regex)object).split(charSequence2, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator<String> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            String[] $this$toTypedArray$iv = (String[])list2;
            boolean $i$f$toTypedArray = false;
            String[] thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull(stringArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            String[] $this$filterNot$iv = stringArray;
            boolean $i$f$filterNot = false;
            thisCollection$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (void element$iv$iv : $this$filterNotTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

