/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collections;
import java.util.Map;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.backend.common.SamType;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ClassBodyCodegen;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SyntheticInnerClassInfo;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class SamWrapperCodegen {
    private static final Method GET_FUNCTION_DELEGATE = new Method("getFunctionDelegate", AsmTypes.FUNCTION, new Type[0]);
    private final GenerationState state;
    private final boolean isInsideInline;
    private final KotlinTypeMapper typeMapper;
    private final SamType samType;
    private final MemberCodegen<?> parentCodegen;
    private final CodegenContext<?> parentContext;
    private final int visibility;
    private final int classFlags;
    public static final String SAM_WRAPPER_SUFFIX = "$0";

    public SamWrapperCodegen(@NotNull GenerationState state, @NotNull SamType samType, @NotNull MemberCodegen<?> parentCodegen, @NotNull CodegenContext<?> parentContext, boolean isInsideInline) {
        if (state == null) {
            SamWrapperCodegen.$$$reportNull$$$0(0);
        }
        if (samType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(1);
        }
        if (parentCodegen == null) {
            SamWrapperCodegen.$$$reportNull$$$0(2);
        }
        if (parentContext == null) {
            SamWrapperCodegen.$$$reportNull$$$0(3);
        }
        this.state = state;
        this.isInsideInline = isInsideInline;
        this.typeMapper = state.getTypeMapper();
        this.samType = samType;
        this.parentCodegen = parentCodegen;
        this.parentContext = parentContext;
        this.visibility = isInsideInline ? 1 : 0;
        int synth = state.getLanguageVersionSettings().supportsFeature(LanguageFeature.SamWrapperClassesAreSynthetic) ? 4096 : 0;
        this.classFlags = this.visibility | 0x10 | 0x20 | synth;
    }

    @NotNull
    public Type genWrapper(@NotNull KtFile file2, @NotNull CallableMemberDescriptor contextDescriptor) {
        String[] stringArray;
        if (file2 == null) {
            SamWrapperCodegen.$$$reportNull$$$0(4);
        }
        if (contextDescriptor == null) {
            SamWrapperCodegen.$$$reportNull$$$0(5);
        }
        FqName fqName2 = this.getWrapperName(file2, contextDescriptor);
        Type asmType = AsmUtil.asmTypeByFqNameWithoutInnerClasses(fqName2);
        KotlinType functionType = this.samType.getKotlinFunctionType();
        boolean isKotlinFunInterface = !(this.samType.getClassDescriptor() instanceof JavaClassDescriptor);
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(this.samType.getClassDescriptor().getContainingDeclaration(), fqName2.shortName(), Modality.FINAL, ClassKind.CLASS, Collections.singleton(this.samType.getType()), SourceElement.NO_SOURCE, false, LockBasedStorageManager.NO_LOCKS);
        classDescriptor.initialize(MemberScope.Empty.INSTANCE, Collections.emptySet(), null);
        SimpleFunctionDescriptor erasedInterfaceFunction = this.samType.getOriginalAbstractMethod().copy(classDescriptor, Modality.FINAL, DescriptorVisibilities.PUBLIC, CallableMemberDescriptor.Kind.SYNTHESIZED, false);
        ClassBuilder cv = this.state.getFactory().newVisitor(JvmDeclarationOriginKt.OtherOrigin(erasedInterfaceFunction), asmType, file2);
        Type samAsmType = this.typeMapper.mapType(this.samType.getType());
        if (isKotlinFunInterface) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = samAsmType.getInternalName();
            stringArray = stringArray2;
            stringArray2[1] = AsmTypes.FUNCTION_ADAPTER.getInternalName();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = samAsmType.getInternalName();
        }
        String[] superInterfaces = stringArray;
        cv.defineClass(file2, this.state.getClassFileVersion(), this.classFlags, asmType.getInternalName(), null, AsmTypes.OBJECT_TYPE.getInternalName(), superInterfaces);
        cv.visitSource(file2.getName(), null);
        WriteAnnotationUtilKt.writeSyntheticClassMetadata(cv, this.state, this.isInsideInline);
        this.generateInnerClassInformation(file2, asmType, cv);
        Type functionAsmType = this.typeMapper.mapType(functionType);
        cv.newField(JvmDeclarationOriginKt.OtherOrigin(erasedInterfaceFunction), 4114, "function", functionAsmType.getDescriptor(), null, null);
        this.generateConstructor(asmType, functionAsmType, cv);
        ClassContext context = this.state.getRootContext().intoClass(classDescriptor, OwnerKind.IMPLEMENTATION, this.state);
        FunctionCodegen functionCodegen = new FunctionCodegen(context, cv, this.state, this.parentCodegen);
        this.generateMethod(asmType, functionAsmType, erasedInterfaceFunction, functionType, functionCodegen);
        if (isKotlinFunInterface) {
            SamWrapperCodegen.generateGetFunctionDelegate(cv, asmType, functionAsmType);
            SamWrapperCodegen.generateEquals(cv, asmType, functionAsmType, samAsmType);
            SamWrapperCodegen.generateHashCode(cv, asmType, functionAsmType);
            SamWrapperCodegen.generateDelegatesToDefaultImpl(asmType, classDescriptor, this.samType.getClassDescriptor(), functionCodegen, this.state);
        }
        cv.done();
        Type type2 = asmType;
        if (type2 == null) {
            SamWrapperCodegen.$$$reportNull$$$0(6);
        }
        return type2;
    }

    private void generateInnerClassInformation(@NotNull KtFile file2, Type asmType, ClassBuilder cv) {
        if (file2 == null) {
            SamWrapperCodegen.$$$reportNull$$$0(7);
        }
        this.parentCodegen.addSyntheticAnonymousInnerClass(new SyntheticInnerClassInfo(asmType.getInternalName(), this.classFlags));
        CodegenContext<?> outerContext = MemberCodegen.getNonInlineOuterContext(this.parentContext);
        assert (outerContext != null) : "Outer context for SAM wrapper " + asmType.getInternalName() + " is null, parentContext:" + this.parentContext;
        Type outerClassType = MemberCodegen.computeOuterClass(this.state.getTypeMapper(), this.state.getJvmDefaultMode(), file2, outerContext);
        assert (outerClassType != null) : "Outer class for SAM wrapper " + asmType.getInternalName() + " is null, parentContext:" + this.parentContext;
        Method enclosingMethod = MemberCodegen.computeEnclosingMethod(this.state.getTypeMapper(), outerContext);
        cv.visitOuterClass(outerClassType.getInternalName(), enclosingMethod == null ? null : enclosingMethod.getName(), enclosingMethod == null ? null : enclosingMethod.getDescriptor());
        cv.visitInnerClass(asmType.getInternalName(), null, null, this.classFlags);
    }

    private void generateConstructor(Type ownerType, Type functionType, ClassBuilder cv) {
        MethodVisitor mv = cv.newMethod(JvmDeclarationOriginKt.OtherOrigin(this.samType.getClassDescriptor()), this.visibility, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, functionType), null, null);
        if (this.state.getClassBuilderMode().generateBodies) {
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            iv.load(0, AsmTypes.OBJECT_TYPE);
            iv.invokespecial(AsmTypes.OBJECT_TYPE.getInternalName(), "<init>", "()V", false);
            iv.load(0, AsmTypes.OBJECT_TYPE);
            iv.load(1, functionType);
            iv.putfield(ownerType.getInternalName(), "function", functionType.getDescriptor());
            iv.visitInsn(177);
            FunctionCodegen.endVisit(iv, "constructor of SAM wrapper");
        }
    }

    private void generateMethod(@NotNull Type ownerType, @NotNull Type functionType, @NotNull SimpleFunctionDescriptor erasedInterfaceFunction, @NotNull KotlinType functionKotlinType, @NotNull FunctionCodegen functionCodegen) {
        if (ownerType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(8);
        }
        if (functionType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(9);
        }
        if (erasedInterfaceFunction == null) {
            SamWrapperCodegen.$$$reportNull$$$0(10);
        }
        if (functionKotlinType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(11);
        }
        if (functionCodegen == null) {
            SamWrapperCodegen.$$$reportNull$$$0(12);
        }
        SimpleFunctionDescriptor invokeFunction = functionKotlinType.getMemberScope().getContributedFunctions(OperatorNameConventions.INVOKE, NoLookupLocation.FROM_BACKEND).iterator().next().getOriginal();
        StackValue.Field functionField = StackValue.field(functionType, ownerType, "function", false, StackValue.none());
        functionCodegen.genSamDelegate(erasedInterfaceFunction, invokeFunction, functionField);
        SimpleFunctionDescriptor originalInterfaceErased = this.samType.getOriginalAbstractMethod();
        ClosureCodegen.generateBridgesForSAM(originalInterfaceErased, erasedInterfaceFunction, functionCodegen);
    }

    private static void generateEquals(@NotNull ClassBuilder cv, @NotNull Type asmType, @NotNull Type functionAsmType, @NotNull Type samAsmType) {
        if (cv == null) {
            SamWrapperCodegen.$$$reportNull$$$0(13);
        }
        if (asmType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(14);
        }
        if (functionAsmType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(15);
        }
        if (samAsmType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(16);
        }
        MethodVisitor mv = cv.newMethod(JvmDeclarationOrigin.NO_ORIGIN, 1, "equals", "(Ljava/lang/Object;)Z", null, null);
        InstructionAdapter iv = new InstructionAdapter(mv);
        Label notEqual = new Label();
        iv.load(1, AsmTypes.OBJECT_TYPE);
        iv.instanceOf(samAsmType);
        iv.ifeq(notEqual);
        iv.load(1, AsmTypes.OBJECT_TYPE);
        iv.instanceOf(AsmTypes.FUNCTION_ADAPTER);
        iv.ifeq(notEqual);
        iv.load(0, AsmTypes.OBJECT_TYPE);
        iv.getfield(asmType.getInternalName(), "function", functionAsmType.getDescriptor());
        iv.load(1, AsmTypes.OBJECT_TYPE);
        iv.checkcast(AsmTypes.FUNCTION_ADAPTER);
        iv.invokeinterface(AsmTypes.FUNCTION_ADAPTER.getInternalName(), GET_FUNCTION_DELEGATE.getName(), GET_FUNCTION_DELEGATE.getDescriptor());
        DescriptorAsmUtil.genAreEqualCall(iv);
        iv.ifeq(notEqual);
        iv.iconst(1);
        Label exit = new Label();
        iv.goTo(exit);
        iv.visitLabel(notEqual);
        iv.iconst(0);
        iv.visitLabel(exit);
        iv.areturn(Type.BOOLEAN_TYPE);
        FunctionCodegen.endVisit(iv, "equals of SAM wrapper");
    }

    private static void generateHashCode(@NotNull ClassBuilder cv, @NotNull Type asmType, @NotNull Type functionAsmType) {
        if (cv == null) {
            SamWrapperCodegen.$$$reportNull$$$0(17);
        }
        if (asmType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(18);
        }
        if (functionAsmType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(19);
        }
        MethodVisitor mv = cv.newMethod(JvmDeclarationOrigin.NO_ORIGIN, 1, "hashCode", "()I", null, null);
        InstructionAdapter iv = new InstructionAdapter(mv);
        iv.load(0, AsmTypes.OBJECT_TYPE);
        iv.getfield(asmType.getInternalName(), "function", functionAsmType.getDescriptor());
        iv.invokevirtual(AsmTypes.OBJECT_TYPE.getInternalName(), "hashCode", "()I", false);
        iv.areturn(Type.INT_TYPE);
        FunctionCodegen.endVisit(iv, "hashCode of SAM wrapper");
    }

    private static void generateGetFunctionDelegate(@NotNull ClassBuilder cv, @NotNull Type asmType, @NotNull Type functionAsmType) {
        if (cv == null) {
            SamWrapperCodegen.$$$reportNull$$$0(20);
        }
        if (asmType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(21);
        }
        if (functionAsmType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(22);
        }
        MethodVisitor mv = cv.newMethod(JvmDeclarationOrigin.NO_ORIGIN, 1, GET_FUNCTION_DELEGATE.getName(), GET_FUNCTION_DELEGATE.getDescriptor(), null, null);
        InstructionAdapter iv = new InstructionAdapter(mv);
        iv.load(0, asmType);
        iv.getfield(asmType.getInternalName(), "function", functionAsmType.getDescriptor());
        iv.areturn(AsmTypes.OBJECT_TYPE);
        FunctionCodegen.endVisit(iv, "getFunctionDelegate of SAM wrapper");
    }

    public static void generateDelegatesToDefaultImpl(@NotNull Type asmType, @NotNull ClassDescriptor classDescriptor, @NotNull ClassDescriptor funInterface, @NotNull FunctionCodegen functionCodegen, @NotNull GenerationState state) {
        if (asmType == null) {
            SamWrapperCodegen.$$$reportNull$$$0(23);
        }
        if (classDescriptor == null) {
            SamWrapperCodegen.$$$reportNull$$$0(24);
        }
        if (funInterface == null) {
            SamWrapperCodegen.$$$reportNull$$$0(25);
        }
        if (functionCodegen == null) {
            SamWrapperCodegen.$$$reportNull$$$0(26);
        }
        if (state == null) {
            SamWrapperCodegen.$$$reportNull$$$0(27);
        }
        JvmKotlinType receiverType = new JvmKotlinType(asmType, classDescriptor.getDefaultType());
        for (DeclarationDescriptor descriptor2 : DescriptorUtils.getAllDescriptors(funInterface.getDefaultType().getMemberScope())) {
            CallableMemberDescriptor member2;
            if (!(descriptor2 instanceof CallableMemberDescriptor) || (member2 = (CallableMemberDescriptor)descriptor2).getModality() == Modality.ABSTRACT || DescriptorVisibilities.isPrivate(member2.getVisibility()) || member2.getVisibility() == DescriptorVisibilities.INVISIBLE_FAKE || DescriptorUtils.isMethodOfAny(member2)) continue;
            for (Map.Entry<FunctionDescriptor, FunctionDescriptor> entry : CodegenUtil.INSTANCE.copyFunctions(member2, member2, classDescriptor, Modality.OPEN, DescriptorVisibilities.PUBLIC, CallableMemberDescriptor.Kind.DECLARATION, false).entrySet()) {
                ClassBodyCodegen.generateDelegationToDefaultImpl(entry.getKey(), entry.getValue(), receiverType, functionCodegen, state, false);
            }
        }
    }

    @NotNull
    private FqName getWrapperName(@NotNull KtFile containingFile, CallableMemberDescriptor contextDescriptor) {
        FqName outermostOwner;
        if (containingFile == null) {
            SamWrapperCodegen.$$$reportNull$$$0(28);
        }
        boolean hasPackagePartClass = !CodegenUtil.getMemberDeclarationsToGenerate(containingFile).isEmpty();
        FqName filePartFqName = JvmFileClassUtil.getFileClassInfoNoResolve(containingFile).getFileClassFqName();
        if (hasPackagePartClass) {
            outermostOwner = filePartFqName;
        } else {
            ClassDescriptor outermostClassifier = SamWrapperCodegen.getOutermostParentClass(contextDescriptor);
            if (outermostClassifier == null) {
                throw new IllegalStateException("Can't find outermost parent class for " + contextDescriptor);
            }
            String internalName2 = this.typeMapper.mapType(outermostClassifier).getInternalName();
            outermostOwner = filePartFqName.parent().child(Name.identifier(StringsKt.substringAfterLast(internalName2, '/', internalName2)));
        }
        String shortName = String.format("%s$sam%s$%s$0", outermostOwner.shortName().asString(), this.isInsideInline ? "$i" : "", DescriptorUtils.getFqNameSafe(this.samType.getClassDescriptor()).asString().replace('.', '_'));
        FqName fqName2 = outermostOwner.parent().child(Name.identifier(shortName));
        if (fqName2 == null) {
            SamWrapperCodegen.$$$reportNull$$$0(29);
        }
        return fqName2;
    }

    private static ClassDescriptor getOutermostParentClass(CallableMemberDescriptor contextDescriptor) {
        ClassDescriptor next;
        ClassDescriptor parent2 = DescriptorUtils.getParentOfType(contextDescriptor, ClassDescriptor.class, true);
        do {
            if ((next = DescriptorUtils.getParentOfType(parent2, ClassDescriptor.class, true)) == null) continue;
            parent2 = next;
        } while (next != null);
        return parent2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 29: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCodegen";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextDescriptor";
                break;
            }
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/SamWrapperCodegen";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "erasedInterfaceFunction";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionKotlinType";
                break;
            }
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCodegen";
                break;
            }
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cv";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asmType";
                break;
            }
            case 15: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionAsmType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "samAsmType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funInterface";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/SamWrapperCodegen";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "genWrapper";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapperName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "genWrapper";
                break;
            }
            case 6: 
            case 29: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateInnerClassInformation";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generateMethod";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "generateEquals";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateHashCode";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateGetFunctionDelegate";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "generateDelegatesToDefaultImpl";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getWrapperName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 29: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

