/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrRawFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CaptureStackTraceInThrowables;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class CaptureStackTraceInThrowables
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;

    public CaptureStackTraceInThrowables(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        IrCall irCall;
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        if (!(container instanceof IrConstructor) || !((IrConstructor)container).isPrimary()) {
            return;
        }
        IrClass klass = IrUtilsKt.getParentAsClass(container);
        if (!IrUtilsKt.isSubclassOf(klass, (IrClass)this.context.getIrBuiltIns().getThrowableClass().getOwner())) {
            return;
        }
        Collection collection = ((IrBlockBody)irBody).getStatements();
        IrCall call2 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getIntrinsics().getCaptureStack(), null, null, null, 14, null);
        boolean bl = false;
        IrValueParameter irValueParameter = klass.getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        call2.putValueArgument(0, JsIrBuilder.INSTANCE.buildGetValue(irValueParameter.getSymbol()));
        call2.putValueArgument(1, new IrRawFunctionReferenceImpl(-1, -1, this.context.getIrBuiltIns().getAnyType(), ((IrConstructor)container).getSymbol()));
        collection.add(irCall);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

