/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.dce.AnalysisResult;
import org.jetbrains.kotlin.js.dce.Analyzer;
import org.jetbrains.kotlin.js.dce.Context;
import org.jetbrains.kotlin.js.dce.DCELogLevel;
import org.jetbrains.kotlin.js.dce.DeadCodeEliminationResult;
import org.jetbrains.kotlin.js.dce.DeadCodeEliminationStatus;
import org.jetbrains.kotlin.js.dce.Eliminator;
import org.jetbrains.kotlin.js.dce.InputFile;
import org.jetbrains.kotlin.js.dce.InputResource;
import org.jetbrains.kotlin.js.dce.ReachabilityTracker;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FixForwardNameReferencesKt;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapError;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapLocationRemapper;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParseResult;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParser;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSuccess;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilderConsumer;
import org.jetbrains.kotlin.js.util.TextOutputImpl;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u0019R\u00020\u000b0\u00182\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u00060\u0019R\u00020\u000b0\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/dce/DeadCodeElimination;", "", "printReachabilityInfo", "", "logConsumer", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/js/dce/DCELogLevel;", "", "", "(ZLkotlin/jvm/functions/Function2;)V", "context", "Lorg/jetbrains/kotlin/js/dce/Context;", "getContext", "()Lorg/jetbrains/kotlin/js/dce/Context;", "setContext", "(Lorg/jetbrains/kotlin/js/dce/Context;)V", "moduleMapping", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "getModuleMapping", "()Ljava/util/Map;", "reachableNames", "", "<set-?>", "", "Lorg/jetbrains/kotlin/js/dce/Context$Node;", "reachableNodes", "getReachableNodes", "()Ljava/lang/Iterable;", "apply", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "Companion", "js.dce"})
public final class DeadCodeElimination {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean printReachabilityInfo;
    @NotNull
    private final Function2<DCELogLevel, String, Unit> logConsumer;
    @NotNull
    private final Map<JsBlock, String> moduleMapping;
    @NotNull
    private final Set<String> reachableNames;
    @NotNull
    private Iterable<Context.Node> reachableNodes;
    @Nullable
    private Context context;

    public DeadCodeElimination(boolean printReachabilityInfo, @NotNull Function2<? super DCELogLevel, ? super String, Unit> logConsumer2) {
        Intrinsics.checkNotNullParameter(logConsumer2, "logConsumer");
        this.printReachabilityInfo = printReachabilityInfo;
        this.logConsumer = logConsumer2;
        this.moduleMapping = new LinkedHashMap();
        this.reachableNames = new LinkedHashSet();
        this.reachableNodes = SetsKt.emptySet();
    }

    @NotNull
    public final Map<JsBlock, String> getModuleMapping() {
        return this.moduleMapping;
    }

    @NotNull
    public final Iterable<Context.Node> getReachableNodes() {
        return this.reachableNodes;
    }

    @Nullable
    public final Context getContext() {
        return this.context;
    }

    public final void setContext(@Nullable Context context) {
        this.context = context;
    }

    /*
     * WARNING - void declaration
     */
    public final void apply(@NotNull JsNode root2) {
        Context context;
        Intrinsics.checkNotNullParameter(root2, "root");
        this.context = context = new Context();
        Set<JsName> topLevelVars = CollectUtilsKt.collectDefinedNames(root2);
        context.addNodesForLocalVars((Collection<? extends JsName>)topLevelVars);
        for (JsName name : topLevelVars) {
            Context.Node node = context.getNodes().get(name);
            Intrinsics.checkNotNull(node);
            Context.Node node2 = context.getGlobalScope();
            String string2 = name.getIdent();
            Intrinsics.checkNotNullExpressionValue(string2, "name.ident");
            node.alias(node2.member(string2));
        }
        Analyzer analyzer2 = new Analyzer(context);
        analyzer2.getModuleMapping().putAll(this.moduleMapping);
        root2.accept(analyzer2);
        Function2<DCELogLevel, String, Unit> function2 = this.logConsumer;
        Function2<DCELogLevel, String, Unit> function22 = function2;
        AnalysisResult analysisResult2 = analyzer2.getAnalysisResult();
        Context context2 = context;
        boolean bl = false;
        boolean bl2 = this.printReachabilityInfo;
        Function2<DCELogLevel, String, Unit> function23 = bl2 ? function2 : null;
        AnalysisResult analysisResult3 = analysisResult2;
        Context context3 = context2;
        ReachabilityTracker usageFinder = new ReachabilityTracker(context3, analysisResult3, function23);
        root2.accept(usageFinder);
        for (String reachableName : this.reachableNames) {
            void $this$fold$iv;
            String[] stringArray = new String[]{"."};
            List path2 = StringsKt.split$default((CharSequence)reachableName, stringArray, false, 0, 6, null);
            Iterable iterable = path2;
            Context.Node initial$iv = context.getGlobalScope();
            boolean $i$f$fold = false;
            Context.Node accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void part;
                String string3 = (String)element$iv;
                Context.Node node = accumulator$iv;
                boolean bl3 = false;
                accumulator$iv = node.member((String)part);
            }
            Context.Node node = accumulator$iv;
            usageFinder.reach(node);
        }
        this.reachableNodes = usageFinder.getReachableNodes();
        new Eliminator(analyzer2.getAnalysisResult()).accept(root2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u000e\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/js/dce/DeadCodeElimination$Companion;", "", "()V", "run", "Lorg/jetbrains/kotlin/js/dce/DeadCodeEliminationResult;", "inputFiles", "", "Lorg/jetbrains/kotlin/js/dce/InputFile;", "rootReachableNames", "", "", "printReachabilityInfo", "", "logConsumer", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/js/dce/DCELogLevel;", "", "Reporter", "js.dce"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final DeadCodeEliminationResult run(@NotNull Collection<InputFile> inputFiles, @NotNull Set<String> rootReachableNames, boolean printReachabilityInfo, @NotNull Function2<? super DCELogLevel, ? super String, Unit> logConsumer2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(inputFiles, "inputFiles");
            Intrinsics.checkNotNullParameter(rootReachableNames, "rootReachableNames");
            Intrinsics.checkNotNullParameter(logConsumer2, "logConsumer");
            JsProgram program = new JsProgram();
            DeadCodeElimination dce = new DeadCodeElimination(printReachabilityInfo, logConsumer2);
            boolean hasErrors = false;
            Iterable $this$map$iv = inputFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsGlobalBlock jsGlobalBlock;
                Object it3;
                void file2;
                InputFile inputFile = (InputFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JsGlobalBlock block = new JsGlobalBlock();
                Object it2 = file2.getResource().getReader().invoke();
                boolean bl2 = false;
                Closeable closeable = new InputStreamReader((InputStream)it2, "UTF-8");
                it2 = null;
                try {
                    it3 = (InputStreamReader)closeable;
                    boolean bl3 = false;
                    it3 = TextStreamsKt.readText((Reader)it3);
                }
                catch (Throwable it3) {
                    it2 = it3;
                    throw it3;
                }
                finally {
                    CloseableKt.closeFinally(closeable, (Throwable)it2);
                }
                Object code = it3;
                ErrorReporter errorReporter = new Reporter(file2.getResource().getName(), logConsumer2);
                JsObjectScope jsObjectScope = program.getScope();
                Intrinsics.checkNotNullExpressionValue(jsObjectScope, "program.scope");
                if (ParserUtilsKt.parse((String)code, errorReporter, jsObjectScope, file2.getResource().getName()) == null) {
                    Companion $this$run_u24lambda_u2d6_u24lambda_u2d2 = Companion;
                    boolean bl4 = false;
                    hasErrors = true;
                    jsGlobalBlock = block;
                } else {
                    List<JsStatement> statements;
                    SourceMapParseResult sourceMapParseResult;
                    it3 = file2.getSourceMapResource();
                    if (it3 != null) {
                        Object it4 = it3;
                        boolean bl5 = false;
                        sourceMapParseResult = SourceMapParser.INSTANCE.parse(TextStreamsKt.readText(new InputStreamReader(((InputResource)it4).getReader().invoke(), "UTF-8")));
                    } else {
                        sourceMapParseResult = null;
                    }
                    SourceMapParseResult sourceMapParse = sourceMapParseResult;
                    it3 = sourceMapParse;
                    if (it3 instanceof SourceMapError) {
                        logConsumer2.invoke(DCELogLevel.WARN, "Error parsing source map file " + file2.getSourceMapResource() + ": " + ((SourceMapError)sourceMapParse).getMessage());
                    } else if (it3 instanceof SourceMapSuccess) {
                        SourceMap sourceMap2 = ((SourceMapSuccess)sourceMapParse).getValue();
                        SourceMapLocationRemapper remapper2 = new SourceMapLocationRemapper(sourceMap2, null, 2, null);
                        Iterable $this$forEach$iv = statements;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            JsStatement it5 = (JsStatement)element$iv;
                            boolean bl6 = false;
                            remapper2.remap(it5);
                        }
                    } else if (it3 == null) {
                        // empty if block
                    }
                    List<JsStatement> list2 = block.getStatements();
                    Intrinsics.checkNotNullExpressionValue(list2, "block.statements");
                    CollectionsKt.addAll((Collection)list2, (Iterable)statements);
                    if (file2.getModuleName() != null) {
                        String it6;
                        boolean bl7 = false;
                        dce.getModuleMapping().put(block, it6);
                    }
                    jsGlobalBlock = block;
                }
                collection.add(jsGlobalBlock);
            }
            List blocks = (List)destination$iv$iv;
            if (hasErrors) {
                return new DeadCodeEliminationResult(dce.getContext(), SetsKt.emptySet(), DeadCodeEliminationStatus.FAILED);
            }
            List<JsStatement> list3 = program.getGlobalBlock().getStatements();
            Intrinsics.checkNotNullExpressionValue(list3, "program.globalBlock.statements");
            CollectionsKt.addAll((Collection)list3, blocks);
            JsGlobalBlock jsGlobalBlock = program.getGlobalBlock();
            Intrinsics.checkNotNullExpressionValue(jsGlobalBlock, "program.globalBlock");
            FixForwardNameReferencesKt.fixForwardNameReferences(jsGlobalBlock);
            CollectionsKt.addAll((Collection)dce.reachableNames, (Iterable)rootReachableNames);
            JsGlobalBlock jsGlobalBlock2 = program.getGlobalBlock();
            Intrinsics.checkNotNullExpressionValue(jsGlobalBlock2, "program.globalBlock");
            dce.apply(jsGlobalBlock2);
            for (Pair pair : CollectionsKt.zip((Iterable)inputFiles, blocks)) {
                InputFile file3 = (InputFile)pair.component1();
                JsGlobalBlock block = (JsGlobalBlock)pair.component2();
                File sourceMapFile = new File(file3.getOutputPath() + ".map");
                TextOutputImpl textOutput = new TextOutputImpl();
                SourceMap3Builder sourceMapBuilder = new SourceMap3Builder(new File(file3.getOutputPath()), textOutput, "");
                File inputFile = new File(file3.getResource().getName());
                File sourceBaseDir = inputFile.exists() ? inputFile.getParentFile() : new File(".");
                SourceFilePathResolver sourcePathResolver = new SourceFilePathResolver(CollectionsKt.emptyList(), new File(file3.getOutputPath()).getParentFile());
                SourceMapBuilderConsumer consumer = new SourceMapBuilderConsumer(sourceBaseDir, sourceMapBuilder, sourcePathResolver, true, true);
                block.accept(new JsToStringGenerationVisitor(textOutput, consumer));
                String sourceMapContent = sourceMapBuilder.build();
                sourceMapBuilder.addLink();
                File $this$run_u24lambda_u2d7 = new File(file3.getOutputPath());
                boolean bl = false;
                $this$run_u24lambda_u2d7.getParentFile().mkdirs();
                String string2 = textOutput.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "textOutput.toString()");
                FilesKt.writeText$default($this$run_u24lambda_u2d7, string2, null, 2, null);
                if (file3.getSourceMapResource() == null) continue;
                Intrinsics.checkNotNullExpressionValue(sourceMapContent, "sourceMapContent");
                FilesKt.writeText$default(sourceMapFile, sourceMapContent, null, 2, null);
            }
            return new DeadCodeEliminationResult(dce.getContext(), dce.getReachableNodes(), DeadCodeEliminationStatus.OK);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/dce/DeadCodeElimination$Companion$Reporter;", "Lcom/google/gwt/dev/js/rhino/ErrorReporter;", "fileName", "", "logConsumer", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/js/dce/DCELogLevel;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "error", "message", "startPosition", "Lcom/google/gwt/dev/js/rhino/CodePosition;", "endPosition", "warning", "js.dce"})
        private static final class Reporter
        implements ErrorReporter {
            @NotNull
            private final String fileName;
            @NotNull
            private final Function2<DCELogLevel, String, Unit> logConsumer;

            public Reporter(@NotNull String fileName, @NotNull Function2<? super DCELogLevel, ? super String, Unit> logConsumer2) {
                Intrinsics.checkNotNullParameter(fileName, "fileName");
                Intrinsics.checkNotNullParameter(logConsumer2, "logConsumer");
                this.fileName = fileName;
                this.logConsumer = logConsumer2;
            }

            @Override
            public void warning(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
                Intrinsics.checkNotNullParameter(message, "message");
                Intrinsics.checkNotNullParameter(startPosition, "startPosition");
                Intrinsics.checkNotNullParameter(endPosition, "endPosition");
                this.logConsumer.invoke(DCELogLevel.WARN, "at " + this.fileName + " (" + (startPosition.getLine() + 1) + ", " + (startPosition.getOffset() + 1) + "): " + message);
            }

            @Override
            public void error(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
                Intrinsics.checkNotNullParameter(message, "message");
                Intrinsics.checkNotNullParameter(startPosition, "startPosition");
                Intrinsics.checkNotNullParameter(endPosition, "endPosition");
                this.logConsumer.invoke(DCELogLevel.ERROR, "at " + this.fileName + " (" + (startPosition.getLine() + 1) + ", " + (startPosition.getOffset() + 1) + "): " + message);
            }
        }
    }
}

