/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/AbstractClassInstantiationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class AbstractClassInstantiationChecker
implements CallChecker {
    @NotNull
    public static final AbstractClassInstantiationChecker INSTANCE = new AbstractClassInstantiationChecker();

    private AbstractClassInstantiationChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        Object candidateDescriptor = resolvedCall2.getCandidateDescriptor();
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue(call2, "resolvedCall.call");
        Call call3 = call2;
        if (candidateDescriptor instanceof ConstructorDescriptor && !CallResolverUtilKt.isSuperOrDelegatingConstructorCall(call3) && ((ConstructorDescriptor)candidateDescriptor).getConstructedClass().getModality() == Modality.ABSTRACT) {
            BindingTrace bindingTrace = context.getTrace();
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS.on(call3.getCallElement());
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, "CREATING_AN_INSTANCE_OF_\u2026LASS.on(call.callElement)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }
}

