/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.ConeClassLookupTagWithFixedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a-\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00010\u0017H\u0082\b\u001a\u001e\u0010\u0018\u001a\u00020\u0001*\u00020\u00192\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u001e\u0010\u001a\u001a\u00020\u0001*\u00020\u00192\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0014\u0010\u001b\u001a\u00020\u0001*\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0018\u0010\b\u001a\u00020\u0001*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\"\u001c\u0010\b\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\f\"\u0015\u0010\r\u001a\u00020\u0001*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\"\u001c\u0010\r\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u000e8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006\u001c"}, d2={"canHaveOpenMembers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getCanHaveOpenMembers", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Z", "isEnumEntryInitializer", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "isExtensionMember", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Z", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "isLocalMember", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "isInsideExpectClass", "containingClass", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "isInsideExternalClass", "isInsideSpecificClass", "predicate", "Lkotlin/Function1;", "isEffectivelyExpect", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isEffectivelyExternal", "isEffectivelyFinal", "checkers"})
public final class DeclarationUtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExpectClass(@NotNull FirClass containingClass, @NotNull CheckerContext context) {
        boolean bl;
        boolean $i$f$isExpect;
        FirMemberDeclaration $this$isExpect$iv;
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExpect$iv = klass;
            $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExpect$iv = klass;
                    $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInsideExternalClass(@NotNull FirClass containingClass, @NotNull CheckerContext context) {
        boolean bl;
        boolean $i$f$isExternal;
        FirMemberDeclaration $this$isExternal$iv;
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(context, "context");
        boolean $i$f$isInsideSpecificClass = false;
        FirClass klass = containingClass;
        boolean bl2 = false;
        if (klass instanceof FirRegularClass) {
            $this$isExternal$iv = klass;
            $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) {
                return true;
            }
        }
        boolean bl3 = false;
        if (bl3) return true;
        Iterable $this$any$iv$iv = CollectionsKt.asReversed(context.getContainingDeclarations());
        boolean $i$f$any = false;
        if ($this$any$iv$iv instanceof Collection && ((Collection)$this$any$iv$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv$iv = iterator2.next();
            FirDeclaration it$iv = (FirDeclaration)element$iv$iv;
            boolean bl4 = false;
            if (it$iv instanceof FirRegularClass) {
                klass = (FirClass)it$iv;
                bl2 = false;
                if (klass instanceof FirRegularClass) {
                    $this$isExternal$iv = klass;
                    $i$f$isExternal = false;
                    if ($this$isExternal$iv.getStatus().isExternal()) {
                        return true;
                    }
                }
                boolean bl5 = false;
                if (bl5) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final boolean isEffectivelyFinal(@NotNull FirMemberDeclaration $this$isEffectivelyFinal, @NotNull CheckerContext context) {
        Modality modality$iv;
        Object modality$iv2;
        Intrinsics.checkNotNullParameter($this$isEffectivelyFinal, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        FirMemberDeclaration $this$isFinal$iv = $this$isEffectivelyFinal;
        boolean $i$f$isFinal = false;
        Modality modality = $this$isFinal$iv.getStatus().getModality();
        if (modality == null ? true : (modality$iv2 = modality) == Modality.FINAL) {
            return true;
        }
        modality$iv2 = CollectionsKt.lastOrNull(context.getContainingDeclarations());
        FirRegularClass firRegularClass = modality$iv2 instanceof FirRegularClass ? (FirRegularClass)modality$iv2 : null;
        if (firRegularClass == null) {
            return true;
        }
        FirRegularClass containingClass = firRegularClass;
        FirClass $this$isEnumClass$iv = containingClass;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        if (bl) {
            return false;
        }
        FirMemberDeclaration $this$isFinal$iv2 = containingClass;
        boolean $i$f$isFinal2 = false;
        Modality modality2 = $this$isFinal$iv2.getStatus().getModality();
        return modality2 == null ? true : (modality$iv = modality2) == Modality.FINAL;
    }

    public static final boolean isEffectivelyExpect(@NotNull FirMemberDeclaration $this$isEffectivelyExpect, @Nullable FirClass containingClass, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$isEffectivelyExpect, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        FirMemberDeclaration $this$isExpect$iv = $this$isEffectivelyExpect;
        boolean $i$f$isExpect = false;
        if ($this$isExpect$iv.getStatus().isExpect()) {
            return true;
        }
        return containingClass != null && DeclarationUtilsKt.isInsideExpectClass(containingClass, context);
    }

    public static final boolean isEffectivelyExternal(@NotNull FirMemberDeclaration $this$isEffectivelyExternal, @Nullable FirClass containingClass, @NotNull CheckerContext context) {
        block9: {
            block10: {
                boolean bl;
                boolean bl2;
                boolean $i$f$isExternal;
                Intrinsics.checkNotNullParameter($this$isEffectivelyExternal, "<this>");
                Intrinsics.checkNotNullParameter(context, "context");
                FirMemberDeclaration $this$isExternal$iv = $this$isEffectivelyExternal;
                boolean $i$f$isExternal2 = false;
                if ($this$isExternal$iv.getStatus().isExternal()) {
                    return true;
                }
                if ($this$isEffectivelyExternal instanceof FirPropertyAccessor) {
                    FirDeclaration firDeclaration = CollectionsKt.last(context.getContainingDeclarations());
                    Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirProperty");
                    FirProperty property2 = (FirProperty)firDeclaration;
                    return DeclarationUtilsKt.isEffectivelyExternal(property2, containingClass, context);
                }
                if (!($this$isEffectivelyExternal instanceof FirProperty)) break block9;
                FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$isEffectivelyExternal).getGetter();
                if (firPropertyAccessor != null) {
                    FirMemberDeclaration $this$isExternal$iv2 = firPropertyAccessor;
                    $i$f$isExternal = false;
                    bl2 = $this$isExternal$iv2.getStatus().isExternal();
                } else {
                    bl2 = false;
                }
                if (!bl2) break block9;
                if (!((FirProperty)$this$isEffectivelyExternal).isVar()) break block10;
                FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)$this$isEffectivelyExternal).getSetter();
                if (firPropertyAccessor2 != null) {
                    FirMemberDeclaration $this$isExternal$iv3 = firPropertyAccessor2;
                    $i$f$isExternal = false;
                    bl = $this$isExternal$iv3.getStatus().isExternal();
                } else {
                    bl = false;
                }
                if (!bl) break block9;
            }
            return true;
        }
        return containingClass != null && DeclarationUtilsKt.isInsideExternalClass(containingClass, context);
    }

    public static final boolean getCanHaveOpenMembers(@NotNull FirClass $this$canHaveOpenMembers) {
        Intrinsics.checkNotNullParameter($this$canHaveOpenMembers, "<this>");
        return FirHelpersKt.modality($this$canHaveOpenMembers) != Modality.FINAL || $this$canHaveOpenMembers.getClassKind() == ClassKind.ENUM_CLASS;
    }

    public static final boolean isEnumEntryInitializer(@NotNull FirDeclaration $this$isEnumEntryInitializer) {
        Intrinsics.checkNotNullParameter($this$isEnumEntryInitializer, "<this>");
        if (!($this$isEnumEntryInitializer instanceof FirConstructor) || !((FirConstructor)$this$isEnumEntryInitializer).isPrimary()) {
            return false;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.getContainingClassForStaticMemberAttr((FirCallableDeclaration)$this$isEnumEntryInitializer);
        Object object = coneClassLikeLookupTag instanceof ConeClassLookupTagWithFixedSymbol ? (ConeClassLookupTagWithFixedSymbol)coneClassLikeLookupTag : null;
        return (object != null && (object = ((ConeClassLookupTagWithFixedSymbol)object).getSymbol()) != null ? ((FirClassSymbol)object).getClassKind() : null) == ClassKind.ENUM_ENTRY;
    }

    public static final boolean isLocalMember(@NotNull FirDeclaration $this$isLocalMember) {
        Intrinsics.checkNotNullParameter($this$isLocalMember, "<this>");
        return DeclarationUtilsKt.isLocalMember($this$isLocalMember.getSymbol());
    }

    public static final boolean isLocalMember(@NotNull FirBasedSymbol<?> $this$isLocalMember) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isLocalMember, "<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$isLocalMember;
        if (firBasedSymbol instanceof FirPropertySymbol) {
            bl = ((FirPropertySymbol)$this$isLocalMember).isLocal();
        } else if (firBasedSymbol instanceof FirRegularClassSymbol) {
            FirClassLikeSymbol $this$isLocal$iv = (FirClassLikeSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            bl = $this$isLocal$iv.getClassId().isLocal();
        } else if (firBasedSymbol instanceof FirNamedFunctionSymbol) {
            FirNamedFunctionSymbol $this$isLocal$iv = (FirNamedFunctionSymbol)$this$isLocalMember;
            boolean $i$f$isLocal = false;
            FirCallableSymbol $this$visibility$iv$iv = $this$isLocal$iv;
            boolean $i$f$getVisibility = false;
            bl = Intrinsics.areEqual($this$visibility$iv$iv.getResolvedStatus().getVisibility(), Visibilities.Local.INSTANCE);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isExtensionMember(@NotNull FirCallableDeclaration $this$isExtensionMember) {
        Intrinsics.checkNotNullParameter($this$isExtensionMember, "<this>");
        return DeclarationUtilsKt.isExtensionMember($this$isExtensionMember.getSymbol());
    }

    public static final boolean isExtensionMember(@NotNull FirCallableSymbol<?> $this$isExtensionMember) {
        Intrinsics.checkNotNullParameter($this$isExtensionMember, "<this>");
        return $this$isExtensionMember.getResolvedReceiverTypeRef() != null && $this$isExtensionMember.getDispatchReceiverType() != null;
    }
}

