/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.comparators;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.comparators.FirCallableDeclarationComparator;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0003j\b\u0012\u0004\u0012\u00020\u0002`\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/comparators/FirMemberDeclarationComparator;", "Lkotlin/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Ljava/util/Comparator;", "<init>", "()V", "compare", "", "a", "b", "TypeAndNameComparator", "tree"})
public final class FirMemberDeclarationComparator
implements Comparator<FirMemberDeclaration> {
    @NotNull
    public static final FirMemberDeclarationComparator INSTANCE = new FirMemberDeclarationComparator();

    private FirMemberDeclarationComparator() {
    }

    @Override
    public int compare(@NotNull FirMemberDeclaration a, @NotNull FirMemberDeclaration b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        if (a instanceof FirCallableDeclaration && b instanceof FirCallableDeclaration) {
            return FirCallableDeclarationComparator.INSTANCE.compare((FirCallableDeclaration)a, (FirCallableDeclaration)b);
        }
        int typeAndNameDiff = TypeAndNameComparator.INSTANCE.compare(a, b);
        if (typeAndNameDiff != 0) {
            return typeAndNameDiff;
        }
        FirMemberDeclaration firMemberDeclaration = a;
        if (firMemberDeclaration instanceof FirClass) {
            if (!(b instanceof FirClass)) {
                boolean $i$a$-require-FirMemberDeclarationComparator$compare$32 = false;
                String $i$a$-require-FirMemberDeclarationComparator$compare$32 = "priority is inconsistent: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b);
                throw new IllegalArgumentException($i$a$-require-FirMemberDeclarationComparator$compare$32.toString());
            }
            String string2 = FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)a).getPackageFqName().asString();
            String string3 = FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)b).getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
            return string2.compareTo(string3);
        }
        if (firMemberDeclaration instanceof FirTypeAlias) {
            if (!(b instanceof FirTypeAlias)) {
                boolean bl = false;
                String string4 = "priority is inconsistent: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b);
                throw new IllegalArgumentException(string4.toString());
            }
            return FirTypeRefComparator.INSTANCE.compare(((FirTypeAlias)a).getExpandedTypeRef(), ((FirTypeAlias)b).getExpandedTypeRef());
        }
        throw new IllegalStateException(("Unsupported member declaration comparison: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b)).toString());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0003j\b\u0012\u0004\u0012\u00020\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/comparators/FirMemberDeclarationComparator$TypeAndNameComparator;", "Lkotlin/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Ljava/util/Comparator;", "<init>", "()V", "priority", "", "getPriority", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)I", "compare", "a", "b", "tree"})
    public static final class TypeAndNameComparator
    implements Comparator<FirMemberDeclaration> {
        @NotNull
        public static final TypeAndNameComparator INSTANCE = new TypeAndNameComparator();

        private TypeAndNameComparator() {
        }

        private final int getPriority(FirMemberDeclaration $this$priority) {
            int n;
            FirMemberDeclaration firMemberDeclaration = $this$priority;
            if (firMemberDeclaration instanceof FirEnumEntry) {
                n = 7;
            } else if (firMemberDeclaration instanceof FirConstructor) {
                n = 6;
            } else if (firMemberDeclaration instanceof FirProperty) {
                n = 5;
            } else if (firMemberDeclaration instanceof FirField) {
                n = 4;
            } else if (firMemberDeclaration instanceof FirFunction) {
                n = 3;
            } else if (firMemberDeclaration instanceof FirClass) {
                n = 2;
            } else if (firMemberDeclaration instanceof FirTypeAlias) {
                n = 1;
            } else if (firMemberDeclaration instanceof FirErrorProperty) {
                n = 0;
            } else if (firMemberDeclaration instanceof FirValueParameter) {
                n = 0;
            } else if (firMemberDeclaration instanceof FirBackingField) {
                n = 0;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n;
        }

        @Override
        public int compare(@NotNull FirMemberDeclaration a, @NotNull FirMemberDeclaration b) {
            Intrinsics.checkNotNullParameter(a, "a");
            Intrinsics.checkNotNullParameter(b, "b");
            int priorityDiff = this.getPriority(a) - this.getPriority(b);
            if (priorityDiff != 0) {
                return priorityDiff;
            }
            if (a instanceof FirEnumEntry) {
                if (!(b instanceof FirEnumEntry)) {
                    boolean bl = false;
                    String string2 = "priority is inconsistent: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b);
                    throw new IllegalArgumentException(string2.toString());
                }
                return 0;
            }
            return FirDeclarationUtilKt.getNameOrSpecialName(a).compareTo(FirDeclarationUtilKt.getNameOrSpecialName(b));
        }
    }
}

