/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.signaturer;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.CodeFragmentConversionData;
import org.jetbrains.kotlin.fir.backend.CodeFragmentUtilsKt;
import org.jetbrains.kotlin.fir.backend.FirMangler;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.signaturer.FirBasedSignatureComposer;
import org.jetbrains.kotlin.fir.signaturer.FirManglerUtilKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\tH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposerImpl;", "Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "mangler", "Lorg/jetbrains/kotlin/fir/backend/FirMangler;", "<init>", "(Lorg/jetbrains/kotlin/fir/backend/FirMangler;)V", "signatureCache", "", "Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposerImpl$FirDeclarationWithParentId;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "computeSignatureHashAndDescriptionFor", "Lkotlin/Pair;", "", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "composeSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "containingClass", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "forceExpect", "", "composeSignatureImpl", "calculatePublicSignature", "declarationWithParentId", "isTopLevelPrivate", "fakeFileSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "commonSignature", "FirDeclarationWithParentId", "SignatureBuilder", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFirBasedSignatureComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBasedSignatureComposer.kt\norg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,225:1\n1#2:226\n21#3:227\n21#3:235\n381#4,7:228\n*S KotlinDebug\n*F\n+ 1 FirBasedSignatureComposer.kt\norg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposerImpl\n*L\n74#1:227\n215#1:235\n79#1:228,7\n*E\n"})
public final class FirBasedSignatureComposerImpl
extends FirBasedSignatureComposer {
    @NotNull
    private final Map<FirDeclarationWithParentId, IdSignature.CommonSignature> signatureCache;

    public FirBasedSignatureComposerImpl(@NotNull FirMangler mangler) {
        Intrinsics.checkNotNullParameter(mangler, "mangler");
        super(mangler, null);
        this.signatureCache = new LinkedHashMap();
    }

    private final Pair<Long, String> computeSignatureHashAndDescriptionFor(FirDeclaration declaration) {
        FirMangler $this$computeSignatureHashAndDescriptionFor_u24lambda_u241 = this.getMangler();
        boolean bl = false;
        String it = $this$computeSignatureHashAndDescriptionFor_u24lambda_u241.signatureString(declaration, false);
        boolean bl2 = false;
        return TuplesKt.to($this$computeSignatureHashAndDescriptionFor_u24lambda_u241.getHashMangle(it), it);
    }

    @Override
    @Nullable
    public IdSignature composeSignature(@NotNull FirCallableDeclaration declaration, @Nullable ConeClassLikeLookupTag containingClass, boolean forceExpect) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return this.composeSignatureImpl(declaration, containingClass, forceExpect);
    }

    private final IdSignature composeSignatureImpl(FirDeclaration declaration, ConeClassLikeLookupTag containingClass, boolean forceExpect) {
        IdSignature idSignature;
        IdSignature.CommonSignature commonSignature;
        block10: {
            block11: {
                if (declaration instanceof FirAnonymousObject || declaration instanceof FirAnonymousFunction) {
                    return null;
                }
                if (declaration instanceof FirRegularClass && FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)declaration).isLocal()) {
                    return null;
                }
                if (!(declaration instanceof FirCallableDeclaration)) break block10;
                FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$getVisibility = false;
                if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Local.INSTANCE)) {
                    return null;
                }
                Object object = ClassMembersKt.dispatchReceiverClassLookupTagOrNull((FirCallableDeclaration)declaration);
                if (object != null && (object = ((ConeClassLikeLookupTag)object).getClassId()) != null ? ((ClassId)object).isLocal() : false) break block11;
                Object object2 = containingClass;
                boolean bl = object2 != null && (object2 = ((ConeClassLikeLookupTag)object2).getClassId()) != null ? ((ClassId)object2).isLocal() : false;
                if (!bl) break block10;
            }
            return null;
        }
        ConeClassLikeLookupTag coneClassLikeLookupTag = containingClass;
        FirDeclarationWithParentId declarationWithParentId = new FirDeclarationWithParentId(declaration, coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null, forceExpect);
        Map<FirDeclarationWithParentId, IdSignature.CommonSignature> $this$getOrPut$iv = this.signatureCache;
        boolean $i$f$getOrPut = false;
        IdSignature.CommonSignature value$iv = $this$getOrPut$iv.get(declarationWithParentId);
        if (value$iv == null) {
            boolean bl = false;
            IdSignature.CommonSignature answer$iv = this.calculatePublicSignature(declarationWithParentId);
            $this$getOrPut$iv.put(declarationWithParentId, answer$iv);
            commonSignature = answer$iv;
        } else {
            commonSignature = value$iv;
        }
        IdSignature.CommonSignature publicSignature = commonSignature;
        if (this.isTopLevelPrivate(declaration)) {
            IdSignature.FileSignature fileSig = this.fakeFileSignature(declaration, publicSignature);
            idSignature = new IdSignature.CompositeSignature(fileSig, publicSignature);
        } else {
            idSignature = publicSignature;
        }
        IdSignature resultSignature = idSignature;
        return resultSignature;
    }

    private final IdSignature.CommonSignature calculatePublicSignature(FirDeclarationWithParentId declarationWithParentId) {
        IdSignature.CommonSignature commonSignature;
        FirDeclaration declaration = declarationWithParentId.component1();
        ClassId containingClassId = declarationWithParentId.component2();
        SignatureBuilder builder = new SignatureBuilder(declarationWithParentId.getForceExpect());
        try {
            declaration.accept(builder, null);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error while composing signature for " + UtilsKt.render(declaration), t);
        }
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            ClassId classId = FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)declaration);
            String string2 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String string3 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
            commonSignature = new IdSignature.CommonSignature(string2, string3, builder.getHashId(), builder.getMask(), builder.getDescription());
        } else if (firDeclaration instanceof FirTypeAlias) {
            ClassId classId = ((FirTypeAlias)declaration).getSymbol().getClassId();
            String string4 = classId.getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string4, "asString(...)");
            String string5 = classId.getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue(string5, "asString(...)");
            commonSignature = new IdSignature.CommonSignature(string4, string5, builder.getHashId(), builder.getMask(), builder.getDescription());
        } else if (firDeclaration instanceof FirCallableDeclaration) {
            ClassId classId;
            Object object;
            ClassId classId2 = containingClassId;
            if (classId2 == null) {
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag((FirCallableDeclaration)declaration);
                classId2 = coneClassLikeLookupTag != null ? coneClassLikeLookupTag.getClassId() : null;
            }
            if ((object = (classId = classId2)) == null || (object = ((ClassId)object).getPackageFqName()) == null) {
                object = ((FirCallableDeclaration)declaration).getSymbol().getCallableId().getPackageName();
            }
            Object packageName2 = object;
            Name callableName = FirManglerUtilKt.getIrName((FirCallableDeclaration)declaration);
            String string6 = ((FqName)packageName2).asString();
            Intrinsics.checkNotNullExpressionValue(string6, "asString(...)");
            Object object2 = classId;
            if (object2 == null || (object2 = ((ClassId)object2).getRelativeClassName()) == null || (object2 = ((FqName)object2).child(callableName)) == null || (object2 = ((FqName)object2).asString()) == null) {
                String string7 = callableName.asString();
                object2 = string7;
                Intrinsics.checkNotNullExpressionValue(string7, "asString(...)");
            }
            commonSignature = new IdSignature.CommonSignature(string6, (String)object2, builder.getHashId(), builder.getMask(), builder.getDescription());
        } else if (firDeclaration instanceof FirScript) {
            String string8 = ((FirScript)declaration).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string8, "asString(...)");
            String string9 = ((FirScript)declaration).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string9, "asString(...)");
            commonSignature = new IdSignature.CommonSignature(string8, string9, builder.getHashId(), builder.getMask(), builder.getDescription());
        } else if (firDeclaration instanceof FirCodeFragment) {
            CodeFragmentConversionData conversionData = CodeFragmentUtilsKt.getConversionData((FirCodeFragment)declaration);
            String string10 = conversionData.getClassId().getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string10, "asString(...)");
            String packageFqName = string10;
            String string11 = conversionData.getClassId().getRelativeClassName().asString();
            Intrinsics.checkNotNullExpressionValue(string11, "asString(...)");
            String classFqName = string11;
            commonSignature = new IdSignature.CommonSignature(packageFqName, classFqName, builder.getHashId(), builder.getMask(), null);
        } else {
            throw new IllegalStateException(("Unsupported FIR declaration in signature composer: " + UtilsKt.render(declaration)).toString());
        }
        return commonSignature;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTopLevelPrivate(FirDeclaration declaration) {
        if (FirVisibilityCheckerKt.getOwnerLookupTag(declaration.getSymbol()) != null) return false;
        if (!(declaration instanceof FirMemberDeclaration)) return false;
        FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$getVisibility = false;
        if (!Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) return false;
        return true;
    }

    private final IdSignature.FileSignature fakeFileSignature(FirDeclaration $this$fakeFileSignature, IdSignature.CommonSignature commonSignature) {
        return new IdSignature.FileSignature($this$fakeFileSignature, new FqName(commonSignature.getPackageFqName() + '.' + commonSignature.getDeclarationFqName()), "<unknown>");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposerImpl$FirDeclarationWithParentId;", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "forceExpect", "", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/name/ClassId;Z)V", "getDeclaration", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getForceExpect", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "fir2ir"})
    private static final class FirDeclarationWithParentId {
        @NotNull
        private final FirDeclaration declaration;
        @Nullable
        private final ClassId classId;
        private final boolean forceExpect;

        public FirDeclarationWithParentId(@NotNull FirDeclaration declaration, @Nullable ClassId classId, boolean forceExpect) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            this.declaration = declaration;
            this.classId = classId;
            this.forceExpect = forceExpect;
        }

        @NotNull
        public final FirDeclaration getDeclaration() {
            return this.declaration;
        }

        @Nullable
        public final ClassId getClassId() {
            return this.classId;
        }

        public final boolean getForceExpect() {
            return this.forceExpect;
        }

        @NotNull
        public final FirDeclaration component1() {
            return this.declaration;
        }

        @Nullable
        public final ClassId component2() {
            return this.classId;
        }

        public final boolean component3() {
            return this.forceExpect;
        }

        @NotNull
        public final FirDeclarationWithParentId copy(@NotNull FirDeclaration declaration, @Nullable ClassId classId, boolean forceExpect) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            return new FirDeclarationWithParentId(declaration, classId, forceExpect);
        }

        public static /* synthetic */ FirDeclarationWithParentId copy$default(FirDeclarationWithParentId firDeclarationWithParentId, FirDeclaration firDeclaration, ClassId classId, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                firDeclaration = firDeclarationWithParentId.declaration;
            }
            if ((n & 2) != 0) {
                classId = firDeclarationWithParentId.classId;
            }
            if ((n & 4) != 0) {
                bl = firDeclarationWithParentId.forceExpect;
            }
            return firDeclarationWithParentId.copy(firDeclaration, classId, bl);
        }

        @NotNull
        public String toString() {
            return "FirDeclarationWithParentId(declaration=" + this.declaration + ", classId=" + this.classId + ", forceExpect=" + this.forceExpect + ')';
        }

        public int hashCode() {
            int result2 = this.declaration.hashCode();
            result2 = result2 * 31 + (this.classId == null ? 0 : this.classId.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.forceExpect);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FirDeclarationWithParentId)) {
                return false;
            }
            FirDeclarationWithParentId firDeclarationWithParentId = (FirDeclarationWithParentId)other;
            if (!Intrinsics.areEqual(this.declaration, firDeclarationWithParentId.declaration)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.classId, firDeclarationWithParentId.classId)) {
                return false;
            }
            return this.forceExpect == firDeclarationWithParentId.forceExpect;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u001a\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010,\u001a\u00020\u00022\u0006\u0010-\u001a\u00020.2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u0002012\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u0002042\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u0002072\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020:2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010;\u001a\u00020\u00022\u0006\u0010<\u001a\u00020=2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposerImpl$SignatureBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "", "forceExpect", "", "<init>", "(Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposerImpl;Z)V", "hashId", "", "getHashId", "()Ljava/lang/Long;", "setHashId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "description", "", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "mask", "getMask", "()J", "setMask", "(J)V", "setHashAndDescriptionFor", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "setExpected", "f", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitScript", "script", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "visitCodeFragment", "codeFragment", "Lorg/jetbrains/kotlin/fir/declarations/FirCodeFragment;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitField", "field", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "fir2ir"})
    @SourceDebugExtension(value={"SMAP\nFirBasedSignatureComposer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirBasedSignatureComposer.kt\norg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposerImpl$SignatureBuilder\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,225:1\n37#2:226\n37#2:227\n37#2:228\n37#2:229\n37#2:230\n37#2:231\n37#2:232\n*S KotlinDebug\n*F\n+ 1 FirBasedSignatureComposer.kt\norg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposerImpl$SignatureBuilder\n*L\n175#1:226\n186#1:227\n191#1:228\n196#1:229\n201#1:230\n206#1:231\n210#1:232\n*E\n"})
    private final class SignatureBuilder
    extends FirVisitor<Unit, Object> {
        private final boolean forceExpect;
        @Nullable
        private Long hashId;
        @Nullable
        private String description;
        private long mask;

        public SignatureBuilder(boolean forceExpect) {
            this.forceExpect = forceExpect;
        }

        @Nullable
        public final Long getHashId() {
            return this.hashId;
        }

        public final void setHashId(@Nullable Long l) {
            this.hashId = l;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(@Nullable String string2) {
            this.description = string2;
        }

        public final long getMask() {
            return this.mask;
        }

        public final void setMask(long l) {
            this.mask = l;
        }

        private final void setHashAndDescriptionFor(FirDeclaration declaration) {
            Pair it = FirBasedSignatureComposerImpl.this.computeSignatureHashAndDescriptionFor(declaration);
            boolean bl = false;
            this.hashId = (Long)it.getFirst();
            this.description = (String)it.getSecond();
        }

        private final void setExpected(boolean f) {
            this.mask |= IdSignature.Flags.IS_EXPECT.encode(f || this.forceExpect);
        }

        @Override
        public void visitElement(@NotNull FirElement element, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(element, "element");
            String string2 = "Should not be here";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(regularClass, "regularClass");
            FirMemberDeclaration $this$isExpect$iv = regularClass;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitScript(@NotNull FirScript script, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(script, "script");
        }

        @Override
        public void visitCodeFragment(@NotNull FirCodeFragment codeFragment, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(codeFragment, "codeFragment");
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            FirMemberDeclaration $this$isExpect$iv = typeAlias;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(constructor2, "constructor");
            this.setHashAndDescriptionFor(constructor2);
            FirMemberDeclaration $this$isExpect$iv = constructor2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
            this.setHashAndDescriptionFor(simpleFunction);
            FirMemberDeclaration $this$isExpect$iv = simpleFunction;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitProperty(@NotNull FirProperty property, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(property, "property");
            this.setHashAndDescriptionFor(property);
            FirMemberDeclaration $this$isExpect$iv = property;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitField(@NotNull FirField field, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(field, "field");
            this.setHashAndDescriptionFor(field);
            FirMemberDeclaration $this$isExpect$iv = field;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
            FirMemberDeclaration $this$isExpect$iv = enumEntry;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }
    }
}

